#include <stdbool.h>
#include <stdint.h>
#include "remoteioComms.h"
#include "vibAndLed.h"
#include "printf.h"
#include "boot.h"

static uint32_t mEndTime = 0;

bool vibAndLedHwIsSupported(bool led)
{
	return led && (remoteioCommsWaitForContinueBooot()->miscBits & MISC_BIT_LED_SUPPORTED);
}

void vibAndLedHwStart(bool led, const struct HwVibAndLedConfig* cfg)
{
	if (led) {
		
		uint32_t csecPerPieceRounded = (cfg->csecPerPattern + 16) / 32;
		uint32_t totalTime = 0;
	
		if (csecPerPieceRounded < 1)
			csecPerPieceRounded = 1;
		
		if (cfg->numTimes)
			totalTime += (cfg->numTimes - 1) * cfg->csecBetween;
			
		totalTime += cfg->numTimes * 32 * csecPerPieceRounded;
		
		remoteioCommsLedControl(cfg->pattern, csecPerPieceRounded, cfg->csecBetween, cfg->numTimes);
		mEndTime = TimGetTicks() + totalTime;
	}
}

void vibAndLedHwStop(bool led)
{
	if (led) {
	
		remoteioCommsLedControl(0, 0, 0, 0);
		mEndTime = 0;
	}
}

bool vibAndLedHwIsActive(bool led)
{
	return led && TimGetTicks() >= mEndTime;
}

/*

k3 on pro is led

prism edge and pro have LEDs
likely all have hal traps to support it

HalLEDCommand(hal trap 20) calls HwrPluggedIn() to nly allow us led control when not charging
if we overwrite it, we can ge total control of led

but it is also controlled by HalChargeIndicator which is claled for mmany palces and we'd need to override it (doable: trap 9)

*/