#include "dockAndBattery.h"
#include "remoteioComms.h"
#include "dal.h"



void dockHwrInit(void)
{
	const struct MsgBatteryInfo *bi = remoteioCommsGetBatteryInfo();
	SysBatteryKind kind = (SysBatteryKind)((bi->flags & BATT_INFO_KIND_MASK) >> BATT_INFO_KIND_SHIFT);
	uint32_t state = 0;
	
	if (bi->flags & BATT_INFO_PLUGGED_IN_MASK) {
		if (kind != sysBatteryKindAlkaline)		//we do not charge alkaline batteries
			state |= HAL_DOCK_STATUS_CHARGING;
		
		state |= HAL_DOCK_STATUS_EXTRNAL_PWR;
	}
	
	halDockStatusChanged(state);
}

void batteryInfo(SysBatteryKind *kindP, bool *haveMainsP, uint8_t *percentP)
{
	const struct MsgBatteryInfo *bi = remoteioCommsGetBatteryInfo();

	if (kindP)
		*kindP = (SysBatteryKind)((bi->flags & BATT_INFO_KIND_MASK) >> BATT_INFO_KIND_SHIFT);
	
	if (haveMainsP)
		*haveMainsP = !!(bi->flags & BATT_INFO_PLUGGED_IN_MASK);
	
	if (percentP)
		*percentP = (bi->flags & BATT_INFO_PERCENT_MASK) >> BATT_INFO_PERCENT_SHIFT;
}

