#include "ac97codec.h"
#include "printf.h"
#include "wm9705.h"

#define VID_1_VAL_WM9705					0x574d
#define VID_2_VAL_WM9705					0x4c05


#define WM9705_REG_EXTD_AUDIO_ID			0x28
#define WM9705_REG_EXTD_AUDIO_STA_CTL		0x2a
#define WM9705_REG_AUDIO_DAC_RATE			0x2c
#define WM9705_REG_AUDIO_ADC_RATE			0x32
#define WM9705_REG_SPDIF_CONTROL			0x3a
#define WM9705_REG_MIXER_PATH_MUTE			0x5a
#define WM9705_REG_ADD_FUNC_CTL				0x5c
#define WM9705_REG_FRONT_MIX_VOL			0x72
#define WM9705_REG_ADD_FUNC					0x74
#define WM9705_REG_DIGITIZER_CONTROL_1		0x76
#define WM9705_REG_DIGITIZER_CONTROL_2		0x78	
#define WM9705_REG_PEN_DIGITIZER_DATA		0x7A


static uint16_t mDigCtl1, mDigCtl2;

bool wm9705init(enum AC97deviceSelection where)		//assumes cold link reset befoer this
{
	uint16_t vid1, vid2;
	uint32_t tries;
	
	if (!ac97codecInit(where, &vid1, &vid2))
		return false;
	
	if (vid1 != VID_1_VAL_WM9705 || vid2 != VID_2_VAL_WM9705) {
		
		loge("VID doesn't match: 0x%04x 0x%04x\n", vid1, vid2);
		return false;
	}
	
	for (tries = 0; tries < 1024; tries++) {
		
		if (ac97IsCodecReady(where))
			return true;
	}
	
	loge("Failed to wait for codec power up\n");
	
	return true;
}


bool wm9705penInit(bool on, uint8_t del, bool pden, bool penDetInverted, bool busyFlagEn, bool busyFlagInverted, bool wait, bool higherPressureCurrent, bool phiz, uint8_t msk, uint8_t pdd)
{
	uint16_t val;
	
	//0x76
	mDigCtl1 = val = (del << 4) | 0xf08;	//convert coordinates, fast rate
	if (!ac97codecRegWrite(WM9705_REG_DIGITIZER_CONTROL_1, val))
		return false;
	
	//0x78
	mDigCtl2 = val = (on ? 0xc000 : 0) | (pden ? 0x1000 : 0) | (penDetInverted ?0x0800 : 0) | (busyFlagEn ? 0x0400 : 0) | (busyFlagInverted ? 0x0200 : 0) | (wait ? 0x0100 : 0) | (higherPressureCurrent ? 0x0080 : 0) | (phiz ? 0x0040 : 0) | ((msk & 3) << 4) | (pdd & 15);
	if (!ac97codecRegWrite(WM9705_REG_DIGITIZER_CONTROL_2, val))
		return false;
	
	return true;
}

bool wm9705penSetPden(bool pden)
{
	uint32_t newVal = mDigCtl2;
	
	if (pden)
		newVal |= 0x1000;
	else
		newVal &=~ 0x1000;
	
	if (newVal != mDigCtl2) {
		if (!ac97codecRegWrite(WM9705_REG_DIGITIZER_CONTROL_2, newVal))
			return false;
		mDigCtl2 = newVal;
	}
	
	return true;
}

bool wm9705penSetExtraSamp(enum WM9705penSampleType extraSampTyp)
{
	uint32_t newVal = mDigCtl1;
	
	newVal &=~ 0x7000;
	newVal |= (((uint32_t)extraSampTyp) << 12);
	
	if (newVal != mDigCtl2) {
		if (!ac97codecRegWrite(WM9705_REG_DIGITIZER_CONTROL_1, newVal))
			return false;
		mDigCtl1 = newVal;
	}
	
	return true;
}