#include "msioComms.h"
#include "printf.h"
#include "rtc.h"


static DrvRtcCbk mAlmCbk = NULL, mHzCbk = NULL;
static uint32_t mCurTime;

static void rtcPrvMsioSecondCbk(uint32_t curTime, bool alarm)
{
	bool tick = mCurTime != curTime;
	
	mCurTime = curTime;
	
	if (tick && mHzCbk)
		mHzCbk();
	if (alarm && mAlmCbk)
		mAlmCbk();
}

kstatus_t drvRtcInit(DrvRtcCbk hzCbk, DrvRtcCbk almCbk)
{
	uint32_t time;
	kstatus_t sta;
	
	mAlmCbk = almCbk;
	mHzCbk = hzCbk;
	
	msioCommsRtcSetSecondCbk(rtcPrvMsioSecondCbk);
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcPreSleep(void)
{
	//todo
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcPostWake(void)
{
	//todo
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcGet(uint32_t *valP)
{
	*valP = mCurTime;
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcSet(uint32_t val)
{
	msioCommsRtcSetRtc(val);
	return KERN_STATUS_OK;
}

kstatus_t drvRtcSetAlarm(uint32_t at)
{
	msioCommsRtcSetAlarm(at);
	return KERN_STATUS_OK;
}
