#ifndef _KAL_H_
#define _KAL_H_

#include <PalmTypes.h>
#include <stdbool.h>
#include <stdint.h>

typedef void (*ThreadFunc)(void *param);

struct KalTaskCreateInfo {
	void*		exinf;
	ThreadFunc	codeToRun;
	uint32_t	stackSz;
	uint32_t	prio;
	uint32_t	tag;			//unuse din general
};

struct KalTaskInfo {
	void*		exinf;		//untouched and ingored by us
	void*		startFunc;
	void*		curStack;	//we do not provide this. it always looks like func is using 4 bytes of stack (for credibility)
	uint32_t	stackSz;
	uint32_t	prio;		//untouched and ingored by us
	uint32_t	tag;		//untouched and ingored by us
	uint32_t	waitId;		//we do not provide this
	uint16_t	waitCause;	//we do not provide this
	uint8_t		taskState;	//we do not provide this
	uint8_t		wakeupCnt;	//we do not provide this
	uint32_t	suspendCnt;	//we do not provide this
};

Err KALTaskCreate(uint32_t *tidP, const struct KalTaskCreateInfo *info);
Err KALTaskStart(uint32_t tid, void *taskParam);
Err KALTaskGetCurrentID(uint32_t *tidP);
Err KALTaskGetInfo(uint32_t tid, struct KalTaskInfo* info);
Err KALTaskSwitching(bool enable);
Err KALTaskWait(int32_t timeoutMSec);	//sleep up to given number of msec or until someone else wakes us
Err KALTaskWaitClr(void);				//"wake" state gotten from KALTaskWake willpersist if we woke up not because of it. this clears it
Err KALTaskWake(uint32_t tid);	//wake a task waiting in KALTaskWait()
Err KALTaskDelay(uint32_t msec);
Err KALTaskDelete(uint32_t tid);
Err KALTaskSuspend(uint32_t tid);
Err KALTaskResume(uint32_t tid);

Err KALSemaphoreCreate(uint32_t *semHandleP, uint32_t tag, uint32_t initialVal);
Err KALSemaphoreDelete(uint32_t semHandle);
Err KALSemaphoreSignal(uint32_t semHandle);
Err KALSemaphoreWait(uint32_t semHandle, int32_t timeout);

Err KALMutexCreate(uint32_t *mutHandleP, UInt32 tag);
Err KALMutexDelete(uint32_t mutHandle);
Err KALMutexRelease(uint32_t mutHandle);
Err KALMutexReserve(uint32_t mutHandle, int32_t timeoutMsec);

#ifdef KAL_EXPORT_RAW_MUTEX_CMDS
	//used by module manager before module manager is up so we export proper names too
	Err impl_KALMutexCreate(uint32_t *mutHandleP, UInt32 tag);
	Err impl_KALMutexRelease(uint32_t mutHandle);
	Err impl_KALMutexReserve(uint32_t mutHandle, int32_t timeoutMsec);
#endif

#define KAL_EVT_GRP_WAIT_TYPE_OR	2
#define KAL_EVT_GRP_WAIT_TYPE_AND	1


struct KalEvtGrpWaitReq {
	uint32_t	wantedBits;
	uint32_t	waitType;		//KAL_EVT_GRP_WAIT_TYPE_*
	int32_t		timeoutMsec;	//negative for forever, 0 for no wait, positive for milliseconds
};

Err KALEventGroupCreate(uint32_t *evtGrpHandleP, uint32_t tag, uint32_t startingState);
Err KALEventGroupDelete(uint32_t evtGrpHandle);
Err KALEventGroupClear(uint32_t evtGrpHandle, uint32_t evts);
Err KALEventGroupRead(uint32_t evtGrpHandle, uint32_t *evtsP);
Err KALEventGroupSignal(uint32_t evtGrpHandle, uint32_t evts);
Err KALEventGroupWait(uint32_t evtGrpHandle, const struct KalEvtGrpWaitReq *req, uint32_t *evtsP);

typedef void (*KALTimerProcFn)(void *userData);
Err KALTimerCreate(uint32_t *timerIDP, uint32_t tag, KALTimerProcFn cbk, void *userData);
Err KALTimerDelete(uint32_t timerID);
Err KALTimerSet(uint32_t timerID, uint32_t milliseconds);

Err KALMailboxCreate(uint32_t *mailboxIDP, uint32_t tag, uint32_t depth);
Err KALMailboxDelete(uint32_t mailboxID);
Err KALMailboxSend(uint32_t mailboxID, uint32_t message);
Err KALMailboxWait(uint32_t mailboxID, uint32_t *messageP, int32_t timeout);

#endif