#include "boot.h"
#include "ral_export.h"
#include "printf.h"
#include "misc.h"
#include "pace.h"
#include "dal.h"
#include "ral.h"



static Err dalPaceDispatch(EmulStateRef ref, uint16_t call)
{
	Err ret = errNone, ret68k = errNone;
	void *retPtr, *paramP1, *paramP2;
	uint32_t ret32, t;
	uint64_t ret64;
	bool bVal;
	
	//all 68k calls return "Err" and provide return value via pointer (unless it was "Err", in which case directly)
	switch (call) {
		case sysLibTrapOpen:
		case sysLibTrapClose:
		case sysLibTrapSleep:
		case sysLibTrapWake:
			break;
		
		case sysLibTrapCustom + REPALM_FUNC_IDX_GET_CLOCK_RATE:		//Err (i32 *rateP, u32 which)
			retPtr = (void*)PceReadInt32From68KStack(ref, 2);
			if (retPtr == NULL)
				return sysErrParamErr;
			ret32 = repalmDalGetClockRate(PceReadInt32From68KStack(ref, 6));
			PceWriteInt32To68KMemory(ref, retPtr, 0, ret32);
			ret68k = errNone;
			break;
		
		case sysLibTrapCustom + REPALM_FUNC_IDX_GET_TIMER_VAL:		//Err (u64 *timerValP)
			retPtr = (void*)PceReadInt32From68KStack(ref, 2);
			if (retPtr == NULL)
				return sysErrParamErr;
			ret64 = repalmDalGetTimerVal();
			PceWriteInt32To68KMemory(ref, retPtr, 4, ret64);
			PceWriteInt32To68KMemory(ref, retPtr, 0, ret64 >> 32);
			ret68k = errNone;
			break;
		
		case sysLibTrapCustom + REPALM_FUNC_IDX_GET_ADC_VALUE:		//Err (i32 *val, u32 which);
			retPtr = (void*)PceReadInt32From68KStack(ref, 2);
			if (retPtr == NULL)
				return sysErrParamErr;
			ret32 = repalmDalGetAdcVal(PceReadInt32From68KStack(ref, 6));
			PceWriteInt32To68KMemory(ref, retPtr, 0, ret32);
			ret68k = errNone;
			break;

		case sysLibTrapCustom + REPALM_FUNC_IDX_PWR_CTL:			//Err (bool* success, u32 which, const u32 *newValP, u32 *oldValP)
			retPtr = (void*)PceReadInt32From68KStack(ref, 2);
			if (retPtr == NULL)
				return sysErrParamErr;
			paramP1 = (void*)PceReadInt32From68KStack(ref, 10);
			paramP2 = (void*)PceReadInt32From68KStack(ref, 14);
			if (paramP1)
				t = PceReadInt32From68KMemory(ref, paramP1, 0);
			if (paramP2)
				ret32 = PceReadInt32From68KMemory(ref, paramP2, 0);
			bVal = hwPwrCtl(PceReadInt32From68KStack(ref, 6), paramP1 ? &t : NULL, paramP2 ? &ret32 : NULL);
			PceWriteInt8To68KMemory(ref, retPtr, 0, bVal);
			if (paramP1)
				PceWriteInt32To68KMemory(ref, paramP1, 0, t);
			if (paramP2)
				PceWriteInt32To68KMemory(ref, paramP2, 0, ret32);
			ret68k = errNone;
			break;

		default:
			//not all machine-specific things need to be exported, so not all machines support this
			ret = machinePaceDispatch(ref, call, &ret68k);
			break;
	}
	
	PceSet68KInt16ReturnResult(ref, ret68k);
	return ret;
}


static Err dalPaceHandler(EmulStateRef ref, void* param, uint16_t call)
{
	if (call == 0) {		//lib oad
		
		((void**)param)[5] = "rePalm DAL";
	}
	else if (call == 1)	{	//lib unload
		
		//nothing to do
	}
	else { 					//call from 68k
		
		return dalPaceDispatch(ref, call);
	}
	
	return errNone;
}

void* dalGetPaceHandlerPtr(void)
{
	return &dalPaceHandler;
}
