#ifndef _BOOT_H_
#define _BOOT_H_

#include <stdbool.h>
#include <stdint.h>


#define DmOpenDatabaseInfo DmOpenDatabaseInfo_OLD
#define DmDatabaseInfo DmDatabaseInfo_OLD
#define DmNumDatabases DmNumDatabases_OLD
#define DmGetDatabase DmGetDatabase_OLD
#define DmOpenDatabase DmOpenDatabase_OLD
#define DmGetNextDatabaseByTypeCreator DmGetNextDatabaseByTypeCreator_OLD
#define SysAppLaunch SysAppLaunch_OLD
#define SysBatteryInfo SysBatteryInfoV40
#define SysNotifyRegister SysNotifyRegisterV40
#define DmFindDatabase DmFindDatabaseV40
#define SysNotifyUnregister SysNotifyUnregisterV40
#define AlmSetAlarm AlmSetAlarmV40
#define DmDatabaseProtect DmDatabaseProtectV40
#define DmCreateDatabase DmCreateDatabaseV40
#include <DataMgr.h>
#include <NotifyMgr.h>
#include <SystemMgr.h>
#include <NotifyMgr.h>
#include <SoundMgr.h>
#include <TimeMgr.h>
#include <Bitmap.h>
#include <Rect.h>
#include <AlarmMgr.h>
#include <ErrorBase.h>
#include <Crc.h>
#undef DmDatabaseProtect
#undef AlmSetAlarm
#undef SysNotifyUnregister
#undef DmFindDatabase
#undef SysNotifyRegister
#undef SysBatteryInfo
#undef SysAppLaunch
#undef DmGetNextDatabaseByTypeCreator
#undef DmOpenDatabase
#undef DmGetDatabase
#undef DmNumDatabases
#undef DmDatabaseInfo
#undef DmOpenDatabaseInfo
#undef DmCreateDatabase

Err AlmSetAlarm(LocalID dbID, UInt32 ref, UInt32 alarmSeconds, Boolean quiet, AlmAlarmProcPtr procP);
Err SysNotifyUnregister(LocalID dbID, UInt32 notifyType, Int8 priority);
LocalID	DmFindDatabase(const Char *nameP);
Err SysAppLaunch(LocalID dbID, UInt16 launchFlags, UInt16 cmd, MemPtr cmdPBP, UInt32 *resultP);
Err DmGetNextDatabaseByTypeCreator(Boolean newSearch, DmSearchStatePtr stateInfoP, UInt32 type, UInt32 creator, Boolean onlyLatestVers, LocalID *dbID);
Err DmDatabaseInfo(LocalID dbH, Char *nameP, uint16_t* attributesP, uint16_t *versionP, uint32_t *crDateP, uint32_t* modDateP, uint32_t *bckUpDateP, uint32_t * modNumP, MemHandle *appInfoHP, MemHandle *sortInfoHP, uint32_t *typeP, uint32_t *creatorP);
Err DmOpenDatabaseInfo(DmOpenRef dbP, LocalID* dbIDP, UInt16* openCountP, uint16_t* modeP, Boolean* resDBP);
uint16_t DmNumDatabases(void);
LocalID DmGetDatabase(uint16_t dbIdx);
DmOpenRef DmOpenDatabase(LocalID dbID, UInt16 mode);
Err DmCreateDatabase(const Char * nameP, UInt32 creator, UInt32 type, Boolean resDB);
Err DmDatabaseProtect(LocalID dbID, Boolean protect);
Err SysNotifyRegister(LocalID dbId, uint32_t notifyType, SysNotifyProcPtr callbackP, int8_t priority, void *userDataP);
void SysEventAddToQueue(const EventType *evt);

UInt32 HALOEMGetCompanyID(void);
UInt32 HALOEMGetHALID(void);
UInt32 HALOEMGetDeviceID(void);

Err SysPatchEntry(UInt32 refNum, UInt32 entryNum, void *procP, void **oldProcP);
Err SysGetEntryAddresses(UInt32 refNum, UInt32 entryNumStart, UInt32 entryNumEnd, void **addressesP);
Err SysFindModule(UInt32 dbType, UInt32 dbCreator, UInt16 rsrcID, UInt32 flags, UInt32 *refNumP);
Err SysLoadModule(UInt32 dbType, UInt32 dbCreator, UInt16 rsrcID, UInt32 flags, UInt32 *refNumP);
Err SysUnloadModule(UInt32 refNum);
Err SysFindModule(UInt32 dbType, UInt32 dbCreator, UInt16 rsrcID, UInt32 flags, UInt32 *refNumP);

Err SysBatteryInfo(Boolean set, UInt16 *warnThresholdPercentP, UInt16 *criticalThresholdPercentP, UInt16 *shutdownThresholdPercentP, UInt32 *warnMaxTicksP, SysBatteryKind *kindP, Boolean *pluggedInP, SysBatteryState *stateP, UInt8 *percentP);

struct PalmFont;
struct PalmSilkscreenInfo;
struct EvtMgrGlobals;
struct BitmapType;
struct PalmClut;
struct PalmOsGobals {
	uint8_t						rfu0[0x3c];			//0x00
	struct EvtMgrGlobals		*evtG;				//0x3C
	uint8_t						rfu1[0x1c];			//0x40
	UInt8						resetFlags;			//0x5C
	uint8_t						rfu2[0x67];			//0x5D
	struct PalmSilkscreenInfo	*silkNfo;			//0xC4
	uint8_t						rfu3[0x0c];			//0xC8
	struct PalmFont				**appSubFonts;		//0xD4	(if app defined a font with a font map (and subfonts), this is where the fonts for it are)
};

struct PalmOsGobals* PalmOSGetGlobalsPtr(void);

struct PalmBitmapV3fat;
void BmpPrvConvertBitmap(BitmapPtr srcBmp, struct PalmBitmapV3fat *dstBmp);	//exists in Boot.prc
void WinGetBitmapDimensions(BitmapPtr bmp, Coord *widthP, Coord *heightP);	//bmp dims in current coord sys
struct BitmapType* BmpCreateVersion3(Coord w, Coord h, uint32_t depth, struct PalmClut *clut, uint32_t density, uint32_t transparentValue, uint32_t pixelFormat, Err *errOut);

void SysEventAddUniqueToQueue(const EventType *evt, uint32_t id, bool replaceInPlaceInPlace);
	
uint16_t AttnIndicatorGetBlinkPattern(void);
bool AttnIndicatorAllowed(void);


#define NOTIF_REGISTER_NO_DB			((LocalID)0xFFFFFFFFUL)

#endif
