#include "util.h"



XXX: if a databse exists with the following type and creator, the os will open it and use fonts in there instad of system fonts, it might save us from having to reach into globals to patch fonts
type: fnts
crid: psys
	

/*
	left things to patch:
		
		UI's check for & use of 0x6C (aka 108):
			Field code
				DrawChars	(also uses WinPrvScalePoint)
				ScrollDisplayUp
				ScrollDisplayDown
			LstScrollList
			PrvHandleScrollingIndicators	(used by LstHandleEvent)
			DrawArrow (used by SclDrawScrollbar & SclHandleEvent)
			SclDrawScrollbar
			SclHandleEvent
			ResizeTextItem (used by TblHandleEvent)
			Command bar erasing
			Menu erasing
*/

static void initGlobals(struct Globals *g)
{
	//if we had globals that need initial values we'd set them here
}

static uintptr_t __attribute__((noinline,naked)) getBase(void)		//get base of this module in a sane way. there is no way to do this in c (gcc insists on a got). luckily GAS has our back
{
	asm volatile(
		"	ldr r0, 1f			\n\t"
		"	add r0, pc			\n\t"
		"	bx lr				\n\t"
		"2:						\n\t"
		"	.balign 4			\n\t"
		"1:						\n\t"
		"	.word vecs - 2b		\n\t"
	);
	
	return 0;	//shut gcc up, you're useless
}

static void __attribute__((naked, used, section(".patches.a"))) patchesStart(void) {}	//must be in same compilation unit as the below, or else we get a ".got"
static void __attribute__((naked, used, section(".patches.z"))) patchesEnd(void) {}
static void installPatchesForModule(struct Globals *g, uint32_t moduleId, uint32_t moduleRefNo, uintptr_t base)
{
	const struct PalmOsFuncPatch *__patches_start = (struct PalmOsFuncPatch*)(((uintptr_t)&patchesStart) &~ 1);
	const struct PalmOsFuncPatch *__patches_end = (struct PalmOsFuncPatch*)(((uintptr_t)&patchesEnd) &~ 1);
	const struct PalmOsFuncPatch *p;
	
	for (p = __patches_start; p != __patches_end; p++) {
		
		void *func = (void*)((((uintptr_t)p->func) & 0x00ffffff) + base);
		
		if (p->moduleId != moduleId)
			continue;
		
		if (errNone != SysPatchEntry(moduleRefNo, p->entryPt, func, (p->oldTrapOfst == -1) ? NULL : (((void**)g) + p->oldTrapOfst)))
			SysFatalAlert("Patch install failure");
	}
}

static void installPatches(struct Globals *g)
{
	uintptr_t base = getBase();
	uint32_t refNo;

	if (errNone != SysFindModule('rsrc', 'pdal', 0, 0, &refNo))
		SysFatalAlert("Failed to find DAL");
	installPatchesForModule(g, 0, refNo, base);

	if (errNone != SysFindModule('rsrc', 'psys', 0, 0, &refNo))
		SysFatalAlert("Failed to find Boot");
	installPatchesForModule(g, 1, refNo, base);

	if (errNone != SysFindModule('rsrc', 'puil', 0, 0, &refNo))
		SysFatalAlert("Failed to find UI");
	installPatchesForModule(g, 2, refNo, base);
}

static void installFonts(struct Globals *g)
{
	static const uint16_t myResIds[] = {32000, 32001, 32002, 10000, 10001, 10002, 10003, 32003};
	uint32_t i, myNumFonts = sizeof(myResIds) / sizeof(*myResIds), oldNumFonts;
	struct UiGlobals *ui = UIGetGlobalsPtr();
	struct PalmFont **myFonts, **oldFonts;
	MemHandle mh;
	DmOpenRef db;
	
	if (!ui->numSystemFonts)
		SysFatalAlert("Too early to replace fonts!\n");
	
	db = DmOpenDatabase(DmFindDatabase(MY_DB_NAME), dmModeReadOnly);
	if (!db)
		SysFatalAlert("Cannot open self\n");
	
	myFonts = MemChunkNew(0, sizeof(void*) * myNumFonts, 0x200);
	for (i = 0; i < myNumFonts; i++) {
		mh = DmGet1Resource('afnx', myResIds[i]);
		myFonts[i] = MemHandleLock(mh);
	}
	
	oldNumFonts = ui->numSystemFonts;
	oldFonts = ui->systemFonts;
	
	if (oldNumFonts > myNumFonts)
		ui->numSystemFonts = myNumFonts;
	ui->systemFonts = myFonts;
	ui->numSystemFonts = myNumFonts;
	
	for (i = 0; i < oldNumFonts; i++) {
		if (oldFonts[i])
			MemPtrUnlock(oldFonts[i]);
	}
	MemChunkFree(oldFonts);
	DmCloseDatabase(db);
}

static void alarmTriggeredProc(UInt16 almProcCmd, SysAlarmTriggeredParamType *paramP)
{
	DmOpenDatabase(DmFindDatabase(MY_DB_NAME), dmModeLeaveOpen | dmModeReadOnly);
}

static void registerForResetEndNotif(void)		//doing this via notif fails (somehow db gets closed, so we do it via alarm now)
{
	AlmSetAlarm(DmFindDatabase(MY_DB_NAME), 0, TimGetSeconds(), true, &alarmTriggeredProc);
}

static void advertiseFeatureSet(void)
{
	uint32_t version;
	
	if (errNone != FtrGet(sysFtrCreator, sysFtrNumWinVersion, &version))
		SysFatalAlert("Cannot get window manager version\n");
	
	if (version != 4)
		logw("Window manager version not what was expected. Got %u\n", version);
	else
		FtrSet(sysFtrCreator, sysFtrNumWinVersion, 5);
}

static void prvPaceHdDispatchHandler(EmulStateRef ref)
{
	struct Globals *g = globalsGet();
	uint32_t selector = ref->d[2];
	
	if (selector == HDSelectorWinSetScalingMode) {
		
		PceSet68KInt32ReturnResult(ref, WinSetScalingMode(PceReadInt32From68KStack(ref, 0)));
	}
	else if (selector == HDSelectorWinGetScalingMode) {
		
		PceSet68KInt32ReturnResult(ref, WinGetScalingMode());
	}
	else
		g->oldPaceHdDispatchHandler(ref);
}

static void installExtra68kThings(struct Globals *g)
{
	if (errNone != PceGet68KTrapHandler(PceGetSystemEmulState(), 0x3EC, &g->oldPaceHdDispatchHandler)) //sysTrapHighDensityDispatch
		SysFatalAlert("Failed to get HD 68K handler");
	if (errNone != PceSet68KTrapHandler(PceGetSystemEmulState(), 0x3EC, prvPaceHdDispatchHandler)) //sysTrapHighDensityDispatch
		SysFatalAlert("Failed to get HD 68K handler");
	
}

uint32_t __attribute__((used)) PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	
	if (cmd == RAL_CMD_LOAD) {
		
		uint16_t density;
		uint32_t osVer;
	
		if (errNone != FtrGet(sysFtrCreator, sysFtrNumROMVersion, &osVer))
			SysFatalAlert("Cannot get OS version");
		
		if (errNone != HALDisplayGetAttributes(hwrDispDensity, &density))
			SysFatalAlert("Cannot get display density");
		
		if (osVer >= 0x05100000 && osVer < 0x05400000 && (density != kDensityLow && density != kDensityDouble)) {
			
			struct Globals *g = globalsGet();
			
			initGlobals(g);
			installPatches(g);
			if (density == kDensityOneAndAHalf || density == kDensityTriple)
				installFonts(g);
			registerForResetEndNotif();
			installExtra68kThings(g);
			advertiseFeatureSet();
		}
	}
	
	return errNone;
}





