#include "flashops.h"
#include "psoc40xx.h"


#define RAMFUNC			__attribute__((section(".ramfuncs")))
#define RAMFUNC_ENTRY	RAMFUNC __attribute__((noinline))


void flashOpsInit(void)
{
	extern uint32_t __ramfuncs_start[], __ramfuncs_end[], __ramfuncs_data[];
	uint32_t *src = __ramfuncs_data, *dst = __ramfuncs_start;
	
	while (dst < __ramfuncs_end)
		*dst++ = *src++;
}

static void RAMFUNC __attribute__((used, noinline)) timedOp(struct PsocSpcifType *spcif, uint32_t time)
{
	spcif->FLASH_OP_TIMER = time;
	spcif->FLASH_LL_CTRL |= 0x200;
	while(spcif->FLASH_LL_CTRL & 0x200);
}

static void  RAMFUNC __attribute__((noinline,naked)) programing_substep(struct PsocSpcifType *spcif, uint32_t time, uint32_t step)
{
	//gcc sucks at optimizing so we do it for it
	//equivalent C:		spcif->FLASH_LL_CTRL = (SPCIF->FLASH_LL_CTRL &~ 0x30) | step;
	//					spcif->FLASH_LL_CTRL |= 0x40;
	//					timedOp(spcif, time);
	
	asm volatile(
		"	mov r12, r1			\n\t"
		"	mov r3, #0x30		\n\t"
		"	ldr r1, [r0, #0x0C]	\n\t"
		"	bic r1, r3			\n\t"
		"	orr r1, r2			\n\t"
		"	str r1, [r0, #0x0C]	\n\t"	//second load would be redundant as FLASH_LL_CTRL will not change from under us
		"	mov r2, #0x40		\n\t"
		"	orr r1, r2			\n\t"
		"	str r1, [r0, #0x0C]	\n\t"
		"	mov r1, r12			\n\t"
		"	b   timedOp			\n\t"
	);
}

static void RAMFUNC __attribute__((noinline,naked)) flash_ll_ctrl_clear_0x4000(struct PsocSpcifType *spcif)	//purely a space-saving measure
{
	//gcc sucks at optimizing so we do it for it
	//equivalent C:   spcif->FLASH_LL_CTRL &=~ 0x4000;
	asm volatile(
		"	mov r1, #0x40		\n\t"
		"	lsl r1, #8			\n\t"
		"	ldr r2, [r0, #0x0C]	\n\t"
		"	bic r2, r1			\n\t"
		"	str r2, [r0, #0x0C]	\n\t"
		"	bx  lr				\n\t"
	);
}

static void RAMFUNC __attribute__((noinline,naked)) flash_ll_ctrl_set_0x4000(struct PsocSpcifType *spcif)	//purely a space-saving measure
{
	//gcc sucks at optimizing so we do it for it
	//equivalent C:   spcif->FLASH_LL_CTRL |= 0x4000;
	asm volatile(
		"	mov r1, #0x40		\n\t"
		"	lsl r1, #8			\n\t"
		"	ldr r2, [r0, #0x0C]	\n\t"
		"	orr r2, r1			\n\t"
		"	str r2, [r0, #0x0C]	\n\t"
		"	bx  lr				\n\t"
	);
}

static void RAMFUNC __attribute__((used)) flash_op_finishing_steps(struct PsocSpcifType *spcif)
{
	uint32_t t;
	
	spcif->FLASH_LL_CTRL &=~ 0x80;
	
	timedOp(spcif, 650);
	
	programing_substep(spcif, 13, 0x30);
	
	t = spcif->FLASH_LL_CTRL;
	spcif->FLASH_LL_CTRL = t &=~ 0x30;
	
	spcif->FLASH_LL_CTRL = t |= 0x40;
	spcif->FLASH_LL_CTRL = t &=~ 0x0F;
	spcif->FLASH_LL_CTRL = t |= 0x40;
	flash_ll_ctrl_clear_0x4000(spcif);
}

static void RAMFUNC __attribute__((noinline, naked)) rubber_to_road(struct PsocSpcifType *spcif, uint8_t calibOfst, uint8_t op, uint32_t sromStart)
{
	//gcc sucks at optimizing so we do it for it
	//equivalent C:
	
	//uint32_t calibdata = *(uint32_t*)(sromStart + 0x1A0 + calibOfst);
	//uint8_t *otherCalibdata = (uint8_t*)(sromStart + 0x1BC);	//gcc still produces shitty code for this...no idea whay
	//spcif->unknown_ff0c = otherCalibdata[op >> 7];
	//
	//timedOp(spcif, 650);
	//spcif->DAC_SETTINGS = calibdata >> 24;
	//flash_ll_ctrl_set_0x4000(spcif);
	//
	//if ((op & 0x0F) == 0x01) {
	//		
	//	spcif->FLASH_LL_CTRL |= 0x01;
	//	spcif->FLASH_LL_CTRL |= 0x40;
	//	op |= 0x0F;
	//}
	//
	//#ifdef SUPPORT_FULL_CHIP_ERASE
	//	if (op & 0x20) {
	//		
	//		spcif->FLASH_LL_CTRL |= 0x02;
	//		spcif->WRITE_LATCH_VAL = 0xFF;
	//		spcif->FLASH_LL_CTRL &=~ 0x02;
	//	}
	//#endif
	//
	//spcif->FLASH_LL_CTRL |= op & 0x0f;
	//
	//programing_substep(spcif, 13, 0x10);
	//programing_substep(spcif, 130, 0x20);
	//
	//spcif->FLASH_LL_CTRL |= 0x80;
	//timedOp(spcif, calibdata & 0x00ffffff);
	
	//flash_op_finishing_steps(spcif);
	
	asm volatile(
		"	add   r3, #0xFF					\n\t"	// sromStart += 0x1A0;
		"	add   r3, #0xA1					\n\t"
		"	push  {r0-r6, lr}				\n\t"
		"	mov   r4, #0xff					\n\t"	// r4 = spcif + 0xFF00
		"	lsl   r4, #8					\n\t"
		"	add   r4, r0					\n\t"
		"	lsr   r5, r2, #7				\n\t"	// r5 = (op >> 7) + 0x1C
		"   add   r5, #0x1C					\n\t"
		"	ldrb  r5, [r3, r5]				\n\t"	// r5 = [sromStart, r5]
		"	str   r5, [r4, #0x0C]			\n\t"	// spcif->unknown_ff0c = r5
		"	ldr   r1, =650					\n\t"	// timedOp(spcif, 650);
		"	bl    timedOp					\n\t"
		"	pop   {r0-r3}					\n\t"
		"   mov   r6, r2					\n\t"	// r6 is now op
		"	ldr   r5, [r3, r1]				\n\t"	// r5 = [sromStart, calibOfst]			//r5 = calibdata
		"	lsr   r1, r5, #24				\n\t"	// r1 = top byte of r5 (DAC settings)
		"	str   r1, [r4, #0x08]			\n\t"	// spcif->DAC_SETTINGS = calibdata >> 24;
		"   bl    flash_ll_ctrl_set_0x4000	\n\t"	// we know this only clobbers r1 & r2
		"	mov   r1, #0x0F					\n\t"	// if ((op & 0x0F) == 1)
		"	and   r1, r6					\n\t"
		"	cmp   r1, #1					\n\t"
		"	bne   1f						\n\t"	// {
		"	ldr   r1, [r0, #0x0C]			\n\t"	//    spcif->FLASH_LL_CTRL |= 0x01;
		"	mov   r2, #0x01					\n\t"
		"	orr   r1, r2					\n\t"
		"	str   r1, [r0, #0x0C]			\n\t"
		"	mov   r2, #0x40					\n\t"   //    spcif->FLASH_LL_CTRL |= 0x40;
		"	orr   r1, r2					\n\t"
		"	str   r1, [r0, #0x0C]			\n\t"
		"	mov   r1, #0x0F					\n\t"   //    op |= 0x0F
		"	orr   r6, r1					\n\t"
		"1:									\n\t"	// }
#ifdef SUPPORT_FULL_CHIP_ERASE
		"	mov   r1, #0x20					\n\t"	// if (op & 0x20)
		"	tst   r1, r6					\n\t"
		"	beq   1f						\n\t"	// {
		"	mov   r2, #2					\n\t"
		"	ldr   r1, [r0, #0x0C]			\n\t"	//    spcif->FLASH_LL_CTRL |= 2;
		"	orr   r2, r1					\n\t"
		"	str   r2, [r0, #0x0C]			\n\t"
		"	mov   r2, #0xFF					\n\t"	//    spcif->WRITE_LATCH_VAL = 0xFF;
		"	str   r2, [r0, #0x10]			\n\t"
		"	str   r1, [r0, #0x0C]			\n\t"	//    spcif->FLASH_LL_CTRL &=~ 2;
		"1:									\n\t"	// }
#endif
		"	mov   r1, #0x0F					\n\t"	// op &= 0x0F
		"	and   r6, r1					\n\t"
		"	ldr   r1, [r0, #0x0C]			\n\t"	// spcif->FLASH_LL_CTRL |= op;
		"	orr   r1, r6					\n\t"
		"	str   r1, [r0, #0x0C]			\n\t"
		"	mov   r6, r0					\n\t"
		"	mov   r1, #13					\n\t"	// programing_substep(spcif, 13, 0x10)
		"	mov   r2, #0x10					\n\t"
		"	bl    programing_substep		\n\t"
		"	mov   r0, r6					\n\t"	// programing_substep(spcif, 130, 0x20)
		"   mov   r1, #130					\n\t"
		"	mov   r2, #0x20					\n\t"
		"	bl    programing_substep		\n\t"
		"	ldr   r1, [r6, #0x0C]			\n\t"	// spcif->FLASH_LL_CTRL |= 0x80;
		"	mov   r2, #0x80					\n\t"
		"	orr   r1, r2					\n\t"
		"	str   r1, [r6, #0x0C]			\n\t"
		"	lsl   r5, r5, #8				\n\t"	// calibdata &= 0x00ffffff;
		"	lsr   r1, r5, #8				\n\t"
		"	mov   r0, r6					\n\t"	// timedOp(spcif, calibdata);
		"	bl    timedOp					\n\t"
		"	mov   r0, r6					\n\t"
		"	bl    flash_op_finishing_steps	\n\t"	// flash_op_finishing_steps(spcif)
		"	pop   {r4-r6, pc}				\n\t"
	);
}

extern/*to make gcc not assume spcif == SPCIF*/
void RAMFUNC __attribute__((noinline)) program_or_write_setup(struct PsocSpcifType *spcif, uint32_t addr, uint32_t sromStart)
{
	bool srom = false;
	uint32_t row;
	
	if (addr >= sromStart) {	//SROM
		srom = true;
		addr -= sromStart;
	}
	
	//gcc sucks at optimising
	//equivalent C:
	/*
		switch((spcif->GEOMETRY >> 22) & 3) {	//row size
			case 3:		//256 byte rows
				row >>= 1;
				//fallthrough
			case 2:		//unsupported
				//fallthrough
			case 1:		//128-byte rows
				row >>= 1;
				//fallthrough
			case 0:		//64-byte rows
				row >>= 6;
				break;
			default:	//192-byte rows not supported
				row = 0;
		}
	*/
	asm volatile (
		"	lsl %0, #1		\n\t"
		"	add pc, %0		\n\t"
		"	nop				\n\t"
		"	lsr %1, #1		\n\t"	//case 3 - 256 byte rows
		"	nop				\n\t"	//case 2 - 192 byte rows (unsupported)
		"	lsr %1, #1		\n\t"	//case 1 - 128 byte rows
		"	lsr %1, #6		\n\t"
		:"=r"(addr) /*used as dummy here*/, "=r"(row)
		:"0" (3 - ((spcif->GEOMETRY >> 22) & 3)), "1"(addr)
		:"cc"
	);
	
	spcif->ADRCTRL &= 0x20000000;
	spcif->ADRCTRL |= row << 16;
	
	if (srom) {
		flash_ll_ctrl_clear_0x4000(spcif);
		spcif->ADRCTRL |= 0x10000000;
	}
}

extern/*to make gcc not assume spcif == SPCIF*/
void RAMFUNC __attribute__((noinline)) program_or_write_cleanup(struct PsocSpcifType *spcif)
{
	spcif->FLASH_LL_CTRL = 0x4004;
	spcif->FLASH_LL_CTRL |= 0x0040;
	spcif->FLASH_LL_CTRL = 0x0000;
	spcif->ADRCTRL = 0;
}

extern/*to make gcc not assume spcif == SPCIF*/
void RAMFUNC set_and_latch_flash_view(struct PsocSpcifType *spcif, uint32_t view)
{
	spcif->FLASH_VIEWCTL = (spcif->FLASH_VIEWCTL &~ 0x1F) | view;
	
	flash_ll_ctrl_set_0x4000(spcif);
	spcif->FLASH_LL_CTRL |= 0x0040;
	flash_ll_ctrl_clear_0x4000(spcif);
}

void RAMFUNC_ENTRY flashWriteLatches(uint32_t offset, uint32_t len, const uint8_t *data)
{
	flash_ll_ctrl_set_0x4000(SPCIF);
	SPCIF->ADRCTRL = 0x100 | offset;

	while (len--)
		SPCIF->WRITE_LATCH_VAL = *data++;

	flash_ll_ctrl_clear_0x4000(SPCIF);
}

void RAMFUNC_ENTRY flashReadLatches(uint32_t offset, uint32_t len, uint8_t *data)
{
	uint8_t *src = (uint8_t*)0x40;	//any row other than first is good. first may read SROM instead
	
	SPCIF->FLASH_LL_CTRL &=~ 0x0F;
	set_and_latch_flash_view(SPCIF, 0x18);
	
	src += offset;
	while(len--)
		*data++ = ~*src++;
	
	set_and_latch_flash_view(SPCIF, 0);
}

void RAMFUNC_ENTRY flashEraseRow(uint32_t addr)
{
	program_or_write_setup(SPCIF, addr, SROM_START);
	rubber_to_road(SPCIF, 0x00, 0x81, SROM_START);
	rubber_to_road(SPCIF, 0x04, 0x0b, SROM_START);
	program_or_write_cleanup(SPCIF);
}

void RAMFUNC_ENTRY flashWriteRow(uint32_t addr)
{
	program_or_write_setup(SPCIF, addr, SROM_START);
	rubber_to_road(SPCIF, 0x08, 0x8f, SROM_START);
	program_or_write_cleanup(SPCIF);
}

#ifdef SUPPORT_FULL_CHIP_ERASE

	void RAMFUNC_ENTRY flashFullErase(void)
	{
		SPCIF->ADRCTRL = 0x20000000;
		
		rubber_to_road(SPCIF, 0x0C, 0x29, SROM_START);
		rubber_to_road(SPCIF, 0x10, 0x8C, SROM_START);
		rubber_to_road(SPCIF, 0x0C, 0x09, SROM_START);
		program_or_write_cleanup(SPCIF);
	}

#endif



