#include <stdbool.h>
#include <stdint.h>
#include "mke.h"
#include "leds.h"

//int prio here is higher than systick, so calling time funcs IN our int handler may not work well...

//#define LEDS_ARE_BACKWARDS


static uint8_t gStorage[2][NUM_LEDS];
static volatile uint8_t *gVals = gStorage[0], *gBack = gStorage[1];

#define TIME_QUANTUM	50

const int8_t mLedsPosX[] = {0, 2, 4, 10, 15, 16, 14, 11, 7, 4, 0, -4, -7, -11, -14, -16, -15, -10, -4, -2};
const int8_t mLedsPosY[] = {20, 23, 28, 29, 26, 21, 16, 12, 8, 5, 2, 5, 8, 12, 16, 21, 26, 29, 28, 23};


void PIT_CH0_IRQHandler(void)
{
	static const uint8_t sLeds[NUM_LEDS] = {0x01, 0x02, 0x03, 0x04, 0x10, 0x12, 0x13, 0x14, 0x20, 0x21, 0x23, 0x24, 0x30, 0x31, 0x32, 0x34, 0x40, 0x41, 0x42, 0x43};
	static uint8_t sCurMult = 1, sCurIdx = 0;
	uint32_t pins, pinHi, pinLo;
	
	PIT->timer[0].TFLG = 1;

	
	pins = sLeds[sCurIdx];
	
	#ifdef LEDS_ARE_BACKWARDS
		
		pinHi = 256 << (pins >> 4);
		pinLo = 256 << (pins & 0x0f);
	
	#else
	
		pinLo = 256 << (pins >> 4);
		pinHi = 256 << (pins & 0x0f);
	
	#endif
	
	GPIO->PCOR = 0x1f00;
	GPIO->PDDR = pinHi | pinLo;
	if (gVals[sCurIdx] & sCurMult)
		GPIO->PSOR = pinHi;

		
	if (++sCurIdx == NUM_LEDS) {
		sCurIdx = 0;
		sCurMult <<= 1;
		if (!sCurMult) {
			sCurMult = 1;
			
			if (!gBack) {
				gBack = gVals;
				gVals = gVals == gStorage[0] ? gStorage[1] : gStorage[0];
			}
		}
		//recalc ldval now so next time we hit it properly
		PIT->timer[0].LDVAL = TIME_QUANTUM * sCurMult;
	}
}

void ledInit(void)
{
	//enable clock to pit0
	SIM->SCGC |= 1 << 1;
	
	//setup pit0
	PIT->MCR = 0;
	PIT->timer[0].LDVAL = 100;		//start now
	PIT->timer[0].TCTRL = 0x3;		//on and int on
	
	//enable pit0 interrupt
	NVIC_EnableIRQ(PIT_CH0_IRQn);
	NVIC_SetPriority(PIT_CH0_IRQn, 1);
}

void ledSet(uint32_t i, uint8_t bri)
{
	gBack[i] = bri;
}

uint8_t ledGet(uint32_t i)
{
	return gBack[i];
}

void ledSwap(void)
{
	uint32_t i;
	
	gBack = 0;
	while (!gBack) {
		asm volatile("":::"memory");
	}
	for (i = 0; i < NUM_LEDS; i++)
		gBack[i] = gVals[i];
}

void ledClear(void)
{
	uint32_t i;
	
	for (i = 0; i < NUM_LEDS; i++)
		gBack[i] = 0;
}








