#define WEAK __attribute__ ((weak))
#define ALIAS(f) __attribute__ ((weak, alias (#f)))

#include <stdint.h>

#define EXTREME_CLEVERNESS



WEAK void IntDefaultHandler(void);
WEAK void NMI_Handler(void) ALIAS(IntDefaultHandler);
WEAK void HardFault_Handler(void) ALIAS(IntDefaultHandler);
WEAK void SVC_Handler(void) ALIAS(IntDefaultHandler);
WEAK void PendSV_Handler(void) ALIAS(IntDefaultHandler);
WEAK void SysTick_Handler(void) ALIAS(IntDefaultHandler);

void FTMRE_IRQHandler(void) ALIAS(IntDefaultHandler);
void PMC_IRQHandler(void) ALIAS(IntDefaultHandler);
void IRQ_IRQHandler(void) ALIAS(IntDefaultHandler);
void I2C0_IRQHandler(void) ALIAS(IntDefaultHandler);
void SPI0_IRQHandler(void) ALIAS(IntDefaultHandler);
void UART0_IRQHandler(void) ALIAS(IntDefaultHandler);
void ADC0_IRQHandler(void) ALIAS(IntDefaultHandler);
void ACMP0_IRQHandler(void) ALIAS(IntDefaultHandler);
void ACMP1_IRQHandler(void) ALIAS(IntDefaultHandler);
void FTM0_IRQHandler(void) ALIAS(IntDefaultHandler);
void FTM2_IRQHandler(void) ALIAS(IntDefaultHandler);
void RTC_IRQHandler(void) ALIAS(IntDefaultHandler);
void PIT_CH0_IRQHandler(void) ALIAS(IntDefaultHandler);
void PIT_CH1_IRQHandler(void) ALIAS(IntDefaultHandler);
void KBI0_IRQHandler(void) ALIAS(IntDefaultHandler);
void KBI1_IRQHandler(void) ALIAS(IntDefaultHandler);
void ICS_IRQHandler(void) ALIAS(IntDefaultHandler);
void WDOG_IRQHandler(void) ALIAS(IntDefaultHandler);
void PWT_IRQHandler(void) ALIAS(IntDefaultHandler);


void LPTMR0_IRQHandler(void) ALIAS(IntDefaultHandler);
void PORTA_IRQHandler(void) ALIAS(IntDefaultHandler);
void PORTB_IRQHandler(void) ALIAS(IntDefaultHandler);


//main must exist
extern int main(void);

//stack top (provided by linker)
extern void __stack_top();
extern void __data_data();
extern void __data_start();
extern void __data_end();
extern void __bss_start();
extern void __bss_end();



#define INFINITE_LOOP_LOW_POWER		while (1) {				\
							asm("wfi":::"memory");	\
						}

//shove some thigns into first flash block as we might as well...
void __attribute__((noreturn)) __attribute__ ((section(".vectorscode"))) IntDefaultHandler(void)
{
	INFINITE_LOOP_LOW_POWER
}

//shove some thigns into first flash block as we might as well...
static void __attribute__((noreturn)) __attribute__ ((section(".vectorscode"))) ResetISR(void)
{
	uint32_t *dst, *src, *end;

	//copy data
	dst = (uint32_t*)&__data_start;
	src = (uint32_t*)&__data_data;
	end = (uint32_t*)&__data_end;
	while(dst != end)
		*dst++ = *src++;

	//init bss
	dst = (uint32_t*)&__bss_start;
	end = (uint32_t*)&__bss_end;
	while(dst != end)
		*dst++ = 0;

//maybe this?
	//SystemInit();

	main();

//if main returns => bad
	HardFault_Handler();
	
//do not return
	while(1);
}


//vector table

__attribute__ ((section(".vectors"))) void (*const __VECTORS[]) (void) =
{
	&__stack_top,		// The initial stack pointer
	ResetISR,		// The reset handler
	NMI_Handler,		// The NMI handler
	HardFault_Handler,	// The hard fault handler
	
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	
	SVC_Handler,		// SVCall handler
	0,			// Reserved
	0,			// Reserved
	PendSV_Handler,		// The PendSV handler
	SysTick_Handler,	// The SysTick handler
	
	// Chip Level - MKL03
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	FTMRE_IRQHandler,			// Command complete
    PMC_IRQHandler , //Low-voltage detect, low-voltage warning
	IRQ_IRQHandler , //"IRQ"
	I2C0_IRQHandler , //I2C0 interrupt
	0,			// Reserved
	SPI0_IRQHandler,
	0,			// Reserved
	UART0_IRQHandler, //LPUART0 status and error
	0,			// Reserved
	0,			// Reserved
	ADC0_IRQHandler , //ADC0 interrupt
	ACMP0_IRQHandler , //CMP0 interrupt
	FTM0_IRQHandler,
	0,
	FTM2_IRQHandler , //TPM1 single interrupt vector for all sources
	RTC_IRQHandler , //RTC alarm
	ACMP1_IRQHandler , //CMP0 interrupt
	PIT_CH0_IRQHandler,			// Reserved
	PIT_CH1_IRQHandler,			// Reserved
	KBI0_IRQHandler,			// Reserved
	KBI1_IRQHandler,			// Reserved
	0,			// Reserved
	ICS_IRQHandler,			// Reserved
	WDOG_IRQHandler , //LPTMR0 interrupt
	PWT_IRQHandler,			// Reserved
	0, //Reserved
	0, //Reserved
};


