#ifndef _NRF_H_
#define _NRF_H_

#include <stdint.h>

#ifndef true
# define true 1
#endif

#ifndef false
# define false 0
#endif

#ifndef bool
# define bool char
#endif

#define NRF_ADDR_MINE	0
#define NRF_ADDR_TO		1


#define RF_PWR_0		0	//-18 dBm	0.015625 mW
#define RF_PWR_1		1	//-12 dBm	0.062500 mW
#define RF_PWR_2		2	//-6 dBm	0.250000 mW
#define RF_PWR_3		3	//0 dBm		1.000000 mW


//external api
void nrfCE(char active);
void nrfCS(char active);
void nrfDelay200us(void);
uint8_t nrfSpiByte(uint8_t byte);
void nrfWaitForIrq(void);		//can be implemented as NOP if you want



//state transitions
//init: start -> off
//pwOn: off -> sby or sby -> off
//doRx: sby -> rx
//doRx: rx -> sby
//doTx: sby -> tx -> sby 


//high-level api

void nrfInit(uint8_t channel, uint8_t power);
void nrfSetPowerState(bool pwron);
void nrfRxEnable(bool rxon);
void nrfSetAddr(uint8_t which, uint32_t addr);
bool nrfSend(const void* data, uint8_t len, uint8_t retries);
uint8_t nrfRecv(void* data, uint8_t len);	//return num bytes RXed

//low-level api


void nrfSetReg(uint8_t reg, uint8_t val);
uint8_t nrfGetReg(uint8_t reg);
uint8_t nrfCmd(uint8_t cmd);
void nrfSetRegEx(uint8_t reg, const uint8_t* data, uint8_t len);
void nrfGetRegEx(uint8_t reg, uint8_t* data, uint8_t len);


//Commands
#define CMD_R_REGISTER    0x00
#define CMD_W_REGISTER    0x20
#define CMD_R_RX_PL_WID   0x60
#define CMD_R_RX_PAYLOAD  0x61
#define CMD_W_TX_PAYLOAD  0xA0
#define CMD_FLUSH_TX      0xE1
#define CMD_FLUSH_RX      0xE2
#define CMD_REUSE_TX_PL   0xE3
#define CMD_NOP           0xFF

//Registers
#define NRF_REG_CONFIG      0x00
#define NRF_REG_EN_AA       0x01
#define NRF_REG_EN_RXADDR   0x02
#define NRF_REG_SETUP_AW    0x03
#define NRF_REG_SETUP_RETR  0x04
#define NRF_REG_RF_CH       0x05
#define NRF_REG_RF_SETUP    0x06
#define NRF_REG_STATUS      0x07
#define NRF_REG_OBSERVE_TX  0x08
#define NRF_REG_CD          0x09
#define NRF_REG_RX_ADDR_P0  0x0A
#define NRF_REG_RX_ADDR_P1  0x0B
#define NRF_REG_RX_ADDR_P2  0x0C
#define NRF_REG_RX_ADDR_P3  0x0D
#define NRF_REG_RX_ADDR_P4  0x0E
#define NRF_REG_RX_ADDR_P5  0x0F
#define NRF_REG_TX_ADDR     0x10
#define NRF_REG_RX_PW_P0    0x11
#define NRF_REG_RX_PW_P1    0x12
#define NRF_REG_RX_PW_P2    0x13
#define NRF_REG_RX_PW_P3    0x14
#define NRF_REG_RX_PW_P4    0x15
#define NRF_REG_RX_PW_P5    0x16
#define NRF_REG_FIFO_STATUS 0x17
#define NRF_REG_DYNPD		0x1C
#define NRF_REG_FEATURE		0x1D



#endif
