#ifndef _VSD_H_
#define _VSD_H_

#include <stdbool.h>
#include <stdint.h>
#include "vSPI.h"


typedef bool (*VsdSecReadF)(void *userData, uint32_t sec, uint8_t *dst);
typedef bool (*VsdSecWriteF)(void *userData, uint32_t sec, const uint8_t *src);

struct VSD;

struct VSD* vsdInit(VsdSecReadF readF, VsdSecWriteF writeF, void *userData, uint32_t numSec, bool forceHC);
struct VSPI* vsdGetVSPI(struct VSD* vsd);
void vsdDeinit(struct VSD* vsd);




#endif
