#ifndef _VPSRAM_H_
#define _VPSRAM_H_

#include <stdbool.h>
#include <stdint.h>
#include "vSPI.h"


struct PsramStats {
	uint64_t numTimesSelected;
	uint64_t numCyclesSelected;		//	total
	uint32_t longestSelectedDuration;

	uint64_t numTimesSelectedPage0;	//cpu
};

struct VPSRAM;

struct VPSRAM* vpsramInit(const char *spiName, uint32_t size);
struct VSPI* vpsramGetVSPI(struct VPSRAM* psram);
void vpsramDeinit(struct VPSRAM* psram);
void vpsramGetStats(struct VPSRAM* psram, struct PsramStats *stats);



#endif
