#ifndef _VFS_H_
#define _VFS_H_

#include <stdbool.h>
#include <stdint.h>


#define VFS_SECTOR_SIZE				(512)
#define VFS_MAX_NAME_LEN			(255)

#define VFS_TYPE_NONE		0x00
#define VFS_TYPE_PORT		0x01
#define VFS_TYPE_CDEV		0x02
#define VFS_TYPE_DIR		0x04
#define VFS_TYPE_BDEV		0x06
#define VFS_TYPE_FILE		0x08
#define VFS_TYPE_SYMLINK	0x0a
#define VFS_TYPE_SOCKET		0x0c
#define VFS_TYPE_PIPE		0x0e

typedef bool (*VfsReadSecProc)(void *userData, uint32_t sec, void *dst);


struct VfsFileOpenInfoOpaque {
	uint32_t opaque[3];
};

struct VfsFile;


void vfsInit(void *buf512);

struct VfsVolume* vfsMount(VfsReadSecProc readSecF, void *readSecD);
void vfsUnmount(struct VfsVolume *vol);

struct VfsFile* vfsOpenRoot(struct VfsVolume *vol);
struct VfsFile* vfsFileOpen(struct VfsVolume* vol, struct VfsFileOpenInfoOpaque *oiP);
void vfsFileClose(struct VfsFile *file);

bool vfsDirEnum(struct VfsFile *dir, char *nameP, struct VfsFileOpenInfoOpaque *oiP);
bool vfsFileInfo(struct VfsVolume* vol, struct VfsFileOpenInfoOpaque *oiP, uint8_t *typeP, uint32_t *sizeP);

uint32_t vfsFileRead(struct VfsFile *file, void *buf, uint32_t len);
uint32_t vfsFileSkip(struct VfsFile *file, uint32_t len);	//seek forwards
uint32_t vfsFileTell(const struct VfsFile *file);
bool vfsFileSeek(struct VfsFile *file, uint32_t pos);
void vfsFileRewind(struct VfsFile *file);



#endif
