


	org		0000H
	INCL	"common.def"

;init gate - switch to page 0 if we are here
	LDM		1
	DCL
	FIM		r0, 0
	SRC		r0
	LDM		8
	WMP
	;code now continues from this same address on page 0

;gates for jumps back from ops in page 0

	org		0008H
cpuPrvVeneerReturn:		;expects r12:r13 < 0x40
	LDM		1
	DCL
	SRC		r12
	LDM		8
	WMP
	;code continues on page 0 from this addr here (0x0d)

	org		000DH
cpuPrvThreeOperandAnd_landing:	;code continues here from page 1, r13 = dcl to operate on
	LD		r13
	DCL
	JUN		cpuPrvThreeOperandAnd

	org		0012H
cpuPrvThreeOperandOrr_landing:	;code continues here from page 1, r13 = dcl to operate on
	LD		r13
	DCL
	JUN		cpuPrvThreeOperandOrr

	org		0016H
cpuPrvThreeOperandXor_landing:	;code continues here from page 1, r13 = dcl to operate on
	LD		r13
	DCL
	JUN		cpuPrvThreeOperandXor

	org		001AH
cpuPrvThreeOperandNor_landing:	;code continues here from page 1, r13 = dcl to operate on
	LD		r13
	DCL
	JUN		cpuPrvThreeOperandNor

	org		001EH
cpuPrvMultX_landing:					;code continues here from page 1, r13 = dcl to operate on
	LD		r13
	DCL
	JUN		cpuPrvMultX

	org		0022H
hwAndSwInit_landing:						;code continues here from page 1
	LD		r13
	DCL
	JUN		hwAndSwInit

	org		0026H
cpuPrvHypercall_landing:					;code continues here from page 1
	LD		r13
	DCL
	JUN		cpuPrvHypercall

	org		002AH
cpuPrvPutchar_landing:						;code continues here from page 1
	JMS		cpuPrvPutchar
	FIM		r12, 0
	JUN		cpuPrvVeneerReturn

	org		0030H
cpuPrvGetchar_landing:						;code continues here from page 1
	JUN		cpuPrvGetchar
	
	org		0035H
cpuPrvDivu_landing:							;code continues here from page 1
	JUN		cpuPrvDivu
	


	org		0100H							;make life easier with alignment
sdInit:
	LDM		1
	DCL
	FIM		r0, DCL1_NUM_CARD_SECS			;select ram chip whose port has the SD iface
	SRC		r0

init_clocks:
	FIM		r6, 0		;256 clocks

init_clocks_loop:
	
	LDM		0
	WMP
	LDM		2
	WMP

	ISZ		r7, init_clocks_loop
	ISZ		r6, init_clocks_loop

	;send cmd0 until we get the right reply (0x01), up to 256 times

	FIM		r4, 000h
sd_send_cmd0:
	
	ISZ		r5, sd_send_cmd0_again
	ISZ		r4, sd_send_cmd0_again
	JUN		sdInit_fail

sd_send_cmd0_again:
	FIM		r0, cmd0
	JMS		sdPrvCmdFromRom
	JCN		C, sdInit_fail
	JMS		sdSpiDeselect

	;verify reply
	LD		r0
	JCN		NZ, sd_send_cmd0
	LD		r1
	DAC
	JCN		NZ, sd_send_cmd0

	FIM		r0, cmd8
	JMS		sdPrvCmdFromRom
	JCN		C, sdInit_fail

	LDM		16 - 8
	JMS		sdPrvEatNibbles
	JMS		sdSpiDeselect

	;crc off
	FIM		r0, cmd59
	JMS		sdPrvCmdFromRom
	JCN		C, sdInit_fail
	JMS		sdSpiDeselect

init_card:
	FIM		r4, 000h				;try 4096 times
	LDM		0
	XCH		r3

init_card_loop:
	FIM		r0, cmd55
	JMS		sdPrvCmdFromRom		;clobbers r6,r7,r11,r12,r13
	JCN		C, sdInit_fail
	JMS		sdSpiDeselect

	FIM		r0, cmd41
	JMS		sdPrvCmdFromRom
	JCN		C, sdInit_fail
	JMS		sdSpiDeselect

	LD		r1
	JCN		Z, init_card_done

	ISZ		r5, init_card_loop
	ISZ		r4, init_card_loop
	ISZ		r3, init_card_loop

	JUN		sdInit_fail

init_card_done:
	;read csd
	FIM		r0, cmd9
	JMS		sdPrvCmdFromRom
	JCN		C, sdInit_fail
	
	JMS		sdPrvDataWait
	JCN		C, sdInit_fail

	;get first nibble to see CSD ver
	JMS		spiRecvNibble_pin3
	LD		r6
	JCN		Z, card_is_SDSC
	CLC
	LDM		4
	SUB		r6
	JCN		NZ, sdInit_fail

card_is_SDHC:
	;skip nibbles till C_SIZE
	LDM		16 - 13
	JMS		sdPrvEatNibbles
	;top two bits we'll read will be zeroes, card size is this val plus one, LSL 10, we read into 2 nibbles in to get a free LSL 8

	FIM		r4, DCL1_NUM_CARD_SECS + 7			;write to top 6 nibbles
	LDM		16 - 6
	JMS		sdPrvRecvNibbles

	FIM		r4, DCL1_NUM_CARD_SECS + 2
	LDM		16 - 6
	JMS		sdPrvIncNum

	FIM		r4, DCL1_NUM_CARD_SECS + 2
	LDM		16 - 6
	JMS		sdPrvLsl1

	FIM		r4, DCL1_NUM_CARD_SECS + 2
	LDM		16 - 6
	JMS		sdPrvLsl1

	LDM		1
	WR0											;card_is_SDHC, record that we're asn SDHC card

	;eat the rest of the nibbles and we're done
	LDM		16 - 16

sdEatNibblesAndDone:
	JMS		sdPrvEatNibbles
	JMS		sdSpiDeselect
	JUN		sdInitDone

card_is_SDSC:
	;skip nibbles till READ_BL_LEN
	LDM		16 - 10
	JMS		sdPrvEatNibbles

	JMS		spiRecvNibble_pin3
	LD		r6
	XCH		r10						;READ_BL_LEN

	JMS		spiRecvNibble_pin3			;next nibble unused

	;C_SIZE and C_SIZE_MULT are all weirdly arranged so we'll load the whole 32-bit piece and shift it later
	FIM		r4, DCL1_NUM_CARD_SECS + 7
	LDM		16 - 8
	JMS		sdPrvRecvNibbles		;now has bits 44..75

	FIM		r4, DCL1_NUM_CARD_SECS
	LDM		16 - 8
	JMS		sdPrvLsl1				;now has bits 43..74

	FIM		r4, DCL1_NUM_CARD_SECS
	LDM		16 - 8
	JMS		sdPrvLsl1				;now has bits 42..73

	FIM		r4, DCL1_NUM_CARD_SECS + 1
	SRC		r4
	RDM
	CLC
	RAR
	XCH		r9						;C_SIZE_MULT
	
	;DCL1_NUM_CARD_SECS + 5 has uint12 containing C_SIZE, move it to the bottom
	FIM		r6, DCL1_NUM_CARD_SECS + 5
	FIM		r4, DCL1_NUM_CARD_SECS + 0
	LDM		16 - 3
	XCH		r2
sdsc_copy:
	SRC		r6
	INC		r7
	RDM
	SRC		r4
	INC		r5
	WRM
	ISZ		r2, sdsc_copy

	;zero the rest
	LDM		16 - 5
	XCH		r2
	LDM		0
sdsc_clr:
	SRC		r4
	INC		r5
	WRM
	ISZ		r2, sdsc_clr

	;inc
	FIM		r4, DCL1_NUM_CARD_SECS + 0
	LDM		16 - 4		;at most 4 nibbles to add
	JMS		sdPrvIncNum
	
	;sort out how far we need to shift == READ_BL_LEN - 9 + 2 + C_SIZE_MULT //sub 1 to allow easier loop control
	LDM		16 - 8
	CLC
	ADD		r10
	CLC
	ADD		r9
	CMA
	XCH		r10
	TCC
	CMA
	XCH		r9						;r9:r10 is 256 - how many times we need to LSL the sector counter and we are SURE that at least oen shift is required

sdsc_shift:
	FIM		r4, DCL1_NUM_CARD_SECS
	LDM		16 - 8
	JMS		sdPrvLsl1
	ISZ		r10, sdsc_shift
	ISZ		r9, sdsc_shift


	;eat the rest of the nibbles and we're done
	LDM		16 - 15
	JUN		sdEatNibblesAndDone

sdInit_fail:		
	JUN		prvShowSdInitFailMsgAndHang


	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP		;space here

sdPrvLsl1:					;A = 16 - num nibbles, r4:r5 = addr to LSL, clobbers r8
	XCH		r8
	CLC
sdPrvLsl1_loop:
	SRC		r4
	INC		r5
	RDM
	RAL
	WRM
	ISZ		r8, sdPrvLsl1_loop
	BBL		0

sdPrvRecvNibbles:			;A = 16 - num nibbles, r4:r5 = addr to RX to, clobbers r6, r7, r8, RXes in reverse order (converting from BE to LE)
	XCH		r8

sdPrvRecvNibbles_loop:
	JMS		spiRecvNibble_pin3
	LD		r6
	SRC		r4
	WRM
	LD		r5
	DAC
	XCH		r5
	ISZ		r8, sdPrvRecvNibbles_loop
	BBL		0

	NOP
	NOP		;space here


sdPrvIncNum:					;A = 16 - num nibbles, r4:r5 = addr to LSL, clobbers r8
	XCH		r8
sdPrvIncNum_loop:
	SRC		r4
	INC		r5
	RDM
	IAC
	WRM
	JCN		NZ, sdPrvIncNum_done
	ISZ		r8, sdPrvIncNum_loop
sdPrvIncNum_done:
	BBL		0

cpuPrvDivu:
	;tmp64a.hi = 0x00000001
	FIM		r4, DCL1_TMP64A + 8
	SRC		r4
	INC		r5
	LDM		1
	WRM
	LDM		0
cpuPrvDivuZeroFillEx_loop:
	SRC		r4
	WRM
	ISZ		r5, cpuPrvDivuZeroFillEx_loop

	;LO = 0
	LDM		8
	XCH		r0
	FIM		r4, DCL1_LO
	LDM		0
cpuPrvDivuZeroFillEx_loop2:
	SRC		r4
	INC		r5
	WRM
	ISZ		r0, cpuPrvDivuZeroFillEx_loop2

; while denom top bit is nonzero, shift denom and tmp64a.hi left, do a nibble at a time if we can
divu_initial_shift_left_by_nibble:
	FIM		r2, DCL1_TMP64A + 7	;top nibble of denom
	SRC		r2
	RDM
	JCN		NZ, divu_initial_shift_left_by_bit

	FIM		r2, DCL1_TMP64A
	LDM		0
	XCH		r4		;lowest nibble gets zero
divu_initial_shift_left_by_nibble_inner:
	SRC		r2
	RDM
	XCH		r4		;r4 has lower nibble. store that and record current nibble there
	WRM
	ISZ		r3, divu_initial_shift_left_by_nibble_inner
	JUN		divu_initial_shift_left_by_nibble
	
divu_initial_shift_left_by_bit:
	FIM		r2, DCL1_TMP64A + 7	;top nibble of denom
	SRC		r2
	RDM
	RAL
	JCN		C, divu_initial_shift_left_done

	FIM		r2, DCL1_TMP64A
	CLC
divu_initial_shift_left_inner:
	SRC		r2
	RDM
	RAL
	WRM
	ISZ		r3, divu_initial_shift_left_inner
	JUN		divu_initial_shift_left_by_bit

divu_initial_shift_left_done:

divu_big_loop:
	;first we need to see if NUM (aka HI) >= shifted_denom (aka tmp64a.lo)
	FIM		r6, DCL1_HI + 7
	FIM		r4, DCL1_TMP64A + 7
	LDM		16 - 8
	XCH		r8

divu_cmp_loop:
	CLC
	SRC		r6
	RDM
	SRC		r4
	SBM
	JCN		NC, divu_skip_result_add
	JCN		NZ, divu_do_result_add

	LD		r7
	DAC
	XCH		r7
	LD		r5
	DAC
	XCH		r5

	ISZ		r8, divu_cmp_loop

;we get here if the numbers are EQUAL precisely. Then we add result, zero remainder and then bail
	FIM		r4, DCL1_TMP64A + 8
	FIM		r2, DCL1_LO
	JMS		cpuPrvTwoOperandAdd

	FIM		r4, DCL1_HI
	LDM		0

divuZeroFillRet:
	SRC		r4
	WRM
	ISZ		r5, divuZeroFillRet
	JUN		cpuPrvVeneerReturn

divu_do_result_add:
;we get here if NUM (aka HI) > shifted_denom (aka tmp64a.lo)

	;we need to subtract, r6:r7 = whence/dst, r4:r5 = what, clobbers r0,
	FIM		r6, DCL1_HI
	FIM		r4, DCL1_TMP64A
	
divuTwoOperandSub:
	LDM		8
	XCH		r0
	STC

divuTwoOperandSub_inner:
	SRC		r4
	INC		r5
	RDM
	CMA
	SRC		r6
	INC		r7
	ADM
	WRM
	ISZ		r0, divuTwoOperandSub_inner
	;r4:r5 is pointing to DCL1_TMP64A + 8 alrady so we do not need to load that into r4

	;then we need to add tmp64a.hi to LO
	FIM		r2, DCL1_LO
	JMS		cpuPrvTwoOperandAdd

divu_skip_result_add:

	;then we need to shift the entire tmp64a down a bit, if this causes bit31 to go high we end the division routine
divu_shift_down:
	FIM		r2, DCL1_TMP64A + 15
	CLB
	XCH		r4
divu_shift_down_loop:
	SRC		r2
	RDM
	RAR
	WRM
	TCC
	XCH		r3
	DAC
	XCH		r3
	RAR
	ISZ		r4, divu_shift_down_loop

	;check for end condition
	FIM		r2, DCL1_TMP64A + 7
	SRC		r2
	RDM
	RAL
	JCN		NC, divu_big_loop

	;when we are here, HI has the remainder, LO has the quotient
	JUN		cpuPrvVeneerReturn

cpuPrvTwoOperandAdd:		;add. r4:r5 = what, r2:r3 = dst, clobbeers r0, moves pointers by 7
	LDM		9
	XCH		r0
	CLC

cpuPrvTwoOperandAdd_inner:
	SRC		r4
	INC		r5
	RDM
	SRC		r2
	INC		r3
	ADM
	WRM
	ISZ		r0, cpuPrvTwoOperandAdd_inner
	SRC		r4
	RDM
	SRC		r2
	ADM
	WRM
	BBL		0



	org		0300H



cmd0:
	DB		040h
	DB		000h
	DB		000h
	DB		000h
	DB		000h
	DB		095h

cmd8:
	DB		048h
	DB		000h
	DB		000h
	DB		001h
	DB		0AAh
	DB		087h

cmd55:
	DB		077h	;stuff bits do not care

cmd9:
	DB		049h	;stuff bits ignored so who cares what they are

cmd41:
	DB		069h
	DB		040h
	DB		000h
	DB		000h
	DB		000h

cmd59:
	DB		07Bh
	DB		000h
	DB		000h
	DB		000h
	DB		000h
	DB		091h


	;needs to be in thr same rom page as the commands above
sdPrvCmdFromRom:		;r0:r1 points to cmd stream in rom (6 bytes, in send order, assuming no 16- byte boundary crossings)
						;r0:r1 returns the first byte of reply ("r1" reply since all other reply kinds begin with it, unless reply is type r2). Carry out = reply timed out
						;clobbers r6,r7,r11,r12,r13. Does not DESELECT at end in case of success

	;select (first drive clock and data low, then drive nCS low)
	LDM		3
	WMP
	LDM		7
	WMP
	
	LDM		16 - 6
	XCH		r11

sdPrvCmd_tx:
	FIN		r12
	LD		r12
	JMS		spiSendNibble_nCS2_mode3
	LD		r13
	JMS		spiSendNibble_nCS2_mode3
	INC		r1
	ISZ		r11, sdPrvCmd_tx

	FIM		r12, 0

sdPrvCmd_replyWait:		;assumes card is sane and thus answer begins at byte boundary with a nibble with a clear top bit

	JMS		spiRecvNibble_pin3
	LD		r6
	RAL
	JCN		NC, sdPrvCmd_replyStarted

	ISZ		r13, sdPrvCmd_replyWait
	ISZ		r12, sdPrvCmd_replyWait

sdPrvCmd_replyTimeout:	;carry is set when we get here

sdPrvCmd_out:
	JUN		sdSpiDeselect

sdPrvCmd_replyStarted:
	LD		r6
	XCH		r0
	JMS		spiRecvNibble_pin3
	LD		r6
	XCH		r1

sdPrv_retWithCarryClear
	CLC
	BBL		0

sdPrvDataWait:			;C = fail on exit
	JMS		spiRecvNibble_pin3
	LD		r6
	IAC
	JCN		Z, sdPrvDataWait
	IAC
	JCN		Z, sdPrv_retWithCarryClear

sdPrvDataWait_fail:
	STC
	BBL		0

sdPrvEatNibbles:	;	A = 16 - numNibbelsToEat, clobbers r0
	XCH		r0

sdPrvEatNibbles_loop:
	JMS		spiRecvNibble_pin3
	ISZ		r0, sdPrvEatNibbles_loop
	BBL		0



spiRecvNibble_pin3:	;recv from input pin 3 == SD, returns in r6, clobbers r7, sends all ones

	LDM		6	;chip select low, clock low, data high
	WMP
	RDR
	RAL
	LD		r6
	RAL
	XCH		r6
	LDM		4	;chip select low, clock high, data high
	WMP

	LDM		6	;chip select low, clock low, data high
	WMP
	RDR
	RAL
	LD		r6
	RAL
	XCH		r6
	LDM		4	;chip select low, clock high, data high
	WMP

	LDM		6	;chip select low, clock low, data high
	WMP
	RDR
	RAL
	LD		r6
	RAL
	XCH		r6
	LDM		4	;chip select low, clock high, data high
	WMP

	LDM		6	;chip select low, clock low, data high
	WMP
	RDR
	RAL
	LD		r6
	RAL
	XCH		r6
	LDM		4	;chip select low, clock high, data high
	WMP


	BBL		0

spiRecvNibble_pin1_mode3:	;recv from input pin 1 == VFD, returns in r6, clobbers r7, sends all ones
	LDM		16 - 4
	XCH		r7

spiNibble_loop_pin1:
	LDM		6	;chip select low, clock low, data high
	WMP
	RDR
	RAR
	RAR
	LD		r6
	RAL
	XCH		r6
	LDM		4	;chip select low, clock high, data high
	WMP
	ISZ		r7, spiNibble_loop_pin1
	BBL		0

spiRecvNibble_pin2:	;recv from input pin 1 == UART, returns in r6, clobbers r7, sends all ones
	LDM		16 - 4
	XCH		r7

spiNibble_loop_pin2:
	LDM		0AH	;chip select low, clock low, data high
	WMP
	RDR
	RAL
	RAL
	LD		r6
	RAL
	XCH		r6
	LDM		08H	;chip select low, clock high, data high
	WMP
	ISZ		r7, spiNibble_loop_pin2
	BBL		0


spiSendNibble_nCS2_mode3:		;A = nibble, clobbers r6, r7
	CMA			;we need inverted data, invert it once
	XCH		r6

	LDM		16 - 4
	XCH		r7

spiSendNibble_loop_nCS2:
	XCH		r6
	RAL
	XCH		r6
	LDM		3	;chip select low, clock low, data bit shown
	RAL
	WMP
	DAC
	DAC			;chip select low, clock high, data bit shown
	WMP

	ISZ		r7, spiSendNibble_loop_nCS2

	BBL		0

spiSendNibble_nCS3:		;A = nibble, clobbers r6, r7
	CMA			;we need inverted data, invert it once
	XCH		r6

	LDM		16 - 4
	XCH		r7

spiSendNibble_loop_nCS3:
	XCH		r6
	RAL
	XCH		r6
	LDM		5	;chip select low, clock low, data bit shown
	RAL
	WMP
	DAC
	DAC			;chip select low, clock high, data bit shown
	WMP

	ISZ		r7, spiSendNibble_loop_nCS3

	BBL		0



spiRecvNibbleRAM:	;recv from input pin 0 == SRAM, returns in r6, clobbers r7, sends all ones, r13 = chip select bits with clock bit high and data bit low, r3 = r13 - 2, writes the byte into selected memory

	LD		r13	;chip select low, clock low, data high
	WMP
	RDR
	XCH		r6
	LD		r3	;chip select low, clock high, data high
	WMP

	LD		r13	;chip select low, clock low, data high
	WMP
	RDR
	RAR
	LD		r6
	RAL
	XCH		r6
	LD		r3	;chip select low, clock high, data high
	WMP

	LD		r13	;chip select low, clock low, data high
	WMP
	RDR
	RAR
	LD		r6
	RAL
	XCH		r6
	LD		r3	;chip select low, clock high, data high
	WMP

	LD		r13	;chip select low, clock low, data high
	WMP
	RDR
	RAR
	LD		r6
	RAL
	WRM
	LD		r3	;chip select low, clock high, data high
	WMP


	BBL		0

sdSpiDeselect:	;assumed to not clobber "C", r0, r1 does clober r2
	LDM		7	;lower clock and data while keeping nCS low
	WMP
	XCH		r2
	LDM		8
	XCH		r2

	LDM		3	;raise nCS while keeping clock and data low
	WMP

post_deselect_clocks:
	LDM		1
	WMP
	LDM		3
	WMP
	ISZ		r2, post_deselect_clocks
	BBL		0


	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP		;space here

hypercall_putchar:
	FIM		r2, 020H		;A0 reg
	SRC		r2
	INC		r3
	RDM
	XCH		r1
	SRC		r2
	RDM
	XCH		r0
	JMS		cpuPrvPutchar
	JUN		cpuPrvVeneerReturn

hypercall_get_sd_size:
	FIM		r2, 010H					;V0 reg in DCL0
	FIM		r4, DCL1_NUM_CARD_SECS
	FIM		r6,	10H
	JMS		cpuPrvCopy8_r4r5_to_r2r3_with_DCL


cpuPrvHypercall_out:
	JUN		cpuPrvVeneerReturn

;#define H_CONSOLE_WRITE					1
;#define H_STOR_GET_SZ						2
;#define H_STOR_READ						3
;#define H_STOR_WRITE						4

cpuPrvHypercall:
	LDM		0
	DCL
	FIM		r2, 08H			;lower nibble of AT reg
	SRC		r2
	RDM
	DAC
	JCN		Z, hypercall_putchar
	DAC
	JCN		Z, hypercall_get_sd_size
	DAC

	CLC
	RAR
	JCN		NZ, cpuPrvHypercall_out		;unknown
	TCC									;1 for write, 0 for read
	XCH		r15

	;sector number is in A0, PA is in A1
	;copy PA to DCL1_TMP32B
	FIM		r4, 028H		;A1 reg
	FIM		r2, DCL1_TMP32B
	FIM		r6, 01H
	JMS		cpuPrvCopy8_r4r5_to_r2r3_with_DCL

	;for SDSC card we need sector number shifted left 9, which is faster by copying it a byte later and shifting one, we do need to zero the lower bytes
	;for SDHC no such monkeying is necessary
	FIM		r4, DCL1_NUM_CARD_SECS
	SRC		r4
	RD0									;card_is_SDHC
	JCN		NZ, hyper_sdhc

hyper_sdsc:
	FIM		r2, DCL1_TMP32A
	LDM		0
	SRC		r2
	INC		r3
	WRM
	SRC		r2
	INC		r3
	WRM
	FIM		r4, 020H		;A0 reg
	FIM		r6, 01H
	LDM		16 - 6
	XCH		r0
	JMS		cpuPrvCopyX_r4r5_to_r2r3_with_DCL

	FIM		r4, DCL1_TMP32A + 2
	LDM		16 - 6
	JMS		sdPrvLsl1
	JUN		hyper_have_sec_no

hyper_sdhc:
	FIM		r4, 020H		;A0 reg
	FIM		r2, DCL1_TMP32A
	FIM		r6, 01H
	JMS		cpuPrvCopy8_r4r5_to_r2r3_with_DCL

hyper_have_sec_no:			;DCL1_TMP32A has sector number, DCL1_TMP32B has RAM addr, r15 is 1 for write, 0 for read

	;cmd17 (0x11 + 0x40 = 0x51) is read block
	;cmd24 (0x18 + 0x40 = 0x58) is write block

	;select (first drive clock and data low, then drive nCS low)
	FIM		r2, DCL1_NUM_CARD_SECS
	SRC		r2
	LDM		3
	WMP
	LDM		7
	WMP

	LDM		05H
	JMS		spiSendNibble_nCS2_mode3

	LD		r15
	JCN		Z, hyper_is_rd

hyper_is_wr:
	LDM		08H
	JUN		hyper_cmd_calculated

hyper_is_rd:
	LDM		01H

hyper_cmd_calculated:
	JMS		spiSendNibble_nCS2_mode3

	FIM		r4, DCL1_TMP32A + 7
	LDM		16 - 10		;two extra nibbles or random crap is our CRC, whatever they are
	XCH		r14



hyper_send_cmd:
	SRC		r4
	LD		r5
	DAC
	XCH		r5
	RDM
	SRC		r2
	JMS		spiSendNibble_nCS2_mode3
	ISZ		r14, hyper_send_cmd

	
	FIM		r12, 0
	SRC		r2

hyperSdCmd_replyWait:		;assumes card is sane and thus answer begins at byte boundary with a nibble with a clear top bit

	JMS		spiRecvNibble_pin3
	LD		r6
	RAL
	JCN		NC, hyperSdCmd_replyStarted

	ISZ		r13, hyperSdCmd_replyWait
	ISZ		r12, hyperSdCmd_replyWait

hyperSdCmd_cmdTimedOut:
hyperSdCmd_error:
	JMS		sdSpiDeselect
	CLC
	JUN		hyper_return_success_status

hyperSdCmd_replyStarted:

	LD		r6
	XCH		r0
	JMS		spiRecvNibble_pin3
	LD		r6
	JCN		NZ, hyperSdCmd_error
	LD		r0
	JCN		NZ, hyperSdCmd_error
	JUN		hyper_sd_cmd_continues

hyper_sd_cmd_continues:


hyper_pick_ram_chip:		;we assume no chip straddling, pick the chip select value and stash it in r12, r13 = r12 << 1 (for read), r3 = r13 - 2
	;pick a chip, store proper value to r12 (this SRC also selects the proper ram chip for output port)
	FIM		r10, DCL1_TMP32B + 6
	SRC		r10
	CLC
	LDM		3
	ADM									;now has 0b011 for chip 0 and 0xb101 for chip 1 (proper chip select values)
	XCH		r12							;carry is clear
	LD		r12
	RAL
	XCH		r13
	LD		r13
	DAC
	DAC
	XCH		r3


	SRC		r2
	LD		r15
	JCN		Z, hyper_handle_read
	JUN		hyper_handle_write

hyper_handle_read:

wait_for_data:
	JMS		spiRecvNibble_pin3
	LD		r6
	XCH		r0
	JMS		spiRecvNibble_pin3

	LD		r0		;0 = error token, f = data or more wait, any other value is error
	IAC
	JCN		NZ, hyperSdCmd_error

	LD		r6		;e = data, f = more wait, any other value is error
	IAC
	JCN		Z, wait_for_data
	IAC
	JCN		NZ, hyperSdCmd_error

hyper_data_arriving:	;we RX data 8 nibbles at a time, swap as needed, and write to RAM as a word
						;512 bytes = 1024 nibbles, at 8 at a time that is 128 pieces

	FIM		r0, 256 - 128

hyper_data_rx_outer:
	LDM		16 - 4
	XCH		r4
	FIM		r8, DCL1_TMP32C

hyper_data_rx_inner:	;read a word in our nibble order into DCL1_TMP32C
	SRC		r2
	JMS		spiRecvNibble_pin3
	LD		r6
	XCH		r5
	JMS		spiRecvNibble_pin3
	SRC		r8
	INC		r9
	LD		r6
	WRM
	SRC		r8
	INC		r9
	LD		r5
	WRM
	ISZ		r4, hyper_data_rx_inner
	
	;write to ram -  a specialized write func that only handles words
	
	FIM      r10, DCL1_TMP32B + 5
	SRC      r10

	;select, clock and data lines low. carry is still zero
	LD		r13
	IAC
	WMP

	;write command
	LDM		00H
	JMS		spiSendNibbleRAM

	LDM		02H
	JMS		spiSendNibbleRAM

	;address
	LDM		16 - 6
	XCH		r4
hyper_data_write_addr_inner:
	SRC		r10
	LD		r11
	DAC
	XCH		r11
	RDM
	JMS		spiSendNibbleRAM
	ISZ		r4, hyper_data_write_addr_inner

	;data
	FIM		r10, DCL1_TMP32C
	LDM		16 - 8
	XCH		r4
hyper_data_write_data_inner:
	SRC		r10
	INC		r11
	RDM
	JMS		spiSendNibbleRAM
	ISZ		r4, hyper_data_write_data_inner

	;deselect - lower clock while keeping nCS low
	LD		r13
	WMP
	LDM		2	;raise nCS while keeping clock low
	WMP

	;increment the address by 4 (bytes)
	FIM		r10, DCL1_TMP32B
	LDM		16 - 6
	XCH		r4
	LDM		4
	CLC
hyper_data_write_addr_inc:
	SRC		r10
	INC		r11
	ADM
	WRM
	LDM		0
	ISZ		r4, hyper_data_write_addr_inc

	ISZ		r1, hyper_data_rx_outer
	ISZ		r0, hyper_data_rx_outer

	;ignore CRC
	LDM		16 - 4
	SRC		r2
	JMS		sdPrvEatNibbles

hyper_deselect_and_return_sucess:
	JMS		sdSpiDeselect

	STC
hyper_return_success_status:		;status in C
	FIM		r10, 010H				;V0
	LDM		0
	DCL
	LDM		16 - 8
	XCH		r12

hyper_return_success_status_loop:
	TCC
	SRC		r10
	INC		r11
	WRM
	ISZ		r12, hyper_return_success_status_loop	;leaves r12 at zero as desired by cpuPrvVeneerReturn

	JUN		cpuPrvVeneerReturn


tlbProbe:
	LDM		TLB_ENTRIES_DCL
	DCL

	FIM		r0, 000H
tlbProbeLoop:
	SRC		r0
	LDM		05H
	WRM
	LDM		0BH
	CLC
	ADM
	JCN		NZ, tlbProbeFails
	ISZ		r0, tlbProbeLoop

tlbProbeAllSucceeded:		;if we are here, we have 16 entries
tlbProbeFails:				;if we are here, we have "r0" entries
	LD		r0
	DAC
	
tlbEntriesCounted:
;at this point, A = numEntries - 1
	XCH		r2
	LDM		1
	DCL
	FIM		r0, DCL1_INDEX_IDX
	SRC		r0
	LD		r2
	WR1								;DCL1_NUM_TLB_ENTRIES_M1
	BBL		0


	org		0600H

hyper_handle_write:					;time to send a start byte, 512 data bytes, and 2 crc bytes. data bytes will be sent in groups of 4 bytes (one memory word)

	;send start byte
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3

	LDM		0EH
	JMS		spiSendNibble_nCS2_mode3

	FIM		r0, 256 - 128

hyper_data_tx_outer:

	;read from ram -  a specialized read func that only handles words
	FIM		r10, DCL1_TMP32B + 5
	SRC		r10

	;select, clock and data lines low. carry is still zero
	STC
	LD		r12
	RAL
	WMP

	;read command
	LDM		00H
	JMS		spiSendNibbleRAM

	LDM		03H
	JMS		spiSendNibbleRAM

	;address
	LDM		16 - 6
	XCH		r4
hyper_data_read_addr_inner:
	SRC		r10
	LD		r11
	DAC
	XCH		r11
	RDM
	JMS		spiSendNibbleRAM
	ISZ		r4, hyper_data_read_addr_inner

	;data
	FIM		r10, DCL1_TMP32C
	LDM		16 - 8
	XCH		r4
hyper_data_read_data_inner:
	SRC		r10
	INC		r11
	JMS		spiRecvNibbleRAM
	ISZ		r4, hyper_data_read_data_inner

	;deselect - lower clock while keeping nCS low
	LD		r12
	CLC
	RAL
	WMP
	LDM		2	;raise nCS while keeping clock low
	WMP

	;increment the address by 4 (bytes)
	FIM		r10, DCL1_TMP32B
	LDM		16 - 6
	XCH		r4
	LDM		4
	CLC
hyper_data_read_addr_inc:
	SRC		r10
	INC		r11
	ADM
	WRM
	LDM		0
	ISZ		r4, hyper_data_read_addr_inc

	LDM		16 - 4
	XCH		r4
	FIM		r8, DCL1_TMP32C

hyper_data_tx_inner:	;read a word in our nibble order into DCL1_TMP32C
	SRC		r8
	INC		r9
	RDM
	XCH		r5
	SRC		r8
	INC		r9
	RDM
	SRC		r2
	JMS		spiSendNibble_nCS2_mode3
	LD		r5
	JMS		spiSendNibble_nCS2_mode3
	ISZ		r4, hyper_data_tx_inner


	ISZ		r1, hyper_data_tx_outer
	ISZ		r0, hyper_data_tx_outer

	;send nonsensical CRC
	LDM		16 - 4
	JMS		sdPrvEatNibbles

	;get data reply
	JMS		spiRecvNibble_pin3
	LD		r6
	XCH		r5
	JMS		spiRecvNibble_pin3
	LD		r5
	RAR
	JCN		C, data_reply_invalid			;reply itself is invalid
	LD		r6
	RAR
	JCN		NC, data_reply_invalid			;reply itself is invalid
	DAC
	DAC
	JCN		Z, data_reply_data_accepted

data_reply_data_rejected:
data_reply_invalid:
	JMS		sdSpiDeselect
	CLC
	JUN		hyper_return_success_status

data_reply_data_accepted:					;busy wait
busy_wait:
	LDM		16 - 2
	JMS		sdPrvEatNibbles					;to keep it byte aligned
	LD		r6
	IAC
	JCN		NZ, busy_wait

	JUN		hyper_deselect_and_return_sucess




cpuPrvCopy8_r4r5_to_r2r3_with_DCL:			;copy 8 nibbles from RAM at DCL_r6.r4:r5 to ram at DCL_r7.r2:r3. on it is assumed that the nibble addresses do not cross 16-boundary, clobbers r0
	LDM		8
	XCH		r0
	;fallthrough

cpuPrvCopyX_r4r5_to_r2r3_with_DCL:			;copy X nibbles from RAM at DCL_r6.r4:r5 to ram at DCL_r7.r2:r3. on it is assumed that the nibble addresses do not cross 16-boundary. to copy X nibbles, set r0 to "0x0f & (16 - x)"
	;copy
cpuPrvCopy8_r4r5_to_r2r3_loop1:
	LD		r6
	DCL
	SRC		r4
	RDM
	XCH		r7
	DCL
	XCH		r7
	SRC		r2
	WRM
	INC		r5
	INC		r3
	ISZ		r0, cpuPrvCopy8_r4r5_to_r2r3_loop1
	BBL		0

spiSendNibbleRAM:		;A = data, r12 = chip select bits with clock bit high (LSR 1), clobbers r7
	CMA			;we need inverted data, invert it once

	RAL
	XCH		r6
	LD		r12		;chip select low, clock low, data bit shown
	RAL
	WMP
	DAC
	DAC				;chip select low, clock high, data bit shown
	WMP


	XCH		r6
	RAL
	XCH		r6
	LD		r12		;chip select low, clock low, data bit shown
	RAL
	WMP
	DAC
	DAC				;chip select low, clock high, data bit shown
	WMP


	XCH		r6
	RAL
	XCH		r6
	LD		r12		;chip select low, clock low, data bit shown
	RAL
	WMP
	DAC
	DAC				;chip select low, clock high, data bit shown
	WMP


	XCH		r6
	RAL
	LD		r12		;chip select low, clock low, data bit shown
	RAL
	WMP
	DAC
	DAC				;chip select low, clock high, data bit shown
	WMP


	BBL		0

	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP		;space here


cpuPrvPutchar:		;must not corrupt r10-r15

	DB		07h

	LDM		1
	DCL

	FIM		r2, DCL1_UART_VFD_CHIP		;pick proper output chip
	SRC		r2

	;first send the char to UART since that is easier
	
	;select it (nCS3)
	LDM		03H
	WMP
	LDM		0BH
	WMP

	;write to TCR
	LDM		00H
	JMS		spiSendNibble_nCS3
	LDM		00H
	JMS		spiSendNibble_nCS3
	
	;if byte is '\n', send an '\r'
	LD		r0
	JCN		NZ, no_r_needed
	LDM		10
	CLC
	SUB		r1
	JCN		NZ, no_r_needed

	;\r
	LDM		0
	JMS		spiSendNibble_nCS3
	LDM		13
	JMS		spiSendNibble_nCS3

	;deselect
	LDM		0BH		;lower clock and data while keeping nCS low
	WMP
	LDM		03H		;raise nCS while keeping clock and data low
	WMP

	;select it (nCS3)
	LDM		03H
	WMP
	LDM		0BH
	WMP

	;write to TCR
	LDM		00H
	JMS		spiSendNibble_nCS3
	LDM		00H
	JMS		spiSendNibble_nCS3

no_r_needed:
	;the byte
	LD		r0
	JMS		spiSendNibble_nCS3
	LD		r1
	JMS		spiSendNibble_nCS3

	;deselect
	LDM		0BH		;lower clock and data while keeping nCS low
	WMP
	LDM		03H		;raise nCS while keeping clock and data low
	WMP

	;now the VFD logic which is a bit more complex

	;first we check for '\r'
	LD		r0
	JCN		NZ, char_is_ge_16
	CLC
	LDM		13
	SUB		r1
	JCN		NZ, char_isnt_CR

char_is_CR:
	LDM		0
	WR0
	WR1

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"set pointer" to row 2 col 0
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x40
	LDM		0CH
	JMS		spiSendNibble_nCS2_mode3
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	BBL		0

char_isnt_CR:	;but < 16
	CLC
	LDM		10
	SUB		r1
	JCN		NZ, char_isnt_LF

char_is_LF:
	LDM		1
	WR2				;VFD_LINE_IS_OVER
	BBL		0

char_isnt_LF:
	CLC
	LDM		8
	SUB		r1
	JCN		NZ, char_isnt_BKSP

char_is_BKSP:	;has effect only if we are not at column 0
	RD0				;VFD_COLUMN_HI
	JCN		NZ, bksp_has_effect
	RD1
	JCN		NZ, bksp_has_effect

bksp_has_no_effect:
	BBL		0

bksp_has_effect:
	RD1
	DAC
	WR1		;VFD_COLUMN_LO
	JCN		C, bksp_col_decr_handled
	RD0		;VFD_COLUMN_HI
	DAC
	WR0		;VFD_COLUMN_HI
	LDM		0
	WR2		;VFD_LINE_IS_OVER

bksp_col_decr_handled:
	JUN		screen_backspace


char_isnt_BKSP:
char_is_ge_16:
	;40 is 0x28
	RD0
	DAC
	DAC
	JCN		NZ, not_at_right_edge
	RD1
	RAL
	CMC
	RAR
	JCN		NZ, not_at_right_edge
	
screen_at_right_edge:
	LDM		1
	WR2

not_at_right_edge:
screen_edge_handled:
	RD2
	JCN		Z, screen_scrolling_handled
	JUN		screen_needs_scrolling

screen_scrolling_handled:

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"write data"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		0AH
	JMS		spiSendNibble_nCS2_mode3

	;the char
	LD		r0
	JMS		spiSendNibble_nCS2_mode3
	LD		r1
	JMS		spiSendNibble_nCS2_mode3

	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;increment column
	RD1
	IAC
	WR1
	JCN		NZ, screen_col_incr_done

	RD0
	IAC
	WR0

screen_col_incr_done:
	BBL		0


screen_needs_scrolling:		;scroll the entire screen up a line, reset cursor to start of line 2
	FIM		r2, 256 - 40


screen_scroll:

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"set pointer" to row 2 col "1 - r2:r3"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x40 + 1 - r2:r3
	STC
	LDM		0CH
	SUB		r2
	JMS		spiSendNibble_nCS2_mode3
	LD		r3
	CMA
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"data read"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		0EH
	JMS		spiSendNibble_nCS2_mode3

	JMS		spiRecvNibble_pin1_mode3
	LD		r6
	XCH		r8
	JMS		spiRecvNibble_pin1_mode3
	LD		r6
	XCH		r9

	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"set pointer" to row 1 col "1 - r2:r3"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x00 + 1 - r2:r3
	STC
	LDM		08H
	SUB		r2
	JMS		spiSendNibble_nCS2_mode3
	LD		r3
	CMA
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"data write"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		0AH
	JMS		spiSendNibble_nCS2_mode3

	LD		r8
	JMS		spiSendNibble_nCS2_mode3
	LD		r9
	JMS		spiSendNibble_nCS2_mode3

	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	ISZ		r3, screen_scroll
	ISZ		r2, screen_scroll



screen_row_clear:
	
	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"set pointer" to row 2 col 0
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x40
	LDM		0CH
	JMS		spiSendNibble_nCS2_mode3
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	FIM		r2, 256 - 40

screen_row_clear_loop:

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"data write"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		0AH
	JMS		spiSendNibble_nCS2_mode3

	LDM		02H
	JMS		spiSendNibble_nCS2_mode3
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3

	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	ISZ		r3, screen_row_clear_loop
	ISZ		r2, screen_row_clear_loop

	;reset pointer ot start or row2

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP
	;"set pointer" to row 2 col 0
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x40
	LDM		0CH
	JMS		spiSendNibble_nCS2_mode3
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;col = 0; lineIsOver = 0
	LDM		0
	WR0
	WR1
	WR2
	JUN		screen_scrolling_handled


screen_backspace:	;column has been adjusted backwards already

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"set pointer" to row 2 col "VFD_COLUMN"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x80 + 0x40 + column		// + 12 == -4 in mod 16
	RD0
	DAC
	DAC
	DAC
	DAC
	JMS		spiSendNibble_nCS2_mode3
	RD1
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"data write" of a space
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		0AH
	JMS		spiSendNibble_nCS2_mode3

	LDM		02H
	JMS		spiSendNibble_nCS2_mode3
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3

	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"set pointer" to row 2 col "VFD_COLUMN"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;0x80 + 0x40 + column		// + 12 == -4 in mod 16
	RD0
	DAC
	DAC
	DAC
	DAC
	JMS		spiSendNibble_nCS2_mode3
	RD1
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP
	BBL		0


cpuPrvGetchar:		;return in r0:r1, C = "git a byte"

	LDM		1
	DCL

	FIM		r2, DCL1_UART_VFD_CHIP		;pick proper output chip
	SRC		r2

	;select it (nCS3)
	LDM		03H
	WMP
	LDM		0BH
	WMP

	;read RXLVL
	LDM		0CH
	JMS		spiSendNibble_nCS3
	LDM		08H
	JMS		spiSendNibble_nCS3


	;the byte
	JMS		spiRecvNibble_pin2
	LD		r6
	XCH		r13
	JMS		spiRecvNibble_pin2

	;deselect
	LDM		0BH		;lower clock and data while keeping nCS low
	WMP
	LDM		03H		;raise nCS while keeping clock and data low
	WMP

	LD		r6
	JCN		NZ, cpuPrvGetchar_haveData
	LD		r13
	JCN		NZ, cpuPrvGetchar_haveData

cpuPrvGetchar_noData:
	CLC
	JUN		cpuPrvVeneerReturn

cpuPrvGetchar_haveData:

	;select it (nCS3)
	LDM		03H
	WMP
	LDM		0BH
	WMP

	;read RHR
	LDM		08H
	JMS		spiSendNibble_nCS3
	LDM		00H
	JMS		spiSendNibble_nCS3
	
	;the byte
	JMS		spiRecvNibble_pin2
	LD		r6
	XCH		r0
	JMS		spiRecvNibble_pin2
	LD		r6
	XCH		r1

	;deselect
	LDM		0BH		;lower clock and data while keeping nCS low
	WMP
	LDM		03H		;raise nCS while keeping clock and data low
	WMP

	STC
	JUN		cpuPrvVeneerReturn


vfdInit:
	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"command"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;"clear display"
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3
	LDM		01H
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"command"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;"display on"
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3
	LDM		0CH
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	;select it (nCS2, mode 3)
	LDM		01H		;data low, clock high, nCS high
	WMP
	LDM		05H		;data low, clock high, nCS low
	WMP

	;"command"
	LDM		0FH
	JMS		spiSendNibble_nCS2_mode3
	LDM		08H
	JMS		spiSendNibble_nCS2_mode3

	;"set pointer" to row 2 col 0
	LDM		0CH
	JMS		spiSendNibble_nCS2_mode3
	LDM		00H
	JMS		spiSendNibble_nCS2_mode3
	
	;deselect (nCS2, mode 3)
	LDM		07H		;lower clock while data and nCS low
	WMP
	LDM		05H		;raise clock, keep data and nCS low
	WMP
	LDM		01H		;raise nCS while keeping clock clock high and data low
	WMP

	BBL		0
	


hwAndSwInit:		;;init hw and also some of the SW init that we moved out of rom page 0 due to space
	
	;npc inited to 0x80000000. pc not inited (it will be overwritten by npc when our first hypercall returns)
	;	normally it would be 0xBFC00000 but we load first SD card sector to ram and jump to it directly to save on ROM bytes and decoding ROM
	LDM		1
	DCL
	FIM		r0, DCL1_NPC + 7
	SRC		r0
	LDM		8
	WRM

	;we init all TLB entries to 0x80000000 and into one buchet (bucket 0, as it would be)
	;we thus need to mark bucket 0 as not empty and point it to the first TLB entry
	;this requires a single write of 1 to DLC1_HASH_PRESENT[0]
	FIM		r0, DLC1_HASH_PRESENT
	SRC		r0
	LDM		1
	WRM


	JMS		tlbProbe
	LDM		1
	DCL
	FIM		r2, DCL1_UART_VFD_CHIP		;pick proper output chip
	SRC		r2
	JMS		vfdInit
	JMS		uartInit
	
	JUN		sdInit	;used more stack than a JMS could support
sdInitDone:

	FIM		r12, 0
	JUN		cpuPrvVeneerReturn



;this needs to be in the same page as its data, so make it so:
	ORG		0940H

uartInitData:		;u8 regByte, u8 data byte, top bit in first is end
	DB 8 * 2		;FCR(0x02) = 0x06	//reset fifos
	DB 006H
	DB 8 * 2		;FCR(0x02) = 0x01	//enable fifos
	DB 001H
	DB 8 * 3		;LCR(0x03) = 0xBF	//enable EFR access
	DB 0BFH
	DB 8 * 2		;EFR(0x02) = 0x40	//enable extra regs
	DB 040H
	DB 8 * 4		;MCR(0x04) = 0x04	//enable TCR/TLR
	DB 004H
	DB 8 * 6		;TCR(0x06) = 0x4c	//halt at 48 bytes in buffer, resume at 16
	DB 04CH
	DB 8 * 2		;EFR(0x02) = 0x50	//enable extra regs, rts flow control
	DB 050H
	DB 8 * 3		;LCR(0x03) = 0x80	//enable BRG acess
	DB 080H
	DB 8 * 0		;DLL(0x00) = 20		//assuming a 3.072 MHz crystal, this is 9600 baud
	DB 014H
	DB 8 * 1		;DLH(0x01) = 0
	DB 000H
	DB 8 * 3		;LCR(0x03) = 3		//8n1
	DB 003H
	DB 8 * 1		;IER(0x01) = 0x05	//RX int on, rs line idle on
	DB 005H
	DB 080H			;terminator


uartInit_done:
	BBL		0

uartInit:
	FIM		r0, uartInitData

uartInitLoop:
	FIN		r2
	LD		r2
	RAL
	JCN		C, uartInit_done

	LDM		16 - 2
	XCH		r4

	;select it (nCS3)
	LDM		03H
	WMP
	LDM		0BH
	WMP

uartInitSubloop:

	;write to TCR
	LD		r2
	JMS		spiSendNibble_nCS3
	LD		r3
	JMS		spiSendNibble_nCS3
	
	INC		r1
	LD		r1
	JCN		NZ, uartInitSubloop_inc_done
	INC		r0

uartInitSubloop_inc_done:
	FIN		r2
	ISZ		r4, uartInitSubloop

	;deselect
	LDM		0BH		;lower clock and data while keeping nCS low
	WMP
	LDM		03H		;raise nCS while keeping clock and data low
	WMP

	JUN		uartInitLoop

;messages should start somewhere we are sure will not cross a boundary
	org		0980H

prvShowSdInitFailMsgAndHang:
	FIM		r10, prvSdInitErrMsg
	JMS		prvShowMessage
hang:
	JUN		hang

prvShowMessage:		;ptr in r10
	LD		r10
	XCH		r0
	LD		r11
	XCH		r1
	ISZ		r11, msg_no_rollover
	INC		r10
msg_no_rollover:
	FIN		r0
	LD		r0
	JCN		NZ, msg_yes_print
	LD		r1
	JCN		NZ, msg_yes_print
msg_over:
	BBL		0

msg_yes_print:
	JMS		cpuPrvPutchar
	JUN		prvShowMessage

prvSdInitErrMsg:
	DB		"Failed to init SD card. Halting here and now!", 0

;XOR LUT
	org		09ffH
cpuPrvLutXor:
	DB	031H		;JIN r0 that our assembler refuses to assemble when it is the last byte on a page
	BBL 000H ;0x0 ^ 0x0 = 0x00
	BBL 001H ;0x0 ^ 0x1 = 0x01
	BBL 002H ;0x0 ^ 0x2 = 0x02
	BBL 003H ;0x0 ^ 0x3 = 0x03
	BBL 004H ;0x0 ^ 0x4 = 0x04
	BBL 005H ;0x0 ^ 0x5 = 0x05
	BBL 006H ;0x0 ^ 0x6 = 0x06
	BBL 007H ;0x0 ^ 0x7 = 0x07
	BBL 008H ;0x0 ^ 0x8 = 0x08
	BBL 009H ;0x0 ^ 0x9 = 0x09
	BBL 00AH ;0x0 ^ 0xA = 0x0A
	BBL 00BH ;0x0 ^ 0xB = 0x0B
	BBL 00CH ;0x0 ^ 0xC = 0x0C
	BBL 00DH ;0x0 ^ 0xD = 0x0D
	BBL 00EH ;0x0 ^ 0xE = 0x0E
	BBL 00FH ;0x0 ^ 0xF = 0x0F
	BBL 001H ;0x1 ^ 0x0 = 0x01
	BBL 000H ;0x1 ^ 0x1 = 0x00
	BBL 003H ;0x1 ^ 0x2 = 0x03
	BBL 002H ;0x1 ^ 0x3 = 0x02
	BBL 005H ;0x1 ^ 0x4 = 0x05
	BBL 004H ;0x1 ^ 0x5 = 0x04
	BBL 007H ;0x1 ^ 0x6 = 0x07
	BBL 006H ;0x1 ^ 0x7 = 0x06
	BBL 009H ;0x1 ^ 0x8 = 0x09
	BBL 008H ;0x1 ^ 0x9 = 0x08
	BBL 00BH ;0x1 ^ 0xA = 0x0B
	BBL 00AH ;0x1 ^ 0xB = 0x0A
	BBL 00DH ;0x1 ^ 0xC = 0x0D
	BBL 00CH ;0x1 ^ 0xD = 0x0C
	BBL 00FH ;0x1 ^ 0xE = 0x0F
	BBL 00EH ;0x1 ^ 0xF = 0x0E
	BBL 002H ;0x2 ^ 0x0 = 0x02
	BBL 003H ;0x2 ^ 0x1 = 0x03
	BBL 000H ;0x2 ^ 0x2 = 0x00
	BBL 001H ;0x2 ^ 0x3 = 0x01
	BBL 006H ;0x2 ^ 0x4 = 0x06
	BBL 007H ;0x2 ^ 0x5 = 0x07
	BBL 004H ;0x2 ^ 0x6 = 0x04
	BBL 005H ;0x2 ^ 0x7 = 0x05
	BBL 00AH ;0x2 ^ 0x8 = 0x0A
	BBL 00BH ;0x2 ^ 0x9 = 0x0B
	BBL 008H ;0x2 ^ 0xA = 0x08
	BBL 009H ;0x2 ^ 0xB = 0x09
	BBL 00EH ;0x2 ^ 0xC = 0x0E
	BBL 00FH ;0x2 ^ 0xD = 0x0F
	BBL 00CH ;0x2 ^ 0xE = 0x0C
	BBL 00DH ;0x2 ^ 0xF = 0x0D
	BBL 003H ;0x3 ^ 0x0 = 0x03
	BBL 002H ;0x3 ^ 0x1 = 0x02
	BBL 001H ;0x3 ^ 0x2 = 0x01
	BBL 000H ;0x3 ^ 0x3 = 0x00
	BBL 007H ;0x3 ^ 0x4 = 0x07
	BBL 006H ;0x3 ^ 0x5 = 0x06
	BBL 005H ;0x3 ^ 0x6 = 0x05
	BBL 004H ;0x3 ^ 0x7 = 0x04
	BBL 00BH ;0x3 ^ 0x8 = 0x0B
	BBL 00AH ;0x3 ^ 0x9 = 0x0A
	BBL 009H ;0x3 ^ 0xA = 0x09
	BBL 008H ;0x3 ^ 0xB = 0x08
	BBL 00FH ;0x3 ^ 0xC = 0x0F
	BBL 00EH ;0x3 ^ 0xD = 0x0E
	BBL 00DH ;0x3 ^ 0xE = 0x0D
	BBL 00CH ;0x3 ^ 0xF = 0x0C
	BBL 004H ;0x4 ^ 0x0 = 0x04
	BBL 005H ;0x4 ^ 0x1 = 0x05
	BBL 006H ;0x4 ^ 0x2 = 0x06
	BBL 007H ;0x4 ^ 0x3 = 0x07
	BBL 000H ;0x4 ^ 0x4 = 0x00
	BBL 001H ;0x4 ^ 0x5 = 0x01
	BBL 002H ;0x4 ^ 0x6 = 0x02
	BBL 003H ;0x4 ^ 0x7 = 0x03
	BBL 00CH ;0x4 ^ 0x8 = 0x0C
	BBL 00DH ;0x4 ^ 0x9 = 0x0D
	BBL 00EH ;0x4 ^ 0xA = 0x0E
	BBL 00FH ;0x4 ^ 0xB = 0x0F
	BBL 008H ;0x4 ^ 0xC = 0x08
	BBL 009H ;0x4 ^ 0xD = 0x09
	BBL 00AH ;0x4 ^ 0xE = 0x0A
	BBL 00BH ;0x4 ^ 0xF = 0x0B
	BBL 005H ;0x5 ^ 0x0 = 0x05
	BBL 004H ;0x5 ^ 0x1 = 0x04
	BBL 007H ;0x5 ^ 0x2 = 0x07
	BBL 006H ;0x5 ^ 0x3 = 0x06
	BBL 001H ;0x5 ^ 0x4 = 0x01
	BBL 000H ;0x5 ^ 0x5 = 0x00
	BBL 003H ;0x5 ^ 0x6 = 0x03
	BBL 002H ;0x5 ^ 0x7 = 0x02
	BBL 00DH ;0x5 ^ 0x8 = 0x0D
	BBL 00CH ;0x5 ^ 0x9 = 0x0C
	BBL 00FH ;0x5 ^ 0xA = 0x0F
	BBL 00EH ;0x5 ^ 0xB = 0x0E
	BBL 009H ;0x5 ^ 0xC = 0x09
	BBL 008H ;0x5 ^ 0xD = 0x08
	BBL 00BH ;0x5 ^ 0xE = 0x0B
	BBL 00AH ;0x5 ^ 0xF = 0x0A
	BBL 006H ;0x6 ^ 0x0 = 0x06
	BBL 007H ;0x6 ^ 0x1 = 0x07
	BBL 004H ;0x6 ^ 0x2 = 0x04
	BBL 005H ;0x6 ^ 0x3 = 0x05
	BBL 002H ;0x6 ^ 0x4 = 0x02
	BBL 003H ;0x6 ^ 0x5 = 0x03
	BBL 000H ;0x6 ^ 0x6 = 0x00
	BBL 001H ;0x6 ^ 0x7 = 0x01
	BBL 00EH ;0x6 ^ 0x8 = 0x0E
	BBL 00FH ;0x6 ^ 0x9 = 0x0F
	BBL 00CH ;0x6 ^ 0xA = 0x0C
	BBL 00DH ;0x6 ^ 0xB = 0x0D
	BBL 00AH ;0x6 ^ 0xC = 0x0A
	BBL 00BH ;0x6 ^ 0xD = 0x0B
	BBL 008H ;0x6 ^ 0xE = 0x08
	BBL 009H ;0x6 ^ 0xF = 0x09
	BBL 007H ;0x7 ^ 0x0 = 0x07
	BBL 006H ;0x7 ^ 0x1 = 0x06
	BBL 005H ;0x7 ^ 0x2 = 0x05
	BBL 004H ;0x7 ^ 0x3 = 0x04
	BBL 003H ;0x7 ^ 0x4 = 0x03
	BBL 002H ;0x7 ^ 0x5 = 0x02
	BBL 001H ;0x7 ^ 0x6 = 0x01
	BBL 000H ;0x7 ^ 0x7 = 0x00
	BBL 00FH ;0x7 ^ 0x8 = 0x0F
	BBL 00EH ;0x7 ^ 0x9 = 0x0E
	BBL 00DH ;0x7 ^ 0xA = 0x0D
	BBL 00CH ;0x7 ^ 0xB = 0x0C
	BBL 00BH ;0x7 ^ 0xC = 0x0B
	BBL 00AH ;0x7 ^ 0xD = 0x0A
	BBL 009H ;0x7 ^ 0xE = 0x09
	BBL 008H ;0x7 ^ 0xF = 0x08
	BBL 008H ;0x8 ^ 0x0 = 0x08
	BBL 009H ;0x8 ^ 0x1 = 0x09
	BBL 00AH ;0x8 ^ 0x2 = 0x0A
	BBL 00BH ;0x8 ^ 0x3 = 0x0B
	BBL 00CH ;0x8 ^ 0x4 = 0x0C
	BBL 00DH ;0x8 ^ 0x5 = 0x0D
	BBL 00EH ;0x8 ^ 0x6 = 0x0E
	BBL 00FH ;0x8 ^ 0x7 = 0x0F
	BBL 000H ;0x8 ^ 0x8 = 0x00
	BBL 001H ;0x8 ^ 0x9 = 0x01
	BBL 002H ;0x8 ^ 0xA = 0x02
	BBL 003H ;0x8 ^ 0xB = 0x03
	BBL 004H ;0x8 ^ 0xC = 0x04
	BBL 005H ;0x8 ^ 0xD = 0x05
	BBL 006H ;0x8 ^ 0xE = 0x06
	BBL 007H ;0x8 ^ 0xF = 0x07
	BBL 009H ;0x9 ^ 0x0 = 0x09
	BBL 008H ;0x9 ^ 0x1 = 0x08
	BBL 00BH ;0x9 ^ 0x2 = 0x0B
	BBL 00AH ;0x9 ^ 0x3 = 0x0A
	BBL 00DH ;0x9 ^ 0x4 = 0x0D
	BBL 00CH ;0x9 ^ 0x5 = 0x0C
	BBL 00FH ;0x9 ^ 0x6 = 0x0F
	BBL 00EH ;0x9 ^ 0x7 = 0x0E
	BBL 001H ;0x9 ^ 0x8 = 0x01
	BBL 000H ;0x9 ^ 0x9 = 0x00
	BBL 003H ;0x9 ^ 0xA = 0x03
	BBL 002H ;0x9 ^ 0xB = 0x02
	BBL 005H ;0x9 ^ 0xC = 0x05
	BBL 004H ;0x9 ^ 0xD = 0x04
	BBL 007H ;0x9 ^ 0xE = 0x07
	BBL 006H ;0x9 ^ 0xF = 0x06
	BBL 00AH ;0xA ^ 0x0 = 0x0A
	BBL 00BH ;0xA ^ 0x1 = 0x0B
	BBL 008H ;0xA ^ 0x2 = 0x08
	BBL 009H ;0xA ^ 0x3 = 0x09
	BBL 00EH ;0xA ^ 0x4 = 0x0E
	BBL 00FH ;0xA ^ 0x5 = 0x0F
	BBL 00CH ;0xA ^ 0x6 = 0x0C
	BBL 00DH ;0xA ^ 0x7 = 0x0D
	BBL 002H ;0xA ^ 0x8 = 0x02
	BBL 003H ;0xA ^ 0x9 = 0x03
	BBL 000H ;0xA ^ 0xA = 0x00
	BBL 001H ;0xA ^ 0xB = 0x01
	BBL 006H ;0xA ^ 0xC = 0x06
	BBL 007H ;0xA ^ 0xD = 0x07
	BBL 004H ;0xA ^ 0xE = 0x04
	BBL 005H ;0xA ^ 0xF = 0x05
	BBL 00BH ;0xB ^ 0x0 = 0x0B
	BBL 00AH ;0xB ^ 0x1 = 0x0A
	BBL 009H ;0xB ^ 0x2 = 0x09
	BBL 008H ;0xB ^ 0x3 = 0x08
	BBL 00FH ;0xB ^ 0x4 = 0x0F
	BBL 00EH ;0xB ^ 0x5 = 0x0E
	BBL 00DH ;0xB ^ 0x6 = 0x0D
	BBL 00CH ;0xB ^ 0x7 = 0x0C
	BBL 003H ;0xB ^ 0x8 = 0x03
	BBL 002H ;0xB ^ 0x9 = 0x02
	BBL 001H ;0xB ^ 0xA = 0x01
	BBL 000H ;0xB ^ 0xB = 0x00
	BBL 007H ;0xB ^ 0xC = 0x07
	BBL 006H ;0xB ^ 0xD = 0x06
	BBL 005H ;0xB ^ 0xE = 0x05
	BBL 004H ;0xB ^ 0xF = 0x04
	BBL 00CH ;0xC ^ 0x0 = 0x0C
	BBL 00DH ;0xC ^ 0x1 = 0x0D
	BBL 00EH ;0xC ^ 0x2 = 0x0E
	BBL 00FH ;0xC ^ 0x3 = 0x0F
	BBL 008H ;0xC ^ 0x4 = 0x08
	BBL 009H ;0xC ^ 0x5 = 0x09
	BBL 00AH ;0xC ^ 0x6 = 0x0A
	BBL 00BH ;0xC ^ 0x7 = 0x0B
	BBL 004H ;0xC ^ 0x8 = 0x04
	BBL 005H ;0xC ^ 0x9 = 0x05
	BBL 006H ;0xC ^ 0xA = 0x06
	BBL 007H ;0xC ^ 0xB = 0x07
	BBL 000H ;0xC ^ 0xC = 0x00
	BBL 001H ;0xC ^ 0xD = 0x01
	BBL 002H ;0xC ^ 0xE = 0x02
	BBL 003H ;0xC ^ 0xF = 0x03
	BBL 00DH ;0xD ^ 0x0 = 0x0D
	BBL 00CH ;0xD ^ 0x1 = 0x0C
	BBL 00FH ;0xD ^ 0x2 = 0x0F
	BBL 00EH ;0xD ^ 0x3 = 0x0E
	BBL 009H ;0xD ^ 0x4 = 0x09
	BBL 008H ;0xD ^ 0x5 = 0x08
	BBL 00BH ;0xD ^ 0x6 = 0x0B
	BBL 00AH ;0xD ^ 0x7 = 0x0A
	BBL 005H ;0xD ^ 0x8 = 0x05
	BBL 004H ;0xD ^ 0x9 = 0x04
	BBL 007H ;0xD ^ 0xA = 0x07
	BBL 006H ;0xD ^ 0xB = 0x06
	BBL 001H ;0xD ^ 0xC = 0x01
	BBL 000H ;0xD ^ 0xD = 0x00
	BBL 003H ;0xD ^ 0xE = 0x03
	BBL 002H ;0xD ^ 0xF = 0x02
	BBL 00EH ;0xE ^ 0x0 = 0x0E
	BBL 00FH ;0xE ^ 0x1 = 0x0F
	BBL 00CH ;0xE ^ 0x2 = 0x0C
	BBL 00DH ;0xE ^ 0x3 = 0x0D
	BBL 00AH ;0xE ^ 0x4 = 0x0A
	BBL 00BH ;0xE ^ 0x5 = 0x0B
	BBL 008H ;0xE ^ 0x6 = 0x08
	BBL 009H ;0xE ^ 0x7 = 0x09
	BBL 006H ;0xE ^ 0x8 = 0x06
	BBL 007H ;0xE ^ 0x9 = 0x07
	BBL 004H ;0xE ^ 0xA = 0x04
	BBL 005H ;0xE ^ 0xB = 0x05
	BBL 002H ;0xE ^ 0xC = 0x02
	BBL 003H ;0xE ^ 0xD = 0x03
	BBL 000H ;0xE ^ 0xE = 0x00
	BBL 001H ;0xE ^ 0xF = 0x01
	BBL 00FH ;0xF ^ 0x0 = 0x0F
	BBL 00EH ;0xF ^ 0x1 = 0x0E
	BBL 00DH ;0xF ^ 0x2 = 0x0D
	BBL 00CH ;0xF ^ 0x3 = 0x0C
	BBL 00BH ;0xF ^ 0x4 = 0x0B
	BBL 00AH ;0xF ^ 0x5 = 0x0A
	BBL 009H ;0xF ^ 0x6 = 0x09
	BBL 008H ;0xF ^ 0x7 = 0x08
	BBL 007H ;0xF ^ 0x8 = 0x07
	BBL 006H ;0xF ^ 0x9 = 0x06
	BBL 005H ;0xF ^ 0xA = 0x05
	BBL 004H ;0xF ^ 0xB = 0x04
	BBL 003H ;0xF ^ 0xC = 0x03
	BBL 002H ;0xF ^ 0xD = 0x02
	BBL 001H ;0xF ^ 0xE = 0x01
	BBL 000H ;0xF ^ 0xF = 0x00


;ORR LUT
	org		0bffH
cpuPrvLutOrr:
	DB	031H		;JIN r0 that our assembler refuses to assemble when it is the last byte on a page
	BBL 000H ;0x0 | 0x0 = 0x00
	BBL 001H ;0x0 | 0x1 = 0x01
	BBL 002H ;0x0 | 0x2 = 0x02
	BBL 003H ;0x0 | 0x3 = 0x03
	BBL 004H ;0x0 | 0x4 = 0x04
	BBL 005H ;0x0 | 0x5 = 0x05
	BBL 006H ;0x0 | 0x6 = 0x06
	BBL 007H ;0x0 | 0x7 = 0x07
	BBL 008H ;0x0 | 0x8 = 0x08
	BBL 009H ;0x0 | 0x9 = 0x09
	BBL 00AH ;0x0 | 0xA = 0x0A
	BBL 00BH ;0x0 | 0xB = 0x0B
	BBL 00CH ;0x0 | 0xC = 0x0C
	BBL 00DH ;0x0 | 0xD = 0x0D
	BBL 00EH ;0x0 | 0xE = 0x0E
	BBL 00FH ;0x0 | 0xF = 0x0F
	BBL 001H ;0x1 | 0x0 = 0x01
	BBL 001H ;0x1 | 0x1 = 0x01
	BBL 003H ;0x1 | 0x2 = 0x03
	BBL 003H ;0x1 | 0x3 = 0x03
	BBL 005H ;0x1 | 0x4 = 0x05
	BBL 005H ;0x1 | 0x5 = 0x05
	BBL 007H ;0x1 | 0x6 = 0x07
	BBL 007H ;0x1 | 0x7 = 0x07
	BBL 009H ;0x1 | 0x8 = 0x09
	BBL 009H ;0x1 | 0x9 = 0x09
	BBL 00BH ;0x1 | 0xA = 0x0B
	BBL 00BH ;0x1 | 0xB = 0x0B
	BBL 00DH ;0x1 | 0xC = 0x0D
	BBL 00DH ;0x1 | 0xD = 0x0D
	BBL 00FH ;0x1 | 0xE = 0x0F
	BBL 00FH ;0x1 | 0xF = 0x0F
	BBL 002H ;0x2 | 0x0 = 0x02
	BBL 003H ;0x2 | 0x1 = 0x03
	BBL 002H ;0x2 | 0x2 = 0x02
	BBL 003H ;0x2 | 0x3 = 0x03
	BBL 006H ;0x2 | 0x4 = 0x06
	BBL 007H ;0x2 | 0x5 = 0x07
	BBL 006H ;0x2 | 0x6 = 0x06
	BBL 007H ;0x2 | 0x7 = 0x07
	BBL 00AH ;0x2 | 0x8 = 0x0A
	BBL 00BH ;0x2 | 0x9 = 0x0B
	BBL 00AH ;0x2 | 0xA = 0x0A
	BBL 00BH ;0x2 | 0xB = 0x0B
	BBL 00EH ;0x2 | 0xC = 0x0E
	BBL 00FH ;0x2 | 0xD = 0x0F
	BBL 00EH ;0x2 | 0xE = 0x0E
	BBL 00FH ;0x2 | 0xF = 0x0F
	BBL 003H ;0x3 | 0x0 = 0x03
	BBL 003H ;0x3 | 0x1 = 0x03
	BBL 003H ;0x3 | 0x2 = 0x03
	BBL 003H ;0x3 | 0x3 = 0x03
	BBL 007H ;0x3 | 0x4 = 0x07
	BBL 007H ;0x3 | 0x5 = 0x07
	BBL 007H ;0x3 | 0x6 = 0x07
	BBL 007H ;0x3 | 0x7 = 0x07
	BBL 00BH ;0x3 | 0x8 = 0x0B
	BBL 00BH ;0x3 | 0x9 = 0x0B
	BBL 00BH ;0x3 | 0xA = 0x0B
	BBL 00BH ;0x3 | 0xB = 0x0B
	BBL 00FH ;0x3 | 0xC = 0x0F
	BBL 00FH ;0x3 | 0xD = 0x0F
	BBL 00FH ;0x3 | 0xE = 0x0F
	BBL 00FH ;0x3 | 0xF = 0x0F
	BBL 004H ;0x4 | 0x0 = 0x04
	BBL 005H ;0x4 | 0x1 = 0x05
	BBL 006H ;0x4 | 0x2 = 0x06
	BBL 007H ;0x4 | 0x3 = 0x07
	BBL 004H ;0x4 | 0x4 = 0x04
	BBL 005H ;0x4 | 0x5 = 0x05
	BBL 006H ;0x4 | 0x6 = 0x06
	BBL 007H ;0x4 | 0x7 = 0x07
	BBL 00CH ;0x4 | 0x8 = 0x0C
	BBL 00DH ;0x4 | 0x9 = 0x0D
	BBL 00EH ;0x4 | 0xA = 0x0E
	BBL 00FH ;0x4 | 0xB = 0x0F
	BBL 00CH ;0x4 | 0xC = 0x0C
	BBL 00DH ;0x4 | 0xD = 0x0D
	BBL 00EH ;0x4 | 0xE = 0x0E
	BBL 00FH ;0x4 | 0xF = 0x0F
	BBL 005H ;0x5 | 0x0 = 0x05
	BBL 005H ;0x5 | 0x1 = 0x05
	BBL 007H ;0x5 | 0x2 = 0x07
	BBL 007H ;0x5 | 0x3 = 0x07
	BBL 005H ;0x5 | 0x4 = 0x05
	BBL 005H ;0x5 | 0x5 = 0x05
	BBL 007H ;0x5 | 0x6 = 0x07
	BBL 007H ;0x5 | 0x7 = 0x07
	BBL 00DH ;0x5 | 0x8 = 0x0D
	BBL 00DH ;0x5 | 0x9 = 0x0D
	BBL 00FH ;0x5 | 0xA = 0x0F
	BBL 00FH ;0x5 | 0xB = 0x0F
	BBL 00DH ;0x5 | 0xC = 0x0D
	BBL 00DH ;0x5 | 0xD = 0x0D
	BBL 00FH ;0x5 | 0xE = 0x0F
	BBL 00FH ;0x5 | 0xF = 0x0F
	BBL 006H ;0x6 | 0x0 = 0x06
	BBL 007H ;0x6 | 0x1 = 0x07
	BBL 006H ;0x6 | 0x2 = 0x06
	BBL 007H ;0x6 | 0x3 = 0x07
	BBL 006H ;0x6 | 0x4 = 0x06
	BBL 007H ;0x6 | 0x5 = 0x07
	BBL 006H ;0x6 | 0x6 = 0x06
	BBL 007H ;0x6 | 0x7 = 0x07
	BBL 00EH ;0x6 | 0x8 = 0x0E
	BBL 00FH ;0x6 | 0x9 = 0x0F
	BBL 00EH ;0x6 | 0xA = 0x0E
	BBL 00FH ;0x6 | 0xB = 0x0F
	BBL 00EH ;0x6 | 0xC = 0x0E
	BBL 00FH ;0x6 | 0xD = 0x0F
	BBL 00EH ;0x6 | 0xE = 0x0E
	BBL 00FH ;0x6 | 0xF = 0x0F
	BBL 007H ;0x7 | 0x0 = 0x07
	BBL 007H ;0x7 | 0x1 = 0x07
	BBL 007H ;0x7 | 0x2 = 0x07
	BBL 007H ;0x7 | 0x3 = 0x07
	BBL 007H ;0x7 | 0x4 = 0x07
	BBL 007H ;0x7 | 0x5 = 0x07
	BBL 007H ;0x7 | 0x6 = 0x07
	BBL 007H ;0x7 | 0x7 = 0x07
	BBL 00FH ;0x7 | 0x8 = 0x0F
	BBL 00FH ;0x7 | 0x9 = 0x0F
	BBL 00FH ;0x7 | 0xA = 0x0F
	BBL 00FH ;0x7 | 0xB = 0x0F
	BBL 00FH ;0x7 | 0xC = 0x0F
	BBL 00FH ;0x7 | 0xD = 0x0F
	BBL 00FH ;0x7 | 0xE = 0x0F
	BBL 00FH ;0x7 | 0xF = 0x0F
	BBL 008H ;0x8 | 0x0 = 0x08
	BBL 009H ;0x8 | 0x1 = 0x09
	BBL 00AH ;0x8 | 0x2 = 0x0A
	BBL 00BH ;0x8 | 0x3 = 0x0B
	BBL 00CH ;0x8 | 0x4 = 0x0C
	BBL 00DH ;0x8 | 0x5 = 0x0D
	BBL 00EH ;0x8 | 0x6 = 0x0E
	BBL 00FH ;0x8 | 0x7 = 0x0F
	BBL 008H ;0x8 | 0x8 = 0x08
	BBL 009H ;0x8 | 0x9 = 0x09
	BBL 00AH ;0x8 | 0xA = 0x0A
	BBL 00BH ;0x8 | 0xB = 0x0B
	BBL 00CH ;0x8 | 0xC = 0x0C
	BBL 00DH ;0x8 | 0xD = 0x0D
	BBL 00EH ;0x8 | 0xE = 0x0E
	BBL 00FH ;0x8 | 0xF = 0x0F
	BBL 009H ;0x9 | 0x0 = 0x09
	BBL 009H ;0x9 | 0x1 = 0x09
	BBL 00BH ;0x9 | 0x2 = 0x0B
	BBL 00BH ;0x9 | 0x3 = 0x0B
	BBL 00DH ;0x9 | 0x4 = 0x0D
	BBL 00DH ;0x9 | 0x5 = 0x0D
	BBL 00FH ;0x9 | 0x6 = 0x0F
	BBL 00FH ;0x9 | 0x7 = 0x0F
	BBL 009H ;0x9 | 0x8 = 0x09
	BBL 009H ;0x9 | 0x9 = 0x09
	BBL 00BH ;0x9 | 0xA = 0x0B
	BBL 00BH ;0x9 | 0xB = 0x0B
	BBL 00DH ;0x9 | 0xC = 0x0D
	BBL 00DH ;0x9 | 0xD = 0x0D
	BBL 00FH ;0x9 | 0xE = 0x0F
	BBL 00FH ;0x9 | 0xF = 0x0F
	BBL 00AH ;0xA | 0x0 = 0x0A
	BBL 00BH ;0xA | 0x1 = 0x0B
	BBL 00AH ;0xA | 0x2 = 0x0A
	BBL 00BH ;0xA | 0x3 = 0x0B
	BBL 00EH ;0xA | 0x4 = 0x0E
	BBL 00FH ;0xA | 0x5 = 0x0F
	BBL 00EH ;0xA | 0x6 = 0x0E
	BBL 00FH ;0xA | 0x7 = 0x0F
	BBL 00AH ;0xA | 0x8 = 0x0A
	BBL 00BH ;0xA | 0x9 = 0x0B
	BBL 00AH ;0xA | 0xA = 0x0A
	BBL 00BH ;0xA | 0xB = 0x0B
	BBL 00EH ;0xA | 0xC = 0x0E
	BBL 00FH ;0xA | 0xD = 0x0F
	BBL 00EH ;0xA | 0xE = 0x0E
	BBL 00FH ;0xA | 0xF = 0x0F
	BBL 00BH ;0xB | 0x0 = 0x0B
	BBL 00BH ;0xB | 0x1 = 0x0B
	BBL 00BH ;0xB | 0x2 = 0x0B
	BBL 00BH ;0xB | 0x3 = 0x0B
	BBL 00FH ;0xB | 0x4 = 0x0F
	BBL 00FH ;0xB | 0x5 = 0x0F
	BBL 00FH ;0xB | 0x6 = 0x0F
	BBL 00FH ;0xB | 0x7 = 0x0F
	BBL 00BH ;0xB | 0x8 = 0x0B
	BBL 00BH ;0xB | 0x9 = 0x0B
	BBL 00BH ;0xB | 0xA = 0x0B
	BBL 00BH ;0xB | 0xB = 0x0B
	BBL 00FH ;0xB | 0xC = 0x0F
	BBL 00FH ;0xB | 0xD = 0x0F
	BBL 00FH ;0xB | 0xE = 0x0F
	BBL 00FH ;0xB | 0xF = 0x0F
	BBL 00CH ;0xC | 0x0 = 0x0C
	BBL 00DH ;0xC | 0x1 = 0x0D
	BBL 00EH ;0xC | 0x2 = 0x0E
	BBL 00FH ;0xC | 0x3 = 0x0F
	BBL 00CH ;0xC | 0x4 = 0x0C
	BBL 00DH ;0xC | 0x5 = 0x0D
	BBL 00EH ;0xC | 0x6 = 0x0E
	BBL 00FH ;0xC | 0x7 = 0x0F
	BBL 00CH ;0xC | 0x8 = 0x0C
	BBL 00DH ;0xC | 0x9 = 0x0D
	BBL 00EH ;0xC | 0xA = 0x0E
	BBL 00FH ;0xC | 0xB = 0x0F
	BBL 00CH ;0xC | 0xC = 0x0C
	BBL 00DH ;0xC | 0xD = 0x0D
	BBL 00EH ;0xC | 0xE = 0x0E
	BBL 00FH ;0xC | 0xF = 0x0F
	BBL 00DH ;0xD | 0x0 = 0x0D
	BBL 00DH ;0xD | 0x1 = 0x0D
	BBL 00FH ;0xD | 0x2 = 0x0F
	BBL 00FH ;0xD | 0x3 = 0x0F
	BBL 00DH ;0xD | 0x4 = 0x0D
	BBL 00DH ;0xD | 0x5 = 0x0D
	BBL 00FH ;0xD | 0x6 = 0x0F
	BBL 00FH ;0xD | 0x7 = 0x0F
	BBL 00DH ;0xD | 0x8 = 0x0D
	BBL 00DH ;0xD | 0x9 = 0x0D
	BBL 00FH ;0xD | 0xA = 0x0F
	BBL 00FH ;0xD | 0xB = 0x0F
	BBL 00DH ;0xD | 0xC = 0x0D
	BBL 00DH ;0xD | 0xD = 0x0D
	BBL 00FH ;0xD | 0xE = 0x0F
	BBL 00FH ;0xD | 0xF = 0x0F
	BBL 00EH ;0xE | 0x0 = 0x0E
	BBL 00FH ;0xE | 0x1 = 0x0F
	BBL 00EH ;0xE | 0x2 = 0x0E
	BBL 00FH ;0xE | 0x3 = 0x0F
	BBL 00EH ;0xE | 0x4 = 0x0E
	BBL 00FH ;0xE | 0x5 = 0x0F
	BBL 00EH ;0xE | 0x6 = 0x0E
	BBL 00FH ;0xE | 0x7 = 0x0F
	BBL 00EH ;0xE | 0x8 = 0x0E
	BBL 00FH ;0xE | 0x9 = 0x0F
	BBL 00EH ;0xE | 0xA = 0x0E
	BBL 00FH ;0xE | 0xB = 0x0F
	BBL 00EH ;0xE | 0xC = 0x0E
	BBL 00FH ;0xE | 0xD = 0x0F
	BBL 00EH ;0xE | 0xE = 0x0E
	BBL 00FH ;0xE | 0xF = 0x0F
	BBL 00FH ;0xF | 0x0 = 0x0F
	BBL 00FH ;0xF | 0x1 = 0x0F
	BBL 00FH ;0xF | 0x2 = 0x0F
	BBL 00FH ;0xF | 0x3 = 0x0F
	BBL 00FH ;0xF | 0x4 = 0x0F
	BBL 00FH ;0xF | 0x5 = 0x0F
	BBL 00FH ;0xF | 0x6 = 0x0F
	BBL 00FH ;0xF | 0x7 = 0x0F
	BBL 00FH ;0xF | 0x8 = 0x0F
	BBL 00FH ;0xF | 0x9 = 0x0F
	BBL 00FH ;0xF | 0xA = 0x0F
	BBL 00FH ;0xF | 0xB = 0x0F
	BBL 00FH ;0xF | 0xC = 0x0F
	BBL 00FH ;0xF | 0xD = 0x0F
	BBL 00FH ;0xF | 0xE = 0x0F
	BBL 00FH ;0xF | 0xF = 0x0F


cpuPrvThreeOperandAnd:	;r6:r7 = whence, r4:r5 = what, r2:r3 = dst, clobbers r0, r1, r8, r9
	LDM		16 - 8
	XCH		r8
cpuPrvThreeOperandAnd_loop:
	SRC		r6
	INC		r7
	RDM
	XCH		r0
	SRC		r4
	INC		r5
	RDM
	XCH		r1
	JMS		cpuPrvLutAnd
	SRC		r2
	INC		r3
	WRM
	ISZ		r8, cpuPrvThreeOperandAnd_loop
	JUN		cpuPrvVeneerReturn

cpuPrvThreeOperandOrr:	;r6:r7 = whence, r4:r5 = what, r2:r3 = dst, clobbers r0, r1, r8, r9
	LDM		16 - 8
	XCH		r8
cpuPrvThreeOperandOrr_loop:
	SRC		r6
	INC		r7
	RDM
	XCH		r0
	SRC		r4
	INC		r5
	RDM
	XCH		r1
	JMS		cpuPrvLutOrr
	SRC		r2
	INC		r3
	WRM
	ISZ		r8, cpuPrvThreeOperandOrr_loop
	JUN		cpuPrvVeneerReturn


cpuPrvThreeOperandXor:	;r6:r7 = whence, r4:r5 = what, r2:r3 = dst, clobbers r0, r1, r8, r9
	LDM		16 - 8
	XCH		r8
cpuPrvThreeOperandXor_loop:
	SRC		r6
	INC		r7
	RDM
	XCH		r0
	SRC		r4
	INC		r5
	RDM
	XCH		r1
	JMS		cpuPrvLutXor
	SRC		r2
	INC		r3
	WRM
	ISZ		r8, cpuPrvThreeOperandXor_loop
	JUN		cpuPrvVeneerReturn


cpuPrvThreeOperandNor:	;r6:r7 = whence, r4:r5 = what, r2:r3 = dst, clobbers r0, r1, r8, r9
	LDM		16 - 8
	XCH		r8
cpuPrvThreeOperandNor_loop:
	SRC		r6
	INC		r7
	RDM
	XCH		r0
	SRC		r4
	INC		r5
	RDM
	XCH		r1
	JMS		cpuPrvLutOrr
	CMA
	SRC		r2
	INC		r3
	WRM
	ISZ		r8, cpuPrvThreeOperandNor_loop
	JUN		cpuPrvVeneerReturn

cpuPrvNegate32:						;r6:r7 = ptr, r13 clobbered
	LDM		16 - 8
	XCH		r13
	CLC

cpuPrvNegate32_loop:
	SRC		r6
	INC		r7
	LDM		0
	SBM
	WRM
	CMC
	ISZ		r13, cpuPrvNegate32_loop
	BBL		0

cpuPrvMults:
	INC		r12						;so bottom bit will be zero
	FIM		r6, DCL1_TMP32B + 7
	SRC		r6
	RDM
	RAL
	JCN		NC, cpuPrvMults_opaNotNeg

cpuPrvMults_opaIsNeg:
	INC		r12						;flip whether we now need the result negated
	FIM		r6, DCL1_TMP32B
	JMS		cpuPrvNegate32

cpuPrvMults_opaNotNeg:
	FIM		r6, DCL1_TMP32A + 7
	SRC		r6
	RDM
	RAL
	JCN		NC, cpuPrvMultu

cpuPrvMults_opbIsNeg:
	INC		r12						;flip whether we now need the result negated
	FIM		r6, DCL1_TMP32A
	JMS		cpuPrvNegate32
	JUN		cpuPrvMultu


cpuPrvMultX:	;assumes operands are in DCL1_TMP32B and DCL1_TMP32A with DCL1 selected. r12 = "is signed"

	LD		r12
	JCN		NZ, cpuPrvMults

cpuPrvMultu:	;when we get here, r12's bottom bit = "please negate the result"

	;clear hi:lo
	FIM		r6, DCL1_LO
	LDM		0
cpuPrvMultu_clrDest:
	SRC		r6
	WRM
	ISZ		r7, cpuPrvMultu_clrDest

	FIM		r2, DCL1_TMP32B	+ 0		;r2:r3 = nibble we are multiplying all of the second number with
									;r6:r7 = number we're multying into (already is)

	LDM		8
	XCH		r15						;num iterations we'll do over the first number
	
	LD		r6						;r8:r9 = will be nibble we're multiplying into, as top nibble of the addr never changes, we copy it here
	XCH		r8
	
cpuPrvMultu_outer_loop:
	LD		r7
	XCH		r9
	INC		r7

	FIM		r4, DCL1_TMP32A			;r4:r5 = number we'll multiply by this nibble
	SRC		r2						;r14 = nibble from first number
	INC		r3
	RDM
	JCN		Z, cpuPrvMultu_outer_0	;skip if zero
	XCH		r14						;save the nibble
	LDM		0
	XCH		r13						;carry nibble so far

	LDM		16 - 8
	XCH		r11						;iterations over second number

cpuPrvMultu_inner_loop:
	SRC		r4
	INC		r5
	RDM
	JCN		Z, cpuPrvMultu_inner_0	;skip if zero

	XCH		r1
	LD		r14
	XCH		r0
	JMS		mul_4x4_do				;result is in r0, r1
	CLC								;add in nibble-carry
	LD		r13
	ADD		r1
	XCH		r1
	LDM		0
	ADD		r0						;guaranteed to NOT carry
	XCH		r0						;new nibble carry
	
cpuPrvMultu_inner_add_in:
	SRC		r8						;add in partial sum so far
	INC		r9
	RDM
	ADD		r1
	WRM
	LDM		0
	ADD		r0
	XCH		r13						;new nibble carry

	ISZ		r11, cpuPrvMultu_inner_loop

	;now propagate carry, if any and if there is space, for multu case specifically we know there is none past end of number so no need to check
	LD		r9
	JCN		Z, cpuPrvMultu_carry_propagate_done
	CLC
	SRC		r8
	RDM
	ADD		r13
	WRM
	JUN		cpuPrvMultu_carry_propagate_check

cpuPrvMultu_carry_propagate:
	SRC		r8
	LDM		0
	ADM
	WRM

cpuPrvMultu_carry_propagate_check:
	ISZ		r9, cpuPrvMultu_carry_propagate


cpuPrvMultu_outer_0:
cpuPrvMultu_carry_propagate_done:
	ISZ		r15, cpuPrvMultu_outer_loop


	;invert?
	LD		r12
	RAR
	JCN		NC, cpuPrvMults_done
	
cpuPrvMults_needInvert:
	
	FIM		r6, DCL1_LO
	CLC
cpuPrvMultsNegate64_loop:
	SRC		r6
	LDM		0
	SBM
	WRM
	CMC
	ISZ		r7, cpuPrvMultsNegate64_loop


cpuPrvMults_done:

	;r12 might be 4 now, but for return to work it must be under 4
	LDM		0
	XCH		r12

	JUN		cpuPrvVeneerReturn

cpuPrvMultu_inner_0:		;r0:r1 = r13, C=0
	LDM		0
	XCH		r0
	LD		r13
	XCH		r1
	CLC
	JUN		cpuPrvMultu_inner_add_in




;AND LUT
	org		0dffH
cpuPrvLutAnd:
	DB	031H		;JIN r0 that our assembler refuses to assemble when it is the last byte on a page
	BBL 000H ;0x0 & 0x0 = 0x00
	BBL 000H ;0x0 & 0x1 = 0x00
	BBL 000H ;0x0 & 0x2 = 0x00
	BBL 000H ;0x0 & 0x3 = 0x00
	BBL 000H ;0x0 & 0x4 = 0x00
	BBL 000H ;0x0 & 0x5 = 0x00
	BBL 000H ;0x0 & 0x6 = 0x00
	BBL 000H ;0x0 & 0x7 = 0x00
	BBL 000H ;0x0 & 0x8 = 0x00
	BBL 000H ;0x0 & 0x9 = 0x00
	BBL 000H ;0x0 & 0xA = 0x00
	BBL 000H ;0x0 & 0xB = 0x00
	BBL 000H ;0x0 & 0xC = 0x00
	BBL 000H ;0x0 & 0xD = 0x00
	BBL 000H ;0x0 & 0xE = 0x00
	BBL 000H ;0x0 & 0xF = 0x00
	BBL 000H ;0x1 & 0x0 = 0x00
	BBL 001H ;0x1 & 0x1 = 0x01
	BBL 000H ;0x1 & 0x2 = 0x00
	BBL 001H ;0x1 & 0x3 = 0x01
	BBL 000H ;0x1 & 0x4 = 0x00
	BBL 001H ;0x1 & 0x5 = 0x01
	BBL 000H ;0x1 & 0x6 = 0x00
	BBL 001H ;0x1 & 0x7 = 0x01
	BBL 000H ;0x1 & 0x8 = 0x00
	BBL 001H ;0x1 & 0x9 = 0x01
	BBL 000H ;0x1 & 0xA = 0x00
	BBL 001H ;0x1 & 0xB = 0x01
	BBL 000H ;0x1 & 0xC = 0x00
	BBL 001H ;0x1 & 0xD = 0x01
	BBL 000H ;0x1 & 0xE = 0x00
	BBL 001H ;0x1 & 0xF = 0x01
	BBL 000H ;0x2 & 0x0 = 0x00
	BBL 000H ;0x2 & 0x1 = 0x00
	BBL 002H ;0x2 & 0x2 = 0x02
	BBL 002H ;0x2 & 0x3 = 0x02
	BBL 000H ;0x2 & 0x4 = 0x00
	BBL 000H ;0x2 & 0x5 = 0x00
	BBL 002H ;0x2 & 0x6 = 0x02
	BBL 002H ;0x2 & 0x7 = 0x02
	BBL 000H ;0x2 & 0x8 = 0x00
	BBL 000H ;0x2 & 0x9 = 0x00
	BBL 002H ;0x2 & 0xA = 0x02
	BBL 002H ;0x2 & 0xB = 0x02
	BBL 000H ;0x2 & 0xC = 0x00
	BBL 000H ;0x2 & 0xD = 0x00
	BBL 002H ;0x2 & 0xE = 0x02
	BBL 002H ;0x2 & 0xF = 0x02
	BBL 000H ;0x3 & 0x0 = 0x00
	BBL 001H ;0x3 & 0x1 = 0x01
	BBL 002H ;0x3 & 0x2 = 0x02
	BBL 003H ;0x3 & 0x3 = 0x03
	BBL 000H ;0x3 & 0x4 = 0x00
	BBL 001H ;0x3 & 0x5 = 0x01
	BBL 002H ;0x3 & 0x6 = 0x02
	BBL 003H ;0x3 & 0x7 = 0x03
	BBL 000H ;0x3 & 0x8 = 0x00
	BBL 001H ;0x3 & 0x9 = 0x01
	BBL 002H ;0x3 & 0xA = 0x02
	BBL 003H ;0x3 & 0xB = 0x03
	BBL 000H ;0x3 & 0xC = 0x00
	BBL 001H ;0x3 & 0xD = 0x01
	BBL 002H ;0x3 & 0xE = 0x02
	BBL 003H ;0x3 & 0xF = 0x03
	BBL 000H ;0x4 & 0x0 = 0x00
	BBL 000H ;0x4 & 0x1 = 0x00
	BBL 000H ;0x4 & 0x2 = 0x00
	BBL 000H ;0x4 & 0x3 = 0x00
	BBL 004H ;0x4 & 0x4 = 0x04
	BBL 004H ;0x4 & 0x5 = 0x04
	BBL 004H ;0x4 & 0x6 = 0x04
	BBL 004H ;0x4 & 0x7 = 0x04
	BBL 000H ;0x4 & 0x8 = 0x00
	BBL 000H ;0x4 & 0x9 = 0x00
	BBL 000H ;0x4 & 0xA = 0x00
	BBL 000H ;0x4 & 0xB = 0x00
	BBL 004H ;0x4 & 0xC = 0x04
	BBL 004H ;0x4 & 0xD = 0x04
	BBL 004H ;0x4 & 0xE = 0x04
	BBL 004H ;0x4 & 0xF = 0x04
	BBL 000H ;0x5 & 0x0 = 0x00
	BBL 001H ;0x5 & 0x1 = 0x01
	BBL 000H ;0x5 & 0x2 = 0x00
	BBL 001H ;0x5 & 0x3 = 0x01
	BBL 004H ;0x5 & 0x4 = 0x04
	BBL 005H ;0x5 & 0x5 = 0x05
	BBL 004H ;0x5 & 0x6 = 0x04
	BBL 005H ;0x5 & 0x7 = 0x05
	BBL 000H ;0x5 & 0x8 = 0x00
	BBL 001H ;0x5 & 0x9 = 0x01
	BBL 000H ;0x5 & 0xA = 0x00
	BBL 001H ;0x5 & 0xB = 0x01
	BBL 004H ;0x5 & 0xC = 0x04
	BBL 005H ;0x5 & 0xD = 0x05
	BBL 004H ;0x5 & 0xE = 0x04
	BBL 005H ;0x5 & 0xF = 0x05
	BBL 000H ;0x6 & 0x0 = 0x00
	BBL 000H ;0x6 & 0x1 = 0x00
	BBL 002H ;0x6 & 0x2 = 0x02
	BBL 002H ;0x6 & 0x3 = 0x02
	BBL 004H ;0x6 & 0x4 = 0x04
	BBL 004H ;0x6 & 0x5 = 0x04
	BBL 006H ;0x6 & 0x6 = 0x06
	BBL 006H ;0x6 & 0x7 = 0x06
	BBL 000H ;0x6 & 0x8 = 0x00
	BBL 000H ;0x6 & 0x9 = 0x00
	BBL 002H ;0x6 & 0xA = 0x02
	BBL 002H ;0x6 & 0xB = 0x02
	BBL 004H ;0x6 & 0xC = 0x04
	BBL 004H ;0x6 & 0xD = 0x04
	BBL 006H ;0x6 & 0xE = 0x06
	BBL 006H ;0x6 & 0xF = 0x06
	BBL 000H ;0x7 & 0x0 = 0x00
	BBL 001H ;0x7 & 0x1 = 0x01
	BBL 002H ;0x7 & 0x2 = 0x02
	BBL 003H ;0x7 & 0x3 = 0x03
	BBL 004H ;0x7 & 0x4 = 0x04
	BBL 005H ;0x7 & 0x5 = 0x05
	BBL 006H ;0x7 & 0x6 = 0x06
	BBL 007H ;0x7 & 0x7 = 0x07
	BBL 000H ;0x7 & 0x8 = 0x00
	BBL 001H ;0x7 & 0x9 = 0x01
	BBL 002H ;0x7 & 0xA = 0x02
	BBL 003H ;0x7 & 0xB = 0x03
	BBL 004H ;0x7 & 0xC = 0x04
	BBL 005H ;0x7 & 0xD = 0x05
	BBL 006H ;0x7 & 0xE = 0x06
	BBL 007H ;0x7 & 0xF = 0x07
	BBL 000H ;0x8 & 0x0 = 0x00
	BBL 000H ;0x8 & 0x1 = 0x00
	BBL 000H ;0x8 & 0x2 = 0x00
	BBL 000H ;0x8 & 0x3 = 0x00
	BBL 000H ;0x8 & 0x4 = 0x00
	BBL 000H ;0x8 & 0x5 = 0x00
	BBL 000H ;0x8 & 0x6 = 0x00
	BBL 000H ;0x8 & 0x7 = 0x00
	BBL 008H ;0x8 & 0x8 = 0x08
	BBL 008H ;0x8 & 0x9 = 0x08
	BBL 008H ;0x8 & 0xA = 0x08
	BBL 008H ;0x8 & 0xB = 0x08
	BBL 008H ;0x8 & 0xC = 0x08
	BBL 008H ;0x8 & 0xD = 0x08
	BBL 008H ;0x8 & 0xE = 0x08
	BBL 008H ;0x8 & 0xF = 0x08
	BBL 000H ;0x9 & 0x0 = 0x00
	BBL 001H ;0x9 & 0x1 = 0x01
	BBL 000H ;0x9 & 0x2 = 0x00
	BBL 001H ;0x9 & 0x3 = 0x01
	BBL 000H ;0x9 & 0x4 = 0x00
	BBL 001H ;0x9 & 0x5 = 0x01
	BBL 000H ;0x9 & 0x6 = 0x00
	BBL 001H ;0x9 & 0x7 = 0x01
	BBL 008H ;0x9 & 0x8 = 0x08
	BBL 009H ;0x9 & 0x9 = 0x09
	BBL 008H ;0x9 & 0xA = 0x08
	BBL 009H ;0x9 & 0xB = 0x09
	BBL 008H ;0x9 & 0xC = 0x08
	BBL 009H ;0x9 & 0xD = 0x09
	BBL 008H ;0x9 & 0xE = 0x08
	BBL 009H ;0x9 & 0xF = 0x09
	BBL 000H ;0xA & 0x0 = 0x00
	BBL 000H ;0xA & 0x1 = 0x00
	BBL 002H ;0xA & 0x2 = 0x02
	BBL 002H ;0xA & 0x3 = 0x02
	BBL 000H ;0xA & 0x4 = 0x00
	BBL 000H ;0xA & 0x5 = 0x00
	BBL 002H ;0xA & 0x6 = 0x02
	BBL 002H ;0xA & 0x7 = 0x02
	BBL 008H ;0xA & 0x8 = 0x08
	BBL 008H ;0xA & 0x9 = 0x08
	BBL 00AH ;0xA & 0xA = 0x0A
	BBL 00AH ;0xA & 0xB = 0x0A
	BBL 008H ;0xA & 0xC = 0x08
	BBL 008H ;0xA & 0xD = 0x08
	BBL 00AH ;0xA & 0xE = 0x0A
	BBL 00AH ;0xA & 0xF = 0x0A
	BBL 000H ;0xB & 0x0 = 0x00
	BBL 001H ;0xB & 0x1 = 0x01
	BBL 002H ;0xB & 0x2 = 0x02
	BBL 003H ;0xB & 0x3 = 0x03
	BBL 000H ;0xB & 0x4 = 0x00
	BBL 001H ;0xB & 0x5 = 0x01
	BBL 002H ;0xB & 0x6 = 0x02
	BBL 003H ;0xB & 0x7 = 0x03
	BBL 008H ;0xB & 0x8 = 0x08
	BBL 009H ;0xB & 0x9 = 0x09
	BBL 00AH ;0xB & 0xA = 0x0A
	BBL 00BH ;0xB & 0xB = 0x0B
	BBL 008H ;0xB & 0xC = 0x08
	BBL 009H ;0xB & 0xD = 0x09
	BBL 00AH ;0xB & 0xE = 0x0A
	BBL 00BH ;0xB & 0xF = 0x0B
	BBL 000H ;0xC & 0x0 = 0x00
	BBL 000H ;0xC & 0x1 = 0x00
	BBL 000H ;0xC & 0x2 = 0x00
	BBL 000H ;0xC & 0x3 = 0x00
	BBL 004H ;0xC & 0x4 = 0x04
	BBL 004H ;0xC & 0x5 = 0x04
	BBL 004H ;0xC & 0x6 = 0x04
	BBL 004H ;0xC & 0x7 = 0x04
	BBL 008H ;0xC & 0x8 = 0x08
	BBL 008H ;0xC & 0x9 = 0x08
	BBL 008H ;0xC & 0xA = 0x08
	BBL 008H ;0xC & 0xB = 0x08
	BBL 00CH ;0xC & 0xC = 0x0C
	BBL 00CH ;0xC & 0xD = 0x0C
	BBL 00CH ;0xC & 0xE = 0x0C
	BBL 00CH ;0xC & 0xF = 0x0C
	BBL 000H ;0xD & 0x0 = 0x00
	BBL 001H ;0xD & 0x1 = 0x01
	BBL 000H ;0xD & 0x2 = 0x00
	BBL 001H ;0xD & 0x3 = 0x01
	BBL 004H ;0xD & 0x4 = 0x04
	BBL 005H ;0xD & 0x5 = 0x05
	BBL 004H ;0xD & 0x6 = 0x04
	BBL 005H ;0xD & 0x7 = 0x05
	BBL 008H ;0xD & 0x8 = 0x08
	BBL 009H ;0xD & 0x9 = 0x09
	BBL 008H ;0xD & 0xA = 0x08
	BBL 009H ;0xD & 0xB = 0x09
	BBL 00CH ;0xD & 0xC = 0x0C
	BBL 00DH ;0xD & 0xD = 0x0D
	BBL 00CH ;0xD & 0xE = 0x0C
	BBL 00DH ;0xD & 0xF = 0x0D
	BBL 000H ;0xE & 0x0 = 0x00
	BBL 000H ;0xE & 0x1 = 0x00
	BBL 002H ;0xE & 0x2 = 0x02
	BBL 002H ;0xE & 0x3 = 0x02
	BBL 004H ;0xE & 0x4 = 0x04
	BBL 004H ;0xE & 0x5 = 0x04
	BBL 006H ;0xE & 0x6 = 0x06
	BBL 006H ;0xE & 0x7 = 0x06
	BBL 008H ;0xE & 0x8 = 0x08
	BBL 008H ;0xE & 0x9 = 0x08
	BBL 00AH ;0xE & 0xA = 0x0A
	BBL 00AH ;0xE & 0xB = 0x0A
	BBL 00CH ;0xE & 0xC = 0x0C
	BBL 00CH ;0xE & 0xD = 0x0C
	BBL 00EH ;0xE & 0xE = 0x0E
	BBL 00EH ;0xE & 0xF = 0x0E
	BBL 000H ;0xF & 0x0 = 0x00
	BBL 001H ;0xF & 0x1 = 0x01
	BBL 002H ;0xF & 0x2 = 0x02
	BBL 003H ;0xF & 0x3 = 0x03
	BBL 004H ;0xF & 0x4 = 0x04
	BBL 005H ;0xF & 0x5 = 0x05
	BBL 006H ;0xF & 0x6 = 0x06
	BBL 007H ;0xF & 0x7 = 0x07
	BBL 008H ;0xF & 0x8 = 0x08
	BBL 009H ;0xF & 0x9 = 0x09
	BBL 00AH ;0xF & 0xA = 0x0A
	BBL 00BH ;0xF & 0xB = 0x0B
	BBL 00CH ;0xF & 0xC = 0x0C
	BBL 00DH ;0xF & 0xD = 0x0D
	BBL 00EH ;0xF & 0xE = 0x0E
	BBL 00FH ;0xF & 0xF = 0x0F



;4x4->8 MUL
	org		0f00H

mul_4x4_do:			;assumes r0 != 0!!!!!
	FIN		r0
	BBL		0

	org		0f10H
	DB 000H ;0x1 * 0x0 = 0x00
	DB 001H ;0x1 * 0x1 = 0x01
	DB 002H ;0x1 * 0x2 = 0x02
	DB 003H ;0x1 * 0x3 = 0x03
	DB 004H ;0x1 * 0x4 = 0x04
	DB 005H ;0x1 * 0x5 = 0x05
	DB 006H ;0x1 * 0x6 = 0x06
	DB 007H ;0x1 * 0x7 = 0x07
	DB 008H ;0x1 * 0x8 = 0x08
	DB 009H ;0x1 * 0x9 = 0x09
	DB 00AH ;0x1 * 0xA = 0x0A
	DB 00BH ;0x1 * 0xB = 0x0B
	DB 00CH ;0x1 * 0xC = 0x0C
	DB 00DH ;0x1 * 0xD = 0x0D
	DB 00EH ;0x1 * 0xE = 0x0E
	DB 00FH ;0x1 * 0xF = 0x0F
	DB 000H ;0x2 * 0x0 = 0x00
	DB 002H ;0x2 * 0x1 = 0x02
	DB 004H ;0x2 * 0x2 = 0x04
	DB 006H ;0x2 * 0x3 = 0x06
	DB 008H ;0x2 * 0x4 = 0x08
	DB 00AH ;0x2 * 0x5 = 0x0A
	DB 00CH ;0x2 * 0x6 = 0x0C
	DB 00EH ;0x2 * 0x7 = 0x0E
	DB 010H ;0x2 * 0x8 = 0x10
	DB 012H ;0x2 * 0x9 = 0x12
	DB 014H ;0x2 * 0xA = 0x14
	DB 016H ;0x2 * 0xB = 0x16
	DB 018H ;0x2 * 0xC = 0x18
	DB 01AH ;0x2 * 0xD = 0x1A
	DB 01CH ;0x2 * 0xE = 0x1C
	DB 01EH ;0x2 * 0xF = 0x1E
	DB 000H ;0x3 * 0x0 = 0x00
	DB 003H ;0x3 * 0x1 = 0x03
	DB 006H ;0x3 * 0x2 = 0x06
	DB 009H ;0x3 * 0x3 = 0x09
	DB 00CH ;0x3 * 0x4 = 0x0C
	DB 00FH ;0x3 * 0x5 = 0x0F
	DB 012H ;0x3 * 0x6 = 0x12
	DB 015H ;0x3 * 0x7 = 0x15
	DB 018H ;0x3 * 0x8 = 0x18
	DB 01BH ;0x3 * 0x9 = 0x1B
	DB 01EH ;0x3 * 0xA = 0x1E
	DB 021H ;0x3 * 0xB = 0x21
	DB 024H ;0x3 * 0xC = 0x24
	DB 027H ;0x3 * 0xD = 0x27
	DB 02AH ;0x3 * 0xE = 0x2A
	DB 02DH ;0x3 * 0xF = 0x2D
	DB 000H ;0x4 * 0x0 = 0x00
	DB 004H ;0x4 * 0x1 = 0x04
	DB 008H ;0x4 * 0x2 = 0x08
	DB 00CH ;0x4 * 0x3 = 0x0C
	DB 010H ;0x4 * 0x4 = 0x10
	DB 014H ;0x4 * 0x5 = 0x14
	DB 018H ;0x4 * 0x6 = 0x18
	DB 01CH ;0x4 * 0x7 = 0x1C
	DB 020H ;0x4 * 0x8 = 0x20
	DB 024H ;0x4 * 0x9 = 0x24
	DB 028H ;0x4 * 0xA = 0x28
	DB 02CH ;0x4 * 0xB = 0x2C
	DB 030H ;0x4 * 0xC = 0x30
	DB 034H ;0x4 * 0xD = 0x34
	DB 038H ;0x4 * 0xE = 0x38
	DB 03CH ;0x4 * 0xF = 0x3C
	DB 000H ;0x5 * 0x0 = 0x00
	DB 005H ;0x5 * 0x1 = 0x05
	DB 00AH ;0x5 * 0x2 = 0x0A
	DB 00FH ;0x5 * 0x3 = 0x0F
	DB 014H ;0x5 * 0x4 = 0x14
	DB 019H ;0x5 * 0x5 = 0x19
	DB 01EH ;0x5 * 0x6 = 0x1E
	DB 023H ;0x5 * 0x7 = 0x23
	DB 028H ;0x5 * 0x8 = 0x28
	DB 02DH ;0x5 * 0x9 = 0x2D
	DB 032H ;0x5 * 0xA = 0x32
	DB 037H ;0x5 * 0xB = 0x37
	DB 03CH ;0x5 * 0xC = 0x3C
	DB 041H ;0x5 * 0xD = 0x41
	DB 046H ;0x5 * 0xE = 0x46
	DB 04BH ;0x5 * 0xF = 0x4B
	DB 000H ;0x6 * 0x0 = 0x00
	DB 006H ;0x6 * 0x1 = 0x06
	DB 00CH ;0x6 * 0x2 = 0x0C
	DB 012H ;0x6 * 0x3 = 0x12
	DB 018H ;0x6 * 0x4 = 0x18
	DB 01EH ;0x6 * 0x5 = 0x1E
	DB 024H ;0x6 * 0x6 = 0x24
	DB 02AH ;0x6 * 0x7 = 0x2A
	DB 030H ;0x6 * 0x8 = 0x30
	DB 036H ;0x6 * 0x9 = 0x36
	DB 03CH ;0x6 * 0xA = 0x3C
	DB 042H ;0x6 * 0xB = 0x42
	DB 048H ;0x6 * 0xC = 0x48
	DB 04EH ;0x6 * 0xD = 0x4E
	DB 054H ;0x6 * 0xE = 0x54
	DB 05AH ;0x6 * 0xF = 0x5A
	DB 000H ;0x7 * 0x0 = 0x00
	DB 007H ;0x7 * 0x1 = 0x07
	DB 00EH ;0x7 * 0x2 = 0x0E
	DB 015H ;0x7 * 0x3 = 0x15
	DB 01CH ;0x7 * 0x4 = 0x1C
	DB 023H ;0x7 * 0x5 = 0x23
	DB 02AH ;0x7 * 0x6 = 0x2A
	DB 031H ;0x7 * 0x7 = 0x31
	DB 038H ;0x7 * 0x8 = 0x38
	DB 03FH ;0x7 * 0x9 = 0x3F
	DB 046H ;0x7 * 0xA = 0x46
	DB 04DH ;0x7 * 0xB = 0x4D
	DB 054H ;0x7 * 0xC = 0x54
	DB 05BH ;0x7 * 0xD = 0x5B
	DB 062H ;0x7 * 0xE = 0x62
	DB 069H ;0x7 * 0xF = 0x69
	DB 000H ;0x8 * 0x0 = 0x00
	DB 008H ;0x8 * 0x1 = 0x08
	DB 010H ;0x8 * 0x2 = 0x10
	DB 018H ;0x8 * 0x3 = 0x18
	DB 020H ;0x8 * 0x4 = 0x20
	DB 028H ;0x8 * 0x5 = 0x28
	DB 030H ;0x8 * 0x6 = 0x30
	DB 038H ;0x8 * 0x7 = 0x38
	DB 040H ;0x8 * 0x8 = 0x40
	DB 048H ;0x8 * 0x9 = 0x48
	DB 050H ;0x8 * 0xA = 0x50
	DB 058H ;0x8 * 0xB = 0x58
	DB 060H ;0x8 * 0xC = 0x60
	DB 068H ;0x8 * 0xD = 0x68
	DB 070H ;0x8 * 0xE = 0x70
	DB 078H ;0x8 * 0xF = 0x78
	DB 000H ;0x9 * 0x0 = 0x00
	DB 009H ;0x9 * 0x1 = 0x09
	DB 012H ;0x9 * 0x2 = 0x12
	DB 01BH ;0x9 * 0x3 = 0x1B
	DB 024H ;0x9 * 0x4 = 0x24
	DB 02DH ;0x9 * 0x5 = 0x2D
	DB 036H ;0x9 * 0x6 = 0x36
	DB 03FH ;0x9 * 0x7 = 0x3F
	DB 048H ;0x9 * 0x8 = 0x48
	DB 051H ;0x9 * 0x9 = 0x51
	DB 05AH ;0x9 * 0xA = 0x5A
	DB 063H ;0x9 * 0xB = 0x63
	DB 06CH ;0x9 * 0xC = 0x6C
	DB 075H ;0x9 * 0xD = 0x75
	DB 07EH ;0x9 * 0xE = 0x7E
	DB 087H ;0x9 * 0xF = 0x87
	DB 000H ;0xA * 0x0 = 0x00
	DB 00AH ;0xA * 0x1 = 0x0A
	DB 014H ;0xA * 0x2 = 0x14
	DB 01EH ;0xA * 0x3 = 0x1E
	DB 028H ;0xA * 0x4 = 0x28
	DB 032H ;0xA * 0x5 = 0x32
	DB 03CH ;0xA * 0x6 = 0x3C
	DB 046H ;0xA * 0x7 = 0x46
	DB 050H ;0xA * 0x8 = 0x50
	DB 05AH ;0xA * 0x9 = 0x5A
	DB 064H ;0xA * 0xA = 0x64
	DB 06EH ;0xA * 0xB = 0x6E
	DB 078H ;0xA * 0xC = 0x78
	DB 082H ;0xA * 0xD = 0x82
	DB 08CH ;0xA * 0xE = 0x8C
	DB 096H ;0xA * 0xF = 0x96
	DB 000H ;0xB * 0x0 = 0x00
	DB 00BH ;0xB * 0x1 = 0x0B
	DB 016H ;0xB * 0x2 = 0x16
	DB 021H ;0xB * 0x3 = 0x21
	DB 02CH ;0xB * 0x4 = 0x2C
	DB 037H ;0xB * 0x5 = 0x37
	DB 042H ;0xB * 0x6 = 0x42
	DB 04DH ;0xB * 0x7 = 0x4D
	DB 058H ;0xB * 0x8 = 0x58
	DB 063H ;0xB * 0x9 = 0x63
	DB 06EH ;0xB * 0xA = 0x6E
	DB 079H ;0xB * 0xB = 0x79
	DB 084H ;0xB * 0xC = 0x84
	DB 08FH ;0xB * 0xD = 0x8F
	DB 09AH ;0xB * 0xE = 0x9A
	DB 0A5H ;0xB * 0xF = 0xA5
	DB 000H ;0xC * 0x0 = 0x00
	DB 00CH ;0xC * 0x1 = 0x0C
	DB 018H ;0xC * 0x2 = 0x18
	DB 024H ;0xC * 0x3 = 0x24
	DB 030H ;0xC * 0x4 = 0x30
	DB 03CH ;0xC * 0x5 = 0x3C
	DB 048H ;0xC * 0x6 = 0x48
	DB 054H ;0xC * 0x7 = 0x54
	DB 060H ;0xC * 0x8 = 0x60
	DB 06CH ;0xC * 0x9 = 0x6C
	DB 078H ;0xC * 0xA = 0x78
	DB 084H ;0xC * 0xB = 0x84
	DB 090H ;0xC * 0xC = 0x90
	DB 09CH ;0xC * 0xD = 0x9C
	DB 0A8H ;0xC * 0xE = 0xA8
	DB 0B4H ;0xC * 0xF = 0xB4
	DB 000H ;0xD * 0x0 = 0x00
	DB 00DH ;0xD * 0x1 = 0x0D
	DB 01AH ;0xD * 0x2 = 0x1A
	DB 027H ;0xD * 0x3 = 0x27
	DB 034H ;0xD * 0x4 = 0x34
	DB 041H ;0xD * 0x5 = 0x41
	DB 04EH ;0xD * 0x6 = 0x4E
	DB 05BH ;0xD * 0x7 = 0x5B
	DB 068H ;0xD * 0x8 = 0x68
	DB 075H ;0xD * 0x9 = 0x75
	DB 082H ;0xD * 0xA = 0x82
	DB 08FH ;0xD * 0xB = 0x8F
	DB 09CH ;0xD * 0xC = 0x9C
	DB 0A9H ;0xD * 0xD = 0xA9
	DB 0B6H ;0xD * 0xE = 0xB6
	DB 0C3H ;0xD * 0xF = 0xC3
	DB 000H ;0xE * 0x0 = 0x00
	DB 00EH ;0xE * 0x1 = 0x0E
	DB 01CH ;0xE * 0x2 = 0x1C
	DB 02AH ;0xE * 0x3 = 0x2A
	DB 038H ;0xE * 0x4 = 0x38
	DB 046H ;0xE * 0x5 = 0x46
	DB 054H ;0xE * 0x6 = 0x54
	DB 062H ;0xE * 0x7 = 0x62
	DB 070H ;0xE * 0x8 = 0x70
	DB 07EH ;0xE * 0x9 = 0x7E
	DB 08CH ;0xE * 0xA = 0x8C
	DB 09AH ;0xE * 0xB = 0x9A
	DB 0A8H ;0xE * 0xC = 0xA8
	DB 0B6H ;0xE * 0xD = 0xB6
	DB 0C4H ;0xE * 0xE = 0xC4
	DB 0D2H ;0xE * 0xF = 0xD2
	DB 000H ;0xF * 0x0 = 0x00
	DB 00FH ;0xF * 0x1 = 0x0F
	DB 01EH ;0xF * 0x2 = 0x1E
	DB 02DH ;0xF * 0x3 = 0x2D
	DB 03CH ;0xF * 0x4 = 0x3C
	DB 04BH ;0xF * 0x5 = 0x4B
	DB 05AH ;0xF * 0x6 = 0x5A
	DB 069H ;0xF * 0x7 = 0x69
	DB 078H ;0xF * 0x8 = 0x78
	DB 087H ;0xF * 0x9 = 0x87
	DB 096H ;0xF * 0xA = 0x96
	DB 0A5H ;0xF * 0xB = 0xA5
	DB 0B4H ;0xF * 0xC = 0xB4
	DB 0C3H ;0xF * 0xD = 0xC3
	DB 0D2H ;0xF * 0xE = 0xD2
	DB 0E1H ;0xF * 0xF = 0xE1


	END









