/*
 (c) 2014 Dmitry Grinberg - http://dmitry.gr - me@dmitry.gr
  Free for non-commercial use only
*/

#ifndef _UFAT_H_
#define _UFAT_H_

#include <stdint.h>
#include "bool.h"



#define UFAT_DISK_SECTOR_SZ		512

#define UFAT_FLAG_READONLY		1
#define UFAT_FLAG_HIDDEN		2
#define UFAT_FLAG_SYSTEM		4
#define UFAT_FLAG_DIR			16
#define UFAT_FLAG_ARCHIVE		32

//externally required function(s)
Boolean ufatExtRead(uint32_t sector, uint16_t offset, uint8_t len, uint8_t* buf);

void ufatInit(void);										//init fs driver
Boolean ufatMount(void);									//try mounting a volume
Boolean ufatGetNthFile(uint16_t n, char* name, uint32_t* sz, uint8_t* flags, uint16_t* id);	//in root directory only, false for no more
Boolean ufatOpen(uint16_t id);									//in root directory only
Boolean ufatGetNextSectorRange(uint32_t* first, uint32_t* len);					//for currently opened file, false for "no more"

#endif
