
###### parsing code

def sql2arr(line)		#grad the values being inserted into the table

	#remove start crap
	
	if !line.gsub!(/INSERT\ INTO\ \"[^"]*\"\ VALUES\(/,"") then
		abort "LINE does not start: [[[[#{line}]]]]\n"
	end
	
	
	#remove end crap and append final comma
	
	endi = line.rindex ");"
	
	if !endi || endi == 0 then
		abort "LINE does not end: [[[[#{line}]]]]\n"
	end
	
	line = line[0..endi - 1] + ","
	
	
	#split into pieces
	
	items = []
	
	line.gsub /([^,']|('([^']|'')*'))*,/ do |v|		#it is my belief that this will handle all the possible cases of sqlite3 values
		
		items << v[0..-2]
	end
	
	return items
end

def val2int(val)
	
	if val == "NULL" then
		
		return nil	# a null is not a number
		
	elsif val[0..0] == "'" then
		
		return nil	#a string is not a number
		
	elsif val[0..1] == "X'" then
		
		return nil	#a blob is not a number
		
	else
		
		return val.to_i
	end
end

def val2str(val)
	
	if val[0..0] != "'" || val[-1..-1] != "'" then
		
		return nil	#no start/end markers -> not a string
		
	else
		
		return val[1..-2]
	end
end

def val2blob(val)
	
	if val[0..1] != "X'" || val[-1..-1] != "'" then
		
		return nil	#no start/end markers -> not a blob
		
	else
		
		return val[2..-2]
	end
end


def parseMsg(line)
	
	#INSERT INTO "message" VALUES(2,'+12246286094',1191193557,'If you ...-dima',3,0,NULL,2,0,0,4,0,NULL,'us',NULL,NULL,1);

	
	items = sql2arr line
	
	msg = {}
	
	msg[:ROWID] = val2int items[0]
	msg[:address] = val2str items[1]
	msg[:time] = val2int items[2]
	msg[:body] = val2str items[3]
	direction = val2int items[4]
	msg[:group] = val2int items[7]
	msg[:subj] = val2str items[12]
	
	
	if (direction & 1) ==  1 then
		
		msg[:direction] = "out"
		
	else
		msg[:direction] = "in"
	end
	
	return msg
end

def parsePiece(line)
	
	items = sql2arr line
	
	piece = {}
	
	piece[:ROWID] = val2int items[0]
	piece[:msg_id] = val2int items[1]
	piece[:data] = val2blob items[2]
	piece[:idx] = val2int items[3]
	piece[:mime] = val2str items[5]
	piece[:name] = val2str items[10]
	
	return piece
end

def parseMember(line)
	
	items = sql2arr line
	
	member = {}
	
	member[:ROWID] = val2int items[0]
	member[:group] = val2int items[1]
	member[:address] = val2str items[2]
	
	return member
end

def parseGroup(line, maxGroupID)
	
	items = sql2arr line
	
	id = val2int items[0]
	
	if id > maxGroupID then
		
		maxGroupID = id
	end
	
	return maxGroupID
end

def parseSQL(lines)

	messages = []
	pieces = []
	members = []
	maxGroupID = 0
	
	lines.each_index do |i|
	
		l = lines[i]
		s = l.split
		
		if s[0] == "INSERT" then	#an insert - what we need
			
			if s[2] == '"message"' then
				
				messages << parseMsg(l)
				
			elsif s[2] =='"msg_pieces"' then
				
				pieces << parsePiece(l)
			
			elsif s[2] =='"group_member"' then
				
				members << parseMember(l)
			
			elsif s[2] == '"msg_group"' then
				
				maxGroupID = parseGroup(l, maxGroupID)
			
			elsif s[2] == '"_SqliteDatabaseProperties"' then
				
				# nothing to do for the db properties table
			
			elsif s[2] == '"sqlite_sequence"' then
				
				# nothing to do for the db sequence table
			
			else
				
				abort "strange table: #{s[2]}\n"
			end
		end
	end
	
	return [messages, pieces, members, maxGroupID]
end

def reassembleMmsPieces(messages, pieces)
	
	messages.map! do |m|
		
		if !m[:body] then
			
			m[:files] = []
			
			pieces.each_index do |i|
				
				p = pieces[i]
				
				if p[:msg_id] == m[:ROWID] then
					
					m[:files] << p
				end
			end
		end
		
		m
	end
	
	return messages
end

def expandGroups(messages, members, maxGroupID)

	members.sort {|a, b| a[:group] <=> b[:group]}	#sort members by groups they belong to

	i = 1;
	
	while i < members.length
		
		if members[i][:group] == members[i - 1][:group] then
			
			new_messages = []
			
			#find all messages whose address is in members[i][:address] and give them a new group
			messages.each do |m|
				
				if m[:group] == members[i][:group] then
					
					m[:address] = members[i - 1][:address]
					new_messages << m
					m[:address] = members[i][:address]
					m[:group] = maxGroupID
					members << {:ROWID=>"dont care", :group=>maxGroupID, :address=>members[i][:address]}
					maxGroupID = maxGroupID + 1
				end
				
				new_messages << m
			end
			
			messages = new_messages
			members = members - [members[i]]
		else
			
			i = i + 1
		end
	end
	
	#set addresses to all messages that do not have it
	
	messages.map! do |m|
		
		if !m[:address] then
			
			members.each do |gm|
				
				if gm[:group] == m[:group] then
				
					m[:address] = gm[:address]
				end
			end
		end
		
		m
	end

	return messages
end

def normalizeAddresses(messages)
	
	messages.map do |m|
		
		if m[:address].include? "@" then
			
			#nothing?
		else
			
			m[:address] = m[:address].gsub(" ","").gsub("(","").gsub(")","").gsub("-","")
		end
		
		m
	end
	
end

###### export code

def str2hex(str)
	
	if !str
		abort "bad str"
	end
	
	ret = ""
	
	str.each_byte do |b|
		
		cc = b.to_s(16).upcase
		if cc.length == 1 then
			cc = "0" + cc
		elsif cc.length >2 then
			abort "char too long"
		end
		
		ret = ret + cc
	end
	
	return ret
end

def writeXML(messages)
	
	print "<messages>\n"
	
	messages.each do |m|
		
		print "\t<item type=\"#{if m[:files] then "mms" else "sms" end}\" address=\"#{m[:address]}\" time=\"#{m[:time]}\" direction=\"#{m[:direction]}\" "
		
		if m[:files] then
		
			if !m[:subj] then
				
				m[:subj] = "--"
			end
			
			print "subject=\"#{str2hex m[:subj]}\">\n"
			
			m[:files].each do |f|
				
				if f[:mime] && f[:mime] != "" && !f[:data] then
					
					path = "iPhone/Parts/#{m[:ROWID]}.jpg"
					
					if File.exist?(path) && (f[:mime] == "image/jpeg" || f[:mime] == "image/jpg") then
						
						$stderr.print "\tImporting #{path}..."
						f[:data] = str2hex open(path, "rb") {|io| io.read }
						$stderr.print "done\n"
						
					else
						
						f[:mime] = nil		#makes sure file is not written out
					end
				end
				
				if f[:mime] && f[:mime]!="" && f[:mime]!="application/smil" then
					
					print "\t\t<file name=\"#{f[:name]}\" mime=\"#{f[:mime]}\" data=\"#{f[:data]}\" />\n"
				end
			end
			
			print "\t</item>\n"
			
		else
			print "body=\"#{str2hex m[:body]}\"/>\n"
		end
	end
	
	print "</messages>"
end

###### main code

lines = []
numLines = 0

$stderr.puts "Reading...\n"


while l = gets() do
	
	if l[0..17] == "BEGIN TRANSACTION;" then
		
		#nothing to do on transaction operation
		
	elsif l[0..12] == "CREATE TABLE " then
		
		#nothing to do on table creation
		
	elsif l[0..11] == "DELETE FROM " then
		
		#nothing to do on item deletion
		
	elsif l[0..12] == "CREATE INDEX " then
		
		#nothing to do on index creation
		
	elsif l[0..14] == "CREATE TRIGGER " then
		
		#nothing to do on trigger creation
		
	elsif l[0..12] == "INSERT INTO \"" then
		
		lines << l
		
	else
		lines[lines.length - 1] << l
	end
	numLines = numLines + 1
end

$stderr.puts "\t#{numLines} lines read\n"

$stderr.puts "Processing...\n"

$stderr.puts "\tParsing SQL...\n"
messages, pieces, members, maxGroupID = parseSQL(lines)

$stderr.puts "\tReassembling MMS pieces...\n"
messages = reassembleMmsPieces(messages, pieces)

$stderr.puts "\tExpanding groups...\n"
messages = expandGroups(messages, members, maxGroupID)

$stderr.puts "\tNormalizing addresses...\n"
messages = normalizeAddresses(messages)

$stderr.puts "Writing output...\n"
writeXML(messages)