/* 	Option.c, Option setting menu  */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "lcars24.h"
#include "option.h"

void BuildAlarmString()
{
	int l_holder, r_holder;
	int hour;

	hour=AlarmHour;

	if(MilitaryTime==0) t=32;
		else t=0;
	AlarmString[5]=(t);

	if(AlarmHour > 11 )	{
		t=80;
		AlarmString[6]=(t);
	}
	if(AlarmHour < 12  ) {
		t=65;
		AlarmString[6]=(t);
	}
	if(MilitaryTime==0) {
		if(AlarmHour > 12) hour -= 12;
		if(AlarmHour==0) hour=12;

	}

	l_holder=hour / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	AlarmString[0]=(t);

	r_holder=hour - (l_holder * 10);
	t=r_holder + 48;
	AlarmString[1]=(t);

	l_holder=AlarmMin / 10;
	t=l_holder + 48;
	AlarmString[3]=(t);

	r_holder=AlarmMin - (l_holder * 10);
	t=r_holder + 48;
	AlarmString[4]=(t);
}
void OkPrompt(int x)
{
	ButtonType3Short(x+120, 569-(1*47)+14, ORANGE, LILAC, "CANCEL");
	EscSymbol(x+237, 569-(1*47)+14,2, NAPLES);
	ButtonType3(x+373, 536, ORANGE, LILAC, "CHANGES OK");
	EnterSymbol(x+373+118, 536, 2, NAPLES);
}
void OptionMenu(char TempEndgame,int x)  /* display user options and their current settings */
{
	rectfill(screen,0,0,800,600,BLACK);
	rectfill(screen,10, 569-(12*47)+14, x+287, 569-(12*47)+50, NAPLES);
	PutsLuna(x+283-StrLenLuna("SETTING OPTIONS"),569-(12*47)+32,BLACK,NAPLES,"SETTING OPTIONS");

	rectfill(screen,x+373,569-(12*47)+14,x+500,569-(12*47)+50, NAPLES);
	PutsLuna(x+377,569-(12*47)+32,BLACK,NAPLES,"SELECTED");

	rectfill(screen,665,569-(12*47)+14,x+632,569-(12*47)+50, NAPLES);
	PutsLuna(669,569-(12*47)+32,BLACK,NAPLES,"REGISTERED");

/* panel beeps & voice muting */
	rectfill(screen,10, 569-(11*47)+14, x+112-36, 569-(11*47)+51, MANGO);
	RightBumper36(x+112-36,569-(11*47)+14,MANGO);
	PutsLuna(14,569-(11*47)+33,BLACK,MANGO,"BEEPS & VOICE: MUTE/ENABLE");

	rectfill(screen,665,569-(11*47)+14,x+632,569-(11*47)+51, MANGO);
	if(MuteBeeps==FALSE) {
		PutsLuna(669,569-(11*47)+33,BLACK,MANGO,"BEEPS, VOICE ENABLED");
	} else {
		PutsLuna(669,569-(11*47)+33,BLACK,MANGO,"BEEPS, VOICE MUTED");
	}

/* alarm */
	rectfill(screen,10, 569-(10*47)+14, x+112-36, 569-(10*47)+51, SEABLUE);
	RightBumper36(x+112-36,569-(10*47)+14,SEABLUE);
	PutsLuna(15,569-(10*47)+33,BLACK,SEABLUE,"ALARM TYPE: MIDI/MP3/VOICE");

	rectfill(screen,665,569-(9*47)+14,x+632,569-(9*47)+51, SEABLUE);
	if(AlarmType==0) { /* 0 = MIDI */
		PutsLuna(669,569-(9*47)+33,BLACK,SEABLUE,"MIDI ALARM");
	}
	if(AlarmType==1) { /* 1 = MP3 */
		PutsLuna(669,569-(9*47)+33,BLACK,SEABLUE,"MP3 ALARM");
	}
	if(AlarmType==2) { /* 2 = voice */
		PutsLuna(669,569-(9*47)+33,BLACK,SEABLUE,"VOICE ALARM");
	}

/* all audio */
	rectfill(screen,10, 569-(8*47)+14, x+112-36, 569-(8*47)+51, SKYBLUE);
	RightBumper36(x+112-36,569-(8*47)+14,SKYBLUE);
	PutsLuna(15,569-(8*47)+33,BLACK,SKYBLUE,"AUDIO OUTPUT: MUTE/ENABLE");
	rectfill(screen,665,569-(8*47)+14,x+632,569-(8*47)+51, MANGO);
	if(AudioOff==FALSE) {
		PutsLuna(669,569-(8*47)+33,BLACK,MANGO,"AUDIO ENABLED");
	} else {
		PutsLuna(669,569-(8*47)+33,BLACK,MANGO,"AUTIO MUTED");
	}

/* scheme */
	rectfill(screen,10, 569-(6*47)+14, x+112-36, 569-(6*47)+51, SEABLUE);
	RightBumper36(x+112-36,569-(6*47)+14,SEABLUE);
	PutsLuna(15,569-(6*47)+33,BLACK,SEABLUE,"COLOR SCHEME (MAIN & PROGRAM LAUNCHER)");

	rectfill(screen,665,569-(5*47)+14,x+632,569-(5*47)+51, SEABLUE);
	if(ColorScheme==0) { /* 0 = Scheme 1 (PALEBLUE & ORANGE) */
		PutsLuna(669,569-(5*47)+33,BLACK,SEABLUE,"COLOR SCHEME 1");
	}
	if(ColorScheme==1) { /* 1 = Scheme 2 (PALEBLUE & BIGBLUE) */
		PutsLuna(669,569-(5*47)+33,BLACK,SEABLUE,"COLOR SCHEME 2");
	}
	if(ColorScheme==2) { /* 2 = Scheme 3 (BRICK & MANGO) */
		PutsLuna(669,569-(5*47)+33,BLACK,SEABLUE,"COLOR SCHEME 3");
	}

/* palette */
	rectfill(screen,10, 569-(4*47)+14, x+112-36, 569-(4*47)+51, LAVENDER);
	RightBumper36(x+112-36,569-(4*47)+14,LAVENDER);
	PutsLuna(15,569-(4*47)+33,BLACK,LAVENDER,"PALETTE: STANDARD/ENDGAME");

	rectfill(screen,665,569-(4*47)+14,x+632,569-(4*47)+51, KHAKI);
	if(TempEndgame==0) {
		PutsLuna(669,569-(4*47)+33,BLACK,KHAKI,"STANDARD PALETTE");
	} else {
		PutsLuna(669,569-(4*47)+33,BLACK,KHAKI,"ENDGAME PALETTE");
	}


/* military/civilian time display */
	rectfill(screen,10, 569-(7*47)+14, x+112-36, 569-(7*47)+51, SEABLUE);
	RightBumper36(x+112-36,569-(7*47)+14,SEABLUE);
	PutsLuna(15,569-(7*47)+33,BLACK,SEABLUE,"TIME DISPLAY: CIVILIAN/MILITARY");

	rectfill(screen,665,569-(7*47)+14,x+632,569-(7*47)+51, MANGO);
	if(MilitaryTime==0) {
		PutsLuna(669,569-(7*47)+33,BLACK,MANGO,"CIVILIAN STYLE");
	} else {
		PutsLuna(669,569-(7*47)+33,BLACK,MANGO,"MILITARY STYLE");
	}

	ButtonType3(x+120, 569-(1*47)+14, ORANGE, LILAC, "BACK");
	EscSymbol(x+237, 569-(1*47)+14,2, ORANGE);

/* Cheat: Trim the BACK button to a ButtonType3Short */
	rectfill(screen,x+288,532,x+300,575, BLACK);

/* reset button */

	ButtonType5(59,536, MANGO, "ALL TO DEFAULT", "F1", BIGBLUE);

/* center flange */
	rectfill(screen,x+294,569-(12*47)+14,x+366,569-47+51, LAVENDER);

	FlangeHole(x+294,1);
	FlangeHole(x+294,3);
	FlangeHole(x+294,4);
	FlangeHole(x+294,5);
	FlangeHole(x+294,7);
	FlangeHole(x+294,8);
	FlangeHole(x+294,11);
}

void DisplayTempMuteBeepsSetting(char TempMuteBeeps, int x, int pos)
{
	pos=569-((12-pos)*47)+14;

	rectfill(screen,x+230,pos,x+276,pos+37, BLACK);


	if(TempMuteBeeps==FALSE) {
		ButtonType3Short(x+120, pos, LILAC, LAVENDER, "MUTE");
		F36_1(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, LAVENDER);
		ButtonType1(x+391,pos,LILAC,"ENABLE");
		return;
	} else {
		ButtonType3Short(x+120, pos, LAVENDER, LILAC, "ENABLE");
		F36_2(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, LILAC);
		ButtonType1(x+391,pos,LAVENDER,"MUTE");
		return;
	}
}

void DisplayTempAlarmTypeSetting(char TempAlarmType, int x, int pos)
{
	pos=569-((12-pos)*47)+14;

	rectfill(screen,x+230, pos,x+276,pos+47+36, BLACK);

	if(TempAlarmType==0) { /* 0 = MIDI */
		ButtonType3Short(x+120, pos+47, BRICK, PALEBLUE, "MP3");
		F36_4(x+260, pos+47+1, ORANGE, BLACK);
		ButtonType3Short(x+120, pos, MANGO, PURPLE, "VOICE");
		F36_5(x+260, pos+1, ORANGE, BLACK);
		rectfill(screen,x+373,pos+47,x+383,pos+47+36, PALEBLUE);
		ButtonType1(x+391,pos+47,ORANGE,"MIDI");
		return;
	}
	if(TempAlarmType==1) { /* 1 = MP3 */
		ButtonType3Short(x+120, pos+47, PALEBLUE, ORANGE, "MIDI");
		F36_3(x+260, pos+47+1, ORANGE, BLACK);
		ButtonType3Short(x+120, pos, MANGO, PURPLE, "VOICE");
		F36_5(x+260, pos+1, ORANGE, BLACK);
		rectfill(screen,x+373,pos+47,x+383,pos+47+36, BRICK);
		ButtonType1(x+391,pos+47,PALEBLUE,"MP3");
		return;
	}
	if(TempAlarmType==2) { /* 2 = voice */
		ButtonType3Short(x+120, pos+47, PALEBLUE, ORANGE, "MIDI");
		F36_3(x+260, pos+47+1, ORANGE, BLACK);
		ButtonType3Short(x+120, pos, BRICK, PALEBLUE, "MP3");
		F36_4(x+260, pos+1, ORANGE, BLACK);
		rectfill(screen,x+373,pos+47,x+383,pos+47+36, MANGO);
		ButtonType1(x+391,pos+47,PURPLE,"VOICE");
		return;
	}
}

void DisplayTempAudioOffSetting(char TempAudioOff, int x, int pos)
{
	pos=569-((12-pos)*47)+14;

	rectfill(screen,x+230,pos,x+276,pos+37, BLACK);

	if(TempAudioOff==FALSE) {
		ButtonType3Short(x+120, pos, SKYBLUE, BIGBLUE, "MUTE");
		F36_F(x+260-13, pos+1, NAPLES, BLACK);
		F36_9(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, BIGBLUE);
		ButtonType1(x+391,pos,SKYBLUE,"ENABLE");
		return;
	} else {
		ButtonType3Short(x+120, pos, BIGBLUE, SKYBLUE, "ENABLE");
		F36_F(x+260-24, pos+1, NAPLES, BLACK);
		F36_1(x+260-13, pos+1, NAPLES, BLACK);
		F36_0(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, SKYBLUE);
		ButtonType1(x+391,pos,BIGBLUE,"MUTE");
		return;
	}
}

void DisplayTempColorSchemeSetting(char TempColorScheme, int x, int pos)
{
	pos=569-((12-pos)*47)+14;

	rectfill(screen,x+230, pos,x+276,pos+47+36, BLACK);

	if(TempColorScheme==0) { /* 0 = Scheme 1 (PALEBLUE & ORANGE) */
		ButtonType3Short(x+120, pos+47, PALEBLUE, BIGBLUE, "SCHEME 2");
		F36_7(x+260, pos+47+1, MANGO, BLACK);
		ButtonType3Short(x+120, pos, BRICK, MANGO, "SCHEME 3");
		F36_8(x+260, pos+1, MANGO, BLACK);
		rectfill(screen,x+373,pos+47,x+383,pos+47+36, PALEBLUE);
		ButtonType1(x+391,pos+47,ORANGE,"SCHEME 1");
		return;
	}
	if(TempColorScheme==1) { /* 1 = Scheme 2 (PALEBLUE & BIGBLUE) */
		ButtonType3Short(x+120, pos+47, PALEBLUE, ORANGE, "SCHEME 1");
		F36_6(x+260, pos+47+1, MANGO, BLACK);
		ButtonType3Short(x+120, pos, BRICK, MANGO, "SCHEME 3");
		F36_8(x+260, pos+1, MANGO, BLACK);
		rectfill(screen,x+373,pos+47,x+383,pos+47+36, PALEBLUE);
		ButtonType1(x+391,pos+47,BIGBLUE,"SCHEME 2");
		return;
	}
	if(TempColorScheme==2) { /* 2 = Scheme 3 (BRICK & MANGO) */
		ButtonType3Short(x+120, pos+47, PALEBLUE, ORANGE, "SCHEME 1");
		F36_6(x+260, pos+47+1, MANGO, BLACK);
		ButtonType3Short(x+120, pos, PALEBLUE, BIGBLUE, "SCHEME 2");
		F36_7(x+260, pos+1, MANGO, BLACK);
		rectfill(screen,x+373,pos+47,x+383,pos+47+36, BRICK);
		ButtonType1(x+391,pos+47,MANGO,"SCHEME 3");
		return;
	}
}
void DisplayTempPaletteSetting(char TempEndgame, int x, int pos)
{
	pos=569-((12-pos)*47)+14;

	rectfill(screen,x+230,pos,x+276,pos+37, BLACK);

	if(TempEndgame==1) {
		ButtonType3Short(x+120, pos, ORANGE, PALEBLUE, "STANDARD");
		F36_F(x+260-24, pos+1, NAPLES, BLACK);
		F36_1(x+260-13, pos+1, NAPLES, BLACK);
		F36_1(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, KHAKI);
		ButtonType1(x+391,pos,BORG,"ENDGAME");
		return;
	} else {
		ButtonType3Short(x+120, pos, KHAKI, BORG, "ENDGAME");
		F36_F(x+260-24, pos+1, NAPLES, BLACK);
		F36_1(x+260-13, pos+1, NAPLES, BLACK);
		F36_2(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, ORANGE);
		ButtonType1(x+391,pos,PALEBLUE,"STANDARD");
		return;
	}
}
void DisplayTempMilitaryTimeSetting(char TempMilitaryTime, int x, int pos)
{
	pos=569-((12-pos)*47)+14;

	rectfill(screen,x+230,pos,x+276,pos+37, BLACK);

	if(TempMilitaryTime==1) {
		ButtonType3Short(x+120, pos, BIGBLUE, PALEBLUE, "CIVILIAN");
		F36_F(x+260-13, pos+1, NAPLES, BLACK);
		F36_5(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, RED);
		ButtonType1(x+391,pos,TAN,"MILITARY");
		return;
	} else {
		ButtonType3Short(x+120, pos, RED, TAN, "MILITARY");
		F36_F(x+260-13, pos+1, NAPLES, BLACK);
		F36_6(x+260, pos+1, NAPLES, BLACK);
		rectfill(screen,x+373,pos,x+383,pos+37, BIGBLUE);
		ButtonType1(x+391,pos,PALEBLUE,"CIVILIAN");
		return;
	}
}


void OptionSettingMode()
{
	int x=158;

	char TempMuteBeeps=MuteBeeps;
	char TempAlarmType=AlarmType;
	char TempColorScheme=ColorScheme;
	char TempAudioOff=AudioOff;
	char TempEndgame=Endgame;
	char TempMilitaryTime=MilitaryTime;
	char OkPromptOn=FALSE;
	char PreviousEndgame;

	PreviousEndgame=Endgame;
	Endgame=0;
	LcarsColors();
	OptionMenu(TempEndgame,x);
reset:	DisplayTempMuteBeepsSetting(TempMuteBeeps,x,1);
	DisplayTempAlarmTypeSetting(TempAlarmType,x,2);
	DisplayTempAudioOffSetting(TempAudioOff,x,4);
	DisplayTempMilitaryTimeSetting(TempMilitaryTime,x,5);
	DisplayTempColorSchemeSetting(TempColorScheme,x,6);
	DisplayTempPaletteSetting(TempEndgame,x,8);

loopback:

	c=GetKey();
	switch( c )
	{
		case 13:	if(OkPromptOn==FALSE) goto loopback;
				MuteBeeps=TempMuteBeeps;
				AlarmType=TempAlarmType;
				Endgame=TempEndgame;
				if(MilitaryTime != TempMilitaryTime) {
					MilitaryTime=TempMilitaryTime;
					BuildAlarmString();
				}
				LcarsColors();
				AudioOff=TempAudioOff;
				if(AudioOff==TRUE) {
					SingleAlarmOnOff=0;
					AlarmDisplay();
				}
				ColorScheme=TempColorScheme;
				goto done;
		case 49:	if(TempMuteBeeps==TRUE) goto loopback;
				TempMuteBeeps=TRUE;
				DisplayTempMuteBeepsSetting(TempMuteBeeps,x,1);
				if(MuteBeeps==TRUE) FlangeHole(x+294,1);
					else MarkFlangeHole(x+294,1, LAVENDER, "1");
				goto showprompt;
		case 50:	if(TempMuteBeeps==FALSE) goto loopback;
				TempMuteBeeps=FALSE;
				DisplayTempMuteBeepsSetting(TempMuteBeeps,x,1);
				if(MuteBeeps==FALSE) FlangeHole(x+294,1);
					else MarkFlangeHole(x+294,1, LAVENDER, "2");
				goto showprompt;
		case 51:	if(TempAlarmType==0) goto loopback;
				TempAlarmType=0;
				DisplayTempAlarmTypeSetting(TempAlarmType,x,2);
				if(AlarmType==0) FlangeHole(x+294,3);
					else MarkFlangeHole(x+294,3, LAVENDER, "3");
				goto showprompt;
		case 52:	if(TempAlarmType==1) goto loopback;
				TempAlarmType=1;
				DisplayTempAlarmTypeSetting(TempAlarmType,x,2);
				if(AlarmType==1) FlangeHole(x+294,3);
					else MarkFlangeHole(x+294,3, LAVENDER, "4");
				goto showprompt;
		case 53:	if(TempAlarmType==2) goto loopback;
				TempAlarmType=2;
				DisplayTempAlarmTypeSetting(TempAlarmType,x,2);
				if(AlarmType==2) FlangeHole(x+294,3);
					else MarkFlangeHole(x+294,3, LAVENDER, "5");
				goto showprompt;
		case 54:	if(TempColorScheme==0) goto loopback;
				TempColorScheme=0;
				DisplayTempColorSchemeSetting(TempColorScheme,x,6);
				if(ColorScheme==0) FlangeHole(x+294,7);
					else MarkFlangeHole(x+294,7, LAVENDER, "6");
				goto showprompt;
		case 55:	if(TempColorScheme==1) goto loopback;
				TempColorScheme=1;
				DisplayTempColorSchemeSetting(TempColorScheme,x,6);
				if(ColorScheme==1) FlangeHole(x+294,7);
					else MarkFlangeHole(x+294,7, LAVENDER, "7");
				goto showprompt;
		case 56:	if(TempColorScheme==2) goto loopback;
				TempColorScheme=2;
				DisplayTempColorSchemeSetting(TempColorScheme,x,6);
				if(ColorScheme==2) FlangeHole(x+294,7);
					else MarkFlangeHole(x+294,7, LAVENDER, "8");
				goto showprompt;
		case 27:        Endgame=PreviousEndgame;
				LcarsColors();
				goto done;
		case F1:	TempMuteBeeps=FALSE;
				TempAlarmType=0;
				TempColorScheme=0;
				TempAudioOff=FALSE;
				TempEndgame=0;
				TempMilitaryTime=0;
				if(OkPromptOn==FALSE) OkPrompt(x);
				OkPromptOn=TRUE;
				goto reset;
		case F5:	if(TempMilitaryTime==0) goto loopback;
				TempMilitaryTime=0;
				DisplayTempMilitaryTimeSetting(TempMilitaryTime,x,5);
				if(MilitaryTime==0) FlangeHole(x+294,5);
					else MarkFlangeHole(x+294,5, LAVENDER, "F5");
				goto showprompt;
		case F6:	if(TempMilitaryTime==1) goto loopback;
				TempMilitaryTime=1;
				DisplayTempMilitaryTimeSetting(TempMilitaryTime,x,5);
				if(MilitaryTime==1) FlangeHole(x+294,5);
					else MarkFlangeHole(x+294,5, LAVENDER, "F6");
				goto showprompt;
		case F9:	if(BlasterOK==FALSE) goto loopback;
				if(TempAudioOff==TRUE) goto loopback;
				TempAudioOff=TRUE;
				DisplayTempAudioOffSetting(TempAudioOff,x,4);
				if(AudioOff==TRUE) FlangeHole(x+294,4);
					else MarkFlangeHole(x+294,4, LAVENDER, "F9");
				goto showprompt;
		case F10:	if(BlasterOK==FALSE) goto loopback;
				if(TempAudioOff==FALSE) goto loopback;
				TempAudioOff=FALSE;
				DisplayTempAudioOffSetting(TempAudioOff,x,4);
				if(AudioOff==FALSE) FlangeHole(x+294,4);
					else MarkFlangeHole(x+294,4, LAVENDER, "F10");
				goto showprompt;
		case F11:	if(TempEndgame==0) goto loopback;
				TempEndgame=0;
				DisplayTempPaletteSetting(TempEndgame,x,8);
				if(PreviousEndgame==0) FlangeHole(x+294,8);
					else MarkFlangeHole(x+294,8, LAVENDER, "F11");
				goto showprompt;
		case F12:	if(TempEndgame==1) goto loopback;
				TempEndgame=1;
				DisplayTempPaletteSetting(TempEndgame,x,8);
				if(PreviousEndgame==1) FlangeHole(x+294,8);
					else MarkFlangeHole(x+294,8, LAVENDER, "F12");
				goto showprompt;
		case 350:	Screenshot792("options.bmp");
				goto loopback;
		default:	goto loopback;
	}

showprompt:
	if(OkPromptOn==FALSE) {
		OkPrompt(x);
		MarkFlangeHole(x+294,11, LAVENDER, "?");
		OkPromptOn=TRUE;
	}
	goto loopback;

done:
	WarmRecover();
	SaveAlarm();
	return;
}

