/* Help.h, for help files
	Usage: OpenHelp(char *filespec) to take a snapshot of the screen
		then restore it when the reader closes, or
		or LcHelp(char *filespec) to call the reader directly
		The original setting below is for 300 lines.  Change it
		if you need more (HELPLINECOUNT).
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef HELP_H
#define HELP_H


#include <allegro.h>
#include "getkey.h"
#include "parts.h"
#include "headline.h"
#include "common.h"
#include "scrnshot.h"

#define HELPLINELENGTH 80
#define HELPLINECOUNT 300

char HelpLn[HELPLINECOUNT][HELPLINELENGTH];
int EndHelpText;
int HelpHeadColor;
int HelpTextColor;

int LcHelp(char *filespec);
int OpenHelp(char *filespec);


#endif

