/*	 Elbows.h, to provide antialiased elbows for brackets2
	and FILES 24.  The x and y calling coordinates refer
	to the inside top edge (northern elbows) or inside bottom
	edge (southern elbows) for easy matching with connecting
	bars.
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "elbows.h"


int fuzz[52][3] =
{
	{84, 0, 1},
	{85, 0, 1},
	{86, 0, 2},
	{87, 0, 2},
	{88, 0, 3},
	{89, 0, 3},
	{90, 0, 4},
	{91, 0, 4},
	{92, 0, 4},
	{93, 1, 1},
	{94, 1, 1},
	{95, 1, 2},
	{96, 1, 3},
	{97, 1, 4},
	{98, 2, 1},
	{99, 2, 2},
	{100, 2, 3},
	{101, 2, 4},
	{102, 2, 4},
	{102, 3, 1},
	{103, 3, 2},
	{104, 3, 3},
	{105, 3, 4},
	{106, 4, 2},
	{107, 4, 3},
	{108, 4, 4},
	{108, 5, 1},
	{109, 5, 2},
	{110, 5, 4},
	{111, 6, 2},
	{112, 6, 4},
	{113, 7, 2},
	{114, 7, 4},
	{115, 8, 2},
	{116, 8, 4},
	{117, 9, 4},
	{118, 10, 2},
	{119, 11, 2},
	{120, 12, 2},
	{121, 13, 2},
	{122, 14, 2},
	{123, 15, 4},
	{123, 16, 2},
	{124, 16, 4},
	{124, 17, 3},
	{124, 18, 2},
	{125, 19, 4},
	{125, 20, 3},
	{125, 21, 2},
	{125, 22, 1},
	{125, 23, 1},
};

void SetFuzz()
{
	int i;

	for( i=0; i<=50; ++i) {
		if( fuzz[i][2]==1) fuzz[i][2]=ac1;
		if( fuzz[i][2]==2) fuzz[i][2]=ac2;
		if( fuzz[i][2]==3) fuzz[i][2]=ac3;
		if( fuzz[i][2]==4) fuzz[i][2]=ac4;
	}
}
void NorthwestElbow(int ex, int ey, int Hue)
{	 /* Make ex greater than 137, ex greater than 1 */
	int i;

	FadeOut(Hue);
	ellipsefill(screen,ex-77,ey+23,48,24,Hue);
	putpixel(screen, ex-77,ey-1, BLACK);
	rectfill(screen,ex, ey, ex-77, ey+26, Hue);
	rectfill(screen,ex-25, ey+23, ex-125, ey+48,Hue);
	NorthwestCorner(ex-24,ey+27);
	SetFuzz();
	for( i=0; i<=50; ++i)
		putpixel(screen, ex-fuzz[i][0],ey+fuzz[i][1], fuzz[i][2]);
}
void SouthwestElbow(int ex, int ey, int Hue)
{	 /* Make ex greater than 137 */
	int i;

	FadeOut(Hue);
	ellipsefill(screen,ex-77,ey-23,48,24,Hue);
	putpixel(screen, ex-77,ey+1, BLACK);
	rectfill(screen,ex, ey, ex-77, ey-26, Hue);
	rectfill(screen,ex-25, ey-23, ex-125, ey-48,Hue);
	SouthwestCorner(ex-24,ey-27);
	SetFuzz();
	for( i=0; i<=50; ++i)
		putpixel(screen, ex-fuzz[i][0],ey-fuzz[i][1], fuzz[i][2]);
}
void NortheastElbow(int ex, int ey, int Hue)
{	 /* Make ex less than MaxX-137 */
	int i;

	FadeOut(Hue);
	ellipsefill(screen,ex+77,ey+23,48,24,Hue);
	putpixel(screen, ex+77,ey-1, BLACK);
	rectfill(screen,ex, ey, ex+77, ey+26, Hue);
	rectfill(screen,ex+25, ey+23, ex+125, ey+48,Hue);
	NortheastCorner(ex+24,ey+27);
	SetFuzz();
	for( i=0; i<=50; ++i)
		putpixel(screen, ex+fuzz[i][0],ey+fuzz[i][1], fuzz[i][2]);
}
void SoutheastElbow(int ex, int ey, int Hue)
{	 /* Make ex less than MaxX-137 */
	int i;

	FadeOut(Hue);
	ellipsefill(screen,ex+77,ey-23,48,24,Hue);
	putpixel(screen, ex+77,ey+1, BLACK);
	rectfill(screen,ex, ey, ex+77, ey-26, Hue);
	rectfill(screen,ex+25, ey-23, ex+125, ey-48,Hue);
	SoutheastCorner(ex+24,ey-27);
	SetFuzz();
	for( i=0; i<=50; ++i)
		putpixel(screen, ex+fuzz[i][0],ey-fuzz[i][1], fuzz[i][2]);
}
/* eof */

