/* 12/19/09 */

/* Worldmap, an LCARS 24 app to display and label a large world map */
/* The original topgraphic map supplied by the CIA is stripped of
 almost all labels and displayed zoomed, with this program supplying
 legible labels at full resolution, using routines and data in mapdata.c
 and mapfont.c. Output is double-buffered.
*/

#include "worldmap.h"


void MapL1()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL1List; ++ln) {
		lx=(L1X[ln]-MapOffsetX)*2;
		ly=(L1Y[ln]-MapOffsetY)*2;
		if(lx>-160 && lx<700 && ly>0 && ly<500-14)
			PutsFont13(worldmap_buf,lx,ly,OFFBLACK,L1[ln]);
	}
}
void MapL2()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL2List; ++ln) {
		lx=(L2X[ln]-MapOffsetX)*2;
		ly=(L2Y[ln]-MapOffsetY)*2;
		if(lx>-100 && lx<700 && ly>0 && ly<600)
			PutsBlock11(worldmap_buf,lx,ly,OFFBLACK,L2[ln]);
	}
}
void MapL3()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL3List; ++ln) {
		lx=(L3X[ln]-MapOffsetX)*2;
		ly=(L3Y[ln]-MapOffsetY)*2;
		if(lx> -500 && lx<906 && ly>-74 && ly<574)
			PutsFont24(worldmap_buf,lx,ly,OFFBLACK,L3[ln]);
	}
}
void MapL4()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL4List; ++ln) {
		lx=(L4X[ln]-MapOffsetX)*2;
		ly=(L4Y[ln]-MapOffsetY)*2;
		if(lx> -200 && lx<700 && ly>0 && ly<500-14)
			PutsFont18(worldmap_buf,lx,ly,OFFBLACK,L4[ln]);
	}
}
void MapL5()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL5List; ++ln) {
		lx=(L5X[ln]-MapOffsetX)*2;
		ly=(L5Y[ln]-MapOffsetY)*2;
		if(lx> -200 && lx<700 && ly>5 && ly<550-78)
			PutsFont24(worldmap_buf,lx,ly,OCEAN,L5[ln]);
	}
}
void MapL6()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL6List; ++ln) {
		lx=(L6X[ln]-MapOffsetX)*2;
		ly=(L6Y[ln]-MapOffsetY)*2;
		if(lx>-160 && lx<700 && ly>0 && ly<500-14)
			PutsFont13(worldmap_buf,lx,ly,OCEAN,L6[ln]);
	}
}
void MapL7()
{
	int lx,ly,ln;

	for(ln=0; ln<=EndL7List; ++ln) {
		lx=(L7X[ln]-MapOffsetX)*2;
		ly=(L7Y[ln]-MapOffsetY)*2;
		if(lx>-160 && lx<700 && ly>0 && ly<500-14)
			PutsFont13(worldmap_buf,lx,ly,DARK,L7[ln]);
	}
}
void MapRefresh()
{
	stretch_blit(topo_map,worldmap_buf,MapOffsetX,MapOffsetY,353,250, 0,0,706,500);
	MapL1();
	MapL3();
	MapL4();
	MapL2();
	MapL5();
	MapL6();
	MapL7();
	blit(worldmap_buf,screen,0,0,47,50,706,500);
}
int MapLoadJpeg(char *filespec)
{
	MarsF(400-((StrLenMars(3,"DECOMPRESSING DATA"))*.5), 244, 3, PURPLE, BLACK, "DECOMPRESSING DATA");
	topo_map = load_jpg(filespec, NULL); 
	if (!topo_map) {
		NormalLoadError(filespec);
		return(86);
	}
	worldmap_buf = create_bitmap(706,500);
	set_palette(the_palette);
	return(0);
}
void MapScreen()
{
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	ColorTitle("SCAN 001",PURPLE);
	PutsLuna(178,20, BLACK,LILAC,MakeDisplayName(CurrentFile));
	PutsLuna(178,566, BLACK,LILAC, "SCROLL:");
	LeftArrowSymbol(228,566,BLACK);
	RightArrowSymbol(228+25,566,BLACK);
	UpArrowSymbol(228+50,566,BLACK);
	DownArrowSymbol(228+75,566,BLACK);

	PutsLuna(600,566, BLACK,LILAC, "CLOSE: F12");
}
void MapScrollLeft(int Amount)
{
	if(MapOffsetX == 0) return;
	MapOffsetX -= Amount;
	if(MapOffsetX <= 0) MapOffsetX = 0;
	MapRefresh();
}
void MapScrollRight(int Amount)
{
	MapOffsetX += Amount;
	if(MapOffsetX >= topo_map->w-706/2) MapOffsetX = topo_map->w-706/2;
	MapRefresh();
}
void MapScrollUp(int Amount)
{
	if(MapOffsetY == 0) return;
	MapOffsetY -= Amount;
	if(MapOffsetY <= 0) MapOffsetY = 0;
	MapRefresh();
}
void MapScrollDown(int Amount)
{
	MapOffsetY += Amount;
	if(MapOffsetY >= topo_map->h-500/2) MapOffsetY = topo_map->h-500/2;
	MapRefresh();
}
int MapWindow()
{
	if(MapLoadJpeg(CurrentFile) !=0) return(86);
	PopPutTime(1);
	MapRefresh();
	PanelBeep();
loopback:
	do {
		PopPutTime(1);
	} while(!keypressed());

	c = GetKey();
	switch( c )
		{
		case LEFTARROW: MapScrollLeft(64/2);
				goto loopback;
		case RIGHTARROW: MapScrollRight(64/2);
				goto loopback;
		case UPARROW: MapScrollUp(64/2);
				goto loopback;
		case DOWNARROW: MapScrollDown(64/2);
				goto loopback;
		case PGUPKEY:	MapScrollUp(256/2);
				goto loopback;
		case PGDNKEY:	MapScrollDown(256/2);
				goto loopback;
		case HOMEKEY:	MapScrollLeft(256/2);
				goto loopback;
		case ENDKEY:	 MapScrollRight(256/2);
				goto loopback;
		case F12: return(0);
			case CTRL_F1: Screenshot792("Map.bmp");
				PanelBeep();
				goto loopback;
			case CTRL_F2: Screenshot1024("Map10.bmp");
				PanelBeep();
				goto loopback;
		default: goto loopback;
	} while(1);
}
void MapInit()
{
	MapOffsetX = 580;
	MapOffsetY = 220;

	OCEAN=makecol(205,219,228);
	DARK=makecol(0x8,0x47,0x68);
	OFFBLACK=makecol(0x20,0x20,0x20);
	min_old=70;

	MapData();

strcpy(L2[509],"Sitka #");			 L2X[509]=466-(StrLenB11(L2[509])*.5); L2Y[509]=208;
strcpy(L2[510],"Sachs Harbour #");  L2X[510]=652-(StrLenB11(L2[510])*.5); L2Y[510]=93;
strcpy(L2[511],"Victoria #");			 L2X[511]=481-(StrLenB11(L2[511])*.5); L2Y[511]=280;
strcpy(L2[512],"Port Hardy #");	  L2X[512]=463-(StrLenB11(L2[512])*.5); L2Y[512]=262;
strcpy(L2[513],"Ketchikan #");			L2X[513]=474-(StrLenB11(L2[513])*.5); L2Y[513]=223;
strcpy(L2[514],"Prince Rupert #");	  L2X[514]=476-(StrLenB11(L2[514])*.5); L2Y[514]=230;
strcpy(L2[515],"Moosonee #");		 L2X[515]=783-(StrLenB11(L2[515])*.5); L2Y[515]=253;
	strcpy(L2[516],"# Durban");		L2X[516]=1530; L2Y[516]=955;
	strcpy(L2[517],"# Naha");	  L2X[517]=2249; L2Y[517]=470;
	strcpy(L2[518],"Okinawa");	 L2X[518]=2232; L2Y[518]=464;
	strcpy(L2[519],"# Laoag");	 L2X[519]=2209; L2Y[519]=538;
	strcpy(L2[520],"# Quezon City"); L2X[520]=2218; L2Y[520]=566;
	strcpy(L2[521],"# Naga");	  L2X[521]=2230; L2Y[521]=574;
	strcpy(L2[522],"* Saipan");		L2X[522]=2401; L2Y[522]=564;
	strcpy(L2[523],"Guam");		 L2X[523]=2376; L2Y[523]=576;
	strcpy(L2[524],"(U.S.)");	  L2X[524]=2376; L2Y[524]=583;
	strcpy(L2[525],"# Aden");	  L2X[525]=1644; L2Y[525]=582;
	strcpy(L2[526],"# Cairns");		L2X[526]=2398; L2Y[526]=838;
	strcpy(L2[527],"# Gibraltar");		L2X[527]=1265; L2Y[527]=386;
	strcpy(L2[528],"  (U.K.)");		L2X[528]=1265; L2Y[528]=393;
	strcpy(L2[529],"# Goteborg");	 L2X[529]=1388; L2Y[529]=203;
strcpy(L2[530],"Cardiff #");	  L2X[530]=1284-(StrLenB11(L2[530])*.5); L2Y[530]=254;
strcpy(L2[531],"Cadiz #");			 L2X[531]=1260-(StrLenB11(L2[531])*.5); L2Y[531]=378;
strcpy(L2[532],"Le Harve #");		 L2X[532]=1311-(StrLenB11(L2[532])*.5); L2Y[532]=269;
strcpy(L2[533],"Cork #");			  L2X[533]=1253-(StrLenB11(L2[533])*.5); L2Y[533]=251;
strcpy(L2[534],"Liverpool #");	L2X[534]=1286-(StrLenB11(L2[534])*.5); L2Y[534]=242;
strcpy(L2[535],"Plymouth #");		 L2X[535]=1283-(StrLenB11(L2[535])*.5); L2Y[535]=263;
	strcpy(L2[536],"# Lviv");	  L2X[536]=1468; L2Y[536]=265;
	strcpy(L2[537],"* Bern");	  L2X[537]=1357; L2Y[537]=291;
strcpy(L2[538],"Nantes #");				  L2X[538]=1301-(StrLenB11(L2[538])*.5); L2Y[538]=289;
strcpy(L2[539],"Porto #");					L2X[539]=1247-(StrLenB11(L2[539])*.5); L2Y[539]=340;
	strcpy(L2[540],"#");	 L2X[540]=1370; L2Y[540]=303;
	strcpy(L2[541],"  Milan");	 L2X[541]=1369; L2Y[541]=306;
	strcpy(L2[542],"# Abha");	  L2X[542]=1623; L2Y[542]=543;
strcpy(L2[543],"# Buraydah");	 L2X[543]=1625; L2Y[543]=454;
	strcpy(L2[544],"#");		 L2X[544]=1335; L2Y[544]=255;
	strcpy(L2[545],"Antwerp");	 L2X[545]=1312; L2Y[545]=252;
	strcpy(L2[546],"# The Hague");		L2X[546]=1335; L2Y[546]=251;
	strcpy(L2[547],"# Cologne");	  L2X[547]=1355; L2Y[547]=258;
	strcpy(L2[548],"Kiritimati Atoll"); L2X[548]=105;  L2Y[548]=679;
	strcpy(L2[549],"(Christmas Atoll)");	L2X[549]=105;  L2Y[549]=686;
	strcpy(L2[550],"	(KIRIBATI)"); L2X[550]=105;  L2Y[550]=693;
	strcpy(L2[551],"#");		 L2X[551]=1352; L2Y[551]=320;
	strcpy(L2[552],"Nice");		 L2X[552]=1339; L2Y[552]=316;
	strcpy(L2[553],"Jarvis Island"); L2X[553]=42;	L2Y[553]=703;
	strcpy(L2[554],"	 (U.S.)");	 L2X[554]=42;	L2Y[554]=710;
	strcpy(L2[555],"Cook Islands");	  L2X[555]=31;	L2Y[555]=818;
	strcpy(L2[556],"	 (N.Z.)");	 L2X[556]=31;	L2Y[556]=825;
	strcpy(L2[557],"Society Islands");  L2X[557]=112;  L2Y[557]=849;
	strcpy(L2[558],"(FRANCE)");		L2X[558]=208;  L2Y[558]=875;
	strcpy(L2[559],"Tahiti");	  L2X[559]=180;  L2Y[559]=853;
	strcpy(L2[560],"* Papeete");	  L2X[560]=172;  L2Y[560]=846;
strcpy(L2[561],"Tours #");					L2X[561]=1312-(StrLenB11(L2[561])*.5); L2Y[561]=298;
	strcpy(L2[562],"Pitcairn Islands"); L2X[562]=345;  L2Y[562]=914;
	strcpy(L2[563],"		(U.K.)");	  L2X[563]=345;  L2Y[563]=921;
	strcpy(L2[564],"Easter Island"); L2X[564]=455;  L2Y[564]=935;
	strcpy(L2[565],"	 (CHILE)");		L2X[565]=455;  L2Y[565]=942;
	strcpy(L2[566],"Revillagigedo Islands"); L2X[566]=428;	L2Y[566]=541;
	strcpy(L2[567],"(MEXICO)");		L2X[567]=446;  L2Y[567]=549;
	strcpy(L2[568],"Clipperton Island");	L2X[568]=469;  L2Y[568]=609;
	strcpy(L2[569],"(FRANCE)");		L2X[569]=480;  L2Y[569]=616;
	strcpy(L2[570],"Coco Island");		L2X[570]=641;  L2Y[570]=639;
	strcpy(L2[571],"(COSTA RICA)");	  L2X[571]=641;  L2Y[571]=646;
strcpy(L2[572],"Adamstown *");				  L2X[572]=334-(StrLenB11(L2[572])*.5); L2Y[572]=912;
strcpy(L2[573],"Malpelo Island");				  L2X[573]=676-(StrLenB11(L2[573])*.5); L2Y[573]=664;
strcpy(L2[574],"  (COLOMBIA)	");				 L2X[574]=676-(StrLenB11(L2[574])*.5); L2Y[574]=671;
	strcpy(L2[575],"Tuamotu Archipelago"); L2X[575]=249;  L2Y[575]=832;
	strcpy(L2[576],"(Fr. Poly.)");		L2X[576]=265;  L2Y[576]=839;
	strcpy(L2[577],"Palmyra Atoll (U.S.)");	L2X[577]=65;	L2Y[577]=646;
	strcpy(L2[578],"Kingman Reef (U.S.)"); L2X[578]=63;	L2Y[578]=637;
	strcpy(L2[579],"Galapagos Islands");	L2X[579]=550;  L2Y[579]=706;
	strcpy(L2[580],"(ECUADOR)");	  L2X[580]=560;  L2Y[580]=714;
	strcpy(L2[581],"Marquesas Islands");	L2X[581]=247;  L2Y[581]=768;
	strcpy(L2[582],"(Fr. Poly)");	 L2X[582]=262;  L2Y[582]=775;
	strcpy(L2[583],"Tubuai Islands");	L2X[583]=189;  L2Y[583]=906;
	strcpy(L2[584],"(Fr. Poly)");	 L2X[584]=196;  L2Y[584]=913;
	strcpy(L2[585],"San Ambrosio Island (CHILE)"); L2X[585]=612;	L2Y[585]=920;
	strcpy(L2[586],"San Felix Island (CHILE)"); L2X[586]=622;	L2Y[586]=927;
	strcpy(L2[587],"Juan Fernandez Archipelago (CHILI)"); L2X[587]=635;  L2Y[587]=998;
	strcpy(L2[588],"South Georgia (U.K.)"); L2X[588]=1084;	L2Y[588]=1162;
	strcpy(L2[589],"South Sandwich Islands (U.K.)"); L2X[589]=1151;	L2Y[589]=1189;
	strcpy(L2[590],"South Orkney Islands (U.K.)"); L2X[590]=1049;  L2Y[590]=1218;
	strcpy(L2[591],"Rhodes");	  L2X[591]=1485; L2Y[591]=381;
	strcpy(L2[592],"Lesbos");	  L2X[592]=1471; L2Y[592]=355;
	strcpy(L2[593],"Sala y Gomez Island"); L2X[593]=523;  L2Y[593]=924;
	strcpy(L2[594],"		 (CHILE)");	L2X[594]=523;  L2Y[594]=932;
	strcpy(L2[595],"Jan Mayen");	  L2X[595]=1278; L2Y[595]=104;
	strcpy(L2[596],"(NORWAY)");		L2X[596]=1280; L2Y[596]=112;
	strcpy(L2[597],"Faroe Islands"); L2X[597]=1280; L2Y[597]=160;
	strcpy(L2[598],"  (DENMARK)");		L2X[598]=1280; L2Y[598]=168;
strcpy(L2[599],"Torshavn *");					L2X[599]=1276-(StrLenB11(L2[599])*.5); L2Y[599]=167;
	strcpy(L2[600],"Rockall (U.K.)");	L2X[600]=1228; L2Y[600]=206;
	strcpy(L2[601],"Azores");	  L2X[601]=1093; L2Y[601]=369;
	strcpy(L2[602],"(PORTUGAL)");	 L2X[602]=1089; L2Y[602]=377;
	strcpy(L2[603],"Madeira Islands");  L2X[603]=1145; L2Y[603]=419;
	strcpy(L2[604],"(PORTUGAL)");	 L2X[604]=1150; L2Y[604]=427;
strcpy(L2[605],"Funchal #");				 L2X[605]=1180-(StrLenB11(L2[605])*.5); L2Y[605]=413;
	strcpy(L2[606],"Canary Islands (SPAIN)"); L2X[606]=1148; L2Y[606]=440;
strcpy(L2[607],"Las Palmas #");				 L2X[607]=1188-(StrLenB11(L2[607])*.5); L2Y[607]=456;
strcpy(L2[608],"Praia *");						L2X[608]=1123-(StrLenB11(L2[608])*.5); L2Y[608]=567;
	strcpy(L2[609],"Tristan da Cuhna (St. Helena)"); L2X[609]=1201;	L2Y[609]=1031;
	strcpy(L2[610],"(U.K.)");	  L2X[610]=1243; L2Y[610]=932;
	strcpy(L2[611],"Ascension (St. Helena)"); L2X[611]=1191; L2Y[611]=767;
	strcpy(L2[612],"St. Helena (St. Helena)");		L2X[612]=1264; L2Y[612]=826;
	strcpy(L2[613],"Gough Island (St. Helena)");	 L2X[613]=1238; L2Y[613]=1047;
	strcpy(L2[614],"Annobon)");		L2X[614]=1313; L2Y[614]=711;
	strcpy(L2[615],"(Eq. Guinea)");	  L2X[615]=1310; L2Y[615]=719;
	strcpy(L2[616],"ANGOLA--");		L2X[616]=1370; L2Y[616]=743;
	strcpy(L2[617],"(Cabinda)");	  L2X[617]=1366; L2Y[617]=751;
	strcpy(L2[618],"Ferdando de Noronha"); L2X[618]=1020; L2Y[618]=712;
	strcpy(L2[619],"Archipelago");		L2X[619]=1030; L2Y[619]=720;
	strcpy(L2[620],"(BRAZIL)");		L2X[620]=1036; L2Y[620]=728;
	strcpy(L2[621],"Martin Vaz Islands");  L2X[621]=1080; L2Y[621]=822;
	strcpy(L2[622],"(BRAZIL)");		L2X[622]=1092; L2Y[622]=830;
	strcpy(L2[623],"Bouvet Island"); L2X[623]=1333; L2Y[623]=1153;
	strcpy(L2[624],"(NORWAY)");		L2X[624]=1338; L2Y[624]=1161;
	strcpy(L2[625],"Svalbard");		L2X[625]=1413; L2Y[625]=61;
	strcpy(L2[626],"(NORWAY)");		L2X[626]=1413; L2Y[626]=69;
	strcpy(L2[627],"Franz Josef Land"); L2X[627]=1561; L2Y[627]=27;
	strcpy(L2[628],"Novaja Zeml'a"); L2X[628]=1587; L2Y[628]=62;
	strcpy(L2[629],"Severnaja Zeml'a"); L2X[629]=1798; L2Y[629]=36;
	strcpy(L2[630],"New Siberian Islands");	L2X[630]=2023; L2Y[630]=60;
	strcpy(L2[631],"Wrangel Island");	L2X[631]=2279; L2Y[631]=90;
	strcpy(L2[632],"Bol'shoy Lyakhov Island"); L2X[632]=2082; L2Y[632]=82;
	strcpy(L2[633],"Bear Island (NORWAY)"); L2X[633]=1426; L2Y[633]=80;
	strcpy(L2[634],"* Santo");	 L2X[634]=772;  L2Y[634]=536;
	strcpy(L2[635],"Domingo");	 L2X[635]=772;  L2Y[635]=542;
	strcpy(L2[636],"Puerto");	  L2X[636]=793;  L2Y[636]=515;
	strcpy(L2[637]," Rico");		L2X[637]=793;  L2Y[637]=522;
	strcpy(L2[638]," (U.S.)");	 L2X[638]=793;  L2Y[638]=529;
	strcpy(L2[639],"Cayman");	  L2X[639]=665;  L2Y[639]=538;
	strcpy(L2[640],"Islands");	 L2X[640]=665;  L2Y[640]=546;
	strcpy(L2[641],"(U.K.)");	  L2X[641]=666;  L2Y[641]=554;
	strcpy(L2[642],"Prince Edward Islands"); L2X[642]=1530;  L2Y[642]=1107;
	strcpy(L2[643],"(SOUTH ARFICA)");	L2X[643]=1541; L2Y[643]=1115;
	strcpy(L2[644],"(FRANCE)");		L2X[644]=1730; L2Y[644]=1073;
	strcpy(L2[645],"Amsterdam Island");	 L2X[645]=1871; L2Y[645]=1013;
	strcpy(L2[646],"(Fr. S. and Ant. Lands)"); L2X[646]=1859;	L2Y[646]=1021;
	strcpy(L2[647],"St. Paul Island");  L2X[647]=1857; L2Y[647]=1032;
	strcpy(L2[648],"(Fr. S. and Ant. Lands)"); L2X[648]=1859;	L2Y[648]=1040;
	strcpy(L2[649],"Crozet Islands");	L2X[649]=1633; L2Y[649]=1106;
	strcpy(L2[650],"(Fr. S. and Ant. Lands)"); L2X[650]=1623;	L2Y[650]=1114;
	strcpy(L2[651],"Kerguelen");	  L2X[651]=1737; L2Y[651]=1129;
	strcpy(L2[652],"(Fr. S. and Ant. Lands)"); L2X[652]=1719;	L2Y[652]=1138;
	strcpy(L2[653],"Heard Island and");	 L2X[653]=1784; L2Y[653]=1146;
	strcpy(L2[654],"McDonald Islands");	 L2X[654]=1794; L2Y[654]=1154;
	strcpy(L2[655],"(AUSTRALIA)");		L2X[655]=1800; L2Y[655]=1162;
	strcpy(L2[656],"(Reunion)");	  L2X[656]=1694; L2Y[656]=883;
	strcpy(L2[657],"(FRANCE)");		L2X[657]=1694; L2Y[657]=891;
	strcpy(L2[658],"* Port Louis");	  L2X[658]=1731; L2Y[658]=870;
strcpy(L2[659],"Saint-Denis *"); L2X[659]=1718-(StrLenB11(L2[659])*.5); L2Y[659]=875;
	strcpy(L2[660],"Mayotte");	 L2X[660]=1624; L2Y[660]=812;
	strcpy(L2[661],"(FRANCE)");		L2X[661]=1624; L2Y[661]=820;
	strcpy(L2[662],"Diego Garcia");	  L2X[662]=1854; L2Y[662]=763;
	strcpy(L2[663],"Socotra");	 L2X[663]=1712; L2Y[663]=593;
	strcpy(L2[664],"(YEMEN)");	 L2X[664]=1712; L2Y[664]=601;
	strcpy(L2[665],"Tromelin Island");  L2X[665]=1706; L2Y[665]=836;
	strcpy(L2[666],"(FRANCE)");		L2X[666]=1712; L2Y[666]=844;
	strcpy(L2[667],"British Indian");	L2X[667]=1799; L2Y[667]=737;
	strcpy(L2[668],"Ocean Territory");  L2X[668]=1794; L2Y[668]=745;
	strcpy(L2[669],"(U.K.)");	  L2X[669]=1810; L2Y[669]=753;
	strcpy(L2[670],"Andaman");	 L2X[670]=1978; L2Y[670]=583;
	strcpy(L2[671],"Islands");	 L2X[671]=1978; L2Y[671]=591;
	strcpy(L2[672],"(INDIA)");	 L2X[672]=1978; L2Y[672]=599;
	strcpy(L2[673],"Nicobar");	 L2X[673]=1990; L2Y[673]=633;
	strcpy(L2[674],"Islands");	 L2X[674]=1990; L2Y[674]=641;
	strcpy(L2[675],"(INDIA)");	 L2X[675]=1990; L2Y[675]=649;
	strcpy(L2[676],"Laccadive");	  L2X[676]=1811; L2Y[676]=604;
	strcpy(L2[677],"  Islands");	  L2X[677]=1811; L2Y[677]=612;
	strcpy(L2[678],"  (INDIA)");	  L2X[678]=1812; L2Y[678]=620;
	strcpy(L2[679],"Christmas Island"); L2X[679]=2105; L2Y[679]=790;
	strcpy(L2[680],"(AUSTRALIA)");		L2X[680]=2111; L2Y[680]=798;
	strcpy(L2[681],"Cocos");		L2X[681]=2008; L2Y[681]=799;
	strcpy(L2[682],"(Keeling) Islands");	L2X[682]=1993; L2Y[682]=807;
	strcpy(L2[683],"(AUSTRALIA)");		L2X[683]=2000; L2Y[683]=815;
	strcpy(L2[684],"Chatham Islands");  L2X[684]=2547; L2Y[684]=1085;
	strcpy(L2[685],"(N.Z.)");	  L2X[685]=2559; L2Y[685]=1093;
	strcpy(L2[686],"Bounty Islands");	L2X[686]=2518; L2Y[686]=1110;
	strcpy(L2[687],"(N.Z.)");	  L2X[687]=2527; L2Y[687]=1118;
	strcpy(L2[688],"Antipodes Islands");	L2X[688]=2500; L2Y[688]=1126;
	strcpy(L2[689],"(N.Z.)");	  L2X[689]=2514; L2Y[689]=1134;
	strcpy(L2[690],"Snares Islands");	L2X[690]=2427; L2Y[690]=1112;
	strcpy(L2[691],"(N.Z.)");	  L2X[691]=2438; L2Y[691]=1120;
	strcpy(L2[692],"Auckland Islands"); L2X[692]=2349; L2Y[692]=1133;
	strcpy(L2[693],"(N.Z.)");	  L2X[693]=2362; L2Y[693]=1141;
	strcpy(L2[694],"Kermadec Islands"); L2X[694]=2633; L2Y[694]=961;
	strcpy(L2[695],"(N.Z.)");	  L2X[695]=2647; L2Y[695]=969;
	strcpy(L2[696],"Lord Howe Islands");	L2X[696]=2465; L2Y[696]=973;
	strcpy(L2[697],"(AUSTRALIA)");		L2X[697]=2475; L2Y[697]=981;
	strcpy(L2[698],"Norfolk Island");	L2X[698]=2539; L2Y[698]=950;
	strcpy(L2[699],"(AUSTRALIA)");		L2X[699]=2543; L2Y[699]=958;
	strcpy(L2[700],"Balleny Islands");  L2X[700]=2255; L2Y[700]=1266;
	strcpy(L2[701],"(N.Z.)");	  L2X[701]=2266; L2Y[701]=1274;
	strcpy(L2[702],"Macquarie Island"); L2X[702]=2330; L2Y[702]=1168;
	strcpy(L2[703],"(AUSTRALIA)");		L2X[703]=2336; L2Y[703]=1176;
	strcpy(L2[704],"Campbell Island");  L2X[704]=2412; L2Y[704]=1150;
	strcpy(L2[705],"(AUSTRALIA)");		L2X[705]=2417; L2Y[705]=1158;
	strcpy(L2[706],"Berkner Island");	L2X[706]=1095; L2Y[706]=1333;
	strcpy(L2[707],"Alexander Island"); L2X[707]=883;  L2Y[707]=1285;
	strcpy(L2[708],"Thurston");		L2X[708]=817;  L2Y[708]=1289;
	strcpy(L2[709],"Island");	  L2X[709]=819;  L2Y[709]=1297;
	strcpy(L2[710],"Aleutian Islands"); L2X[710]=2480; L2Y[710]=232;
	strcpy(L2[711],"(U.S.)");	  L2X[711]=2492; L2Y[711]=240;
	strcpy(L2[712],"Sakhalin");		L2X[712]=2257; L2Y[712]=252;
	strcpy(L2[713],"Kuril Islands"); L2X[713]=2344; L2Y[713]=286;
	strcpy(L2[714],"Midway");	  L2X[714]=2638; L2Y[714]=460;
	strcpy(L2[715],"Islands");	 L2X[715]=2639; L2Y[715]=468;
	strcpy(L2[716],"(U.S.)");	  L2X[716]=2641; L2Y[716]=476;
	strcpy(L2[717],"Wake Island");		L2X[717]=2554; L2Y[717]=526;
	strcpy(L2[718],"(U.S.)");	  L2X[718]=2563; L2Y[718]=534;
	strcpy(L2[719],"Minami Tori Shima");	L2X[719]=2450; L2Y[719]=480;
	strcpy(L2[720],"(JAPAN)");	 L2X[720]=2462; L2Y[720]=488;
	strcpy(L2[721],"Northern");		L2X[721]=2358; L2Y[721]=534;
	strcpy(L2[722],"Mariana");	 L2X[722]=2360; L2Y[722]=542;
	strcpy(L2[723],"Islands");	 L2X[723]=2360; L2Y[723]=550;
	strcpy(L2[724],"(U.S.)");	  L2X[724]=2362; L2Y[724]=558;
	strcpy(L2[725],"* Palikir");	  L2X[725]=2505; L2Y[725]=636;
	strcpy(L2[726],"* Majuro");		L2X[726]=2603; L2Y[726]=634;
	strcpy(L2[727],"* Funafuti");	 L2X[727]=2663; L2Y[727]=769;
strcpy(L2[728],"Yaren District *"); L2X[728]=2576-(StrLenB11(L2[728])*.5); L2Y[728]=700;
strcpy(L2[729],"Noumea *");		L2X[729]=2547-(StrLenB11(L2[729])*.5); L2Y[729]=889;
	strcpy(L2[730],"New Caledonia"); L2X[730]=2496; L2Y[730]=873;
	strcpy(L2[731],"(FRANCE)");		L2X[731]=2505; L2Y[731]=881;
	strcpy(L2[732],"Loyalty Islands");  L2X[732]=2563; L2Y[732]=882;
	strcpy(L2[733],"(FRANCE)");		L2X[733]=2571; L2Y[733]=890;
	strcpy(L2[734],"* Hagatna");	  L2X[734]=2396; L2Y[734]=579;
	strcpy(L2[735],"(Agana)");	 L2X[735]=2404; L2Y[735]=587;
	strcpy(L2[736],"Coral Sea");	  L2X[736]=2451; L2Y[736]=851;
	strcpy(L2[737],"Islands");	 L2X[737]=2454; L2Y[737]=859;
	strcpy(L2[738],"(AUSTRALIA)");		L2X[738]=2449; L2Y[738]=867;
	strcpy(L2[739],"--Glorioso Islands (FRANCE)");  L2X[739]=1663; L2Y[739]=796;
	strcpy(L2[740],"* Tarawa");		L2X[740]=2620; L2Y[740]=683;
strcpy(L2[741],"Apla *");	  L2X[741]=2729-(StrLenB11(L2[741])*.5); L2Y[741]=815;
	strcpy(L2[742],"* Nuku'alofu");	  L2X[742]=2684; L2Y[742]=879;
	strcpy(L2[743],"*");		 L2X[743]=2732; L2Y[743]=819;
	strcpy(L2[744],"Pago Pago");	  L2X[744]=2706; L2Y[744]=823;
	strcpy(L2[745],"Baker Island (U.S.)"); L2X[745]=2653; L2Y[745]=690;
	strcpy(L2[746],"Howland Island (U.S.)"); L2X[746]=2692;  L2Y[746]=683;
	strcpy(L2[747],"Tokelau");	 L2X[747]=2710; L2Y[747]=777;
	strcpy(L2[748],"(N.Z.)");	  L2X[748]=2714; L2Y[748]=785;
	strcpy(L2[749],"American");		L2X[749]=2704; L2Y[749]=830;
	strcpy(L2[750],"Samoa");		L2X[750]=2707; L2Y[750]=837;
	strcpy(L2[751],"(U.S.)");	  L2X[751]=2708; L2Y[751]=845;
	strcpy(L2[752],"Wallis and Futuna (FRANCE)"); L2X[752]=2633;	L2Y[752]=803;
	strcpy(L2[753],"Niue");		 L2X[753]=2704; L2Y[753]=853;
	strcpy(L2[754],"(N.Z.)");	  L2X[754]=2704; L2Y[754]=861;
strcpy(L2[755],"Mata-Uta *");	 L2X[755]=2695-(StrLenB11(L2[755])*.5); L2Y[755]=810;
	strcpy(L2[756],"*");		 L2X[756]=831;  L2Y[756]=605;
	strcpy(L2[757],"Port-of-Spain"); L2X[757]=836;  L2Y[757]=602;
	strcpy(L2[758],"ST. VINCENT &"); L2X[758]=794;  L2Y[758]=577;
	strcpy(L2[759],"THE GRENADINES");	L2X[759]=794;  L2Y[759]=584;
	strcpy(L2[760],"Virgin Islands");	L2X[760]=814;  L2Y[760]=522;
	strcpy(L2[761],"(U.S. & U.K.)"); L2X[761]=814;  L2Y[761]=530;
	strcpy(L2[762],"ST. KITTS");	  L2X[762]=795;  L2Y[762]=542;
	strcpy(L2[763],"& NEVIS");	 L2X[763]=801;  L2Y[763]=548;
	strcpy(L2[764],"Montserrat");	 L2X[764]=793;  L2Y[764]=556;
	strcpy(L2[765],"(U.K.)");	  L2X[765]=801;  L2Y[765]=564;
	strcpy(L2[766],"Neth. Antilles");	L2X[766]=784;  L2Y[766]=591;
	strcpy(L2[767],"(NETH.)");	 L2X[767]=792;  L2Y[767]=598;
	strcpy(L2[768],"Aruba");		L2X[768]=755;  L2Y[768]=579;
	strcpy(L2[769],"(NETH.)");	 L2X[769]=754;  L2Y[769]=586;
	strcpy(L2[770],"Navassa Island (U.S.)"); L2X[770]=684;	L2Y[770]=527;
	strcpy(L2[771],"# Kashi");	 L2X[771]=1839; L2Y[771]=353;
	strcpy(L2[772],"# Lhasa");	 L2X[772]=1971; L2Y[772]=440;
	strcpy(L2[773],"# Kunming");	  L2X[773]=2064; L2Y[773]=479;
	strcpy(L2[774],"# Guiyang");	  L2X[774]=2092; L2Y[774]=466;
	strcpy(L2[775],"# Nanchang");	 L2X[775]=2155; L2Y[775]=448;
	strcpy(L2[776],"# Nanning");	  L2X[776]=2109; L2Y[776]=498;
	strcpy(L2[777],"# Hangzhou");	 L2X[777]=2183; L2Y[777]=435;
	strcpy(L2[778],"# Xi'an");	 L2X[778]=2090; L2Y[778]=400;
	strcpy(L2[779],"# Zhengzhou");		L2X[779]=2122; L2Y[779]=396;
	strcpy(L2[780],"# Taiyuan");	  L2X[780]=2105; L2Y[780]=369;
	strcpy(L2[781],"# Changchun");		L2X[781]=2171; L2Y[781]=318;
	strcpy(L2[782],"# Harbin");		L2X[782]=2171; L2Y[782]=302;
strcpy(L2[783],"Urumqi #");		L2X[783]=1911-(StrLenB11(L2[783])*.5); L2Y[783]=318;
strcpy(L2[784],"Changsha #");	 L2X[784]=2135-(StrLenB11(L2[784])*.5); L2Y[784]=452;
strcpy(L2[785],"Nanjing #");	  L2X[785]=2169-(StrLenB11(L2[785])*.5); L2Y[785]=420;
strcpy(L2[786],"Qingdao #");	  L2X[786]=2167-(StrLenB11(L2[786])*.5); L2Y[786]=385;
strcpy(L2[787],"Jinan #");	 L2X[787]=2141-(StrLenB11(L2[787])*.5); L2Y[787]=379;
strcpy(L2[788],"Baotou #");		L2X[788]=2078-(StrLenB11(L2[788])*.5); L2Y[788]=345;
	strcpy(L2[789],"*");	 L2X[789]=1823; L2Y[789]=325;
	strcpy(L2[790],"Bishkek"); L2X[790]=1828; L2Y[790]=329;
	strcpy(L2[791],"#");	 L2X[791]=1838; L2Y[791]=322;
	strcpy(L2[792],"Almaty");  L2X[792]=1841; L2Y[792]=318;
	strcpy(L2[793],"# Baguio");	L2X[793]=2211; L2Y[793]=555;
	strcpy(L2[794],"# Cebu");  L2X[794]=2241; L2Y[794]=607;
	strcpy(L2[795],"# Jaro");  L2X[795]=2246; L2Y[795]=599;
strcpy(L2[796],"Iloilo #");		L2X[796]=2230-(StrLenB11(L2[796])*.5); L2Y[796]=604;
	strcpy(L2[797],"*");	 L2X[797]=2215; L2Y[797]=568;
	strcpy(L2[798],"Manila");  L2X[798]=2199; L2Y[798]=573;
	strcpy(L2[799],"# Okha");  L2X[799]=2231; L2Y[799]=233;
	strcpy(L2[800],"# Yuzhno-Sakhalinsk"); L2X[800]=2276; L2Y[800]=293;
	strcpy(L2[801],"# Okhotsk");  L2X[801]=2195; L2Y[801]=188;
	strcpy(L2[802],"# Tasiilaq"); L2X[802]=1097; L2Y[802]=140;
	strcpy(L2[803],"#");	 L2X[803]=633;  L2Y[803]=432;
	strcpy(L2[804],"Baton Rouge");	L2X[804]=637;  L2Y[804]=427;
	strcpy(L2[805],"# Charleston");  L2X[805]=727;  L2Y[805]=408;
	strcpy(L2[806],"# Savannah"); L2X[806]=713;  L2Y[806]=415;
strcpy(L2[807],"Sacramento #");	  L2X[807]=444-(StrLenB11(L2[807])*.5); L2Y[807]=364;
	strcpy(L2[808],"# Reno");  L2X[808]=455;  L2Y[808]=361;
strcpy(L2[809],"Eureka #");		L2X[809]=433-(StrLenB11(L2[809])*.5); L2Y[809]=346;
	strcpy(L2[810],"# Roswell");  L2X[810]=534;  L2Y[810]=402;
strcpy(L2[811],"Pittsburgh #");	  L2X[811]=745-(StrLenB11(L2[811])*.5); L2Y[811]=344;
	strcpy(L2[812],"# Townsville");  L2X[812]=2414; L2Y[812]=870;
	strcpy(L2[813],"# Mackay");	L2X[813]=2418; L2Y[813]=881;
	strcpy(L2[814],"# Rockhamption"); L2X[814]=2424;	L2Y[814]=898;
	strcpy(L2[815],"# Bundaberg");	L2X[815]=2435; L2Y[815]=914;
strcpy(L2[816],"Toowoomba #");		L2X[816]=2429-(StrLenB11(L2[816])*.5); L2Y[816]=932;
	strcpy(L2[817],"#");	 L2X[817]=2433; L2Y[817]=937;
	strcpy(L2[818],"Southport");  L2X[818]=2435; L2Y[818]=940;
	strcpy(L2[819],"# Newcastle");	L2X[819]=2404; L2Y[819]=981;
strcpy(L2[820],"Wollongong #");	  L2X[820]=2395-(StrLenB11(L2[820])*.5); L2Y[820]=992;
	strcpy(L2[821],"# Bourke");	L2X[821]=2371; L2Y[821]=956;
strcpy(L2[822],"Weipa #");	 L2X[822]=2378-(StrLenB11(L2[822])*.5); L2Y[822]=802;
	strcpy(L2[823],"# Katherine");	L2X[823]=2299; L2Y[823]=823;
	strcpy(L2[824],"# Mount Isa");	L2X[824]=2352; L2Y[824]=878;
	strcpy(L2[825],"# Longreach");	L2X[825]=2370; L2Y[825]=900;
	strcpy(L2[826],"# Broome");	L2X[826]=2222; L2Y[826]=853;
	strcpy(L2[827],"# Port Hedland"); L2X[827]=2184; L2Y[827]=875;
strcpy(L2[828],"Dampier #");	  L2X[828]=2174-(StrLenB11(L2[828])*.5); L2Y[828]=877;
	strcpy(L2[829],"# Newman");	L2X[829]=2194; L2Y[829]=897;
	strcpy(L2[830],"# Carnarvon");	L2X[830]=2147; L2Y[830]=911;
	strcpy(L2[831],"# Charleville"); L2X[831]=2380; L2Y[831]=919;
	strcpy(L2[832],"# Kalgoorlie-Boulder"); L2X[832]=2188; L2Y[832]=959;
strcpy(L2[833],"Geraldton #");		L2X[833]=2150-(StrLenB11(L2[833])*.5); L2Y[833]=950;
	strcpy(L2[834],"# Bunbury");  L2X[834]=2142; L2Y[834]=986;
	strcpy(L2[835],"# Albany");	L2X[835]=2153; L2Y[835]=999;
	strcpy(L2[836],"# Esperance");  L2X[836]=2182;  L2Y[836]=989;
strcpy(L2[837],"Whyalla #");	  L2X[837]=2300-(StrLenB11(L2[837])*.5); L2Y[837]=983;
strcpy(L2[838],"Coober Pedy #"); L2X[838]=2290-(StrLenB11(L2[838])*.5); L2Y[838]=950;
strcpy(L2[839],"Woomera #");	  L2X[839]=2303-(StrLenB11(L2[839])*.5); L2Y[839]=968;
strcpy(L2[840],"Tamworth #");	 L2X[840]=2408-(StrLenB11(L2[840])*.5); L2Y[840]=965;
strcpy(L2[841],"Orange #");		L2X[841]=2388-(StrLenB11(L2[841])*.5); L2Y[841]=985;
strcpy(L2[842],"Wagga Wagga #"); L2X[842]=2373-(StrLenB11(L2[842])*.5); L2Y[842]=999;
strcpy(L2[843],"Albury #");		L2X[843]=2371-(StrLenB11(L2[843])*.5); L2Y[843]=1007;
strcpy(L2[844],"Port Lincoln #");	L2X[844]=2285-(StrLenB11(L2[844])*.5); L2Y[844]=996;
strcpy(L2[845],"Geelong #");	  L2X[845]=2328-(StrLenB11(L2[845])*.5); L2Y[845]=1028;
strcpy(L2[846],"Ballarat #");	 L2X[846]=2335-(StrLenB11(L2[846])*.5); L2Y[846]=1021;
strcpy(L2[847],"Bendigo #");	  L2X[847]=2345-(StrLenB11(L2[847])*.5); L2Y[847]=1012;
strcpy(L2[848],"Hannover  ");	 L2X[848]=1377-(StrLenB11(L2[848])*.5); L2Y[848]=245;
	strcpy(L2[849],"#"); L2X[849]=1373; L2Y[849]=248;
strcpy(L2[849],"Sorong #");		L2X[849]=2307-(StrLenB11(L2[848])*.5); L2Y[849]=704;
	strcpy(L2[850],"# Jayapura"); L2X[850]=2368; L2Y[850]=718;
	strcpy(L2[851],"# Madang");	L2X[851]=2411; L2Y[851]=743;
strcpy(L2[852],"Lae #");		L2X[852]=2422-(StrLenB11(L2[852])*.5); L2Y[852]=755;
	strcpy(L2[853],"# Manado");	L2X[853]=2252; L2Y[853]=684;
	strcpy(L2[854],"# Merauke");  L2X[854]=2369; L2Y[854]=768;
	strcpy(L2[855],"# Banjarmasin"); L2X[855]=2175; L2Y[855]=727;
strcpy(L2[856],"Milwaukee #");		L2X[856]=698-(StrLenB11(L2[856])*.5); L2Y[856]=324;
strcpy(L2[857],"Kansas City #"); L2X[857]=633-(StrLenB11(L2[857])*.5); L2Y[857]=357;
strcpy(L2[858],"Charlette #");		L2X[858]=713-(StrLenB11(L2[858])*.5); L2Y[858]=393;
strcpy(L2[859],"Spokane #");	  L2X[859]=514-(StrLenB11(L2[859])*.5); L2Y[859]=292;
	strcpy(L2[860],"# Tucsan");	L2X[860]=496;  L2Y[860]=417;
strcpy(L2[861],"Brandon #");	  L2X[861]=641-(StrLenB11(L2[861])*.5); L2Y[861]=262;
strcpy(L2[862],"Nashville #");		L2X[862]=704-(StrLenB11(L2[862])*.5); L2Y[862]=382;
	strcpy(L2[863],"# Boise"); L2X[863]=502;  L2Y[863]=325;
	strcpy(L2[864],"# Omaha"); L2X[864]=630;  L2Y[864]=339;
strcpy(L2[865],"Birmingham #");  L2X[865]=674-(StrLenB11(L2[865])*.5); L2Y[865]=411;
	strcpy(L2[866],"  (Timbuktu)");	  L2X[866]=1274; L2Y[866]=556;
	strcpy(L2[867],"$ Mt. McKinley 20,320"); L2X[867]=420;	L2Y[867]=158;
strcpy(L2[868],"Mt. Rainier 14,410 $");	L2X[868]=480-(StrLenB11(L2[868])*.5); L2Y[868]=295;
	strcpy(L2[869],"#");	 L2X[869]=446;  L2Y[869]=382;
strcpy(L2[870],"Fresno");  L2X[870]=450-(StrLenB11(L2[870])*.5); L2Y[870]=386;
	strcpy(L2[871],"$");	 L2X[871]=455;  L2Y[871]=386;
	strcpy(L2[872],"Mt. Whitney 14,494");  L2X[872]=459;  L2Y[872]=381;
	strcpy(L2[873],"$ Kilimanjaro 19,340"); L2X[873]=1582;	L2Y[873]=721;
	strcpy(L2[874],"$ Mt.");		L2X[874]=1942; L2Y[874]=453;
	strcpy(L2[875],"Everest");	 L2X[875]=1942; L2Y[875]=460;
	strcpy(L2[876],"29,035");	  L2X[876]=1942; L2Y[876]=467;
	strcpy(L2[877],"$ K2 28,250");		L2X[877]=1852; L2Y[877]=386;
	strcpy(L2[878],"#");		 L2X[878]=2307; L2Y[878]=393;
	strcpy(L2[879],"Yokohama");		L2X[879]=2309; L2Y[879]=397;
strcpy(L2[880],"Kyoto #");	 L2X[880]=2281-(StrLenB11(L2[880])*.5); L2Y[880]=389;
	strcpy(L2[881],"$");		 L2X[881]=2302; L2Y[881]=390;
	strcpy(L2[882],"Mt. Fuji 12,388");  L2X[882]=2303; L2Y[882]=382;
strcpy(L2[883],"Nagasaki #");	 L2X[883]=2254-(StrLenB11(L2[883])*.5); L2Y[883]=410;
strcpy(L2[884],"Ayers Rock (Uluru) 2,844 $");	L2X[884]=2273-(StrLenB11(L2[884])*.5); L2Y[884]=913;
	strcpy(L2[885],"$ Mt. Kosciusko 7,310");  L2X[885]=2371; L2Y[885]=1009;
strcpy(L2[886],"Mt. Cook 12,349 $");	L2X[886]=2480-(StrLenB11(L2[886])*.5); L2Y[886]=1078;
strcpy(L2[887],"Mt. Wilhelm 14,793 $");	L2X[887]=2398-(StrLenB11(L2[887])*.5); L2Y[887]=743;
strcpy(L2[888],"Puncak Jaya 16,500 $");	L2X[888]=2347-(StrLenB11(L2[888])*.5); L2Y[888]=726;
	strcpy(L2[889],"#");		 L2X[889]=2258; L2Y[889]=400;
strcpy(L2[890],"Hiroshima  ");	L2X[890]=2262-(StrLenB11(L2[890])*.5); L2Y[890]=397;
	strcpy(L2[891],"$ Etna 11,053"); L2X[891]=1411; L2Y[891]=370;
	strcpy(L2[892],"#");		 L2X[892]=1406; L2Y[892]=343;
	strcpy(L2[893],"Naples");	  L2X[893]=1390; L2Y[893]=346;
	strcpy(L2[894],"$");		 L2X[894]=1410; L2Y[894]=344;
	strcpy(L2[895],"Vesuvius");		L2X[895]=1412; L2Y[895]=351;
	strcpy(L2[896],"4,202");		L2X[896]=1412; L2Y[896]=357;
strcpy(L2[897],"Haugesund #");	L2X[897]=1349-(StrLenB11(L2[897])*.5); L2Y[897]=187;
strcpy(L2[898],"Molde #");		 L2X[898]=1368-(StrLenB11(L2[898])*.5); L2Y[898]=157;
strcpy(L2[899],"Kristiansand #");	L2X[899]=1363-(StrLenB11(L2[899])*.5); L2Y[899]=198;
	strcpy(L2[900],"# Vardo");	 L2X[900]=1486; L2Y[900]=105;
	strcpy(L2[901],"# Ivalo");	 L2X[901]=1472; L2Y[901]=120;
	strcpy(L2[902],"# Ouki");	  L2X[902]=1465; L2Y[902]=144;
	strcpy(L2[903],"# Pori");	  L2X[903]=1445; L2Y[903]=170;
	strcpy(L2[904],"# Malmo");	 L2X[904]=1394; L2Y[904]=216;
	strcpy(L2[905],"# Tromso");		L2X[905]=1427; L2Y[905]=110;

	strcpy(L2[906],"# Moron");	 L2X[906]=1975; L2Y[906]=266;
strcpy(L2[907],"Choybalsan #");	  L2X[907]=2084-(StrLenB11(L2[907])*.5); L2Y[907]=283;
	strcpy(L2[908],"# Atyrau");		L2X[908]=1660; L2Y[908]=290;
strcpy(L2[909],"Brest #");	 L2X[909]=1279-(StrLenB11(L2[909])*.5); L2Y[909]=279;
strcpy(L2[910],"Port Sudan #");	  L2X[910]=1581-(StrLenB11(L2[910])*.5); L2Y[910]=527;
	strcpy(L2[911],"#");	 L2X[911]=1599; L2Y[911]=750;
	strcpy(L2[912],"Zanzibar");		L2X[912]=1604; L2Y[912]=747;

	EndL2List=912;

/* black 13-point */
	strcpy(L1[0],"AFGHANISTAN");	  L1X[0]=1760;	L1Y[0]=405;
	strcpy(L1[1],"ALBANIA");		L1X[1]=1424;	L1Y[1]=332;
	strcpy(L1[2],"ANDORRA");		L1X[2]=1295;	L1Y[2]=329;
	strcpy(L1[3],"HUNGARY");		L1X[3]=1424;	L1Y[3]=293;
	strcpy(L1[4],"Tasmania");	  L1X[4]=2335;	L1Y[4]=1059;
	strcpy(L1[5],"ARMENIA");		L1X[5]=1602;	L1Y[5]=343;
	strcpy(L1[6],"AUSTRIA");		L1X[6]=1405;	L1Y[6]=286;
	strcpy(L1[7],"AZERBAIJAN");		L1X[7]=1638;	L1Y[7]=340;
	strcpy(L1[8],"THE BAHAMAS");	  L1X[8]=732; L1Y[8]=470;
	strcpy(L1[9],"BAHRAIN");		L1X[9]=1646;	L1Y[9]=461;
	strcpy(L1[10],"BANGLADESH");	  L1X[10]=1947;  L1Y[10]=482;
	strcpy(L1[11],"BELARUS");	  L1X[11]=1475;  L1Y[11]=239;
	strcpy(L1[12],"BELGIUM");	  L1X[12]=1319;  L1Y[12]=264;
	strcpy(L1[13],"BELIZE");		L1X[13]=635;	L1Y[13]=540;
	strcpy(L1[14],"BENIN");		 L1X[14]=1310;  L1Y[14]=606;
	strcpy(L1[15],"BHUTAN");		L1X[15]=1965;  L1Y[15]=452;
	strcpy(L1[16],"BOTSWANA");	 L1X[16]=1467;  L1Y[16]=877;
	strcpy(L1[17],"BRUNEI");		L1X[17]=2156;  L1Y[17]=654;
	strcpy(L1[18],"BULGARIA");	 L1X[18]=1491;  L1Y[18]=324;
	strcpy(L1[19],"BURKINA FASO");		L1X[19]=1272;  L1Y[19]=582;
	strcpy(L1[20],"BURUNDI");	  L1X[20]=1529;  L1Y[20]=736;
	strcpy(L1[21],"CAMBODIA");	 L1X[21]=2083;  L1Y[21]=584;
	strcpy(L1[22],"CAMEROON");	 L1X[22]=1373;  L1Y[22]=652;
	strcpy(L1[23],"CAPE VERDE");	  L1X[23]=1089;  L1Y[23]=558;
	strcpy(L1[24],"CENTRAL");	  L1X[24]=1441;  L1Y[24]=633;
	strcpy(L1[25],"AFRICAN REPUBLIC");  L1X[25]=1430;  L1Y[25]=641;
	strcpy(L1[27],"COMOROS");	  L1X[27]=1632;  L1Y[27]=803;
	strcpy(L1[28],"REP. OF");	  L1X[28]=1412;  L1Y[28]=692;
	strcpy(L1[29],"THE");			L1X[29]=1416;  L1Y[29]=700;
	strcpy(L1[30],"CONGO");		 L1X[30]=1412;  L1Y[30]=708;
	strcpy(L1[31],"DEMOCRATIC");	  L1X[31]=1447;  L1Y[31]=700;
	strcpy(L1[32],"REPUBLIC");	 L1X[32]=1452;  L1Y[32]=708;
	strcpy(L1[33],"OF THE CONGO");		L1X[33]=1445;  L1Y[33]=716;
	strcpy(L1[34],"COSTA RICA");	  L1X[34]=629;	L1Y[34]=617;
	strcpy(L1[35],"COTE");		  L1X[35]=1254;  L1Y[35]=617;
	strcpy(L1[36],"D'IVOIRE");	 L1X[36]=1251;  L1Y[36]=625;
	strcpy(L1[38],"CUBA");		  L1X[38]=711;	L1Y[38]=500;
	strcpy(L1[39],"CYPRUS");		L1X[39]=1520;  L1Y[39]=398;
	strcpy(L1[40],"CZECH REP.");	  L1X[40]=1399;  L1Y[40]=272;
	strcpy(L1[41],"DENMARK");	  L1X[41]=1361;  L1Y[41]=211;
	strcpy(L1[42],"DJIBOUTI");	 L1X[42]=1628;  L1Y[42]=588;
	strcpy(L1[43],"French Southern and Antarctic Lands");	 L1X[43]=1693;  L1Y[43]=1064;
	strcpy(L1[44],"EAST TIMOR");	  L1X[44]=2257;  L1Y[44]=778;
	strcpy(L1[45],"EL SALVAVOR");	 L1X[45]=598;	L1Y[45]=584;
	strcpy(L1[46],"EQUATORIAL GUINEA"); L1X[46]=1328;  L1Y[46]=678;
	strcpy(L1[47],"South Island");		L1X[47]=2482;  L1Y[47]=1087;
	strcpy(L1[48],"GABON");		 L1X[48]=1378;  L1Y[48]=704;
	strcpy(L1[49],"THE GAMBIA");	  L1X[49]=1132;  L1Y[49]=586;
	strcpy(L1[50],"GEORGIA");	  L1X[50]=1579;  L1Y[50]=327;
	strcpy(L1[51],"TURKMENISTAN");		L1X[51]=1695;  L1Y[51]=354;
	strcpy(L1[52],"GHANA");		 L1X[52]=1283;  L1Y[52]=626;
	strcpy(L1[53],"GREECE");		L1X[53]=1447;  L1Y[53]=360;
	strcpy(L1[54],"GUATAMALA");		L1X[54]=587;	L1Y[54]=562;
	strcpy(L1[55],"GUINEA");		L1X[55]=1203;  L1Y[55]=603;
	strcpy(L1[56],"GUINEA-BISSAU");	  L1X[56]=1136;  L1Y[56]=603;
	strcpy(L1[57],"GUYANA");		L1X[57]=838;	L1Y[57]=646;
	strcpy(L1[58],"HAITI");		 L1X[58]=745;	L1Y[58]=527;
	strcpy(L1[59],"HONDURAS");		 L1X[59]=635;	L1Y[59]=562;
	strcpy(L1[60],"HUNGARY");	  L1X[60]=1424;  L1Y[60]=293;
	strcpy(L1[61],"IRELAND");	  L1X[61]=1236;  L1Y[61]=228;
	strcpy(L1[62],"ISRAEL");		L1X[62]=1542;  L1Y[62]=411;
	strcpy(L1[63],"ITALY");		 L1X[63]=1383;  L1Y[63]=323;
	strcpy(L1[64],"JAMAICA");	  L1X[64]=693;	L1Y[64]=542;
	strcpy(L1[65],"JORDAN");		L1X[65]=1563;  L1Y[65]=432;
	strcpy(L1[66],"NORTH KOREA");		 L1X[66]=2191;  L1Y[66]=347;
	strcpy(L1[67],"SOUTH KOREA");		 L1X[67]=2211;  L1Y[67]=380;
	strcpy(L1[68],"INDIA");		 L1X[68]=1976;  L1Y[68]=474;
	strcpy(L1[69],"KYRGYZSTAN");	  L1X[69]=1820;  L1Y[69]=339;
	strcpy(L1[70],"LAOS");		  L1X[70]=2060;  L1Y[70]=520;
	strcpy(L1[71],"LATVIA");		L1X[71]=1472;  L1Y[71]=208;
	strcpy(L1[72],"LEBANON");	  L1X[72]=1545;  L1Y[72]=397;
	strcpy(L1[73],"LESOTHO");	  L1X[73]=1498;  L1Y[73]=942;
	strcpy(L1[74],"LIBERIA");	  L1X[74]=1214;  L1Y[74]=651;
	strcpy(L1[75],"SENEGAL");	  L1X[75]=1175;  L1Y[75]=569;
	strcpy(L1[76],"LITHUANIA");		L1X[76]=1457;  L1Y[76]=217;
	strcpy(L1[77],"SAMOA");		 L1X[77]=2710;  L1Y[77]=805;
	strcpy(L1[78],"MACEDONIA");		L1X[78]=1451;  L1Y[78]=340;
	strcpy(L1[79],"MALAWI");		L1X[79]=1565;  L1Y[79]=823;
	strcpy(L1[80],"MALTA");		 L1X[80]=1389;  L1Y[80]=384;
	strcpy(L1[81],"MAURITIUS");		L1X[81]=1734;  L1Y[81]=878;
	strcpy(L1[82],"FEDERATED STATES OF MICRONESIA"); L1X[82]=2378;	 L1Y[82]=611;
	strcpy(L1[83],"ESTONIA");	  L1X[83]=1469;  L1Y[83]=195;
	strcpy(L1[84],"MOLDOVA");	  L1X[84]=1494;  L1Y[84]=283;
	strcpy(L1[85],"--MONACO");	 L1X[85]=1356;  L1Y[85]=319;
	strcpy(L1[86],"NAURU");		 L1X[86]=2580;  L1Y[86]=703;
	strcpy(L1[87],"NAPAL");		 L1X[87]=1902;  L1Y[87]=447;
	strcpy(L1[88],"NETHERLANDS");	 L1X[88]=1329;  L1Y[88]=237;
	strcpy(L1[89],"NICARAGUA");		L1X[89]=649;	L1Y[89]=585;
	strcpy(L1[90],"North Island");		L1X[90]=2552;  L1Y[90]=1045;
	strcpy(L1[91],"PANAMA");		L1X[91]=676;	L1Y[91]=628;
	strcpy(L1[92],"QATAR");		 L1X[92]=1665;  L1Y[92]=479;
	strcpy(L1[93],"ROMANIA");	  L1X[93]=1462;  L1Y[93]=295;
	strcpy(L1[94],"RWANDA");		L1X[94]=1505;  L1Y[94]=711;
	strcpy(L1[95],"SEYCHELLES");	  L1X[95]=1674;  L1Y[95]=766;
	strcpy(L1[96],"SOLOMON ISLANDS");	L1X[96]=2500;  L1Y[96]=750;
	strcpy(L1[97],"SRI LANKA");		L1X[97]=1917;  L1Y[97]=643;
	strcpy(L1[98],"SURINAME");		 L1X[98]=863;	L1Y[98]=666;
	strcpy(L1[99],"SWAZILAND");		L1X[99]=1531;  L1Y[99]=934;
	strcpy(L1[100],"TAJIKISTAN");		 L1X[100]=1798;	 L1Y[100]=356;
	strcpy(L1[101],"UZBEKISTAN");		 L1X[101]=1726;	 L1Y[101]=328;
	strcpy(L1[102],"French Guiana");	 L1X[102]=892;  L1Y[102]=667;
	strcpy(L1[103],"SIERRA LEONE");	  L1X[103]=1176; L1Y[103]=631;
	strcpy(L1[104],"TAKLA MAKAN");		L1X[104]=1872; L1Y[104]=350;
	strcpy(L1[105],"DESERT");	  L1X[105]=1876; L1Y[105]=358;
	strcpy(L1[106],"ERITREA");		 L1X[106]=1582; L1Y[106]=554;
	strcpy(L1[107],"UNITED");	  L1X[107]=1294; L1Y[107]=218;
	strcpy(L1[108],"KINGDOM");		 L1X[108]=1299; L1Y[108]=226;
	strcpy(L1[109],"GERMANY");	 L1X[109]=1383; L1Y[109]=252;
	strcpy(L1[110],"F r e n c h  P o l y n e s i a"); L1X[110]=180;	L1Y[110]=866;
	strcpy(L1[111],"S a i n t  H e l e n a");	 L1X[111]=1220; L1Y[111]=923;
	strcpy(L1[112],"South Shetland");	L1X[112]=896;  L1Y[112]=1256;
	strcpy(L1[113],"		 Islands");	L1X[113]=896;  L1Y[113]=1266;
	strcpy(L1[114],"DOMINICAN");	  L1X[114]=762;  L1Y[114]=519;
	strcpy(L1[115],"REP.");		 L1X[115]=766;  L1Y[115]=527;

	EndL1List=115;

/* black 24-point */
	strcpy(L3[0],"A L G E R I A");	L3X[0]=1293;	L3Y[0]=448;
	strcpy(L3[1],"A U S T R A L I A"); L3X[1]=2249; L3Y[1]=871;
	strcpy(L3[2],"B R A Z I L");  L3X[2]=885; L3Y[2]=779;
	strcpy(L3[3],"C A N A D A");  L3X[3]=625; L3Y[3]=211;
	strcpy(L3[4],"C H A D");	L3X[4]=1430;	L3Y[4]=562;
	strcpy(L3[5],"C H I N A"); L3X[5]=2019;	L3Y[5]=393;
	strcpy(L3[6],"E G Y P T"); L3X[6]=1503;	L3Y[6]=466;
	strcpy(L3[7],"I N D I A");	 L3X[7]=1876;	L3Y[7]=521;
	strcpy(L3[8],"I	 N	 D	 O	 N	 E	 S	 I	 A"); L3X[8]=2103; L3Y[8]=713;
	strcpy(L3[9],"KAZAKHSTAN");	L3X[9]=1715;	L3Y[9]=277;
	strcpy(L3[10],"L I B Y A");	L3X[10]=1404;  L3Y[10]=456;
	strcpy(L3[11],"S U D A N");	L3X[11]=1506;  L3Y[11]=578;
	strcpy(L3[12],"M A L I");  L3X[12]=1273;  L3Y[12]=534;
	strcpy(L3[13],"M O N G O L I A"); L3X[13]=1978; L3Y[13]=296;
	strcpy(L3[14],"N I G E R");	L3X[14]=1347;  L3Y[14]=551;
	strcpy(L3[15],"PHILIPPINES");	 L3X[15]=2246;  L3Y[15]=583;
	strcpy(L3[16],"R		 U		 S		 S		 I		 A");	 L3X[16]=1700;  L3Y[16]=169;
	strcpy(L3[17],"SAUDI");	 L3X[17]=1598;  L3Y[17]=463;
	strcpy(L3[18],"ARABIA");	L3X[18]=1626;  L3Y[18]=497;
	strcpy(L3[19],"ANGOLA");	L3X[19]=1423;  L3Y[19]=801;
	strcpy(L3[20],"U N I T E D"); L3X[20]=570;	L3Y[20]=310;
	strcpy(L3[21],"S T A T E S"); L3X[21]=568;	L3Y[21]=326;

	EndL3List=21;

/* black 18-point */
	strcpy(L4[0],"ARGENTINA");	 L4X[0]=829; L4Y[0]=1008;
	strcpy(L4[1],"BOLIVIA");	L4X[1]=814; L4Y[1]=841;
	strcpy(L4[2],"CHILE");	  L4X[2]=761; L4Y[2]=966;
	strcpy(L4[3],"ETHIOPIA");  L4X[3]=1587;	L4Y[3]=632;
	strcpy(L4[4],"FINLAND");	L4X[4]=1460;	L4Y[4]=162;
	strcpy(L4[5],"FRANCE");	 L4X[5]=1308;	L4Y[5]=283;
	strcpy(L4[6],"I R A N");	L4X[6]=1686;	L4Y[6]=419;
	strcpy(L4[7],"IRAQ");		L4X[7]=1604;	L4Y[7]=400;
	strcpy(L4[8],"JAPAN");	  L4X[8]=2272;	L4Y[8]=379;
	strcpy(L4[9],"MADAGASCAR");	L4X[9]=1641;	L4Y[9]=843;
	strcpy(L4[10],"MAURITANIA");  L4X[10]=1185;  L4Y[10]=528;
	strcpy(L4[11],"MEXICO");	L4X[11]=521;	L4Y[11]=495;
	strcpy(L4[12],"MOROCCO");  L4X[12]=1213;  L4Y[12]=428;
	strcpy(L4[13],"MOZAMBIQUE");  L4X[13]=1554;  L4Y[13]=868;
	strcpy(L4[14],"BURMA");	 L4X[14]=2006;  L4Y[14]=509;
	strcpy(L4[15],"NAMIBIA");  L4X[15]=1412;  L4Y[15]=868;
	strcpy(L4[16],"NEW");		L4X[16]=2476;  L4Y[16]=1049;
	strcpy(L4[17],"ZEALAND");  L4X[17]=2470;  L4Y[17]=1063;
	strcpy(L4[18],"NIGERIA");  L4X[18]=1343;  L4Y[18]=603;
	strcpy(L4[19],"NORWAY");	L4X[19]=1360;  L4Y[19]=135;
	strcpy(L4[20],"OMAN");	  L4X[20]=1721;  L4Y[20]=513;
	strcpy(L4[21],"PAKISTAN");	 L4X[21]=1773;  L4Y[21]=452;
	strcpy(L4[22],"PALAU");	 L4X[22]=2326;  L4Y[22]=645;
	strcpy(L4[23],"PAPUA NEW GUINEA"); L4X[23]=2381;	L4Y[23]=731;
	strcpy(L4[24],"PERU");	  L4X[24]=700;	L4Y[24]=757;
	strcpy(L4[25],"PORTUGAL");	 L4X[25]=1213;  L4Y[25]=350;
	strcpy(L4[26],"SOMALIA");  L4X[26]=1654;  L4Y[26]=648;
	strcpy(L4[27],"TANZANIA");	 L4X[27]=1544;  L4Y[27]=762;
	strcpy(L4[28],"THAILAND");	 L4X[28]=2052;  L4Y[28]=553;
	strcpy(L4[29],"TONGA");	 L4X[29]=2693;  L4Y[29]=890;
	strcpy(L4[30],"TURKEY");	L4X[30]=1531;  L4Y[30]=359;
	strcpy(L4[31],"SPAIN");	 L4X[31]=1266;  L4Y[31]=359;
	strcpy(L4[32],"SWEDEN");	L4X[32]=1404;  L4Y[32]=149;
	strcpy(L4[33],"VENEZUELA");	L4X[33]=778;	L4Y[33]=629;
	strcpy(L4[34],"Western Sahara"); L4X[34]=1132;  L4Y[34]=478;
	strcpy(L4[35],"YEMEN");	 L4X[35]=1662;  L4Y[35]=558;
	strcpy(L4[36],"COLOMBIA"); L4X[36]=728;	L4Y[36]=670;
	strcpy(L4[37],"ECUADOR");  L4X[37]=685;	L4Y[37]=706;
	strcpy(L4[38],"UKRAINE");  L4X[38]=1499;  L4Y[38]=272;
	strcpy(L4[39],"Greenland");	L4X[39]=1079;  L4Y[39]=76;
	strcpy(L4[40],"SOUTH");	 L4X[40]=1453;  L4Y[40]=953;
	strcpy(L4[41],"AFRICA");	L4X[41]=1452;  L4Y[41]=967;
	strcpy(L4[42],"ICELAND");  L4X[42]=1199;  L4Y[42]=144;
	strcpy(L4[43],"KENYA");	 L4X[43]=1577;  L4Y[43]=690;
	strcpy(L4[44],"M  A  L  A  Y  S  I  A"); L4X[44]=2081;	L4Y[44]=665;
	strcpy(L4[45],"MALDIVES");	 L4X[45]=1812;  L4Y[45]=667;
	strcpy(L4[46],"MARSHALL");	 L4X[46]=2602;  L4Y[46]=599;
	strcpy(L4[47],"ISLANDS");  L4X[47]=2602;  L4Y[47]=613;
	strcpy(L4[48],"PARAGUAY");	 L4X[48]=840;	L4Y[48]=888;
	strcpy(L4[49],"POLAND");	L4X[49]=1423;  L4Y[49]=236;
	strcpy(L4[50],"SYRIA");	 L4X[50]=1571;  L4Y[50]=392;
	strcpy(L4[51],"TAIWAN");	L4X[51]=2203;  L4Y[51]=500;
	strcpy(L4[52],"TUNISIA");  L4X[52]=1367;  L4Y[52]=393;
	strcpy(L4[53],"K I R I B A T I"); L4X[53]=2649; L4Y[53]=714;
	strcpy(L4[54],"K I R I B A T I"); L4X[54]=49;	L4Y[54]=760;
	strcpy(L4[55],"TUVALU");	L4X[55]=2633;  L4Y[55]=778;
	strcpy(L4[56],"UGANDA");	L4X[56]=1537;  L4Y[56]=679;
	strcpy(L4[57],"Queen Elizabeth"); L4X[57]=805;  L4Y[57]=47;
	strcpy(L4[58],"Islands");  L4X[58]=819;	L4Y[58]=61;
	strcpy(L4[59],"URUGUAY");  L4X[59]=888;	L4Y[59]=983;
	strcpy(L4[60],"VANUATU");  L4X[60]=2573;  L4Y[60]=839;
	strcpy(L4[61],"VIETNAM");  L4X[61]=2119;  L4Y[61]=566;
	strcpy(L4[62],"ZAMBIA");	L4X[62]=1486;  L4Y[62]=818;
	strcpy(L4[63],"ZIMBABWE"); L4X[63]=1503;  L4Y[63]=862;
	strcpy(L4[64],"FIJI");	  L4X[64]=2626;  L4Y[64]=835;

	EndL4List=64;

/* light blue 24-point */
	strcpy(L5[0],"NORTH");		  L5X[0]=903; L5Y[0]=376;
	strcpy(L5[1],"ATLANTIC");	  L5X[1]=900; L5Y[1]=395;
	strcpy(L5[2],"OCEAN");		  L5X[2]=903; L5Y[2]=414;
	strcpy(L5[3],"SOUTH");		  L5X[3]=1161;	L5Y[3]=819;
	strcpy(L5[4],"ATLANTIC");	  L5X[4]=1158;	L5Y[4]=838;
	strcpy(L5[5],"OCEAN");		  L5X[5]=1161;	L5Y[5]=857;
	strcpy(L5[6],"ARCTIC OCEAN");	 L5X[6]=694; L5Y[6]=23;
	strcpy(L5[7],"ARCTIC OCEAN");	 L5X[7]=1293;	L5Y[7]=23;
	strcpy(L5[8],"ARCTIC OCEAN");	 L5X[8]=2039;	L5Y[8]=23;
	strcpy(L5[9],"NORTH");		  L5X[9]=297; L5Y[9]=328;
	strcpy(L5[10],"PACIFIC");	  L5X[10]=287;	L5Y[10]=347;
	strcpy(L5[11],"OCEAN");		 L5X[11]=277;	L5Y[11]=366;
	strcpy(L5[12],"SOUTH");		 L5X[12]=360;	L5Y[12]=825;
	strcpy(L5[13],"PACIFIC");	  L5X[13]=363;	L5Y[13]=844;
	strcpy(L5[14],"OCEAN");		 L5X[14]=366;	L5Y[14]=863;
	strcpy(L5[15],"INDIAN");		L5X[15]=1870;  L5Y[15]=817;
	strcpy(L5[16],"OCEAN");		 L5X[16]=1870;  L5Y[16]=839;
	strcpy(L5[17],"SOUTHERN OCEAN"); L5X[17]=649;	L5Y[17]=1238;
	strcpy(L5[18],"SOUTHERN OCEAN"); L5X[18]=1352;  L5Y[18]=1238;
	strcpy(L5[19],"SOUTHERN OCEAN"); L5X[19]=2067;  L5Y[19]=1226;
	strcpy(L5[20],"NORTH");		 L5X[20]=2456;  L5Y[20]=338;
	strcpy(L5[21],"PACIFIC");	  L5X[21]=2470;  L5Y[21]=357;
	strcpy(L5[22],"OCEAN");		 L5X[22]=2484;  L5Y[22]=376;
	strcpy(L5[23],"SOUTH");		 L5X[23]=2598;  L5Y[23]=920;
	strcpy(L5[24],"PACIFIC");	  L5X[24]=2591;  L5Y[24]=939;
	strcpy(L5[25],"OCEAN");		 L5X[25]=2584;  L5Y[25]=958;

	EndL5List=25;

/* light blue 13-point */
	strcpy(L6[0],"Tropic of Cancer");	L6X[0]=251; L6Y[0]=486;
	strcpy(L6[1],"Tropic of Cancer");	L6X[1]=2507;	L6Y[1]=486;
	strcpy(L6[2],"Tropic of Cancer");	L6X[2]=917; L6Y[2]=486;
	strcpy(L6[3],"Equator");		L6X[3]=203; L6Y[3]=689;
	strcpy(L6[4],"Equator");		L6X[4]=1186;	L6Y[4]=689;
	strcpy(L6[5],"Equator");		L6X[5]=1885;	L6Y[5]=689;
	strcpy(L6[6],"Equator");		L6X[6]=2542;	L6Y[6]=689;
	strcpy(L6[7],"Tropic of Capricorn");	L6X[7]=333; L6Y[7]=891;
	strcpy(L6[8],"Tropic of Capricorn");	L6X[8]=2014;	L6Y[8]=891;
	strcpy(L6[9],"Tropic of Capricorn");	L6X[9]=1137;	L6Y[9]=891;
	strcpy(L6[10],"Antarctic Circle");  L6X[10]=503;	L6Y[10]=1253;
	strcpy(L6[11],"Antarctic Circle");  L6X[11]=2217;  L6Y[11]=1253;
	strcpy(L6[12],"Bermuda");	  L6X[12]=783;	L6Y[12]=451;
	strcpy(L6[13],"Triangle");	 L6X[13]=783;	L6Y[13]=459;

	EndL6List=13;

/* dark blue 13-point */
	strcpy(L7[0],"Hudson Bay");		L7X[0]=772; L7Y[0]=188;
	strcpy(L7[1],"Beaufort Sea");	 L7X[1]=573; L7Y[1]=84;
	strcpy(L7[2],"Mediterranean Sea");  L7X[2]=1424;	L7Y[2]=401;
	strcpy(L7[3],"Black Sea");	 L7X[3]=1524;	L7Y[3]=321;
	strcpy(L7[4],"Baffin Bay");		L7X[4]=957; L7Y[4]=89;
	strcpy(L7[5],"Denmark Strait");	  L7X[5]=1105;	L7Y[5]=151;
	strcpy(L7[6],"North Sea");	 L7X[6]=1316;	L7Y[6]=209;
	strcpy(L7[7],"Bay of");		 L7X[7]=1271;	L7Y[7]=302;
	strcpy(L7[8],"Biscay");		 L7X[8]=1271;	L7Y[8]=310;
	strcpy(L7[9],"Barents Sea");	  L7X[9]=1521;	L7Y[9]=77;
	strcpy(L7[10],"Sea of Okhotsk"); L7X[10]=2224;  L7Y[10]=215;
	strcpy(L7[11],"Caspian");	  L7X[11]=1638;  L7Y[11]=319;
	strcpy(L7[12],"Sea");			L7X[12]=1652;  L7Y[12]=330;
	strcpy(L7[13],"Aral Sea");	 L7X[13]=1719;  L7Y[13]=304;
	strcpy(L7[14],"Bay of");		L7X[14]=1955;  L7Y[14]=552;
	strcpy(L7[15],"Bengal");		L7X[15]=1955;  L7Y[15]=560;
	strcpy(L7[16],"Persian");	  L7X[16]=1672;  L7Y[16]=459;
	strcpy(L7[17],"Gulf");		  L7X[17]=1681;  L7Y[17]=467;
	strcpy(L7[18],"Red");			L7X[18]=1574;  L7Y[18]=493;
	strcpy(L7[19],"Sea");			L7X[19]=1579;  L7Y[19]=501;
	strcpy(L7[20],"Philippine Sea"); L7X[20]=2264;  L7Y[20]=522;
	strcpy(L7[21],"Baltic");		L7X[21]=1422;  L7Y[21]=211;
	strcpy(L7[22],"Sea");			L7X[22]=1424;  L7Y[22]=219;
	strcpy(L7[23],"Gulf of Mexico"); L7X[23]=604;	L7Y[23]=478;
	strcpy(L7[24],"Caribbean Sea");	  L7X[24]=724;	L7Y[24]=570;
	strcpy(L7[25],"Norwegian Sea");	  L7X[25]=1337;  L7Y[25]=106;
	strcpy(L7[26],"Ross Sea");	 L7X[26]=478;	L7Y[26]=1319;
	strcpy(L7[27],"Labrador Sea");		L7X[27]=966;	L7Y[27]=211;
	strcpy(L7[28],"Drake");		 L7X[28]=928;	L7Y[28]=1202;
	strcpy(L7[29],"Passage");	  L7X[29]=928;	L7Y[29]=1210;
	strcpy(L7[30],"Scotia Sea");	  L7X[30]=989;	L7Y[30]=1177;
	strcpy(L7[31],"Greenland Sea");	  L7X[31]=1296;  L7Y[31]=66;
	strcpy(L7[32],"Bering Sea");	  L7X[32]=2416;  L7Y[32]=210;
	strcpy(L7[33],"East Siberian Sea"); L7X[33]=2172;  L7Y[33]=86;
	strcpy(L7[34],"Sea of");		L7X[34]=2251;  L7Y[34]=345;
	strcpy(L7[35],"Japan");		 L7X[35]=2251;  L7Y[35]=353;
	strcpy(L7[36],"Yellow");		L7X[36]=2184;  L7Y[36]=384;
	strcpy(L7[37],"Sea");			L7X[37]=2188;  L7Y[37]=392;
	strcpy(L7[38],"East China Sea"); L7X[38]=2207;  L7Y[38]=442;
	strcpy(L7[39],"South China Sea");	L7X[39]=2142;  L7Y[39]=580;
	strcpy(L7[40],"Celebes Sea");	 L7X[40]=2218;  L7Y[40]=666;
	strcpy(L7[41],"Sulu Sea");	 L7X[41]=2202;  L7Y[41]=624;
	strcpy(L7[42],"Arafura Sea");	 L7X[42]=2314;  L7Y[42]=776;
	strcpy(L7[43],"Timor Sea");		L7X[43]=2254;  L7Y[43]=793;
	strcpy(L7[44],"Great Australian Bight"); L7X[44]=2212;	L7Y[44]=1014;
	strcpy(L7[45],"Tasman Sea");	  L7X[45]=2390;  L7Y[45]=1043;
	strcpy(L7[46],"Ross Sea");	 L7X[46]=2228;  L7Y[46]=1319;
	strcpy(L7[47],"Gulf of Alaska"); L7X[47]=400;	L7Y[47]=194;
	strcpy(L7[48],"Davis Strait");		L7X[48]=968;	L7Y[48]=154;
	strcpy(L7[49],"Weddell Sea");	 L7X[49]=1022;  L7Y[49]=1291;
	strcpy(L7[50],"Gulf of");	  L7X[50]=2344;  L7Y[50]=817;
	strcpy(L7[51],"Carpentaria");	 L7X[51]=2338;  L7Y[51]=825;
	strcpy(L7[52],"Lake Wiinipeg");	  L7X[52]=680;	L7Y[52]=247;
	strcpy(L7[53],"Great Bear Lake");	L7X[53]=639;	L7Y[53]=141;
	strcpy(L7[54],"Great Slave Lake");  L7X[54]=631;	L7Y[54]=178;
	strcpy(L7[55],"Lake Baykal");	 L7X[55]=2016;  L7Y[55]=225;
	strcpy(L7[56],"Lake Superior");	  L7X[56]=664;	L7Y[56]=286;
	strcpy(L7[57],"Lake Michigan");	  L7X[57]=680;	L7Y[57]=307;
	strcpy(L7[58],"Lake Huron");	  L7X[58]=749;	L7Y[58]=294;
	strcpy(L7[59],"Lake Erie");		L7X[59]=732;	L7Y[59]=322;
	strcpy(L7[60],"Lake Ontario");		L7X[60]=763;	L7Y[60]=310;
	strcpy(L7[61],"Great Salt Lake");	L7X[61]=476;	L7Y[61]=335;
	strcpy(L7[62],"Lake Titicaca");	  L7X[62]=776;	L7Y[62]=826;
	strcpy(L7[63],"Gulf of");	  L7X[63]=478;	L7Y[63]=471;
	strcpy(L7[64],"California");	  L7X[64]=475;	L7Y[64]=479;
	strcpy(L7[65],"Gulf of");	  L7X[65]=1424;  L7Y[65]=165;
	strcpy(L7[66],"Bothnia");	  L7X[66]=1424;  L7Y[66]=173;
	strcpy(L7[67],"Arctic Circle");	  L7X[67]=530;	L7Y[67]=128;
	strcpy(L7[68],"Arctic Circle");	  L7X[68]=1270;  L7Y[68]=128;
	strcpy(L7[69],"Arctic Circle");	  L7X[69]=1776;  L7Y[69]=128;
	strcpy(L7[70],"Arctic Circle");	  L7X[70]=2060;  L7Y[70]=128;
	strcpy(L7[71],"Kara Sea");	 L7X[71]=1702;  L7Y[71]=60;
	strcpy(L7[72],"Laptev Sea");	  L7X[72]=1938;  L7Y[72]=60;
	strcpy(L7[73],"Lake Balkhash");	  L7X[73]=1808;  L7Y[73]=288;
	strcpy(L7[74],"Java Sea");	 L7X[74]=2166;  L7Y[74]=745;
	strcpy(L7[75],"Coral Sea");		L7X[75]=2468;  L7Y[75]=822;
	strcpy(L7[76],"Sea of");		L7X[76]=1565;  L7Y[76]=299;
	strcpy(L7[77],"Azov");		  L7X[77]=1565;  L7Y[77]=307;
	strcpy(L7[78],"Amundsen Sea");		L7X[78]=696;	L7Y[78]=1302;
	strcpy(L7[79],"Bellingshausen Sea");	L7X[79]=824;	L7Y[79]=1277;
	strcpy(L7[80],"Ross Ice Shelf"); L7X[80]=2136;  L7Y[80]=1357;
	strcpy(L7[81],"Ross Ice Shelf"); L7X[81]=574;	L7Y[81]=1365;
	strcpy(L7[82],"Ronne Ice Shelf");	L7X[82]=1008;  L7Y[82]=1339;
	strcpy(L7[83],"Amery");		 L7X[83]=1721;  L7Y[83]=1268;
	strcpy(L7[84],"Ice Shelf");		L7X[84]=1718;  L7Y[84]=1276;
	strcpy(L7[85],"Lake Victoria");	  L7X[85]=1554;  L7Y[85]=713;
	strcpy(L7[86],"Arabian");	  L7X[86]=1763;  L7Y[86]=574;
	strcpy(L7[87],"Sea");			L7X[87]=1768;  L7Y[87]=582;
	strcpy(L7[88],"Subic Bay");		L7X[88]=2188;  L7Y[88]=564;
	strcpy(L7[89],"Lake");		  L7X[89]=2318;  L7Y[89]=940;
	strcpy(L7[90],"Eyre");		  L7X[90]=2318;  L7Y[90]=948;
	strcpy(L7[91],"Banda");		 L7X[91]=2266;  L7Y[91]=746;
	strcpy(L7[92]," Sea");		  L7X[92]=2266;  L7Y[92]=754;

	EndL7List=92;

	SetCurrentFile("\\LC24APPS\\WORLDMAP\\WORLDMAP.JPG");
}
int MapMode()
{
	MapInit();
	MapScreen();
	if(MapWindow()==0) { /* If normal, bitmaps were created. */
				  /* If not, destroying causes crash. */
		destroy_bitmap(topo_map);
		destroy_bitmap(worldmap_buf);
	}
	return(0);
}
/* eof */

