/* 12/20/09 */

/* 	Parts.c, contains various graphics elements for LCARS 24,
	including various buttons and their inline digits and symbols.
	PopPutTime() is for use with PopsicleSticks().
	(And min_old must be initialized to 70 in the calling program.
	Otherwise, the time won't be displayed until the next
	minute.)
*/
/* 	Wrapper() provides an imitation of the silvery curved
	stick-on brackets seen on Voyager's large computer
	screens.  The real purpose is to fill the rightmost
	and bottommost screen area with something when an
	800 x 600 version is runnning on a machine with a
	1024 x 768 screen.  The 800 x 600 version must set the
	graphics mode to a 1024 x 768 mode, since machines like
	the Thinkpad make a mess if you use a lower resolution.
	This wrapper exists when running on an 800 x 600 display,
	but the user doesn't see it, and it performs no actual
	function.
*/
/* 	Digits36, just some nice 10 x 36 digits (not scalable)
	So far, only 0-9, and F and O for inline button labels
	1-9, F1-F12, and "OFF," hard-coded to be called directly
	Usage example:
	int F36_1(int x,int y,int ForeColor,int BackColor)
	ForeColor must be a standard LCARS color, with BackColor
	as BLACK (could be vice versa, but isn't LCARS canon).
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include <time.h>
#include "lcars24.h"
#include "parts.h"


LCARSTIME GetTimeStr()
{
	LCARSTIME Result;
	time_t xt;
	struct tm *pt;
	int l_holder, r_holder, Hr;
	unsigned int t;
	int Minutes,Hours,Seconds;

	time(&xt);
	pt=localtime(&xt);
	Minutes=pt->tm_min;
	Hours=pt->tm_hour;
	Seconds=pt->tm_sec;

	strcpy(Result.SecondsStr, "00");
	l_holder=Seconds / 10;
	t=l_holder + 48;
	Result.SecondsStr[0]=(t);
	r_holder=Seconds - (l_holder * 10);
	t=r_holder + 48;
	Result.SecondsStr[1]=(t);

	Hr=Hours;

	if(Hr > 11 ) strcpy(Result.AmPmStr, "P.M.");
		else strcpy(Result.AmPmStr, "A.M.");

	strcpy(Result.MilitaryTimeStr, "00:00");
	strcpy(Result.CivilianTimeStr, "00:00");
	l_holder=Hr / 10;
	t=l_holder + 48;
	Result.MilitaryTimeStr[0]=(t);
	r_holder=Hr - (l_holder * 10);
	t=r_holder + 48;
	Result.MilitaryTimeStr[1]=(t);

	if(Hr > 12) Hr -= 12;
	if(Hr==0) Hr=12;

	l_holder=Hr / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	Result.CivilianTimeStr[0]=(t);

	r_holder=Hr - (l_holder * 10);
	t=r_holder + 48;
	Result.CivilianTimeStr[1]=(t);

	l_holder=Minutes / 10;
	t=l_holder + 48;
	Result.MilitaryTimeStr[3]=(t);
	Result.CivilianTimeStr[3]=(t);

	r_holder=Minutes - (l_holder * 10);
	t=r_holder + 48;
	Result.MilitaryTimeStr[4]=(t);
	Result.CivilianTimeStr[4]=(t);

	Result.Hours=Hours;
	Result.Minutes=Minutes;
	Result.Seconds=Seconds;

	return(Result);
}
int AutorunTimer()
{
	time_t xt;
	struct tm *pt;
	int Seconds;

	if(Autorun==0) return(FALSE);

	time(&xt);
	pt=localtime(&xt);
	Seconds=pt->tm_sec;
	if (TimerOldSec != Seconds ) {
		SecondsCounter++;
		TimerOldSec=Seconds;
	}
	if (SecondsCounter >= Autorun) return(TRUE);
		else return (FALSE);
}

void CheckIdle()
{
	IdleTime++;
/*	if(IdleTime >= IdleLimit) AutoShutdown(); */
	rest(1);
}
void UpdateIdle()
{
	LCARSTIME now;

	now=GetTimeStr();
	if (old_sec != now.Seconds ) CheckIdle();
	old_sec=now.Seconds;
}


int PopPutTime(int stardate_yn) /* 1 = Yes, display the stardate */
{
	LCARSTIME now;

	now=GetTimeStr();
	if(now.Minutes != min_old)
	{
		if(MilitaryTime==0) {
			rectfill(screen,43,560,100,586,BLACK);
			PutsScorpio(47,560,LILAC,now.CivilianTimeStr);
			rectfill(screen,99,560,138,586,BLACK);
			PutsScorpio(100,560,LILAC,now.AmPmStr);
		} else {
			rectfill(screen,43,560,100,586,BLACK);
			PutsScorpio(47,560,LILAC,now.MilitaryTimeStr);
		}
		if(stardate_yn==1) {
			GetStarDate();
			rectfill(screen,600,13,748,39,LILAC);
			PutsLuna(600,20,BLACK,LILAC,"STARDATE:");
			PutsLuna(660,20,BLACK,LILAC,StarDate);
		}
	}
	if (old_sec != now.Seconds ) CheckIdle(); 
	old_sec=now.Seconds;

	min_old=now.Minutes;
	return(now.Minutes);
}
void T24PutTime()
{
	LCARSTIME now;

	if(MonoType != 0) return;
	now=GetTimeStr();
	if(now.Minutes != min_old)
	{
		if(MilitaryTime==0) {
			rectfill(screen,49,561,105,587,BLACK);
			PutsScorpio(53,561,LILAC,now.CivilianTimeStr);
			rectfill(screen,104,561,144,587,BLACK);
			PutsScorpio(105,561,LILAC,now.AmPmStr);
		} else {
			rectfill(screen,49,561,105,587,BLACK);
			PutsScorpio(53,561,LILAC,now.MilitaryTimeStr);
		}
	}
	if (old_sec != now.Seconds ) CheckIdle(); 
	old_sec=now.Seconds;
	min_old=now.Minutes;
}
void PePutTime(int color)
{
	LCARSTIME now;
	char OutputStr[12];

	now=GetTimeStr();
	if(min_old > 60) {
		LeftBumper26(39, 560, color);
		rectfill(screen,122,550,129,586, BLACK);
	}
	if(now.Minutes != min_old)
	{
		if(MilitaryTime==0) {
			strcpy(OutputStr,now.CivilianTimeStr);
			strcat(OutputStr," ");
			strcat(OutputStr,now.AmPmStr);
			rectfill(screen,39,560,122,586,color);
			PutsLuna(122-StrLenLuna(OutputStr)-3,566,BLACK,color,OutputStr);
		} else {
			rectfill(screen,39,560,122,586,color);
			PutsLuna(122-StrLenLuna(now.MilitaryTimeStr)-3,566,BLACK,color,now.MilitaryTimeStr);
		}
	}
	if (old_sec != now.Seconds ) CheckIdle(); 
	old_sec=now.Seconds;
	min_old=now.Minutes;
}
void SolPutTime()
{
	LCARSTIME now;
	char OutputStr[12];

	now=GetTimeStr();
	if(now.Minutes != min_old)
	{
		if(MilitaryTime==0) {
			strcpy(OutputStr,now.CivilianTimeStr);
			strcat(OutputStr," ");
			strcat(OutputStr,now.AmPmStr);
			rectfill(screen,120,42,204,67,BLACK);
			PutsFont21(120,42,BRICK,OutputStr);
		} else {
			rectfill(screen,120,42,204,67,BLACK);
			PutsFont21(120,42,BRICK,now.MilitaryTimeStr);
		}
	}
	if (old_sec != now.Seconds ) CheckIdle(); 
	old_sec=now.Seconds;
	min_old=now.Minutes;
}
void GatesPutTime()
{
	int GATESGRAY;
	LCARSTIME now;
	char OutputStr[12];

	GATESGRAY=makecol(160,160,169);
	now=GetTimeStr();
	if(now.Minutes != min_old)
	{
		if(MilitaryTime==0) {
			strcpy(OutputStr,now.CivilianTimeStr);
			strcat(OutputStr," ");
			strcat(OutputStr,now.AmPmStr);
			rectfill(screen,720,582,795,595,GATESGRAY);
			PutsArial10(screen,720, 582, BLACK,OutputStr);
		} else {
			rectfill(screen,720,582,795,595,GATESGRAY);
			PutsArial10(screen,720, 582, BLACK,now.MilitaryTimeStr);
		}
	}
	if (old_sec != now.Seconds ) CheckIdle(); 
	old_sec=now.Seconds;
	min_old=now.Minutes;
}
int PutTime(int x, int y, int sz)
{
	int ShowButton,checkdate, checkseconds;
	LCARSTIME now;
	char OutputStr[12];

	now=GetTimeStr();

	checkseconds=1;

	if (old_sec != now.Seconds && MidiPlaying==0 ) {
		CheckIdle(); 
		ColorSwitch(x,y,sz);
		MarsF(669, 240*m, 4, BracketColor1, BLACK, now.SecondsStr);
		checkseconds=now.Seconds;
	}

	old_sec=now.Seconds;

	checkdate=now.Hours+now.Minutes;

	if(min_old != now.Minutes && MilitaryTime==0) {
		MarsF(534*m, 350*m, 3, TimeColor, BLACK, now.AmPmStr);
	}

	if(min_old != now.Minutes) {
		if(SnoozeAlarmMin >= 70) ShowButton=1;
			else ShowButton=0;
		if(MilitaryTime==0) {
			MarsF(x, y, sz, TimeColor, BLACK, now.CivilianTimeStr);
			if(ShowButton==1)
			ButtonRS(667,532,BracketColor1,now.MilitaryTimeStr);
		} else {
			MarsF(x, y, sz, TimeColor, BLACK, now.MilitaryTimeStr);
			if(ShowButton==1) {
				strcpy(OutputStr,now.CivilianTimeStr);
				strcat(OutputStr," ");
				strcat(OutputStr,now.AmPmStr);
				ButtonRS(667,532,BracketColor1,OutputStr);
			}
		}
		if(SnoozeAlarmMin==70) PutDate();
		PutStarDate(388,115,LAVENDER);
/*		CheckBeep(); */
/*		CheckTimers(Hours, Minutes); */
	}
	if (old_sec != now.Seconds ) CheckIdle();
	min_old=now.Minutes;
	Hours=now.Hours;
	Minutes=now.Minutes;
	return(checkdate+checkseconds);
}

void NorthwestCorner(int x,int y)
{
	rectfill(screen, x,		y+3,x+3,y, fc);
	putpixel(screen, x+3, 	y+3, ac2);
	hline(screen,	 x+4, 	y, x+7, fc);
	hline(screen,	 x+8, 	y, x+9, ac2);
	putpixel(screen, x+10, 	y,	  ac3);
	hline(screen,	 x+11, 	y, x+12,ac4);
	hline(screen,	 x+4, 	y+1, x+5,fc);
	putpixel(screen, x+6, 	y+1, ac2);
	putpixel(screen, x+7, 	y+1, ac3);
	putpixel(screen, x+4, 	y+2, ac2);
	putpixel(screen, x+5, 	y+2, ac3);
	hline(screen,	 x,		y+4, x+1,fc);
	putpixel(screen, x+2, 	y+4, ac2);
	hline(screen,	 x,		y+5, x+1,fc);
	putpixel(screen, x+2, 	y+5, ac3);
	putpixel(screen, x,  	y+6, fc);
	putpixel(screen, x+1, 	y+6, ac2);
	putpixel(screen, x,		y+7, fc);
	putpixel(screen, x+1, 	y+7, ac3);
	vline(screen,	 x,		y+8, y+9, ac2);
	putpixel(screen, x,		y+10, ac3);
	vline(screen,	 x,		y+11, y+12, ac4);
}
void SouthwestCorner(int x,int y)
{
	rectfill(screen, x,		y-3,x+3,y, fc);
	putpixel(screen, x+3, 	y-3, ac2);
	hline(screen,	 x+4, 	y, x+7, fc);
	hline(screen,	 x+8, 	y, x+9, ac2);
	putpixel(screen, x+10, 	y,	  ac3);
	hline(screen,	 x+11, 	y, x+12,ac4);
	hline(screen,	 x+4, 	y-1, x+5,fc);
	putpixel(screen, x+6, 	y-1, ac2);
	putpixel(screen, x+7, 	y-1, ac3);
	putpixel(screen, x+4, 	y-2, ac2);
	putpixel(screen, x+5, 	y-2, ac3);
	hline(screen,	 x,		y-4, x+1,fc);
	putpixel(screen, x+2, 	y-4, ac2);
	hline(screen,	 x,		y-5, x+1,fc);
	putpixel(screen, x+2, 	y-5, ac3);
	putpixel(screen, x,  	y-6, fc);
	putpixel(screen, x+1, 	y-6, ac2);
	putpixel(screen, x,		y-7, fc);
	putpixel(screen, x+1, 	y-7, ac3);
	vline(screen,	 x,		y-8, y-9, ac2);
	putpixel(screen, x,		y-10, ac3);
	vline(screen,	 x,		y-11, y-12, ac4);
}

void NortheastCorner(int x,int y)
{
	rectfill(screen, x,		y+3,x-3,y, fc);
	putpixel(screen, x-3, 	y+3, ac2);
	hline(screen,	 x-4, 	y, x-7, fc);
	hline(screen,	 x-8, 	y, x-9, ac2);
	putpixel(screen, x-10, 	y,	  ac3);
	hline(screen,	 x-11, 	y, x-12,ac4);
	hline(screen,	 x-4, 	y+1, x-5,fc);
	putpixel(screen, x-6, 	y+1, ac2);
	putpixel(screen, x-7, 	y+1, ac3);
	putpixel(screen, x-4, 	y+2, ac2);
	putpixel(screen, x-5, 	y+2, ac3);
	hline(screen,	 x,		y+4, x-1,fc);
	putpixel(screen, x-2, 	y+4, ac2);
	hline(screen,	 x,		y+5, x-1,fc);
	putpixel(screen, x-2, 	y+5, ac3);
	putpixel(screen, x,  	y+6, fc);
	putpixel(screen, x-1, 	y+6, ac2);
	putpixel(screen, x,		y+7, fc);
	putpixel(screen, x-1, 	y+7, ac3);
	vline(screen,	 x,		y+8, y+9, ac2);
	putpixel(screen, x,		y+10, ac3);
	vline(screen,	 x,		y+11, y+12, ac4);
}
void SoutheastCorner(int x,int y)
{
	rectfill(screen, x,		y-3,x-3,y, fc);
	putpixel(screen, x-3, 	y-3, ac2);
	hline(screen,	 x-4, 	y, x-7, fc);
	hline(screen,	 x-8, 	y, x-9, ac2);
	putpixel(screen, x-10, 	y,	  ac3);
	hline(screen,	 x-11, 	y, x-12,ac4);
	hline(screen,	 x-4, 	y-1, x-5,fc);
	putpixel(screen, x-6, 	y-1, ac2);
	putpixel(screen, x-7, 	y-1, ac3);
	putpixel(screen, x-4, 	y-2, ac2);
	putpixel(screen, x-5, 	y-2, ac3);
	hline(screen,	 x,		y-4, x-1,fc);
	putpixel(screen, x-2, 	y-4, ac2);
	hline(screen,	 x,		y-5, x-1,fc);
	putpixel(screen, x-2, 	y-5, ac3);
	putpixel(screen, x,  	y-6, fc);
	putpixel(screen, x-1, 	y-6, ac2);
	putpixel(screen, x,		y-7, fc);
	putpixel(screen, x-1, 	y-7, ac3);
	vline(screen,	 x,		y-8, y-9, ac2);
	putpixel(screen, x,		y-10, ac3);
	vline(screen,	 x,		y-11, y-12, ac4);
}

/* antialiasing for exterior of 1/4 of 36-pt. circle */
int fuzz36[23][3]= {
{15,0,1}, {14,0,2}, {13,0,3}, {12,0,4},
{12,1,1}, {11,1,2}, {10,1,3},
{9,2,1}, {8,2,4},
{7,3,2},
{6,4,1},
{5,5,1},
{4,6,1},
{3,7,2},
{2,8,3}, {2,9,1},
{1,10,3}, {1,11,2}, {1,12,1},
{0,12,4}, {0,13,3}, {0,14,2}, {0,15,1}
};

void NortheastFuzz36(int ex,int ey)
{
	int col[4];
	int i;

	col[0]=ac1;
	col[1]=ac2;
	col[2]=ac3;
	col[3]=ac4;

	ex+=36;
	for( i=0; i<=23; ++i)
		putpixel(screen, ex-fuzz36[i][0],ey+fuzz36[i][1], col[fuzz36[i][2]-1]);
}
void SoutheastFuzz36(int ex,int ey)
{
	int col[4];
	int i;

	col[0]=ac1;
	col[1]=ac2;
	col[2]=ac3;
	col[3]=ac4;

	ex+=36;
	ey+=36;
	for( i=0; i<=23; ++i)
		putpixel(screen, ex-fuzz36[i][0],ey-fuzz36[i][1], col[fuzz36[i][2]-1]);
}
void NorthwestFuzz36(int ex,int ey)
{
	int col[4];
	int i;

	col[0]=ac1;
	col[1]=ac2;
	col[2]=ac3;
	col[3]=ac4;

	ex-=36;
	for( i=0; i<=23; ++i)
		putpixel(screen, ex+fuzz36[i][0],ey+fuzz36[i][1], col[fuzz36[i][2]-1]);
}
void SouthwestFuzz36(int ex,int ey)
{
	int col[4];
	int i;

	col[0]=ac1;
	col[1]=ac2;
	col[2]=ac3;
	col[3]=ac4;

	ex-=36;
	ey+=36;
	for( i=0; i<=23; ++i)
		putpixel(screen, ex+fuzz36[i][0],ey-fuzz36[i][1], col[fuzz36[i][2]-1]);
}



void RightBumper36(int x,int y,int Hue)
{
	fc=Hue;
	FadeOut(fc);
	circlefill(screen,x+18,y+18,18,Hue);
	circle(screen,x+18,y+19,18,Hue);
	rectfill(screen,x,y,x+18,y+37,Hue);
	NortheastFuzz36(x,y);
	SoutheastFuzz36(x,y+1);
}
void LeftBumper36(int x,int y,int Hue)
{
	fc=Hue;                             /* ### */
	FadeOut(fc);
	circlefill(screen,x-18,y+18,18,Hue);
	circle(screen,x-18,y+19,18,Hue);
	rectfill(screen,x,y,x-18,y+37,Hue);
	NorthwestFuzz36(x,y);
	SouthwestFuzz36(x,y+1);
}

void LeftBumper26(int x,int y,int Hue)
{
	fc=Hue;
	FadeOut(fc);
	circlefill(screen,x-13,y+13,13,Hue);
	rectfill(screen,x,y,x-13,y+26,Hue);
	putpixel(screen,x-15,y,ac1);
	putpixel(screen,x-16,y,ac2);
	putpixel(screen,x-17,y,ac3);
	putpixel(screen,x-18,y,ac4);
	putpixel(screen,x-19,y+1,ac1);
	putpixel(screen,x-20,y+1,ac4);
	putpixel(screen,x-21,y+2,ac2);
	putpixel(screen,x-22,y+3,ac1);
	putpixel(screen,x-23,y+4,ac1);
	putpixel(screen,x-24,y+5,ac2);
	putpixel(screen,x-25,y+6,ac4);
	putpixel(screen,x-25,y+7,ac1);
	putpixel(screen,x-26,y+8,ac4);
	putpixel(screen,x-26,y+9,ac3);
	putpixel(screen,x-26,y+10,ac2);
	putpixel(screen,x-26,y+11,ac1);

	putpixel(screen,x-26,y+15,ac1);
	putpixel(screen,x-26,y+16,ac2);
	putpixel(screen,x-26,y+17,ac3);
	putpixel(screen,x-26,y+18,ac4);
	putpixel(screen,x-25,y+19,ac1);
	putpixel(screen,x-25,y+20,ac4);
	putpixel(screen,x-24,y+21,ac2);
	putpixel(screen,x-23,y+22,ac1);
	putpixel(screen,x-22,y+23,ac1);
	putpixel(screen,x-21,y+24,ac2);
	putpixel(screen,x-20,y+25,ac4);
	putpixel(screen,x-19,y+25,ac1);
	putpixel(screen,x-18,y+26,ac4);
	putpixel(screen,x-17,y+26,ac3);
	putpixel(screen,x-16,y+26,ac2);
	putpixel(screen,x-15,y+26,ac1);
}
void RightBumper26(int x,int y,int Hue)
{
	fc=Hue;
	FadeOut(fc);
	circlefill(screen,x+13,y+13,13,Hue);
	rectfill(screen,x,y,x+13,y+26,Hue);
	putpixel(screen,x+15,y,ac1);
	putpixel(screen,x+16,y,ac2);
	putpixel(screen,x+17,y,ac3);
	putpixel(screen,x+18,y,ac4);
	putpixel(screen,x+19,y+1,ac1);
	putpixel(screen,x+20,y+1,ac4);
	putpixel(screen,x+21,y+2,ac2);
	putpixel(screen,x+22,y+3,ac1);
	putpixel(screen,x+23,y+4,ac1);
	putpixel(screen,x+24,y+5,ac2);
	putpixel(screen,x+25,y+6,ac4);
	putpixel(screen,x+25,y+7,ac1);
	putpixel(screen,x+26,y+8,ac4);
	putpixel(screen,x+26,y+9,ac3);
	putpixel(screen,x+26,y+10,ac2);
	putpixel(screen,x+26,y+11,ac1);

	putpixel(screen,x+26,y+15,ac1);
	putpixel(screen,x+26,y+16,ac2);
	putpixel(screen,x+26,y+17,ac3);
	putpixel(screen,x+26,y+18,ac4);
	putpixel(screen,x+25,y+19,ac1);
	putpixel(screen,x+25,y+20,ac4);
	putpixel(screen,x+24,y+21,ac2);
	putpixel(screen,x+23,y+22,ac1);
	putpixel(screen,x+22,y+23,ac1);
	putpixel(screen,x+21,y+24,ac2);
	putpixel(screen,x+20,y+25,ac4);
	putpixel(screen,x+19,y+25,ac1);
	putpixel(screen,x+18,y+26,ac4);
	putpixel(screen,x+17,y+26,ac3);
	putpixel(screen,x+16,y+26,ac2);
	putpixel(screen,x+15,y+26,ac1);
}
void PopsicleSticks(int Hue)
{
	int th=26;

	LeftBumper26(th*1.5, th/2,Hue);
	RightBumper26(799-(th*1.5), th/2,Hue);
	rectfill(screen, (th*1.5)+8, th/2, 799-(th*1.5)-8, th*1.5, Hue);
	LeftBumper26(th*1.5, 599-(th*1.5),Hue);
	RightBumper26(799-(th*1.5), 599-(th*1.5),Hue);
	rectfill(screen, (th*1.5)+8, 599-(th*1.5), 799-(th*1.5)-8, 599-(th/2), Hue);
	min_old=70;
}
void Flange(int x, int Hue)
{
	rectfill(screen,x,19,x+72,572,Hue);
}
void FlangeHole(int FlangeX, int HolePos)
{
	int top,bottom;

	top=569-((12-HolePos)*47)-14+34;
	bottom=569-((12-HolePos)*47)+14+30;

	rectfill(screen,FlangeX+42, top, FlangeX+66, bottom, BLACK);
}
void MarkFlangeHole(int FlangeX, int HolePos, int Color, char *key)
{
	int top,bottom;

	top=569-((12-HolePos)*47)-14+34;
	bottom=569-((12-HolePos)*47)+14+30;


	if(strcmp(key, "0")==0) {
		FlangeHole(FlangeX, HolePos);
		rectfill(screen,FlangeX+46, top+4, FlangeX+62, bottom-4, Color);
	} else {
	rectfill(screen,FlangeX+42, top, FlangeX+66, bottom, Color);
		PutsLuna(FlangeX+66-StrLenLuna(key),bottom-14, BLACK, Color, key);
	}
}

void ButtonType1(int x, int y, int Hue, char *Label)
{
	LeftBumper36(x+36,y,Hue);
	rectfill(screen,x+37,y,x+71,y+37,Hue);
	RightBumper36(x+72,y,Hue);
	PutsLuna(x+72+24-StrLenLuna(Label),y+19,BLACK,Hue,Label);
}
void Notchbox(int x, int y, int Hue, char *Label)
{
	line(screen,x,y+8,x+8,y,Hue);
	line(screen,x+8,y,x+140,y,Hue);
	line(screen,x+140,y,x+140,y+30,Hue);
	line(screen,x,y+30,x+140,y+30,Hue);
	line(screen,x,y+8,x,y+30,Hue);
	floodfill(screen,x+30,y+15,Hue);
	PutsLuna(x+136-StrLenLuna(Label),y+14,BLACK,Hue,Label);
}
void ButtonRR(int x, int y, int Hue, char *Label)
{
	LeftBumper36(x+36,y,Hue);
	rectfill(screen,x+37,y,x+53,y+37,Hue);
	RightBumper36(x+54,y,Hue);
	PutsLuna(x+78-StrLenLuna(Label),y+19,BLACK,Hue,Label);
}
void ButtonRS(int x,int y, int Hue, char *Label)
{
	LeftBumper36(x+36,y,Hue);
	rectfill(screen,x+37,y,x+109-36,y+37,Hue);
	PutsLuna(x+69-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
}
void ButtonSR(int x,int y, int Hue, char *Label)
{
	rectfill(screen,x,y,x+35,y+37,Hue);
	RightBumper36(x+36,y,Hue);
	PutsLuna(x+58-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
}
void ButtonSFS(int x, int y, int Hue, char *Label)
{
	rectfill(screen,x,y,x+108,y+37,Hue);
	PutsLuna(x+104-StrLenLuna(Label),y+19,BLACK,Hue,Label);
}
void ButtonRFS(int x, int y, int Hue, char *Label)
{
	LeftBumper36(x+36,y,Hue);
	rectfill(screen,x+37,y,x+108,y+37,Hue);
	PutsLuna(x+104-StrLenLuna(Label),y+19,BLACK,Hue,Label);
}
void ButtonSFR(int x, int y, int Hue, char *Label)
{
	rectfill(screen,x,y,x+71,y+37,Hue);
	RightBumper36(x+72,y,Hue);
	PutsLuna(x+72+24-StrLenLuna(Label),y+19,BLACK,Hue,Label);
}
void ButtonType2(int x,int y,int Hue1, int Hue2, char *Label)
{
	rectfill(screen,x,y,x+10,y+37,Hue1);
	rectfill(screen,x+18,y,x+109,y+37,Hue2);
	RightBumper36(x+157,y,Hue2);
	PutsLuna(x+122-StrLenLuna(Label)-16,y+19,BLACK,Hue2,Label);
}
void OfflineType2(int x,int y,int Hue, char *Label)
{
	rectfill(screen,x,y,x+109-18,y+37,Hue);
	RightBumper36(x+157-36,y,Hue);
	PutsLuna(x+4,y+19,BLACK,Hue,Label);
}
void ButtonType2Broken(int x,int y,int Hue1, int Hue2, char *Label)
{
	rectfill(screen,x,y,x+10,y+37,Hue1);
	rectfill(screen,x+18,y,x+109,y+37,Hue2);
	PutsLuna(x+122-StrLenLuna(Label)-16,y+19,BLACK,Hue2,Label);
}
void ButtonType3Short(int x,int y,int Hue1, int Hue2, char *Label)
{
	rectfill(screen,x,y,x+10,y+37,Hue1);
	LeftBumper36(x+54,y,Hue2);
	rectfill(screen,x+55,y,x+109,y+37,Hue2);
	rectfill(screen,x+157,y,x+157+10,y+37,Hue2);
	PutsLuna(x+122-StrLenLuna(Label)-16,y+19,BLACK,Hue2,Label);
}
void ButtonType3(int x,int y,int Hue1, int Hue2, char *Label)
{
	ButtonType3Short(x, y, Hue1, Hue2, Label);
	rectfill(screen,x+157+11,y,x+157+36,y+37,Hue2);
}
void ButtonType4(int x,int y, int Hue, char *Label, char *key, int keycolor)
{
	LeftBumper36(x+54,y,Hue);
	rectfill(screen,x+55,y,x+109+17,y+37,Hue);  /* 18 -> 17 */
	RightBumper36(x+157+18,y,Hue);
	PutsLuna(x+122-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label); /* 122 -> 121 */
	KeyLabel(x+158,y+1,key,keycolor);
}
void OfflineType4(int x,int y, int Hue, char *Label)
{
	LeftBumper36(x+54,y,Hue);
	rectfill(screen,x+55,y,x+109+18,y+37,Hue);
	PutsLuna(x+122-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
}
void OfflineType4Mini(int x,int y, int Hue, char *Label)
{
	LeftBumper36(x+54,y,Hue);
	rectfill(screen,x+55,y,x+109-18,y+37,Hue);
	PutsLuna(x+86-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
}
void BrokenType4(int x,int y, int Hue)
{
	RightBumper36(x+157+18,y,Hue);
}
void OfflineType5(int x,int y,int Hue, char *Label)
{
	rectfill(screen,x,y,x+109-36,y+37,Hue);
	RightBumper36(x+109-36,y,Hue);
	PutsLuna(x+4,y+19,BLACK,Hue,Label);
}
void OfflineType6(int x,int y, char *key, int keycolor)
{
	KeyLabel(x+158,y+1,key,keycolor);
}
void ButtonType5(int x,int y, int Hue, char *Label, char *key, int keycolor)
{
	rectfill(screen,x+18,y,x+109+17,y+37,Hue); /* 18 -> 17 */
	RightBumper36(x+157+18,y,Hue);
	PutsLuna(x+122-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
	KeyLabel(x+158,y+1,key,keycolor);
}
void ButtonType6(int x,int y, int Hue, char *Label, char *key, int keycolor)
{
	LeftBumper36(x+54,y,Hue);
	rectfill(screen,x+55,y,x+109+17,y+37,Hue); /* 18 -> 17 */
	rectfill(screen,x+175,y,x+211,y+37,Hue);
	PutsLuna(x+122-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
	KeyLabel(x+158,y+1,key,keycolor);
}
void ButtonType7(int x,int y, int Hue, char *Label, char *key, int keycolor)
{
	LeftBumper36(x+54,y,Hue);
	rectfill(screen,x+55,y,x+109+17,y+37,Hue); /* 18 -> 17 */
	PutsLuna(x+122-StrLenLuna(Label)+2,y+19,BLACK,Hue,Label);
	KeyLabel(x+158,y+1,key,keycolor);
}
void EnterSymbol(int x, int y, int sz, int Fc)
{
	int a = x;
	int b;
	int slant = 1;

	b = y+(sz*12);

	while(a < x+(sz*6) ) {
		++a;
		b=b-slant;
		rectfill(screen,a,b,x+(sz*6), b+slant,Fc);
	}
	slant = 1;
	a=x;
	b=y+(sz*12);
	rectfill(screen,a,b,a+(sz*1),b+(slant/2),Fc);

	while(a < x+(sz*6) ) {
		++a;
		rectfill(screen,a,b,x+(sz*6), b+slant,Fc);
		b=b+slant;
	}
	rectfill(screen,x+(sz*6),y+(sz*11),x+(sz*10), y+(sz*13),Fc);
	rectfill(screen,x+(sz*10),y,x+(sz*12), y+(sz*13),Fc);
}
void UpArrowHead(int x, int y, int Hue)
{
	int a = x+7;
	int a2 = a+2;
	int b;

	putpixel(screen, x+8,y,Hue);
	b = y+1;
	while(a >=x ) {
		hline(screen,a,b,a2,Hue);
		--a;
		++a2;
		++b;
	}
}
void UpArrowSymbol(int x, int y, int Hue)
{
	int a = x+7;
	int a2 = a+2;
	int b;

	putpixel(screen, x+8,y,Hue);
	b = y+1;
	while(a >=x ) {
		hline(screen,a,b,a2,Hue);
		--a;
		++a2;
		++b;
	}
	rectfill(screen,x+6,y+8,x+10, y+16,Hue);
}
void DownArrowSymbol(int x, int y, int Hue)
{
	int a = x+7;
	int a2 = a+2;
	int b;

	putpixel(screen, x+8,y+16,Hue);
	b = y+15;
	while(a >=x ) {
		hline(screen,a,b,a2,Hue);
		--a;
		++a2;
		--b;
	}
	rectfill(screen,x+6,y,x+10, y+8,Hue);
}
void LeftArrowSymbol(int x, int y, int Hue)
{
	int b = y+9;
	int b2 = b-2;
	int a;

	putpixel(screen, x,y+8,Hue);
	a = x+1;
	while(b <= y+16 ) {
		vline(screen,a,b2,b,Hue);
		++b;
		--b2;
		++a;
	}
	rectfill(screen,x+8,y+6,x+16, y+10,Hue);
}
void RightArrowSymbol(int x, int y, int Hue)
{
	int b = y+9;
	int b2 = b-2;
	int a;

	putpixel(screen, x+16,y+8,Hue);
	a = x+15;
	while(b <= y+16 ) {
		vline(screen,a,b2,b,Hue);
		++b;
		--b2;
		--a;
	}
	rectfill(screen,x,y+6,x+8, y+10,Hue);
}
void NorthwestArrowSymbol(int x, int y, int Hue)
{
	int z;

	for(z=0; z<12; ++z) hline(screen,x,y+z,x+11-z,Hue);
	line(screen,x+8,y+5,x+12,y+9,Hue);
	line(screen,x+7,y+5,x+12,y+10,Hue);
	line(screen,x+7,y+6,x+11,y+10,Hue);
	line(screen,x+6,y+6,x+11,y+11,Hue);
	line(screen,x+6,y+7,x+10,y+11,Hue);
	line(screen,x+5,y+7,x+10,y+12,Hue);
	line(screen,x+5,y+8,x+9,y+12,Hue);
}
void BracketArrows(int boxnum)
{
	int boxtop;

	boxtop=593-(boxnum*57);
	UpArrowSymbol(90,boxtop+4,BLACK);
	DownArrowSymbol(90,boxtop+33,BLACK);
}

void Wrapper(int radx, int rady)
{ /* off-screen with 800 x 600 screens, fills the void with 1024 x 768 */
  /* scalable, if necessary */
	int right = 994;
	int bottom_edge = 738;

	if(ScreenSize != 1024) return;

	fc=DARKGRAY;
	FadeOut(DARKGRAY);
	CropCircle(screen,0,right-radx,bottom_edge-radx,radx+1);
	rectfill(screen, right-radx*2, 10, right, rady*4, DARKGRAY);
	rectfill(screen, right-radx*2, (rady*4)+8,right,bottom_edge-(rady*4)-8,DARKGRAY);
	rectfill(screen, right-radx*2,bottom_edge-(rady*4),right,bottom_edge-(radx-1),DARKGRAY);

	rectfill(screen, 10, bottom_edge-(rady*2),rady*4, bottom_edge,DARKGRAY);
	rectfill(screen, (rady*4)+8, bottom_edge-rady*2,right-(radx*3)-8, bottom_edge,DARKGRAY);
	rectfill(screen, right-(radx*3),bottom_edge-rady*2,right-(radx-1), bottom_edge,DARKGRAY);
	SoutheastCorner(right-(radx*2)-1,bottom_edge-(rady*2)-1);
}

/* routines for 36-point digits and the letter F for buttons */

void F36Color(int ForeColor,int BackColor)
{
	fc=ForeColor;
	bc=BackColor;
	if(bc==BLACK) FadeOut(fc);
	if(fc==BLACK) FadeIn(bc);
}
void F36_FineFadeUp(int x, int y, int Hue, int range)
{
	int r,b,g,dr,dg,db,z,limit;

	r=getr(Hue);
	g=getg(Hue);
	b=getb(Hue);
	dr = r;
	dg = g;
	db = b;

	limit = range;
	range += range * .5;		/* slows fade to produce nice slants */
	for( z=1; z <= limit; ++z ) {
		dr -= r/range;
		dg -= g/range;
		db -= b/range;
		putpixel(screen,x,y+1-z,makecol(dr,dg,db));
	}
}
void F36_FineFadeDown(int x, int y, int Hue, int range)
{
	int r,b,g,dr,dg,db,z,limit;

	r=getr(Hue);
	g=getg(Hue);
	b=getb(Hue);
	dr = r;
	dg = g;
	db = b;

	limit = range;
	range += range * .5;		/* slows fade to produce nice slants */
	for( z=1; z <= limit; ++z ) {
		dr -= r/range;
		dg -= g/range;
		db -= b/range;
		putpixel(screen,x,y-1+z,makecol(dr,dg,db));
	}
}
void F36_FadeUp3(int x,int y)
{
	putpixel(screen, x,y-2,ac4);
	putpixel(screen, x,y-1,ac3);
	putpixel(screen, x,y,ac2);
}
void F36_FadeDown3(int x,int y)
{
	putpixel(screen, x,y,ac2);
	putpixel(screen, x,y+1,ac3);
	putpixel(screen, x,y+2,ac4);
}
void F36_1(int x,int y,int ForeColor,int BackColor)
{
	F36Color(ForeColor,BackColor);
	rectfill(screen, x+6,y,x+8,y+3,fc);
	rectfill(screen, x+5,y+3,x+8,y+35,fc);
	rectfill(screen, x+2,y+4,x+4,y+6,fc);
	putpixel(screen, x+4,y+2,ac3);
	putpixel(screen, x+5,y+2,ac2);
	putpixel(screen, x+5,y+1,ac3);
	putpixel(screen, x+5,y  ,ac4);
	putpixel(screen, x+4,y+3,ac2);
	putpixel(screen, x+3,y+3,ac3);
	putpixel(screen, x+2,y+3,ac4);
}
void F36_2(int x,int y,int ForeColor,int BackColor)
{
	int a, b;

	F36_O(x,y,ForeColor,BackColor);
	rectfill(screen, x,y+13,x+10,y+35,bc);
	rectfill(screen, x+6,y+12,x+10,y+14,bc);
	rectfill(screen, x,y+32,x+10,y+35,fc);

	b=12;
	for( a=7; a>=1; --a) {
		rectfill(screen, x+a,y+b,x+a+3,y+b+2,fc);
		putpixel(screen, x+a,y+b,ac1);
		putpixel(screen, x+a,y+b-1,ac4);
		putpixel(screen, x+a+3,y+b+2,ac1);
		putpixel(screen, x+a+3,y+b+3,ac4);
		b+=2;
	}
	putpixel(screen, x+7,y+11,fc);

	rectfill(screen, x,y+b+1,x+3,y+31,fc);
	putpixel(screen, x,y+b,ac4);
	putpixel(screen, x,y+b+1,ac3);
	putpixel(screen, x,y+b+2,ac2);
	putpixel(screen, x+7,y+12,fc);
	putpixel(screen, x+6,y+13,ac4);
	putpixel(screen, x+10,y+12,ac2);
	putpixel(screen, x+10,y+13,ac3);
	putpixel(screen, x+10,y+14,ac4);
}
void F36_3(int x,int y,int ForeColor,int BackColor)
{
	F36_8(x,y,ForeColor,BackColor);
	rectfill(screen, x,y+13,x+4,y+22,bc);
	rectfill(screen, x+4,y+16,x+5,y+19,fc);
}
void F36_4(int x,int y,int ForeColor,int BackColor)
{
	F36Color(ForeColor,BackColor);
	rectfill(screen, x,y+23,x+12,y+26,fc);
	rectfill(screen, x+7,y,x+10,y+35,fc);
	vline(screen,x+6,y,y+9,fc);
	vline(screen,x+5,y+3,y+13,fc);
	vline(screen,x+4,y+7,y+17,fc);
	vline(screen,x+3,y+11,y+21,fc);
	vline(screen,x+2,y+15,y+22,fc);
	vline(screen,x+1,y+19,y+22,fc);
	F36_FadeUp3(x+5,y+2);
	F36_FadeUp3(x+4,y+6);
	F36_FadeUp3(x+3,y+10);
	F36_FadeUp3(x+2,y+14);
	F36_FadeUp3(x+1,y+18);
	F36_FadeUp3(x,y+22);
	F36_FadeDown3(x+6,y+10);
	F36_FadeDown3(x+5,y+14);
	F36_FadeDown3(x+4,y+18);
	putpixel(screen,x+3,y+22,ac2);
}
void F36_5(int x,int y,int ForeColor,int BackColor)
{
	F36_6(x,y,ForeColor,BackColor);
	rectfill(screen, x,y,x+10,y+3,fc);
	rectfill(screen, x+4,y+4,x+10,y+12,bc);
	rectfill(screen, x,y+21,x+3,y+22,bc);
}
void F36_6(int x,int y,int ForeColor,int BackColor)
{
	F36_O(x,y,ForeColor,BackColor);
	rectfill(screen, x+7,y+13,x+10,y+15,bc);
	hline(screen, x+6,y+15,x+8,fc);
	rectfill(screen, x+4,y+16,x+6,y+18,fc);

	rectfill(screen, x+4,y+4+15,x+6,y+5+15,ac3);
	putpixel(screen, x+5,y+4+15,ac4);
	putpixel(screen, x+5,y+5+15,bc);
	F36_FadeUp3(x+10,y+18);

	putpixel(screen, x+4,y+16,ac4);
	putpixel(screen, x+5,y+15,ac3);
	putpixel(screen, x+9,y+15,ac3);
}
void F36_7(int x,int y,int ForeColor,int BackColor)
{
	int i,zx,zy;

	zx=6;
	zy=8;
	F36Color(ForeColor,BackColor);
	for(i=0; i < 5; ++i) {
		rectfill(screen, x+zx,y+zy,x+zx+2,y+zy+6,fc);
		--zx;
		zy +=5;
		F36_FadeUp3(x+zx,y+zy-1);
		F36_FineFadeDown(x+zx+4,y+zy-3,ForeColor,5);
	}
	F36_FineFadeDown(x+11,y,ForeColor,5);
	rectfill(screen, x+1,y+33,x+4,y+35,fc);
	rectfill(screen, x+7,y+4,x+10,y+9,fc);
	F36_FineFadeDown(x+10,y+5,ForeColor,5);
	F36_FineFadeUp(x+6,y+7,ForeColor,5);
	rectfill(screen, x,y,x+10,y+3,fc);
}
void F36_8(int x,int y,int ForeColor,int BackColor)
{
	F36_O(x,y,ForeColor,BackColor);
	rectfill(screen, x+4,y+16,x+6,y+19,fc);
/* left delta */
	rectfill(screen, x,y+17,x+1,y+18,bc);
	putpixel(screen, x,y+16,bc);
	putpixel(screen, x,y+19,bc);
	putpixel(screen, x,y+15,ac3);
	putpixel(screen, x,y+20,ac3);
/* right delta */
	rectfill(screen, x+9,y+17,x+10,y+18,bc);
	putpixel(screen, x+10,y+16,bc);
	putpixel(screen, x+10,y+19,bc);
	putpixel(screen, x+10,y+15,ac3);
	putpixel(screen, x+10,y+20,ac3);
/* inner curves */
	rectfill(screen, x+4,y+14,x+6,y+15,ac3);
	putpixel(screen, x+5,y+15,ac4);
	putpixel(screen, x+5,y+14,bc);
	rectfill(screen, x+4,y+20,x+6,y+21,ac3);
	putpixel(screen, x+5,y+20,ac4);
	putpixel(screen, x+5,y+21,bc);
}
void F36_9(int x,int y,int ForeColor,int BackColor)
{
	F36_O(x,y,ForeColor,BackColor);
	rectfill(screen, x,y+20,x+3,y+22,bc);
	hline(screen, x+2,y+20,x+4,fc);
	rectfill(screen, x+4,y+17,x+6,y+19,fc);

	rectfill(screen, x+4,y+15,x+6,y+16,ac3);
	putpixel(screen, x+5,y+16,ac4);
	putpixel(screen, x+5,y+15,bc);
	F36_FadeDown3(x,y+17);

	putpixel(screen, x+6,y+19,ac4);
	putpixel(screen, x+1,y+20,ac3);
	putpixel(screen, x+5,y+20,ac3);
}
void F36_0(int x,int y,int ForeColor,int BackColor)
{
	F36_O(x,y,ForeColor,BackColor);
}
void F36_O(int x,int y,int ForeColor,int BackColor)
{
	F36Color(ForeColor,BackColor);
	rectfill(screen, x,y,x+10,y+35,fc);
	rectfill(screen, x+4,y+4,x+6,y+31,bc);
/* upper left */
	rectfill(screen, x,y,x+1,y+1,bc);
	putpixel(screen, x+2,y,ac3);
	putpixel(screen, x+3,y,ac2);
	putpixel(screen, x,y+2,ac3);
	putpixel(screen, x,y+3,ac2);
	putpixel(screen, x+1,y+1,ac2);
/* upper right */
	rectfill(screen, x+9,y,x+10,y+1,bc);
	putpixel(screen, x+8,y,ac3);
	putpixel(screen, x+7,y,ac2);
	putpixel(screen, x+10,y+2,ac3);
	putpixel(screen, x+10,y+3,ac2);
	putpixel(screen, x+9,y+1,ac2);
/* upper inside */
	rectfill(screen, x+4,y+4,x+6,y+5,ac3);
	putpixel(screen, x+5,y+4,ac4);
	putpixel(screen, x+5,y+5,bc);
/* lower left */
	rectfill(screen, x,y+35,x+1,y+35-1,bc);
	putpixel(screen, x+2,y+35,ac3);
	putpixel(screen, x+3,y+35,ac2);
	putpixel(screen, x,y+35-2,ac3);
	putpixel(screen, x,y+35-3,ac2);
	putpixel(screen, x+1,y+35-1,ac2);
/* lower right */
	rectfill(screen, x+9,y+35,x+10,y+35-1,bc);
	putpixel(screen, x+8,y+35,ac3);
	putpixel(screen, x+7,y+35,ac2);
	putpixel(screen, x+10,y+35-2,ac3);
	putpixel(screen, x+10,y+35-3,ac2);
	putpixel(screen, x+9,y+35-1,ac2);
/* lower inside */
	rectfill(screen, x+4,y+35-4,x+6,y+35-5,ac3);
	putpixel(screen, x+5,y+35-4,ac4);
	putpixel(screen, x+5,y+35-5,bc);
}
void F36_C(int x,int y,int ForeColor,int BackColor)
{
	F36_O(x,y,ForeColor,BackColor);
	rectfill(screen, x+7,y+13,x+10,y+22,bc);
}
void F36_E(int x,int y,int ForeColor,int BackColor)
{
	fc=ForeColor;
	bc=BackColor;
	rectfill(screen, x,y,x+3,y+35,fc);
	rectfill(screen, x+4,y,x+8,y+3,fc);
	rectfill(screen, x+4,y+15,x+8,y+18,fc);
	rectfill(screen, x+4,y+32,x+8,y+35,fc);
}
void F36_F(int x,int y,int ForeColor,int BackColor)
{
	fc=ForeColor;
	bc=BackColor;
	rectfill(screen, x,y,x+3,y+35,fc);
	rectfill(screen, x+4,y,x+8,y+3,fc);
	rectfill(screen, x+4,y+15,x+8,y+18,fc);
}
void F36_S(int x,int y,int ForeColor,int BackColor)
{
	int i,zx,zy;

	zx=1;
	zy=9;
	F36_O(x,y,ForeColor,BackColor);
	rectfill(screen, x,y+13,x+10,y+22,bc);
	for(i=0; i < 7; ++i) {
		rectfill(screen, x+zx,y+zy,x+zx+2,y+zy+6,fc);
		++zx;
		zy +=2;
		F36_FineFadeDown(x+zx-2,y+zy+1,ForeColor,3);
		F36_FineFadeUp(x+zx+2,y+zy,ForeColor,3);
	}
}
void EscSymbol(int x, int y, int sz, int Fc)
{
	F36_E(x-1,  y, Fc, BLACK);
	F36_S(x+10,  y, Fc, BLACK);
	F36_C(x+23, y, Fc, BLACK);
}

/* solid color and antialiasing for inner part of a pipe bend */
int pipebend[100][3]= {
{16,1,0}, {15,1,0}, {14,1,0}, {13,1,0},
{16,2,0}, {15,2,0}, {14,2,0}, {13,2,0}, {12,2,0}, {11,2,0}, {10,2,0},
{16,3,3}, {15,3,2}, {14,3,1}, {13,3,0}, {12,3,0}, {11,3,0},
{10,3,0}, {9,3,0}, {8,3,0},
{13,4,4}, {12,4,2}, {11,4,1}, {10,4,0}, {9,4,0}, {8,4,0}, {7,4,0},
{11,5,4}, {10,5,2}, {9,5,1}, {8,5,0}, {7,5,0}, {6,5,0},
{9,6,3}, {8,6,1}, {7,6,0}, {6,6,0}, {5,6,0},
{8,7,3}, {7,7,1}, {6,7,0}, {5,7,0}, {4,7,0},
{7,8,3}, {6,8,1}, {5,8,0}, {4,8,0}, {3,8,0},
{6,9,3}, {5,9,1}, {4,9,0}, {3,9,0},
{5,10,1}, {4,10,0}, {3,10,0}, {2,10,0},
{5,11,4}, {4,11,1}, {3,11,0}, {2,11,0},
{4,12,2}, {3,12,0}, {2,12,0},
{4,13,4}, {3,13,0}, {2,13,0}, {1,13,0},
{3,14,1}, {2,14,0}, {1,14,0},
{3,15,2}, {2,15,0}, {1,15,0},
{3,16,3}, {2,16,0}, {1,16,0}, {0,16,0},
{15,0,1}, {14,0,2}, {13,0,3}, {12,0,4},
{12,1,1}, {11,1,2}, {10,1,3},
{9,2,1}, {8,2,4},
{7,3,2},
{6,4,1},
{5,5,1},
{4,6,1},
{3,7,2},
{2,8,3}, {2,9,1},
{1,10,3}, {1,11,2}, {1,12,1},
{0,12,4}, {0,13,3}, {0,14,2}, {0,15,1},
};

void NortheastPipebend(int ex, int ey, int color)
{
	int col[5];
	int i;

	fc=color;
	FadeOut(fc);
	col[0]=fc;
	col[1]=ac1;
	col[2]=ac2;
	col[3]=ac3;
	col[4]=ac4;

	ex+=16;
	for( i=0; i<100; ++i)
		putpixel(screen, ex-pipebend[i][0],ey+pipebend[i][1], col[pipebend[i][2]]);
}
void SoutheastPipebend(int ex, int ey, int color)
{
	int col[5];
	int i;

	fc=color;
	FadeOut(fc);
	col[0]=fc;
	col[1]=ac1;
	col[2]=ac2;
	col[3]=ac3;
	col[4]=ac4;

	ex+=16;
	for( i=0; i<100; ++i)
		putpixel(screen, ex-pipebend[i][0],ey-pipebend[i][1], col[pipebend[i][2]]);
}
void NorthwestPipebend(int ex, int ey, int color)
{
	int col[5];
	int i;

	fc=color;
	FadeOut(fc);
	col[0]=fc;
	col[1]=ac1;
	col[2]=ac2;
	col[3]=ac3;
	col[4]=ac4;

	ex-=16;
	for( i=0; i<100; ++i)
		putpixel(screen, ex+pipebend[i][0],ey+pipebend[i][1], col[pipebend[i][2]]);
}
void SouthwestPipebend(int ex, int ey, int color)
{
	int col[5];
	int i;

	fc=color;
	FadeOut(fc);
	col[0]=fc;
	col[1]=ac1;
	col[2]=ac2;
	col[3]=ac3;
	col[4]=ac4;

	ex-=16;  /* was 18 */
	for( i=0; i<100; ++i)
		putpixel(screen, ex+pipebend[i][0],ey-pipebend[i][1], col[pipebend[i][2]]);

}

void Dot(int x, int y, int color)
{
	int i;
	int fuzz[7] = { 4, 3, 2, 1, 2, 3, 4 };

	FadeOut(color);
	rectfill(screen,x+1,y+1,x+9,y+9,color);
	for( i=0; i<=7; ++i) {
		if( fuzz[i]==1) fuzz[i]=ac1;
		if( fuzz[i]==2) fuzz[i]=ac2;
		if( fuzz[i]==3) fuzz[i]=ac3;
		if( fuzz[i]==4) fuzz[i]=ac4;
	}
	for( i=0; i<7; ++i) {
		putpixel(screen, x+2+i,y, fuzz[i]);
		putpixel(screen, x+2+i,y+10, fuzz[i]);
		putpixel(screen, x,y+2+i, fuzz[i]);
		putpixel(screen, x+10,y+2+i, fuzz[i]);
	}
	putpixel(screen, x+1,y+1, ac4);
	putpixel(screen, x+9,y+1, ac4);
	putpixel(screen, x+1,y+9, ac4);
	putpixel(screen, x+9,y+9, ac4);
}
void SchematicLabel(int tx,int ty,int px,int py,char *Str,int Col1,int Col2)
{
	int startx, starty, bendx;

	startx=tx-4;
	starty=ty+5;
	bendx=px-1;

	PutsLuna(tx,ty,Col1,BLACK, Str);

	if(px > tx) {
		startx=StrLenLuna(Str)+4+tx;
		Dot(startx,ty+2, Col1);
		startx +=19;
		px +=3; /* for the thickness, center the pipe on px */
		if(py > ty) {
			rectfill(screen,startx,starty+1,px-14,starty+3, Col2); /* 16->15 */
			rectfill(screen,px,starty+16,px+2,py, Col2);
			NortheastPipebend(px-14,starty+1, Col2);
			return;
		}
		if(py < ty) {
			rectfill(screen,startx,starty+1,px-14,starty+3, Col2);
			rectfill(screen,px,py,px+2,starty-14, Col2);
			SoutheastPipebend(px-14,starty+3, Col2);
			return;
		}
		if(py == ty) {
			return;
		}
	}
	if(px < tx) {
		startx=tx-4;
		startx -=17; /* becomes - 19 after the dot, below */
		Dot(startx+4,ty+2, Col1);
		startx -=4;
		if(py > ty) {
			rectfill(screen,px+16,starty+1,startx,starty+3, Col2);
			rectfill(screen,px+2,starty+16,px+4,py, Col2);
			NorthwestPipebend(px+18,starty+1, Col2);
			return;
		}
		if(py < ty) {
			rectfill(screen,px+15,starty+1,startx,starty+3, Col2);
			rectfill(screen,px,py,px+2,starty-14, Col2);
			SouthwestPipebend(px+16,starty+3, Col2);
			return;
		}
		if(py == ty) {
			return;
		}
	}
}


void Pipe(int x1, int y1, int x2, int y2, int Hue)
{
	int startx, starty, bendx;

	startx=x1-4;
	starty=y1+5;
	bendx=x2-1;

	if(x2==x1 || y2==y1) {

		if (y2==y1) { y1+=7; y2+=7; }
		rectfill(screen,x1-1,y1-1,x2+1,y2+1,Hue);
		return;
	}

	if(x2 > x1) {
		startx=x1;
		x2 +=3; /* for the thickness, center the pipe on x2 */
		if(y2 > y1) {
			rectfill(screen,startx,starty+1,x2-14,starty+3, Hue); /* 16->15 */
			rectfill(screen,x2,starty+16,x2+2,y2, Hue);
			NortheastPipebend(x2-14,starty+1, Hue);
			return;
		}
		if(y2 < y1) {
			rectfill(screen,startx,starty+1,x2-14,starty+3, Hue);
			rectfill(screen,x2,y2,x2+2,starty-14, Hue);
			SoutheastPipebend(x2-14,starty+3, Hue);
			return;
		}
		if(y2 == y1) {
			return;
		}
	}
	if(x2 < x1) {
		startx=x1;
		if(y2 > y1) {
			rectfill(screen,x2+16,starty+1,startx,starty+3, Hue);
			rectfill(screen,x2+2,starty+16,x2+4,y2, Hue);
			NorthwestPipebend(x2+18,starty+1, Hue);
			return;
		}
		if(y2 < y1) {
			rectfill(screen,x2+16,starty+1,startx,starty+3, Hue);
			rectfill(screen,x2,y2,x2+2,starty-14, Hue);
			SouthwestPipebend(x2+18,starty+3, Hue);
			return;
		}
		if(y2 == y1) {
			return;
		}
	}
}


void SetCurrentFile(char *filespec)
{
	strcpy(CurrentFile, LcarsPath);
	strcat(CurrentFile, filespec);
}

int NumSeparators(AL_CONST char *path)
{
	int pos, c, i;

	pos = ustrlen(path);
	i=0;
	while (pos>0) {
		c = ugetat(path, pos-1);
		if(c == '\\' || c == '/') i++;
		pos--;
	}

	return(i);
}
char *MakeDisplayName(AL_CONST char *path)
{
	int pos, c, i;

	i=NumSeparators(path);
	if(i ==0) return (char *)path + uoffset(path,0);
	i-=NumSeparators(LcarsPath);
	i++;
	pos = ustrlen(path);
	while (i>0) {
		c = ugetat(path, pos-1);
		if(c == '\\' || c == '/') i--;
		pos--;
	}

	return (char *)path + uoffset(path,pos);

}

int PutOneKeyChar(int x, int y, int a, int hue)
{
	switch( toupper(a) )
	{
		case 48:	{ F36_0(x,y,hue,BLACK); return(0); }
		case 49:	{ F36_1(x,y,hue,BLACK); return(0); }
		case 50:	{ F36_2(x,y,hue,BLACK); return(0); }
		case 51:	{ F36_3(x,y,hue,BLACK); return(0); }
		case 52:	{ F36_4(x,y,hue,BLACK); return(0); }
		case 53:	{ F36_5(x,y,hue,BLACK); return(0); }
		case 54:	{ F36_6(x,y,hue,BLACK); return(0); }
		case 55:	{ F36_7(x,y,hue,BLACK); return(0); }
		case 56:	{ F36_8(x,y,hue,BLACK); return(0); }
		case 57:	{ F36_9(x,y,hue,BLACK); return(0); }
		case 67:	{ F36_C(x,y,hue,BLACK); return(0); }
		case 69:	{ F36_E(x,y,hue,BLACK); return(0); }
		case 70:	{ F36_F(x,y,hue,BLACK); return(0); }
		case 79:	{ F36_O(x,y,hue,BLACK); return(0); }
		case 83:	{ F36_S(x,y,hue,BLACK); return(0); }
		default:	return(0);
	}
	return(0);
}
int KeyLabel(int x, int y, char *label, int hue)
{
	char str[8];
	size_t num;

	if(strnicmp( "ESC", label,3 )==0 ) {
		EscSymbol(x-23,y,2,hue);
		return(0);
	}
	if(strnicmp( "ENT", label,3 )==0 ) {
		EnterSymbol(x-23,y,2,hue);
		return(0);
	}

	strcpy(str, label);
	num=strlen(str);

	if(num >3) return(0);
	PutOneKeyChar(x, y, str[num-1],hue);
	if(num <2) return(0);
	if(num==2 && str[0]==70) PutOneKeyChar(x-12, y, 70, hue);
		else PutOneKeyChar(x-13, y, str[num-2],hue);
	if(num <3) return(0);
	if(isdigit(str[num-3])) PutOneKeyChar(x-26, y, str[num-3],hue);
		else PutOneKeyChar(x-24, y, str[num-3],hue);
	return(0);
}


