#include <allegro.h>

int BLACK, WHITE, ORANGE, RED, DARKRED, LILAC, PALEBLUE, BORG,
	BIGBLUE, BRICK, TAN, NAPLES, SKYBLUE, MANGO, PURPLE,
	LAVENDER, DARKGRAY, SEABLUE, YELLOW;


void Show(int key)
{
	char HexStr[7] = "00";

	itoa(key,HexStr,16);
	rectfill(screen,120,160,248,168,BLACK);
	textout_ex(screen, font, HexStr,  8*15,  160,  BORG, -1);
}

int GetKey(void)
{
	int key, lo, hi, Result;
	char HexStr[7] = "00";

	key=readkey();
	itoa(key,HexStr,16);

rectfill(screen,120,160,248,168,BLACK);
textout_ex(screen, font, HexStr,  8*15,  160,  WHITE, -1);

	if(key==0x3F08) return(key);  /* backspace */

	lo=key & 0X00FF;
	hi=(key & 0XFF00) >> 8;
	Result=( (lo == 0) ? hi : lo );

rectfill(screen,120,200,148,208,BLACK);
textprintf_ex(screen, font, 8*15, 200, ORANGE, -1, "%d", lo);
rectfill(screen,120,220,148,228,BLACK);
textprintf_ex(screen, font, 8*15, 220, ORANGE, -1, "%d", hi);


	if(lo < 8 && hi != lo) {
		simulate_ukeypress(key,hi);
		ureadkey(NULL);
		if (key_shifts & KB_SHIFT_FLAG) {key += 1;  Show(key); }
		if (key_shifts & KB_CTRL_FLAG)  {key += 2;  Show(key); }
		if (key_shifts & KB_ALT_FLAG)   {key += 4;  Show(key); }
		return(key);
	} else return(Result);
}
END_OF_FUNCTION(GetKey)


int GrSet()
{
	PALETTE pal;

	set_color_depth(16);
	if (set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0) !=0) return (86);
	generate_332_palette(pal);
	set_palette(pal);
	acquire_screen();
	clear_to_color(screen, makecol(0, 0, 0));

	BLACK =		makecol(0x00,0x00,0x00);
	WHITE =		makecol(0xCC,0xCC,0xFF);
	RED =		makecol(0xFF,0x33,0x00);
	DARKRED =	makecol(0xCC,0x33,0x00);
	NAPLES =	makecol(0xFF,0xCC,0x99);
	BORG =		makecol(0x33,0xCC,0x99); /* same as Endgame green 2 */
	MANGO =		makecol(0xFF,0x99,0x66);
	SEABLUE =	makecol(0x66,0x99,0xCC);
	YELLOW =	makecol(0xFF,0xCC,0x66);
	LAVENDER =	makecol(0x99,0x66,0xFF);
	DARKGRAY =	makecol(0x66,0x66,0x99);

	TAN =		makecol(0xCC,0x99,0x66);
	ORANGE =	makecol(0xFF,0x99,0x00);
	LILAC =		makecol(0xCC,0x99,0xCC);
	BIGBLUE =	makecol(0x66,0x66,0xFF);
	SKYBLUE =	makecol(0x99,0xCC,0xFF);
	PALEBLUE =	makecol(0x99,0x99,0xFF);
	BRICK =		makecol(0xCC,0x66,0x66);
	PURPLE =	makecol(0xCC,0x66,0x99);

	return(0);
}


int main(void)
{
	int c;
	char HexStr[7] = "00";

	if (allegro_init() != 0)
		return 1;
	install_keyboard();
	GrSet();


/*   textout_ex(screen, font, "Red",     32, 80,  makecol(255, 0,   0  ), -1); */
   textout_ex(screen, font, "Test Program",  8,  20,  LAVENDER, -1);
   textout_ex(screen, font, "Close: ESC",  700,  20,  LAVENDER, -1);
   textout_ex(screen, font, "Test keys",  700,  566,  LAVENDER, -1);


   textout_ex(screen, font, "ALLEG",  8,  160,  BIGBLUE, -1);
   textout_ex(screen, font, "Value",  8,  180,  BIGBLUE, -1);
   textout_ex(screen, font, "ASCII",  8,  200,  BIGBLUE, -1);
   textout_ex(screen, font, "0",  8*15,  200,  ORANGE, -1);
   textout_ex(screen, font, "Scan",  8,  220,  BIGBLUE, -1);
   textout_ex(screen, font, "0",  8*15,  220,  ORANGE, -1);
   textout_ex(screen, font, "Shift",  8,  240,  BIGBLUE, -1);
   textout_ex(screen, font, "Ctrl",  8,  260,  BIGBLUE, -1);
   textout_ex(screen, font, "Alt",  8,  280,  BIGBLUE, -1);

   textout_ex(screen, font, "lo",  168,  200,  PALEBLUE, -1);
   textout_ex(screen, font, "hi",  168,  220,  PALEBLUE, -1);

textout_ex(screen, font, "Return",  8*40,  160,  PALEBLUE, -1);
textout_ex(screen, font, "0x0000",  8*48,  160,  WHITE, -1);


LOCK_FUNCTION(GetKey);

loopback:
	do {
/*		PutTime(); */

/*
		ureadkey(0);
		if(key_shifts & KB_ALT_FLAG) rect(screen,620,180,644,188,RED);
*/
	} while(!keypressed());
	c=GetKey();
	switch( c )
	{
		case 27:
			return 0;
		default:
			rectfill(screen,120,180,168,188,BLACK);
			textprintf_ex(screen, font, 8*15, 180, NAPLES, -1, "%d", c);
			itoa(c,HexStr,16);
			rectfill(screen,384,160,464,168,BLACK);
			textout_ex(screen, font, HexStr,  8*48,  160,  WHITE, -1);
			goto loopback;
	}

   clear_keybuf();
   keyboard_lowlevel_callback = NULL;
   return 0;
}

END_OF_MAIN()


