/* TEXT 24, a graphical text editor for LCARS 24 */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef TEXT24_H
#define TEXT24_H


#include "lcars24.h"
#include "filemenu.h"
#include "mapfonts.h"
#include "playwav.h"
#include "scrnshot.h"
#include "textio.h"
#include "lcreader.h"
#include "elbows.h"
#include "help.h"
#include "winfont.h"
#include "standby.h"
#include "parts.h"


char AbbrBuf[128][32];
char ShortKey[128][3];
char CapturedStr[LINELENGTH];
int capture_x;
int capture_y;
int j;
int do_again;
int AbbrEnd;
char InputStr[100];
char FindStr[100];
char ReplaceStr[100];
char Clipboard[LINELENGTH];
char SpellBoxesDisplayed;

int Offset;
int T24MinOld;
int Hours, Minutes;
char AmPmString[5];
int submarine;
char Action;
int Result;
char RightStr[LINELENGTH];
char ProgramTitle[40];
char Abort;
int sy;
int NumLns;
int xholder, yholder, offsetholder;
int NoFind;
int Limit; /* for the find function, to be adjusted */
int DictionaryLoaded;
int PersonalDictionaryLoaded;
unsigned short UserCap;
char Dictionary[110000][30];
char PersonalDictionary[10000][30];
char SkipList[1000][30]; /* for spell check, "ignore all" list */
int DictionaryIndex[27];
int EndDict;
int EndPersonalDict;
int EndSkipList;
int TextColor;
char PersonalDictionaryUpdated;
int g1,g2; /* for cut & paste selection */
int lp; /* line pitch (can vary) */
char AutoCorrectDone;


char ActiveList;
char ShiftSelect;
int BlockStartX;
int BlockStartY;
int BlockEndX;
int BlockEndY;
char MarkWord;
char MarkFindStr;
/* char UndoFlag; The hell with Undo!!  */
char FindMode;
int CutSY;
char DictionaryMissing;
char PersonalDictionaryMissing;
char AutoCorrectOff;
BITMAP *T24buf, *T24linebuf;
char SavedAs;

void AutoCorrect();
void SilentDel();
void SaveDictionary();
void PostError(char *ErrorStr);
void LoadMainDictionary();
void LoadPersonalDictionary();
void AddToSkipList();
void AddToDictionary();
int SearchSkipList(char *WordInFile);
int SearchPersonalDict(char *WordInFile);
int SpellCheck();
int Supertype();
void DisplayFilename();
void Brackets2();
void T24ClearAllMessageBoxes();
void T24ClearClearMessageBoxes();
void T24ClearUpperMessageBoxes();
void T24Box(int Hue, int Pos, char *Label1, char *Label2);
void T24MessageBoxes();
void T24LowerMessageBoxes();
void T24Screen1();
int T24Safety();
void T24Infoxy();
void PromptOn();
void PromptOff();
void T24DialogBox();
void T24ClearDialogBox();
void NoFindMessage();
int Xfind();
void Dcursor();
void DisplayInputString();
void Dleft();
void Dright();
void Ddel();
void Dbs();
void Dchar();
void T24GetDialogInput();
int T24Find();
void T24Replace();
int T24FindAndReplace();
void T24NextFind();
void ShiftSelectOff();
void ShiftSelectOn();
int T24Pick(char MenuMode[10]);
void T24ClearWindow();
int T24DoNew();
int T24DoOpen();
void T24DoSave();
void T24DoTextColor();
void T24DoSaveAs();
void T24DoCut();
void T24DoCopy();
void T24DoPaste();
void T24DoUndo();
void T24DoFind();
void T24DoFindAndReplace();
void T24DoNext();
void T24DoAlign();
void T24DoWordCount();
void T24DoAddToDict();
void T24DoSpellCheck();
void T24DoSkip();
void T24DoHelp();
void cxUpdate();
void HighlightSelection();
void HighlightSelectionBackwards();
void T24DrawCursor();
void T24RefreshAll();
void TopOfFile();
void BottomOfFile();
void PageUp();
void PageDown();
void ScrollUp();
void ScrollDown();
int WordLeft();
int WordRight();
void Xreturn();
void Wordwrap(int GrWidth);
void T24DisplayString();
void T24DisplayRight();
void JumpUp();
void Unselect();
void SelectAll();
void SelectLeft();
void SelectRight();
void SelectWordRight();
void SelectUp();
void SelectDown();
void CursorEOL();
void CursorBOL();
int CursorLeft();
int CursorRight();
int CursorUp();
int CursorDown();
void Contract();
void DelKey();
void CtrlU();
void CtrlY();
void Backspace();
void Tab();
void AutoCap();
void T24PutOneChar();
void WordCount();
int FindGraphicalLength(int gx, int gy);
int AlignLine(int linenum);
void AlignParagraph();
void HighlightFindStr();
void HighlightWord();
void T24Edit();
void LoadAbbr();
void T24Init();
int Text24Mode();

#endif

