/*	 Mapfonts, for the LCARS 24 world map, microjustified
	fonts with upper- and lowercase, etc., but no antialiasing
	Punctuation is limited; some characters produce map symbols.
	Usage:	PutsBlock11(BITMAP *bmp,int x,int y, int Hue, char *Str)
			PutsFont13(BITMAP *bmp,int x,int y, int Hue, char *Str)
			PutsFont18(BITMAP *bmp,int x,int y, int Hue, char *Str)
			PutsFont24(BITMAP *bmp,int x,int y, int Hue, char *Str)
			(where Hue is the foreground color)
			StrLenB11(char *Str)
			StrLenFont13(char *Str)
			StrLenFont18(char *Str)
			StrLenFont24(char *Str)
	The font data should be loaded at the beginning of the
	program, by calling LoadMapFonts().
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef MAPFONTS_H
#define MAPFONTS_H


#include "lcars24.h"
#include "getkey.h"
#include "errmsg.h"
#include "parts.h"


char Block11[12544];
char Font13[12544];
char Font18[12544];
char Font24[12544];


int LoadBlock11();
int StrLenB11(char *Str);
int BlitBlock11(BITMAP *bmp,int TargetChar, int x, int y, int Hue);
int PutsBlock11(BITMAP *bmp,int x,int y, int Hue, char *Str);
int LoadFont13();
int StrLenFont13(char *Str);
int BlitFont13(BITMAP *bmp,int TargetChar, int x, int y, int Hue);
int PutsFont13(BITMAP *bmp,int x,int y, int Hue, char *Str);
int LoadFont18();
int StrLenFont18(char *Str);
int BlitFont18(BITMAP *bmp,int TargetChar, int x, int y, int Hue);
int PutsFont18(BITMAP *bmp,int x,int y, int Hue, char *Str);
int LoadFont24();
int StrLenFont24(char *Str);
int BlitFont24(BITMAP *bmp,int TargetChar, int x, int y, int Hue);
int PutsFont24(BITMAP *bmp,int x,int y, int Hue, char *Str);
void LoadMapFonts();

#endif

