/*
MIT License

Copyright (c) 2000 Adrien M. Regimbald

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

/**************************************************
 * Faile version 1.4                              *
 * Author: Adrien Regimbald                       *
 * E-mail: adrien@ee.ualberta.ca                  *
 * Web Page: http://www.ee.ualberta.ca/~adrien/   *
 *                                                *
 * File: book.h                     *
 * Purpose: header for book.c             *
 **************************************************/

#ifndef BOOK_H
#define BOOK_H



#include "allegro.h" /* for TRUE, FALSE defs */
#include "faile.h"
#include "extvars.h"
#include "protos.h"
#include "lcars24.h"
#include "parts.h"

#define B_HASH_MB 32

typedef struct {
  d_long hash;
  unsigned short int freq;
} b_hash_s;
b_hash_s *b_hash_table;
unsigned long int b_hash_mask, collisions;

void b_hash_report (void);
void b_shut_down (int status);
void init_b_hash_tables (void);
unsigned short int search_book (FILE *book);
void update_b_hash (void);
void write_book (void);

#endif


