/* Help.c, for help files
	Usage: OpenHelp(char *filespec) to take a snapshot of the screen
		then restore it when the reader closes, or
		or LcHelp(char *filespec) to call the reader directly
		The original setting below is for 300 lines.  Change it
		if you need more (HELPLINECOUNT).
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "help.h"


void HelpRefresh(int txty)
{
	int gy, i, z;

	gy=60;
	for( z = 0; z < 17; z++) {
		rectfill(screen,46,gy,752,gy+32,BLACK);
		if(txty+z < EndHelpText) {
			if( HelpLn[txty+z][0] == 33 ) {
				for( i=0; i< strlen(HelpLn[txty+z]); ++i)
				Highlight[i]=HelpLn[txty+z][i+1];
				PutsFont21(47,gy,ReaderHeadColor,strupr(Highlight));
			} else PutsFont19(47,gy,ReaderTextColor,HelpLn[txty+z]);
		}
		gy += 29;
	}
}
void HelpTopOfFile(int txty)
{
	HelpRefresh(txty);
}
void HelpEndOfFile(txty)
{
	rectfill(screen,46,60,752,558,BLACK);
	HelpRefresh(txty);
}


void HelpControl(char *filespec, int txty )
{
loopback:

	do {
		PePutTime(BRICK);
	} while(!keypressed());

	c = GetKey();
	switch( c )
	{
		case 27: SaveBookmark(filespec, txty);
			return;
		case LEFTARROW:
		case UPARROW:
			if(txty<1) goto loopback;
			--txty;
			HelpRefresh(txty);
			clear_keybuf();
			goto loopback;
		case RIGHTARROW:
		case DOWNARROW: if(txty>=EndHelpText-8) goto loopback;
			++txty;
			HelpRefresh(txty);
			clear_keybuf();
			goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
			txty=0;
			HelpTopOfFile(txty);
			goto loopback;
		case ENDKEY: if(txty>=EndHelpText-14) goto loopback;
			txty=EndHelpText-14;
			if(EndHelpText < 17) txty=0;
			HelpEndOfFile(txty);
			goto loopback;
		case PGUPKEY:
			if(txty<1) goto loopback;
			txty -=12;
			if(txty<0) txty = 0;
			HelpRefresh(txty);
			goto loopback;
		case PGDNKEY: if(txty>=EndHelpText-8) goto loopback;
			txty +=12;
			if(txty>=EndHelpText-8) {
				txty=EndHelpText-8;
			}
			HelpRefresh(txty);
			goto loopback;
		case F6: ChangeReaderTextColor();
			HelpRefresh(txty);
			goto loopback;
		default: goto loopback;
	}
}
int LoadHelpFile(char *filespec)
{
	long z;
	int i;
	unsigned short t;
	PACKFILE *Fp;

	for(z = 0; z <= EndHelpText; ++z) {
		memset(HelpLn[z],(null),80);
	}
	if( ( Fp = pack_fopen(filespec, "rt") ) == NULL ) return(86);

	z=0;
	i=0;
	t=32;
	do {
		if(pack_feof(Fp)) break;
		t = pack_getc(Fp);
			if( t == 13 ) {
			 ++z;
			 i=0;
		}  else {
			if( i > 79 ) {   /* was 60 */
				++z;
				i=0;
			}
			HelpLn[z][i] = (t);
			if (t> 31 || t == 9) ++i;
			if( t < 32 && t !=9 ) HelpLn[z][i] = (null);
		}
	}  while(1);
	t=26;
	EndHelpText = z-1;
	memset(HelpLn[z],(t),8);
	pack_fclose( Fp );
	return(0);
}

int LcHelp(char *filespec)
{
	int capX, bookmark;

	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LAVENDER);
	capX=ColorTitle(ustrupr("LCARS"),BRICK);
	PutsLuna(capX,20,BLACK,LAVENDER,MakeDisplayName(filespec));
	min_old=70;
	PePutTime(BRICK);
	UpArrowSymbol(148,566,BLACK);
	DownArrowSymbol(173,566,BLACK);
	PutsLuna(679,566, BLACK,LAVENDER, "CLOSE: ESC");
	PutsLuna(525,566, BLACK,LAVENDER, "COLORS: F6");

	ReaderHeadColor=MANGO;
	ReaderTextColor=PURPLE;

	bookmark=LoadBookmark(filespec);

	if( ! exists(filespec)) {
		NormalLoadError(filespec);
		return(86);
	}

	if(LoadHelpFile(filespec) == 0) {
		HelpRefresh(bookmark);
	} else {
		NormalLoadError(filespec);
		return(86);
	}
	HelpControl(filespec, bookmark);
	return(0);
}
int OpenHelp(char *filespec)
{  /* saves the screen then restores it when LcHelp closes */
	BITMAP *bmp = create_bitmap(800,600);

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	LcHelp(filespec);
	rectfill(screen,0,0,800,600, BLACK);
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
	return(0);
}

