/* 12/14/09 */
/* Ferengi Blackjack for LCARS 24 */


#include "blackjak.h"


#define UNAVAILABLE 0
#define AVAILABLE 1
#define TAKEN 2
#define PUSH 2

int Bet;
int OriginalBet;
int Stake;
int deck[52];
char SoftFlag;
char PlayerSoftFlag;
char DealerSoftFlag;
char PlayerBlackjack;
char DealerBlackjack;
int BettingFinished;
int BettingMessageCleared;
int DealerHand[16];
int DealerNumCards;
int DealerScore;
int PlayerHand[16];
int PlayerNumCards;
int PlayerScore;
int Payoff;
int SplitPayoff[4];
char DoubleDown;
char Insurance;
int InsurancePayoff;
char ExtraShufffle;
char SplitMessageOn;
int SplitMode;
int NumHandsInPlay;
int SplitHandNum;	/* splitting allowed up to four hands */
int SplitHandScore[4]; /* (Split aces get one hit each.) */
int SplitHand[4][16];
int SplitHandNumCards[4];
int SplitDoubleDown[4];
int SplitPush[4];
int Stock[52];
int StockCount;
int StockCountAtDeal;
int RunningCount;  /* for level-1 card-counting system */
int RunningL2;     /* for level 2 (level 3 [champion] not displayed) */
BITMAP *bmp;
BITMAP *StakeBuf;


int BjDrawSpot(int x, int y)
{
	rectfill(screen,x,y,x+cw,y+ch,MANGO);
	rectfill(screen,x+5,y+5,x+cw-5,y+ch-5,BLACK);
	return(0);
}
void BjBox1a(int Hue)
{
	int boxtop;

	boxtop=10;
	rectfill(screen,10,boxtop,110,boxtop+54,Hue);
	PutsLuna(14,boxtop + 37, BLACK,Hue, "CLOSE");
	PutsLuna(91,boxtop + 37, BLACK,Hue, "F12");
}
void BjBox2a(int Hue)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54,Hue);
}
void BjClearBox2a()
{
	BjBox2a(PALEBLUE);
/* erase any insurance-payoff message as well (from the upper elbow) */
	rectfill(screen,10,130,110,154,ORANGE);
}
void BjBox1b(int Hue, char *Str)
{
	int boxtop;

	boxtop=536;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);

	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
}
void BjBox2b(int Hue)
{
	int boxtop;

	boxtop=479;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
}
void BjBox3b(int Hue)
{
	int boxtop;

	boxtop=422;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
}
void BjBox4b(int Hue)
{
	int boxtop;

	boxtop=365;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
}
void BjBox5b(int Hue)
{
	int boxtop;

	boxtop=308;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
}
void BjElbowSignage(int Hue1, int Hue2)
{
	int boxtop;

	boxtop=590 - (54*6) - 16;
	PutsLuna(14,boxtop + 28 +9, BLACK,Hue2, "HELP");
	PutsLuna(91,boxtop + 28 +9, BLACK,Hue2, "F11");
}
void BjBoxes()
{
	BjBox1a(LILAC);
	BjBox2a(PALEBLUE);
	BjBox1b(BRICK,"");
	BjBox5b(ORANGE);
	BjElbowSignage(ORANGE, MANGO);
	rectfill(screen,10,365,110,532,MANGO);
}
int BlackjackHelp()
{
	int Result;

	SetCurrentFile("\\LC24APPS\\BLACKJAK\\BLACKJAK.TXT");
	Result=OpenTxt(CurrentFile);
	min_old=70;
	return(Result);
}
int BjCardVal(int CardCode)
{
	if(CardCode >=40) CardCode -= 39;
	if(CardCode >=27) CardCode -= 26;
	if(CardCode >=14) CardCode -= 13;
	if(CardCode==1) SoftFlag=TRUE;
	if(CardCode > 9) CardCode=10;
	return CardCode;
}
int GetBasicStrategy()
{ /* Get advice according to basic strategy */
	int d,p,c,z;
	int Advice=0;

	d=BjCardVal(DealerHand[1]);
	if(d==1) d=11;
	if(SplitMode==FALSE) p=PlayerScore;
		else p=SplitHandScore[SplitHandNum-1];

/* hard totals */
	if(p > 16) Advice=0;
	if(p < 12) Advice=1;
	if(p > 11 && p < 17) {
		if(d > 6) Advice=1;
		if(d < 7) Advice=0;
	}
	if(p==12 && (d==2 || d==3) ) Advice=1;

/* double down */
	if(SplitMode==FALSE && PlayerNumCards==2) {
		if(p==11) Advice=2;
		if(p==10 && d < 10) Advice=2;
		if(p==9 && d < 7) Advice=2;
	}
	if(SplitMode==TRUE && SplitHandNumCards[SplitHandNum-1] < 3) {
		if(p==11) Advice=2;
		if(p==10 && d < 10) Advice=2;
		if(p==9 && d < 7) Advice=2;
	}

/* soft totals */

	if(SplitMode==FALSE) {
		p=0;
		SoftFlag=FALSE;
		for(z=0; z<PlayerNumCards; ++z) {
			p += BjCardVal(PlayerHand[z]);
			if(BjCardVal(PlayerHand[z])==1) SoftFlag=TRUE;
		}
	}
	if(SplitMode==TRUE) {
		p=0;
		SoftFlag=FALSE;
		for(z=0; z<SplitHandNumCards[SplitHandNum-1]; ++z) {
			p += BjCardVal(SplitHand[SplitHandNum-1][z]);
			if(BjCardVal(SplitHand[SplitHandNum-1][z])==1) SoftFlag=TRUE;
		}
	}

	if(SoftFlag==TRUE) {
		if(p==9 && d==6) Advice=2;
		if(p==8 && d < 9) Advice=0;
		if(p==8 && d > 8) Advice=1;
		if(p==8 && d==11) Advice=0;
		if(p < 8) Advice=1; 	/* hit soft 17 or lower */
	}

/* pair splitting */

	c=0;
	if(SplitMode==FALSE) {
		if(PlayerNumCards==2 && (BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1]))) {
			c=BjCardVal(PlayerHand[0]);
		}
	}
	if(SplitMode==TRUE) {
		if(SplitHandNumCards[SplitHandNum-1]==2 && (BjCardVal(SplitHand[SplitHandNum-1][0])==BjCardVal(SplitHand[SplitHandNum-1][1]))) {
			c=BjCardVal(SplitHand[SplitHandNum-1][0]);
		}
	}
		if(c==1 || c==8) Advice=3;
		if(c==9 && d < 10 && d!=7) Advice=3;
		if(c==7 && d < 8) Advice=3;
		if(c==7 && d==10) Advice=1;
		if(c==6 && d < 8) Advice=3;
		if(c==3 && d > 3 && d < 8) Advice=3;
		if(c==2 && d > 2 && d < 8) Advice=3;
	return(Advice);
}
int DisplayL2Count(int Value)
{
	char CountStr[5];
	char WeightedStr[5];
	int Weighted;
	char OutputStr[6];

	if(Value==2 || Value==6) RunningL2 += 1;
	if(Value==3 || Value==4) RunningL2 += 2;
	if(Value==5) RunningL2 += 3;
	if(Value==9) RunningL2 -= 1;
	if(Value==10) RunningL2 -= 2;

	rectfill(screen,240,10+42,400,24+42,BLACK);
	strcpy(OutputStr,"");
	if(RunningL2 > 0) strcpy(OutputStr,"+");
	itoa(RunningL2, CountStr, 10);
	strcat(OutputStr, CountStr);
	PutsLuna(240,10+42,ORANGE,BLACK,"L2:");
	PutsLuna(284-StrLenLuna(OutputStr),10+42,ORANGE,BLACK,OutputStr);

/* same weighting as with the L1 system */
	Weighted=RunningL2;
	if(52-StockCount >= 26) Weighted=RunningL2 * 2;
	if(52-StockCount >= 33) Weighted=RunningL2 * 3;
	if(52-StockCount >= 39) Weighted=RunningL2 * 4;

	strcpy(OutputStr,"");
	if(RunningL2 > 0) strcpy(OutputStr,"+");
	itoa(Weighted, WeightedStr, 10);
	strcat(OutputStr, WeightedStr);
	PutsLuna(288+20-StrLenLuna(OutputStr),10+42,ORANGE,BLACK,OutputStr);
	return(Weighted);
}
int DisplayCount(int Value)
{
	char CountStr[5];
	char WeightedStr[5];
	int Weighted;
	char OutputStr[6];

/* L1 system */
/* simple high/low point system with same values as Hi-Opt I */
	if(Value > 3 && Value < 8) RunningCount += 1;
	if(Value==10) RunningCount -= 1;

	rectfill(screen,240,10+21,330,24+21,BLACK);
	strcpy(OutputStr,"");
	if(RunningCount > 0) strcpy(OutputStr,"+");
	itoa(RunningCount, CountStr, 10);
	strcat(OutputStr, CountStr);
	PutsLuna(240,10+21,MANGO,BLACK,"L1:");
	PutsLuna(284-StrLenLuna(OutputStr),10+21,MANGO,BLACK,OutputStr);

/* weighting adjustment for the L1 system */
	Weighted=RunningCount;

	if(52-StockCount >= 26) Weighted=RunningCount * 2;
	if(52-StockCount >= 33) Weighted=RunningCount * 3;
	if(52-StockCount >= 39) Weighted=RunningCount * 4;

	strcpy(OutputStr,"");
	if(RunningCount > 0) strcpy(OutputStr,"+");
	itoa(Weighted, WeightedStr, 10);
	strcat(OutputStr, WeightedStr);
	PutsLuna(288+20-StrLenLuna(OutputStr),10+21,MANGO,BLACK,OutputStr);
	return(Weighted);
}
int GetCountAdvice()
{
	int Advice;
	int d,p,c,tc,z;

	Advice=GetBasicStrategy();
	tc=DisplayCount(0);

	d=BjCardVal(DealerHand[1]);
	if(d==1) d=11;
	if(SplitMode==FALSE) p=PlayerScore;
		else p=SplitHandScore[SplitHandNum-1];

/* hard totals */
/*
	if(p==17) {
		if(d==2 && tc < -20) Advice=1;
		if(d==3 && tc < -20) Advice=1;
		if(d==5 && tc < -20) Advice=1;
		if(d==7 && tc < -20) Advice=1;
		if(d==8 && tc < -15) Advice=1;
		if(d==9 && tc < -15) Advice=1;
		if(d==10 && tc < -20) Advice=1;
		if(d==11 && tc < -4) Advice=1;
	}
*/
	if(p==16) {
		if(d==2 && tc < -7) Advice=1;
		if(d==3 && tc < -20) Advice=1;
		if(d==4 && tc < -9) Advice=1;
		if(d==5 && tc < -10) Advice=1;
		if(d==6 && tc < -10) Advice=1;
		if(d==7 && tc > 10) Advice=0;
		if(d==8 && tc > 10) Advice=0;
		if(d==9 && tc > 6) Advice=0;
		if(d==10 && tc > 2) Advice=0;
		if(d==11 && tc > 3) Advice=0;
	}
	if(p==15) {
		if(d==2 && tc < -5) Advice=1;
		if(d==3 && tc < -5) Advice=1;
		if(d==4 && tc < -5) Advice=1;
		if(d==5 && tc < -8) Advice=1;
		if(d==6 && tc < -8) Advice=1;
		if(d==7 && tc > 10) Advice=0;
		if(d==8 && tc > 10) Advice=0;
		if(d==9 && tc > 6) Advice=0;
		if(d==10 && tc > 3) Advice=0;
		if(d==11 && tc > 4) Advice=0;
	}
	if(p==14) {
		if(d==2 && tc < -3) Advice=1;
		if(d==3 && tc < -3) Advice=1;
		if(d==4 && tc < -5) Advice=1;
		if(d==5 && tc < -5) Advice=1;
		if(d==7 && tc > 10) Advice=0;
		if(d==8 && tc > 20) Advice=0;
		if(d==10 && tc > 13) Advice=0;
		if(d==11 && tc > 10) Advice=0;
	}
	if(p==13) {
		if(d==2 && tc < 0) Advice=1;
		if(d==3 && tc < 0) Advice=1;
		if(d==4 && tc < -1) Advice=1;
		if(d==5 && tc < -4) Advice=1;
		if(d==6 && tc < -5) Advice=1;
		if(d==11 && tc > 15) Advice=0;
	}
	if(p==12) {
		if(d==2 && tc > 3) Advice=0;
		if(d==3 && tc > 3) Advice=0;
		if(d==4 && tc < 1) Advice=1; /* an exception */
		if(d==5 && tc < -1) Advice=1;
		if(d==6 && tc < -3) Advice=1;
	}

/* double down without split pair */
	if(SplitMode==FALSE && PlayerNumCards==2) {
		if(p==11) {
			Advice=2;
			if(d>1 && d<7 && tc < -10) Advice=1;
			if(d>6 && tc < -5) Advice=1;
			if(d==11 && tc < 0) Advice=1;
		}
		if(p==10) {
			Advice=2;
			if(d>1 && d<7 && tc < -10) Advice=1;
			if(d>6 && d<9 && tc < -5) Advice=1;
			if(d==9 && tc < -1) Advice=1;
			if(d==10 && tc < 5) Advice=1;
			if(d==11 && tc < 5) Advice=1;
		}
		if(p==9) {
			Advice=2;
			if(d==2 && tc > 1) Advice=1;
			if(d>2 && d<5 && tc < 0) Advice=1;
			if(d>4 && d<7 && tc < -5) Advice=1;
			if(d==7 && tc < 5) Advice=1;
			if(d==8 && tc < 10) Advice=1;
		}
	}

	if(SplitMode==TRUE && SplitHandNumCards[SplitHandNum-1] < 3) {
		if(p==11) {
			Advice=2;
			if(d>1 && d<7 && tc < -10) Advice=1;
			if(d>6 && tc < -5) Advice=1;
			if(d==11 && tc < 0) Advice=1;
		}
		if(p==10) {
			Advice=2;
			if(d>1 && d<7 && tc < -10) Advice=1;
			if(d>6 && d<9 && tc < -5) Advice=1;
			if(d==9 && tc < -1) Advice=1;
			if(d==10 && tc < 5) Advice=1;
			if(d==11 && tc < 5) Advice=1;
		}
		if(p==9) {
			Advice=2;
			if(d==2 && tc > 1) Advice=1;
			if(d>2 && d<5 && tc < 0) Advice=1;
			if(d>4 && d<7 && tc < -5) Advice=1;
			if(d==7 && tc < 5) Advice=1;
			if(d==8 && tc < 10) Advice=1;
		}
	}

/* soft totals */
	if(SplitMode==FALSE) {
		p=0;
		SoftFlag=FALSE;
		for(z=0; z<PlayerNumCards; ++z) {
			p += BjCardVal(PlayerHand[z]);
			if(BjCardVal(PlayerHand[z])==1) SoftFlag=TRUE;
		}
	}
	if(SplitMode==TRUE) {
		p=0;
		SoftFlag=FALSE;
		for(z=0; z<SplitHandNumCards[SplitHandNum-1]; ++z) {
			p += BjCardVal(SplitHand[SplitHandNum-1][z]);
			if(BjCardVal(SplitHand[SplitHandNum-1][z])==1) SoftFlag=TRUE;
		}
	}

	if(SoftFlag==TRUE) {
		if(p==9 && d==6) Advice=2;
		if(p==8 && d < 9) Advice=0;
		if(p==8 && d > 8) Advice=1;
		if(p==8 && d==11) Advice=0;
		if(p < 8) Advice=1;		/* hit soft 17 or lower */
	}

/* pair splitting */
	c=0;
	if(SplitMode==FALSE) {
		if(PlayerNumCards==2 && (BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1]))) {
			c=BjCardVal(PlayerHand[0]);
		}
	}
	if(SplitMode==TRUE) {
		if(SplitHandNumCards[SplitHandNum-1]==2 && (BjCardVal(SplitHand[SplitHandNum-1][0])==BjCardVal(SplitHand[SplitHandNum-1][1]))) {
			c=BjCardVal(SplitHand[SplitHandNum-1][0]);
		}
	}
		if(c==1 || c==8) {
			Advice=3;
			if(c==1 && d==11 && tc < -5) Advice=1;
		}
		if(c==10) {
			Advice=0;
			if((d==2 || d==3 || d==7) && tc > 10) Advice=3;
			if((d==4 || d==5 || d==6) && tc > 5) Advice=3;
			if((d==8) && tc > 20) Advice=3;
		}
		if(c==9) {
			Advice=0;
			if(d > 1 && d < 7 && tc > -5) Advice=3;
			if(d==8 || d==9) Advice=3;
			if(d==11 && tc > 5) Advice=3;
		}
		if(c==7) {
			if(d > 1 && d < 8) Advice=3;
			if(d==8 && tc > -1) Advice=3;
		}
		if(c==6) {
			if(d > 1 && d < 5 && tc >-5) Advice=3;
			if(d > 4 && d < 8) Advice=3;
		}
		if(c==4) {
			if(d==3 && tc > -5) Advice=3;
			if(d==4 && tc > 1) Advice=3;
			if(d==5 && tc > -1) Advice=3;
			if(d==6 && tc > 0) Advice=3;
		}
		if(c==3) {
			if(d==2 && tc > -5) Advice=3;
			if(d > 2 && d < 8) Advice=3;
		}
		if(c==2) {
			if((d==2 || d==3) && tc > -5) Advice=3;
			if(d > 3 && d < 8) Advice=3;
			if(d==8 && tc > 5) Advice=3;
		}
	return(Advice);
}
int GetL2CountAdvice()
{
	int Advice;
	int d,p,c,tc,z;

	Advice=GetBasicStrategy();
	tc=DisplayL2Count(0);

	d=BjCardVal(DealerHand[1]);
	if(d==1) d=11;
	if(SplitMode==FALSE) p=PlayerScore;
		else p=SplitHandScore[SplitHandNum-1];

/* hard totals */

	if(p==17) {
		if(d==11 && tc < -14) Advice=1;
	}
	if(p==16) {
		if(d==2 && tc < -12) Advice=1;
		if(d==3 && tc < -20) Advice=1;
		if(d==4 && tc < -23) Advice=1;
		if(d==5 && tc < -28) Advice=1;
		if(d==6 && tc < -23) Advice=1;

		if(d==10 && tc > -1) Advice=0;
		if(d==11 && tc > 13) Advice=0;
	}
	if(p==15) {
		if(d==2 && tc < -10) Advice=1;
		if(d==3 && tc < -13) Advice=1;
		if(d==4 && tc < -15) Advice=1;
		if(d==5 && tc < -19) Advice=1;
		if(d==6 && tc < -19) Advice=1;
		if(d==7 && tc > 25) Advice=0;
		if(d==8 && tc > 22) Advice=0;
		if(d==9 && tc > 14) Advice=0;
		if(d==10 && tc > 5) Advice=0;
		if(d==11 && tc > 15) Advice=0;
	}
	if(p==14) {
		if(d==2 && tc < -5) Advice=1;
		if(d==3 && tc < -7) Advice=1;
		if(d==4 && tc < -10) Advice=1;
		if(d==5 && tc < -13) Advice=1;
		if(d==6 && tc < -13) Advice=1;
		if(d==7 && tc > 26) Advice=0;
		if(d==8 && tc > 30) Advice=0;
		if(d==9 && tc > 22) Advice=0;
		if(d==10 && tc > 13) Advice=0;
		if(d==11 && tc > 20) Advice=0;
	}
	if(p==13) {
		if(d==2 && tc < -1) Advice=1;
		if(d==3 && tc < -3) Advice=1;
		if(d==4 && tc < -5) Advice=1;
		if(d==5 && tc < -9) Advice=1;
		if(d==6 && tc < -8) Advice=1;
		if(d==11 && tc > 28) Advice=0;
	}
	if(p==12) {
		if(d==2 && tc > 6) Advice=0;
		if(d==3 && tc > 4) Advice=0;
		if(d==4 && tc > 1) Advice=1;
		if(d==5 && tc < -2) Advice=1;
		if(d==6 && tc < 0) Advice=1;
		if(d==11 && tc > 41) Advice=0;

	}

/* double down without split pair */
	if(SplitMode==FALSE && PlayerNumCards==2) {
		if(p==11) {
			Advice=2;
			if(d==2 && tc < -26) Advice=1;
			if(d==3 && tc < -28) Advice=1;
			if(d==4 && tc < -31) Advice=1;
			if(d==5 && tc < -35) Advice=1;
			if(d==6 && tc < -39) Advice=1;
			if(d==7 && tc < -19) Advice=1;
			if(d==8 && tc < -13) Advice=1;
			if(d==9 && tc < -10) Advice=1;
			if(d==10 && tc < -8) Advice=1;
			if(d==11 && tc < -2) Advice=1;
		}
		if(p==10) {
			Advice=2;
			if(d==2 && tc < -20) Advice=1;
			if(d==3 && tc < -22) Advice=1;
			if(d==4 && tc < -24) Advice=1;
			if(d==5 && tc < -29) Advice=1;
			if(d==6 && tc < -31) Advice=1;
			if(d==7 && tc < -13) Advice=1;
			if(d==8 && tc < -9) Advice=1;
			if(d==9 && tc < -3) Advice=1;
			if(d==10 && tc < 5) Advice=1;
			if(d==11 && tc < 5) Advice=1;
		}
		if(p==9) {
			Advice=2;
			if(d==2 && tc < 1) Advice=1;
			if(d==3 && tc < -1) Advice=1;
			if(d==4 && tc < -4) Advice=1;
			if(d==5 && tc < -9) Advice=1;
			if(d==6 && tc < -21) Advice=1;
			if(d==7 && tc < 7) Advice=1;
			if(d==8 && tc < 17) Advice=1;
		}
	}

	if(SplitMode==TRUE && SplitHandNumCards[SplitHandNum-1] < 3) {
		if(p==11) {
			Advice=2;
			if(d==2 && tc < -26) Advice=1;
			if(d==3 && tc < -28) Advice=1;
			if(d==4 && tc < -31) Advice=1;
			if(d==5 && tc < -35) Advice=1;
			if(d==6 && tc < -39) Advice=1;
			if(d==7 && tc < -19) Advice=1;
			if(d==8 && tc < -13) Advice=1;
			if(d==9 && tc < -10) Advice=1;
			if(d==10 && tc < -8) Advice=1;
			if(d==11 && tc < -2) Advice=1;
		}
		if(p==10) {
			Advice=2;
			if(d==2 && tc < -20) Advice=1;
			if(d==3 && tc < -22) Advice=1;
			if(d==4 && tc < -24) Advice=1;
			if(d==5 && tc < -29) Advice=1;
			if(d==6 && tc < -31) Advice=1;
			if(d==7 && tc < -13) Advice=1;
			if(d==8 && tc < -9) Advice=1;
			if(d==9 && tc < -3) Advice=1;
			if(d==10 && tc < 5) Advice=1;
			if(d==11 && tc < 5) Advice=1;
		}
		if(p==9) {
			Advice=2;
			if(d==2 && tc < 1) Advice=1;
			if(d==3 && tc < -1) Advice=1;
			if(d==4 && tc < -4) Advice=1;
			if(d==5 && tc < -9) Advice=1;
			if(d==6 && tc < -21) Advice=1;
			if(d==7 && tc < 7) Advice=1;
			if(d==8 && tc < 17) Advice=1;
		}
	}

/* soft totals */
	if(SplitMode==FALSE) {
		p=0;
		SoftFlag=FALSE;
		for(z=0; z<PlayerNumCards; ++z) {
			p += BjCardVal(PlayerHand[z]);
			if(BjCardVal(PlayerHand[z])==1) SoftFlag=TRUE;
		}
	}
	if(SplitMode==TRUE) {
		p=0;
		SoftFlag=FALSE;
		for(z=0; z<SplitHandNumCards[SplitHandNum-1]; ++z) {
			p += BjCardVal(SplitHand[SplitHandNum-1][z]);
			if(BjCardVal(SplitHand[SplitHandNum-1][z])==1) SoftFlag=TRUE;
		}
	}

	if(SoftFlag==TRUE) {
/*		if(p==9 && d==6) Advice=2; 	not offered here */
		if(p==8 && d < 9) Advice=0;
		if(p==8 && d > 8) Advice=1;
		if(p==8 && d==11) Advice=0;
		if(p < 8) Advice=1;		/* hit soft 17 or lower */
	}

/* pair splitting */
	c=0;
	if(SplitMode==FALSE) {
		if(PlayerNumCards==2 && (BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1]))) {
			c=BjCardVal(PlayerHand[0]);
		}
	}
	if(SplitMode==TRUE) {
		if(SplitHandNumCards[SplitHandNum-1]==2 && (BjCardVal(SplitHand[SplitHandNum-1][0])==BjCardVal(SplitHand[SplitHandNum-1][1]))) {
			c=BjCardVal(SplitHand[SplitHandNum-1][0]);
		}
	}
		if(c==1 || c==8) {
			Advice=3;
			if(c==7 && d==11 && tc < -22) Advice=1;
			if(c==8 && d==11 && tc < -20) Advice=1;
			if(c==9 && d==11 && tc < -20) Advice=1;
			if(c==10 && d==11 && tc < -20) Advice=1;
			if(c==1 && d==11 && tc < -14) Advice=1;
		}
		if(c==10) {
			Advice=0;
			if(d==2 && tc > 19) Advice=3;
			if(d==3 && tc > 15) Advice=3;
			if(d==4 && tc > 12) Advice=3;
			if(d==5 && tc > 5) Advice=3;
			if(d==6 && tc > 10) Advice=3;
			if(d==7 && tc > 22) Advice=3;
			if(d==8 && tc > 45) Advice=3;
		}
		if(c==9) {
			Advice=0;
			if(d==2 && tc > -2) Advice=3;
			if(d==3 && tc > -3) Advice=3;
			if(d==4 && tc > -5) Advice=3;
			if(d==5 && tc > -7) Advice=3;
			if(d==6 && tc > -5) Advice=3;
			if(d==7 && tc > 12) Advice=3;
			if(d==8 && tc > 15) Advice=3;
			if(d==9 && tc > 14) Advice=3;
			if(d==11 && tc > 5) Advice=3;
		}
		if(c==7) {
			if(d > 3 && d < 8) Advice=3;
			if(d==8 && tc > -1) Advice=3;
			if(d==2 && tc > -26) Advice=3;
			if(d==3 && tc > -23) Advice=3;
		}
		if(c==6) {
			if(d==2 && tc >-2) Advice=3;
			if(d==3 && tc >-1) Advice=3;
			if(d==4 && tc >-6) Advice=3;
			if(d > 4 && d < 8) Advice=3;
		}
		if(c==4) {
			Advice=1;
			if(d==3 && tc > 5) Advice=3;
			if(d==4 && tc > 1) Advice=3;
			if(d==5 && tc > -1) Advice=3;
			if(d==6 && tc > 0) Advice=3;
		}
		if(c==3) {
			Advice=1;
			if(d==2 && tc > 25) Advice=3;
			if(d > 2 && d < 8) Advice=3;
		}
		if(c==2) {
			Advice=1;
			if((d==2 || d==3) && tc > -5) Advice=3;
			if(d > 3 && d < 8) Advice=3;
			if(d==8 && tc > 5) Advice=3;
		}
	return(Advice);
}
void DisplayCountAdvice()
{
	int Advice;

	Advice=GetCountAdvice();

	rectfill(screen,331,10+21,400,24+42,BLACK);
	if(Advice==0) PutsLuna(331,10+21, MANGO, BLACK, "STAND");
	if(Advice==1) PutsLuna(331,10+21, MANGO, BLACK, "HIT");
	if(Advice==2) PutsLuna(331,10+21, MANGO, BLACK, "DOUBLE DOWN");
	if(Advice==3) PutsLuna(331,10+21, MANGO, BLACK, "SPLIT PAIR");

	Advice=GetL2CountAdvice();

	if(Advice==0) PutsLuna(331,10+42, ORANGE, BLACK, "STAND");
	if(Advice==1) PutsLuna(331,10+42, ORANGE, BLACK, "HIT");
	if(Advice==2) PutsLuna(331,10+42, ORANGE, BLACK, "DOUBLE DOWN");
	if(Advice==3) PutsLuna(331,10+42, ORANGE, BLACK, "SPLIT PAIR");
}
void DisplayBasicStrategy()
{ /* Display advice according to basic strategy */
	int Advice;

	Advice=GetBasicStrategy();
	rectfill(screen,240,10,400,24,BLACK);
	if(Advice==0) PutsLuna(240,10, PALEBLUE, BLACK, "BASIC STRATEGY: STAND");
	if(Advice==1) PutsLuna(240,10, PALEBLUE, BLACK, "BASIC STRATEGY: HIT");
	if(Advice==2) PutsLuna(240,10, PALEBLUE, BLACK, "BASIC STRATEGY: DOUBLE DOWN");
	if(Advice==3) PutsLuna(240,10, PALEBLUE, BLACK, "BASIC STRATEGY: SPLIT PAIR");
	DisplayCountAdvice();
}

void EraseDisplayOfBasicStrategy()
{
	rectfill(screen,240,10,400,24,BLACK);
	rectfill(screen,331,10+21,400,24+44,BLACK);
}
void BjNoticeButton(int hand)
{
	int adj=0;

	if(hand==3) adj=14;
	if(hand==4) adj=28;
	rectfill(screen,180,534,790,572,BLACK);
	if(hand >0) {
		if(SplitMode==FALSE) ButtonType1(226,534,LILAC,"IN PLAY");
			else ButtonType1(200+(160*(hand-1)-adj),534,LILAC,"IN PLAY");
	}
	if(hand==0) EraseDisplayOfBasicStrategy();
		else DisplayBasicStrategy();
}
void BjEnterPrompt(int Col1, int Col2, char *Message)
{
	ButtonType3(597, 135+18, Col1, Col2, Message);
	EnterSymbol(597+118, 135+18, 2, NAPLES);
}
void ShufflePrompt()
{
	ButtonType2(597, 135+14-42, PALEBLUE, BIGBLUE, "NEW SHUFFLE");
	LeftArrowSymbol(597+118, 135+12+14-42, NAPLES);
	ExtraShufffle=AVAILABLE;
}
void UpperOptionPrompt(char *Message)
{
	ButtonType3(390, 135+14-42, MANGO, ORANGE, Message);
	LeftArrowSymbol(390+118, 135+12+14-42, NAPLES);
}
void EraseUpperOptionPrompt()
{
	rectfill(screen,390,106,584,144,BLACK);
}
void LowerOptionPrompt(char *Message)
{
	ButtonType3(390, 135+18, ORANGE, MANGO, Message);
	UpArrowSymbol(390+118, 139+12+14, NAPLES); /* was 136 */
}
void EraseLowerOptionPrompt()
{
	rectfill(screen,390,153,584,191,BLACK);
}
void DoubleAfterSplitPrompt()
{ /* special version of UpperOptionPrompt() */
	ButtonType3(390, 135+14-42, PURPLE, LILAC, "DOUBLE DOWN");
	UpArrowSymbol(390+118, 135+12+14-42, NAPLES);
}
void UpDownPrompt(char *Message)
{
	ButtonType2(597, 135+14-42, PALEBLUE, BRICK, Message);
	UpArrowSymbol(597+118, 135+15-42, NAPLES);
	DownArrowSymbol(597+118+18, 135+14+19-42, NAPLES);
}
void HitStandPrompt()
{
	ButtonType2(597, 135+14-42, PALEBLUE, PURPLE, "HIT");
	RightArrowSymbol(597+118+18, 18+135+14-42, NAPLES);
	ButtonType3(597, 135+18, BRICK, ORANGE, "STAND");
	EnterSymbol(597+118, 135+18, 2, NAPLES);
}
void BetPrompt()
{
	rectfill(screen,444,96,790,190,BLACK); /* erase top right */
	UpDownPrompt("BET");
	BjClearBox2a();
}
void PairSplitPrompt()
{
	ButtonType3(390, 135+18, ORANGE, MANGO, "SPLIT HAND");
	DownArrowSymbol(390+118+18, 135+14+19, NAPLES);
	SplitMessageOn=TRUE;
}
void DealerWinMessage()
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop+34,110,boxtop+54,PALEBLUE);
	PutsLuna(14,boxtop + 37, BLACK,PALEBLUE, "DEALER WINS");
}
void PlayerWinMessage()
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop+34,110,boxtop+54,PALEBLUE);
	PutsLuna(14,boxtop + 37, BLACK,PALEBLUE, "PLAYER WINS");
	rectfill(screen,10,308+34,110,308+53,ORANGE);
	if(DoubleDown==TAKEN) PutsLuna(14,308 + 37, BLACK,ORANGE, "DOUBLE WIN");
		else PutsLuna(14,308 + 37, BLACK,ORANGE, "WIN");
}
void PostDealerScore()
{
	char DealerScoreStr[5]="BUST";

	rectfill(screen,10,68,110,68+20,PALEBLUE);
	PutsLuna(14,72, BLACK,PALEBLUE, "DEALER");
	if(DealerScore < 22) itoa(DealerScore, DealerScoreStr, 10);
	if(DealerScore < 22 /* && SplitMode==FALSE */ ) {
		if(DealerScore > PlayerScore || PlayerScore > 21) DealerWinMessage();
	}
	PutsLuna(106-StrLenLuna(DealerScoreStr),72,BLACK,PALEBLUE, DealerScoreStr);
}
void PostPlayerScore()
{
	char PlayerScoreStr[5]="BUST";

	rectfill(screen,10,308,110,308+53,ORANGE);
	PutsLuna(14,312, BLACK,ORANGE, "PLAYER");
	if(PlayerScore < 22) itoa(PlayerScore, PlayerScoreStr, 10);
	PutsLuna(106-StrLenLuna(PlayerScoreStr),312,BLACK,ORANGE, PlayerScoreStr);
	if(PlayerScore > 21) DealerWinMessage();
}
void PostHand1Score()
{
	char PlayerScoreStr[5]="BUST";

	rectfill(screen,10,308,110,308+20,ORANGE);
	PutsLuna(14,312, BLACK,ORANGE, "HAND 1");
	if(SplitHandScore[0] < 22) itoa(SplitHandScore[0], PlayerScoreStr, 10);
	PutsLuna(106-StrLenLuna(PlayerScoreStr),312,BLACK,ORANGE, PlayerScoreStr);
/* need this for the sister functions below */
	if(SplitHandScore[0] > 21) {
		rectfill(screen,10,308+34,110,308+53,ORANGE);
	}
}
void PostHand2Score()
{
	char PlayerScoreStr[5]="BUST";

	rectfill(screen,10,365,110,365+20,ORANGE);
	PutsLuna(14,369, BLACK,ORANGE, "HAND 2");
	if(SplitHandScore[1] < 22) itoa(SplitHandScore[1], PlayerScoreStr, 10);
	PutsLuna(106-StrLenLuna(PlayerScoreStr),369,BLACK,ORANGE, PlayerScoreStr);
}
void PostHand3Score()
{
	char PlayerScoreStr[5]="BUST";

	rectfill(screen,10,422,110,422+20,ORANGE);
	PutsLuna(14,426, BLACK,ORANGE, "HAND 3");
	if(SplitHandScore[2] < 22) itoa(SplitHandScore[2], PlayerScoreStr, 10);
	PutsLuna(106-StrLenLuna(PlayerScoreStr),426,BLACK,ORANGE, PlayerScoreStr);
}
void PostHand4Score()
{
	char PlayerScoreStr[5]="BUST";

	rectfill(screen,10,479,110,479+20,ORANGE);
	PutsLuna(14,483, BLACK,ORANGE, "HAND 4");
	if(SplitHandScore[3] < 22) itoa(SplitHandScore[3], PlayerScoreStr, 10);
	PutsLuna(106-StrLenLuna(PlayerScoreStr),483,BLACK,ORANGE, PlayerScoreStr);
}
void PushMessage()
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop+34,110,boxtop+54,PALEBLUE);
	PutsLuna(14,boxtop + 37, BLACK,PALEBLUE, "PUSH");
	rectfill(screen,10,308+34,110,308+53,ORANGE);
	PutsLuna(14,308 + 37, BLACK,ORANGE, "PUSH");
}
void PayBlackjackMessage()
{
	SplitResultMessage(0,"3-TO-2 WIN");
}
void InsurancePayoffMessage()
{
	int boxtop;

	boxtop=148;
	PutsLuna(14,boxtop + 6 -24, BLACK,ORANGE, "INSURANCE PAID");
}
void BjDrawStock()
{ /* face-down remaining undeal cards--shows actual number if fewer than 3 */
	if( StockCount < 3) rectfill(screen,140,80,150+cw,90+ch,BLACK);
/* last argument 0=full card back not necessary */
	if( StockCount > 2) DrawDownCard(146,82,0);
	if( StockCount > 1) DrawDownCard(148,83,0);
	DrawDownCard(150,84,1);
}
void ShufflingMessage()
{
	rectfill(screen,140,80,150+cw,90+ch,BLACK); /* erase stock */
	PutsFont21(150,130,ORANGE, "SHUFFLING");
	rest(300);
	rectfill(screen,150,130,240,160,BLACK);
	rest(200);
	PutsFont21(150,130,PALEBLUE, "SHUFFLING");
	rest(300);
	rectfill(screen,150,130,240,160,BLACK);
	rest(200);
	PutsFont21(150,130,ORANGE, "SHUFFLING");
	rest(300);
	rectfill(screen,150,130,240,160,BLACK);
/*
	rest(200);
	PutsFont21(150,130,PALEBLUE, "SHUFFLING");
	rest(300);
	rectfill(screen,150,130,240,160,BLACK);
*/
	BjDrawStock();
}
void EmergencyShuffle()
{
	int z;

	for( z=StockCountAtDeal; z<52; ++z) deck[z]=z+1;
	shuffle( deck, 52-StockCountAtDeal);
	for( z=StockCountAtDeal; z<52; ++z) Stock[z]=deck[z];
	StockCount=52;
	ShufflingMessage();
}
void NewShuffle()
{
	int z;

	for( z=0; z<52; ++z) deck[z]=z+1;
	shuffle( deck, 52);

	for( z=0; z<52; ++z) Stock[z]=deck[z];

	RunningCount=0;
	RunningL2=0;
	DisplayCount(0);
	DisplayL2Count(0);

/* stack the deck for testing */

/*
Stock[51]=13;
Stock[50]=13+13;
Stock[49]=10+26;
Stock[48]=10+39;
Stock[47]=11;
Stock[46]=12+13;
Stock[45]=1+26;
*/

	StockCount=52;
}
void ReportStake()
{
	char StakeStr[15];

	itoa(Stake, StakeStr, 10);
	strcat(StakeStr," SLIPS");
	PutsLuna(640, 370, ORANGE,BLACK, StakeStr);
}
void DrawBettingArea()
{
	PutsFont19(240-57,272,ORANGE,"INSURANCE PAYS 2 TO 1");
	PutsFont19(496+65,272,PALEBLUE,"BLACKJACK PAYS 3 TO 2");
	PutsFont19(380-16,272,BRICK,"DEALER MUST HIT SOFT 17");
	rectfill(screen,150,300,760,350,BIGBLUE);
	rectfill(screen,155,265+40,755,305+40,BLACK);
}
void DrawBettingMessage()
{
	PutsFont21(180-8,275+40,PURPLE,"PLACE A BET");
	PutsFont21(275-8,275+40,ORANGE,"GOLD-PRESSED LATINUM ONLY");
	PutsFont21(484-8,275+40,MANGO,"MINIMUM 2 SLIPS");
	PutsFont21(613-8,275+40,PALEBLUE,"MAXIMUM 100 SLIPS");
	BettingMessageCleared=FALSE;
}
void DrawLatinum(int a, int b)
{
	int GOLD, DARK,LIGHT;

	GOLD=makecol(0x9e,0x70, 0);
	DARK=makecol(0x50,0x50,0);
	LIGHT=makecol(0xe0,0xb0,0x50);
	rectfill(screen,a,b,a+20,b+60,GOLD);
	rect(screen,a,b,a+20,b+60,BLACK);
	hline(screen,a+1,b+1,a+19,LIGHT);
	hline(screen,a+1,b+59,a+19,DARK);
	vline(screen,a+1,b+1,b+59,LIGHT);
	vline(screen,a+19,b+1,b+59,DARK);
}
void DrawLatinumToBuffer(int a, int b)
{
	int GOLD, DARK,LIGHT;

	GOLD=makecol(0x9e,0x70, 0);
	DARK=makecol(0x50,0x50,0);
	LIGHT=makecol(0xe0,0xb0,0x50);
	rectfill(StakeBuf,a,b,a+20,b+60,GOLD);
	rect(StakeBuf,a,b,a+20,b+60,BLACK);
	hline(StakeBuf,a+1,b+1,a+19,LIGHT);
	hline(StakeBuf,a+1,b+59,a+19,DARK);
	vline(StakeBuf,a+1,b+1,b+59,LIGHT);
	vline(StakeBuf,a+19,b+1,b+59,DARK);
}
void DrawOneRowOfLatinum(int amount, int tier)
{
	int a,b,x,z;

	if(tier > 10) return;
	a=0;
	b=0;
	x=tier;
	tier=tier * 10;
	for( z=0; z<amount; ++z) {
		DrawLatinumToBuffer( 6+(z*6)+(x*3), 10+tier+(b*7) );
		++a;
		if(a==10) {
			++b;
			a=0;
		}
	}
}
void DrawStake()
{
	int ThisRow,StakeHolder;
	int y=0;

	clear_bitmap(StakeBuf);
	StakeHolder=Stake;
	if(StakeHolder > 640) StakeHolder -= 320;
	ThisRow=Stake;
	while(StakeHolder > 0) {
		if(StakeHolder > 40) {
			ThisRow=40;
			StakeHolder-=40;
		} else {
			ThisRow=StakeHolder;
			StakeHolder=0;
		}
		DrawOneRowOfLatinum(ThisRow,y);
		++y;
		if(y > 7) y=0;
	}
	blit(StakeBuf, screen, 0, 0, 490, 370, 300, 163); /* to screen */
}
void BjDisplayNew()
{
	BjDrawStock();
	BjDrawSpot(150+90,380);
	DrawStake();
	DrawBettingArea();
	DrawBettingMessage();
	ReportStake();
	BetPrompt();
}
void ShowDealerHoleCard()
{
	DrawCard(240,84,DealerHand[0]);
	DrawCard(240+14,90,DealerHand[1]);
}
void SellInsurance()
{
	UpperOptionPrompt("INSURANCE");
	Insurance=AVAILABLE;
}
void BjNewHand()
{
	rectfill(screen,130,70,444,90+ch,BLACK); /* erase top left */
	rectfill(screen,444,96,790,90+ch,BLACK); /* erase top right */
	rectfill(screen, 120, 250, 790, 590, BLACK); /* erase bottom */
	rectfill(screen,10,365,110,532,MANGO); /* split-hand boxes */

	if(StockCount < 10) {
		NewShuffle();
		ShufflingMessage();
	}
	NumHandsInPlay=1;
	Bet=0;
	BettingFinished=FALSE;
	PlayerScore=0;
	DealerScore=0;
	SoftFlag=FALSE;
	PlayerSoftFlag=FALSE;
	DealerSoftFlag=FALSE;
	BjDisplayNew();
}
int DealerHit()
{
	char DealerScoreStr[5];
	int z;

	if(StockCount < 2) EmergencyShuffle();

	if(DealerScore >=21) {
		itoa(DealerScore, DealerScoreStr, 10);
		rectfill(screen,340+(14*(DealerNumCards-3)),130,355+(14*(DealerNumCards-3)),160,BLACK);
		PutsFont21(340+(14*(DealerNumCards-2)),130,ORANGE, DealerScoreStr);
		if(DealerScore > 21) PutsFont21(340+(14*(DealerNumCards-2)),162,ORANGE, "BUST");
		PostDealerScore();
		return(1);
	}
	rest(150);
	--StockCount;
	DealerHand[DealerNumCards]=Stock[StockCount-1];
	++DealerNumCards;
	srand( (unsigned int)time( NULL ) );
	DrawCard(240+(14*(DealerNumCards-1)),71+(rand() % 12),DealerHand[DealerNumCards-1]);
	DisplayCount(BjCardVal(DealerHand[DealerNumCards-1]));
	DisplayL2Count(BjCardVal(DealerHand[DealerNumCards-1]));
/* a fresh count with each hit, for accurate hard/soft tracking */
	SoftFlag=FALSE;
	DealerScore=0;
	for(z=0; z<DealerNumCards; ++z) DealerScore += BjCardVal(DealerHand[z]);
	if(SoftFlag==TRUE && DealerScore < 12) {
		DealerScore += 10;
		DealerSoftFlag=TRUE;
	}
	PostDealerScore();
	itoa(DealerScore, DealerScoreStr, 10);
	rectfill(screen,340+(14*(DealerNumCards-3)),130,355+(14*(DealerNumCards-3)),160,BLACK);
	PutsFont21(340+(14*(DealerNumCards-2)),130,ORANGE, DealerScoreStr);
	if(DealerScore > 21) PutsFont21(340+(14*(DealerNumCards-2)),162,ORANGE, "BUST");
	return(1);
}
int BjAcknowledge()
{
	rectfill(screen,583,96,790,90+ch,BLACK); /* erase top right */
	BjEnterPrompt(BIGBLUE, PALEBLUE,"CONTINUE");
	if(StockCount < 49) ShufflePrompt();

loopback:

	do {
		SolPutTime();
	} while(!keypressed());
	c=GetKey();
	switch( c )
		{
		case 13: rectfill(screen,583,96,790,90+ch,BLACK); /* erase top right */
				BjNewHand();
				clear_keybuf();
				return(1);
		case LEFTARROW:	if(ExtraShufffle==AVAILABLE) NewShuffle();
				ExtraShufffle=UNAVAILABLE;

	rectfill(screen,130,70,444,90+ch,BLACK); /* erase top left */
	rectfill(screen,444,96,790,90+ch,BLACK); /* erase top right */
	rectfill(screen, 120, 250, 790, 590, BLACK); /* erase bottom */
	rectfill(screen,10,365,110,532,MANGO); /* split-hand boxes */

				ShufflingMessage();
				BjNewHand();
				return(1);
		case F11: BlackjackHelp();
				PanelBeep();
				goto loopback;
		case F12: return(0);
		default: ScoldUser();
			goto loopback;
	}
}
void ShowSplitWinnings(int hand, int Amount)
{
	char PayoffStr[5];
	int adj=0;
	int x,y,z;

	char PayoffMessage[16]="PAYOFF: ";
	itoa(Payoff, PayoffStr, 10);
	strcat(PayoffMessage, PayoffStr);
	PutsFont21(250,275+40,PALEBLUE,PayoffMessage);

	if(Payoff==0) return;

	if(hand==3) adj=14;
	if(hand==4) adj=28;
	x=0;
	y=0;
	for( z=0; z<Amount; ++z) {
		if(x==10) {
			x=0;
			y+=4;
		}
		++x;
		DrawLatinum(222+(160*(hand-1)-adj)+(x*9)+y, 450+y);
	}
}
void ShowWinnings()
{
	ShowSplitWinnings(1,Payoff);
	Stake += Bet;
	Stake += Payoff;
	Payoff=0;
}
void PayInsurance()
{
	int z;

	for( z=0; z<Bet; ++z) {
		DrawLatinum(253+(z*6), 254);
	}
	InsurancePayoffMessage();
	InsurancePayoff=Bet * 1.5;
	Stake += InsurancePayoff;
	InsurancePayoff=0;
	Insurance=UNAVAILABLE;
}
void SpreadLatinumBet(int x, int y, int Amount)
{
	int z,a,b,c;
	a=0;
	b=0;
	c=0;
	for( z=0; z<Amount; ++z) {
		DrawLatinum(x+(z*4)+b, y+(c*3));
		++a;
		if(b > 0) b=0;
		if(a==10) {
			a=0;
			b=4;
			c=!c;
		}
	}
}
int ChangeBet(int x, int y, int Amount)
{ /* same as above but only draws the last two slips of latinum */
	int z,a,b,c;
	a=0;
	b=0;
	c=0;
	for( z=0; z<Amount; ++z) {
		++a;
		if(z>Amount-3) DrawLatinum(x+(z*4)+b, y+(c*3));
		if(b > 0) b=0;
		if(a==10) {
			a=0;
			b=4;
			c=!c;
		}
	}
	return(x+(z*4)+b);
}
void BjTakeSnapshot()
{
	clear_bitmap(bmp);
	blit(screen, bmp, 140, 230, 0, 0, 570, 350); /* to memory bitmap */
}
void BjRestoreBackground()
{
	vsync();
	blit(bmp, screen, 0, 0, 140, 230, 570, 350); /* to screen */
}
void RestoreFromHand2()
{
	vsync();
	blit(bmp, screen, 220, 0, 140+220, 230, 570-220, 350); /* to screen */
}
void RestoreFromHand3()
{
	vsync();
	blit(bmp, screen, 490, 0, 140+490, 230, 570-490, 350); /* to screen */
}
void PlaceInsurance()
{
	int InsuranceAmount;

	InsuranceAmount=Bet*.5;
	if(BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1])) BjRestoreBackground();
	SpreadLatinumBet(530,250,InsuranceAmount);
	Stake -= Bet/2;
	DrawStake();
	ReportStake();
	SpreadLatinumBet(338,300,Bet);
	if(BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1])) BjTakeSnapshot();
	DrawCard(240-14,390,PlayerHand[0]);
	DrawCard(240,400,PlayerHand[1]);
	EraseUpperOptionPrompt();
	Insurance=TAKEN;
}
void BjPush()
{
	Payoff=0;
	PushMessage();
	ShowWinnings();
}

/* Place a message HAND WINS/DEALER WINS/PUSH in one of the boxes
   of the lower bracket for split hands after the dealer's turn */
int SplitResultMessage(int Hand, char *Str)
{
	int boxtop;

	boxtop=590-(54*(5-Hand))-((4-Hand)*3);
	rectfill(screen,10,boxtop+37,110,boxtop+53,ORANGE);
	PutsLuna(14,boxtop+37,BLACK,ORANGE,Str);
	return(0);
}
void CheckEachSplitHand()
{
	int Hand,z,HandWin;

	for(z=0; z<4; ++z) SplitPayoff[z]=0;
	for(Hand=0; Hand<NumHandsInPlay; ++Hand) {
		HandWin=TRUE;
		if(SplitHandScore[Hand]==DealerScore) {
			SplitResultMessage(Hand,"PUSH");
			HandWin=PUSH;
		}
		if(SplitHandScore[Hand] > 21) {
			SplitResultMessage(Hand,"BUST");
			HandWin=FALSE;
		}

		if(DealerScore > 21) DealerScore=0;

		if(SplitHandScore[Hand] < DealerScore) {
/*			SplitResultMessage(Hand,"DEALER WINS"); */
			HandWin=FALSE;
		}
		if(HandWin==TRUE) {
			SplitResultMessage(Hand,"WIN");
			SplitPayoff[Hand]=OriginalBet;
			if(SplitDoubleDown[Hand]==TAKEN) {
				SplitPayoff[Hand]+=OriginalBet;
				SplitResultMessage(Hand,"DOUBLE WIN");
			}
		}
		if(HandWin==PUSH) {
			SplitPush[Hand]=1;
			if(SplitDoubleDown[Hand]==TAKEN) {
				SplitPush[Hand]=2;
			}
		}
	}
	Payoff=0;
	for(z=0; z<4; ++z) Payoff += SplitPayoff[z];
	for(Hand=0; Hand<NumHandsInPlay; ++Hand) {
		if(SplitPayoff[Hand]!=0) ShowSplitWinnings(Hand+1,SplitPayoff[Hand]);
	}
	Stake += Payoff*2; /* bet + Payoff for each winning hand */
	for(z=0; z<4; ++z) Stake += (SplitPush[z] * OriginalBet);

	Payoff=0;
}
void CheckForPlayerWin()
{
	if(PlayerScore==DealerScore) {
		BjPush();
		return;
	}
	if(PlayerScore > 21) {
		DealerWinMessage();
		return;
	}
	if(DealerScore > 21) DealerScore=0;
	if(PlayerScore < DealerScore) {
		DealerWinMessage();
		return;
	}
	Payoff=Bet;
	PlayerWinMessage();
	ShowWinnings();
}
void CheckForDealerWin()
{
	if(PlayerScore==DealerScore) {
		BjPush();
		return;
	}
	if(PlayerScore > 21) return;
	if(DealerScore > 21) DealerScore=0;
	if(PlayerScore < DealerScore) return;
	Payoff=Bet;
	PlayerWinMessage();
	ShowWinnings();
}
int PlayerBust()
{
	PutsFont21(162,472,ORANGE, "BUST");
	BettingFinished=FALSE;
	BjNoticeButton(0);
	ShowDealerHoleCard();
	if(BjCardVal(DealerHand[0])==10 && Insurance==TAKEN) PayInsurance();
	Bet=0;
	return(BjAcknowledge());
}
int PlayerHasBlackjack()
{
	PlayerBlackjack=FALSE;
	if(BjCardVal(DealerHand[1]) != 1) goto out; /* temporary (10--> 1) */
	rectfill(screen,444,96,790,90+ch,BLACK); /* erase top right */
	BjNoticeButton(0);
	BjEnterPrompt(BIGBLUE, PALEBLUE,"CONTINUE");
	SellInsurance();
loopback:
	do {
		SolPutTime();
	} while(!keypressed());
	c=GetKey();
	switch( c )
		{
		case 13:		if(Insurance != UNAVAILABLE) {
					EraseUpperOptionPrompt();
				}
				clear_keybuf();
				goto out;
		case F12: 	return(0);
		case F11:		BlackjackHelp();
				PanelBeep();
				goto loopback;
		case LEFTARROW: if(Insurance==AVAILABLE) {
					PlaceInsurance();
				}
				goto out;
		case CTRL_F1: 	Screenshot792("Bljack8.bmp");
				PanelBeep();
				goto loopback;
		case CTRL_F2: 	Screenshot1024("Bljack10.bmp");
				PanelBeep();
				goto loopback;
		default: 		ScoldUser();
				goto loopback;
	}
out:
	ShowDealerHoleCard();
	if(BjCardVal(DealerHand[0])==10 && Insurance==TAKEN) PayInsurance();
	Insurance=UNAVAILABLE;
	PlayerBlackjack=FALSE;
	if(PlayerScore==DealerScore) return(1);
	Payoff=Bet*1.5;
	PayBlackjackMessage();
	BjNoticeButton(0);
	ShowWinnings();
	PlayerScore=0;
	return(BjAcknowledge());
}
int PlayerStand()
{
	char DealerScoreStr[5];

	ShowDealerHoleCard();
	DisplayCount(BjCardVal(DealerHand[0]));
	DisplayL2Count(BjCardVal(DealerHand[0]));
	itoa(DealerScore, DealerScoreStr, 10);
	rectfill(screen,340,130,355,160,BLACK);
	PutsFont21(340,130,ORANGE, DealerScoreStr);
	PostDealerScore();
	rest(250);
	if(BjCardVal(DealerHand[0])==10 && Insurance==TAKEN) PayInsurance();
	if(DealerScore==17 && DealerSoftFlag==TRUE) DealerHit();
	DealerSoftFlag=FALSE;
	while(DealerScore < 17) DealerHit();
	if(DealerScore==17 && DealerSoftFlag==TRUE) DealerHit();
	if(DealerScore < 17) DealerHit();
	SoftFlag=FALSE;
	CheckForPlayerWin();
	rest(250);
	return(BjAcknowledge());
	return(1);
}
int PlayerHit()
{
	char PlayerScoreStr[5];
	int z;

	if(PlayerScore >=21) {
		BjNoticeButton(0);
		return(1);
	}
	if(StockCount < 2) EmergencyShuffle();
	--StockCount;
	PlayerHand[PlayerNumCards]=Stock[StockCount-1];
	++PlayerNumCards;
/* make the Ferengi shuttle rotate when the player takes a hit */
	Animate=1;
	DrawDownCard(150,84,1);
	srand( (unsigned int)time( NULL ) );
	DrawCard(240+(14*(PlayerNumCards-2)),380+((rand() % 11)*4),PlayerHand[PlayerNumCards-1]);
	DisplayCount(BjCardVal(PlayerHand[PlayerNumCards-1]));
	DisplayL2Count(BjCardVal(PlayerHand[PlayerNumCards-1]));
/* a fresh count with each hit, for accurate hard/soft tracking */
	PlayerScore=0;
	SoftFlag=FALSE;
	for(z=0; z<PlayerNumCards; ++z) PlayerScore += BjCardVal(PlayerHand[z]);
	if(SoftFlag==TRUE && PlayerScore < 12) 	PlayerScore += 10;
	PostPlayerScore();
	DisplayBasicStrategy();
	if(PlayerScore==21) BjNoticeButton(0);
	itoa(PlayerScore, PlayerScoreStr, 10);
	rectfill(screen,170,440,220,462,BLACK);
	PutsFont21(170,440,ORANGE, PlayerScoreStr);
	if(PlayerScore > 21) return(PlayerBust());
		else return(1);
}
int BjDeal()
{
	int z;
	char PlayerScoreStr[5];

	for(z=0; z<4; ++z) SplitDoubleDown[z]=UNAVAILABLE;
	DoubleDown=UNAVAILABLE;
	SplitMessageOn=FALSE;
	SplitMode=FALSE;
	NumHandsInPlay=1;
	SplitHandNum=0;
	Insurance=UNAVAILABLE;
	StockCountAtDeal=StockCount; /* noted in case partial shuffle needed */

/* Dealer */
	DealerSoftFlag=FALSE;
	rectfill(screen,390,96,790,90+ch,BLACK); /* erase top right */
	ExtraShufffle=UNAVAILABLE;
	DrawDownCard(240,84,1);
	DealerHand[0]=Stock[StockCount-1];
	--StockCount;
	rest(150);
	DrawCard(240+14,90,Stock[StockCount-1]);
	DealerHand[1]=Stock[StockCount-1];
	--StockCount;
	DealerNumCards=2;
	SoftFlag=FALSE;
	DealerScore=BjCardVal(DealerHand[0]) + BjCardVal(DealerHand[1]);
	DisplayCount(BjCardVal(DealerHand[1]));
	DisplayL2Count(BjCardVal(DealerHand[1]));
	if(SoftFlag==TRUE) DealerSoftFlag=TRUE;
	if(DealerSoftFlag==TRUE && DealerScore < 12) DealerScore += 10;
	rest(150);

/* Player */
	PlayerHand[0]=Stock[StockCount-1];
	--StockCount;
	PlayerHand[1]=Stock[StockCount-1];
	--StockCount;
	if(BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1])) BjTakeSnapshot();

	DrawDownCard(240+14,390,1);
	rest(150);
	DrawDownCard(240,400,1);
	PlayerNumCards=2;

	rest(600);
	rectfill(screen,220,360,360,510,BLACK);
	BjDrawSpot(240,380);
	DrawCard(240-14,390,PlayerHand[0]);
	DrawCard(240,400,PlayerHand[1]);
	DisplayCount(BjCardVal(PlayerHand[0]));
	DisplayCount(BjCardVal(PlayerHand[1]));
	DisplayL2Count(BjCardVal(PlayerHand[0]));
	DisplayL2Count(BjCardVal(PlayerHand[1]));
	SoftFlag=FALSE;
	PlayerScore=BjCardVal(PlayerHand[0]) + BjCardVal(PlayerHand[1]);
	PlayerSoftFlag=FALSE;
	if(SoftFlag==TRUE) PlayerSoftFlag=TRUE;
	if(PlayerSoftFlag==TRUE && PlayerScore < 12) PlayerScore += 10;
	if(PlayerScore==21) {
		PlayerBlackjack=TRUE;
		PutsFont21(142,472,PALEBLUE, "BLACKJACK");
	}
	if(PlayerScore==9 || PlayerScore==10 || PlayerScore==11 ) {
		if(Stake >= Bet ) {
			LowerOptionPrompt("DOUBLE DOWN");
			DoubleDown=AVAILABLE;
		}
	}
	if((PlayerScore==19 || PlayerScore==20) && PlayerSoftFlag==TRUE) {
		if(Stake >= Bet ) {
			LowerOptionPrompt("DOUBLE DOWN");
			DoubleDown=AVAILABLE;
		}
	}

	if(BjCardVal(PlayerHand[0])==BjCardVal(PlayerHand[1])) {
		if(BjCardVal(PlayerHand[0]) !=5 ) PairSplitPrompt();
	}
	PostPlayerScore();
	if(PlayerScore != 21) DisplayBasicStrategy();
	itoa(PlayerScore, PlayerScoreStr, 10);
	rectfill(screen,170,440,220,462,BLACK);
	PutsFont21(170,440,ORANGE, PlayerScoreStr);
	HitStandPrompt();
	BjNoticeButton(1);
	if(BjCardVal(DealerHand[1])==1) SellInsurance();
	return(0);
}
int UndoBet()
{
	Stake+=Bet;
	Bet=0;
	rectfill(screen,420,300,790,590,BLACK);
	DrawBettingArea();
	DrawBettingMessage();
	DrawStake();
	ReportStake();
	return(0);
}
int PlaceSplitBet(int Hand)
{
	char BetStr[5];

	SpreadLatinumBet(344,300-(Hand*10),OriginalBet);
	itoa(Bet, BetStr, 10);
	rectfill(screen,155,305,250,345,BLACK);
	PutsFont21(180,315,ORANGE,"BET:");
	PutsFont21(180+36,315,ORANGE,BetStr);
	DrawStake();
	ReportStake();
	return(0);
}
int PlaceDoubleDown()
{
	char BetStr[5];

	SpreadLatinumBet(344,310,Bet);
	Stake -= Bet;
	Bet=Bet*2;
	itoa(Bet, BetStr, 10);
	rectfill(screen,155,305,250,305+40,BLACK);
	PutsFont21(180,315,ORANGE,"BET:");
	PutsFont21(180+36,315,ORANGE,BetStr);
	DrawStake();
	ReportStake();
	EraseDisplayOfBasicStrategy();
	DoubleDown=TAKEN;
	return(0);
}
int PlaceSplitDoubleDown(int Hand)
{
	int z;
	char BetStr[5];

	SpreadLatinumBet(350,304-(Hand*10),OriginalBet);
	Stake -= OriginalBet;
	Bet += OriginalBet;
	itoa(Bet, BetStr, 10);
	rectfill(screen,155,305,250,305+40,BLACK);
	PutsFont21(180,315,ORANGE,"BET:");
	PutsFont21(180+36,315,ORANGE,BetStr);
	DrawStake();
	ReportStake();
	SplitDoubleDown[Hand]=TAKEN;
	if(NumHandsInPlay > 2) {
		for(z=0; z<SplitHandNumCards[2]; ++z) {
			DrawCard(200+160+160-14+(z*14),390+(z*14),SplitHand[2][z]);
		}
	}
	if(NumHandsInPlay==4) DrawCard(680-28,390,SplitHand[3][0]);
	EraseDisplayOfBasicStrategy();
	return(0);
}
int PlaceBet(int Amount)
{
	char BetStr[5];

	Bet += Amount;
	Stake-=Amount;
	itoa(Bet, BetStr, 10);
	if(BettingMessageCleared==FALSE) {
		rectfill(screen,155,265+40,755,305+40,BLACK);
		BettingMessageCleared=TRUE;
	}
	else rectfill(screen,155,305,300,337,BLACK);
	PutsFont21(180,315,ORANGE,"BET:");
	PutsFont21(180+36,315,ORANGE,BetStr);
	ChangeBet(338,300,Bet);
	DrawStake();
	ReportStake();
	return(0);
}
int ReduceBet(int Amount)
{
	int x;
	char BetStr[5];

	Bet -= Amount;
	Stake+=Amount;
	itoa(Bet, BetStr, 10);

	rectfill(screen,155,305,300,337,BLACK);
	PutsFont21(180,315,ORANGE,"BET:");
	PutsFont21(180+36,315,ORANGE,BetStr);
	x=ChangeBet(338,300,Bet);
	rectfill(screen,x,300,x+23,368,BLACK);
	rectfill(screen,x,300,x+24,304,BIGBLUE);
	rectfill(screen,x,346,x+24,350,BIGBLUE);
	x=ChangeBet(338,300,Bet);
	DrawStake();
	ReportStake();
	return(0);
}
int SplitHit()
{
	int z,xpos,ypos;

	if(StockCount < 2) EmergencyShuffle();
	SplitHand[SplitHandNum-1][SplitHandNumCards[SplitHandNum-1]]=Stock[StockCount-1];
	++SplitHandNumCards[SplitHandNum-1];

/* make the Ferengi shuttle rotate when the player takes a hit */
	Animate=1;
	DrawDownCard(150,84,1);
	srand( (unsigned int)time( NULL ) );
	xpos=(11*(SplitHandNumCards[SplitHandNum-1])+150*(SplitHandNum-1)-1)+(rand() % 4);
	ypos=(12*(SplitHandNumCards[SplitHandNum-1])-1)*.5+(rand() % 16);
	DrawCard(200+xpos,390+ypos-12,SplitHand[SplitHandNum-1][SplitHandNumCards[SplitHandNum-1]-1]);
	--StockCount;
	DisplayCount(BjCardVal(SplitHand[SplitHandNum-1][SplitHandNumCards[SplitHandNum-1]-1]));
	DisplayL2Count(BjCardVal(SplitHand[SplitHandNum-1][SplitHandNumCards[SplitHandNum-1]-1]));
	EraseUpperOptionPrompt();

/* check for additional split (disallowed for aces, 5s or 10s) */
	if(BjCardVal(SplitHand[SplitHandNum-1][0])==BjCardVal(SplitHand[SplitHandNum-1][1])) {
		if(BjCardVal(SplitHand[SplitHandNum-1][0]) !=1 && BjCardVal(SplitHand[SplitHandNum-1][0]) !=5 && BjCardVal(SplitHand[SplitHandNum-1][0]) !=10 && SplitHandNumCards[SplitHandNum-1]==2 ) {
			if(NumHandsInPlay < 4) PairSplitPrompt();
		}
	}

/* a fresh count with each hit, for accurate hard/soft tracking */
	SplitHandScore[SplitHandNum-1]=0;
	SoftFlag=FALSE;
	for(z=0; z<SplitHandNumCards[SplitHandNum-1]; ++z) SplitHandScore[SplitHandNum-1] += BjCardVal(SplitHand[SplitHandNum-1][z]);
	if(SoftFlag==TRUE && SplitHandScore[SplitHandNum-1] < 12) SplitHandScore[SplitHandNum-1]+= 10;

	if(SplitHandNum==1) PostHand1Score();
	if(SplitHandNum==2) PostHand2Score();
	if(SplitHandNum==3) PostHand3Score();
	if(SplitHandNum==4) PostHand4Score();
	DisplayBasicStrategy();
	return(1);
}
int SplitPair()
{
	if(SplitHandNumCards[SplitHandNum-1]==1) return(0);
	++SplitHandNum;
	++NumHandsInPlay;
	SplitHand[0][0]=PlayerHand[0];
	SplitHand[1][0]=PlayerHand[1];

	if(NumHandsInPlay==2) {
	/* redo hand No. 1 with one card and the spot */
		BjRestoreBackground();
		Stake -= OriginalBet;
		Bet += OriginalBet;
		PlaceSplitBet(1);
		DrawCard(200,390,SplitHand[0][0]);
		SplitHandScore[0]=BjCardVal(SplitHand[0][0]);
		SplitHandNumCards[0]=1;
		PostHand1Score();
	/* draw hand No. 2 for the first time */
		DrawCard(200+160,390,SplitHand[1][0]);
		SplitHandScore[1]=BjCardVal(SplitHand[1][0]);
		SplitHandNumCards[1]=1;
		rectfill(screen,10,365,110,532,BLACK);
		rectfill(screen,10,422,110,532,MANGO);
		BjBox4b(ORANGE);
		PostHand2Score();
		goto out;
	}

/* Hand No. 1 draws a matching card, and player splits to a third hand */
	if(NumHandsInPlay==3 && SplitHandNum==2) {
	/* redo hand No. 1 with one card and the spot */
		BjRestoreBackground();
		PlaceSplitBet(1);
		Stake -= OriginalBet;
		Bet += OriginalBet;
		PlaceSplitBet(2);
		DrawCard(200,390,SplitHand[0][0]);
		SplitHandScore[0]=BjCardVal(SplitHand[0][0]);
		SplitHandNumCards[0]=1;
		PostHand1Score();
	/* hand No. 1 not allowed to double down at this point */
	/* redo hand No. 2 with one card */
		DrawCard(200+160,390,SplitHand[1][0]);
		SplitHandScore[1]=BjCardVal(SplitHand[1][0]);
		SplitHandNumCards[1]=1;
		PostHand2Score();
	/* draw hand No. 3 for the first time */
		SplitHand[2][0]=SplitHand[0][1];
		DrawCard(200+160+160-14,390,SplitHand[2][0]);
		SplitHandScore[2]=BjCardVal(SplitHand[2][0]);
		SplitHandNumCards[2]=1;
		rectfill(screen,10,422,110,532,BLACK);
		rectfill(screen,10,479,110,532,MANGO);
		BjBox3b(ORANGE);
		PostHand3Score();
		--SplitHandNum;
		goto out;
	}

/* Hand No. 2 draws a matching card, and player splits to a third hand */
	if(NumHandsInPlay==3 && SplitHandNum==3) {
		RestoreFromHand2();
		PlaceSplitBet(1);
		Stake -= OriginalBet;
		Bet += OriginalBet;
		PlaceSplitBet(2);
	/* redo hand No. 2 with one card */
		DrawCard(200+160,390,SplitHand[1][0]);
		SplitHandScore[1]=BjCardVal(SplitHand[1][0]);
		SplitHandNumCards[1]=1;
		PostHand2Score();
	/* draw hand No. 3 for the first time */
		SplitHand[2][0]=SplitHand[1][1];
		DrawCard(200+160+160-14,390,SplitHand[2][0]);
		SplitHandScore[2]=BjCardVal(SplitHand[2][0]);
		SplitHandNumCards[2]=1;
		rectfill(screen,10,422,110,532,BLACK);
		rectfill(screen,10,479,110,532,MANGO);
		BjBox3b(ORANGE);
		PostHand3Score();
		--SplitHandNum;
		goto out;
	}

/* Hand No. 1 draws a matching card, and player splits to a fourth hand */
	if(NumHandsInPlay==4 && SplitHandNum==2) {
	/* redo hand No. 1 with one card and the spot */
		BjRestoreBackground();
		PlaceSplitBet(1);
		PlaceSplitBet(2);
		Stake -= OriginalBet;
		Bet += OriginalBet;
		PlaceSplitBet(3);
		DrawCard(200,390,SplitHand[0][0]);
		SplitHandScore[0]=BjCardVal(SplitHand[0][0]);
		SplitHandNumCards[0]=1;
		PostHand1Score();
	/* hand No. 1 not allowed to double down at this point */
	/* redo hand No. 2 with one card */
		DrawCard(360,390,SplitHand[1][0]);
	/* redo hand No. 3 with one card */
		DrawCard(520-14,390,SplitHand[2][0]);
	/* draw hand No. 4 for the first time */
		SplitHand[3][0]=SplitHand[0][1];
		DrawCard(680-28,390,SplitHand[3][0]);
		SplitHandScore[3]=BjCardVal(SplitHand[3][0]);
		SplitHandNumCards[3]=1;
		rectfill(screen,10,479,110,532,BLACK);
		BjBox2b(ORANGE);
		PostHand4Score();
		--SplitHandNum;
		goto out;
	}

/* Hand No. 2 draws a matching card, and player splits to a fourth hand */
	if(NumHandsInPlay==4 && SplitHandNum==3) {
		RestoreFromHand2();
		PlaceSplitBet(1);
		PlaceSplitBet(2);
		Stake -= OriginalBet;
		Bet += OriginalBet;
		PlaceSplitBet(3);
	/* hand No. 2 not allowed to double down at this point */
	/* redo hand No. 2 with one card */
		DrawCard(200+160,390,SplitHand[1][0]);
		SplitHandScore[1]=BjCardVal(SplitHand[1][0]);
		SplitHandNumCards[1]=1;
		PostHand2Score();
	/* redo hand No. 3 with one card */
		DrawCard(520-14,390,SplitHand[2][0]);
	/* draw hand No. 4 for the first time */
		SplitHand[3][0]=SplitHand[0][1];
		DrawCard(680-28,390,SplitHand[3][0]);
		SplitHandScore[3]=BjCardVal(SplitHand[3][0]);
		SplitHandNumCards[3]=1;
		rectfill(screen,10,479,110,532,BLACK);
		BjBox2b(ORANGE);
		PostHand4Score();
		--SplitHandNum;
		goto out;
	}

/* Hand No. 3 draws a matching card, and player splits to a fourth hand */
	if(NumHandsInPlay==4 && SplitHandNum==4) {
		RestoreFromHand3();
		PlaceSplitBet(1);
		PlaceSplitBet(2);
		Stake -= OriginalBet;
		Bet += OriginalBet;
		PlaceSplitBet(3);
	/* redo hand No. 3 with one card */
		DrawCard(520-14,390,SplitHand[2][0]);
	/* draw hand No. 4 for the first time */
		SplitHand[3][0]=SplitHand[0][1];
		DrawCard(680-28,390,SplitHand[3][0]);
		SplitHandScore[3]=BjCardVal(SplitHand[3][0]);
		SplitHandNumCards[3]=1;
		rectfill(screen,10,479,110,532,BLACK);
		BjBox2b(ORANGE);
		PostHand4Score();
		--SplitHandNum;
	}
out:
	SoftFlag=FALSE;
	HitStandPrompt();
	DisplayBasicStrategy();
	return(0);
}
int SplitStand()
{
	char DealerScoreStr[5];

	BjNoticeButton(0);

	PlayerScore=SplitHandScore[0];  /* ?? */

	ShowDealerHoleCard();
	itoa(DealerScore, DealerScoreStr, 10);
	rectfill(screen,340,130,355,160,BLACK);
	PutsFont21(340,130,ORANGE, DealerScoreStr);
	PostDealerScore();
	SplitMode=FALSE;
	rest(250);
	if(BjCardVal(DealerHand[0])==10 && Insurance==TAKEN) PayInsurance();
	if(DealerScore==17 && DealerSoftFlag==TRUE) DealerHit();
	DealerSoftFlag=FALSE;
	while(DealerScore < 17) DealerHit();
	if(DealerScore==17 && DealerSoftFlag==TRUE) DealerHit();
	if(DealerScore < 17) DealerHit();
	SoftFlag=FALSE;
	CheckEachSplitHand();
	rest(250);
	return(BjAcknowledge());
	return(1);
}
int BlackjackWindowActive()
{
	int Result;

	Result=1;
	BeepSet=TRUE;
loopback:
	if(SplitMode==FALSE && PlayerBlackjack==TRUE) Result=PlayerHasBlackjack();
	if(Result==0) return(0);
	if(SplitMode==FALSE && PlayerScore==21) PlayerStand();

	if(SplitMode==TRUE) {
	/* bust or 21: move on */
		if(SplitHandScore[SplitHandNum-1] >=21) {
			EraseDisplayOfBasicStrategy();
			if(NumHandsInPlay > SplitHandNum) {
				++SplitHandNum;
				BjNoticeButton(SplitHandNum);
				SplitHit();
				goto loopback;
			} else {
				SplitStand();
				goto loopback;
			}
		}
	/* split aces get one hit each */
		if(BjCardVal(SplitHand[SplitHandNum-1][0])==1 && SplitHandNumCards[SplitHandNum-1]==2) {
			EraseDisplayOfBasicStrategy();
			if(NumHandsInPlay > SplitHandNum) {
				++SplitHandNum;
				BjNoticeButton(SplitHandNum);
				SplitHit();
				goto loopback;
			} else {
				SplitStand();
				goto loopback;
			}
		}
		if(BjCardVal(SplitHand[SplitHandNum-1][0])==1 && SplitHandNumCards[SplitHandNum-1]==1) {
			EraseDisplayOfBasicStrategy();
			if(SplitHandNum==0) {
				SplitHit();
				++SplitHandNum;
				BjNoticeButton(SplitHandNum);
				goto loopback;
			} else {
				SplitHit();
				SplitStand();
				goto loopback;
			}
		}

	/* double after split gets only one hit */
		if(SplitDoubleDown[SplitHandNum-1]==TAKEN) {
			if(NumHandsInPlay > SplitHandNum) {

				++SplitHandNum;
				BjNoticeButton(SplitHandNum);
				SplitHit();

				goto loopback;
			} else {
				SplitStand();
				goto loopback;
			}
		}
	/* offer double after split */
		if(SplitHandScore[SplitHandNum-1] > 8 && SplitHandScore[SplitHandNum-1] < 12) {
			if(Stake >= OriginalBet && SplitHandNumCards[SplitHandNum-1]==2) {
				DoubleAfterSplitPrompt();
				SplitDoubleDown[SplitHandNum-1]=AVAILABLE;
			}
		}
	/* offer soft double after split */
		if(SplitHandScore[SplitHandNum-1]==19 || SplitHandScore[SplitHandNum-1]==20) {
			if(Stake >= OriginalBet && SplitHandNumCards[SplitHandNum-1]==2) {
				if(BjCardVal(SplitHand[SplitHandNum-1][0])==1 || BjCardVal(SplitHand[SplitHandNum-1][1])==1) {
					DoubleAfterSplitPrompt();
					SplitDoubleDown[SplitHandNum-1]=AVAILABLE;
				}
			}
		}
	}

	do {
		SolPutTime();
	} while(!keypressed());
	c=GetKey();
	switch( c ) {
		case 13:	if(DoubleDown==AVAILABLE) {
					DoubleDown=UNAVAILABLE;
					EraseLowerOptionPrompt();
				}
					if(Insurance != UNAVAILABLE) {
					EraseUpperOptionPrompt();
				}
				if(SplitMessageOn==TRUE) {
					SplitMessageOn=FALSE;
					EraseLowerOptionPrompt();
				}
				if(SplitMode==TRUE && NumHandsInPlay > SplitHandNum) {
					++SplitHandNum;
					BjNoticeButton(SplitHandNum);
					SplitHit();
					goto loopback;
				}
				if(SplitMode==TRUE && NumHandsInPlay==SplitHandNum) {
					BjNoticeButton(0);
					Result=SplitStand();
				}
				if(BettingFinished==TRUE) {
					BjNoticeButton(0);
					Result=PlayerStand();
					Payoff=0;
				}
				if(Bet>0 && BettingFinished==FALSE) {
					BettingFinished=TRUE;
					OriginalBet=Bet;
					BjDeal();
					BjClearBox2a();
				}
				clear_keybuf();
				goto loopback;
		case 27:
				goto loopback;
		case F11:	BlackjackHelp();
				PanelBeep();
				goto loopback;
		case F12: return(0);
		case UPARROW: if(Stake==0) goto loopback;
				if(DoubleDown==AVAILABLE) {
					PlaceDoubleDown();
					Result=PlayerHit();
					rest(100);
					EraseLowerOptionPrompt();
					EraseDisplayOfBasicStrategy();
					Result=PlayerStand();
					Payoff=0;
					goto loopback;
				}
				if(SplitMode==TRUE && SplitDoubleDown[SplitHandNum-1]==AVAILABLE) {
					PlaceSplitDoubleDown(SplitHandNum-1);
					SplitDoubleDown[SplitHandNum-1]=TAKEN;
					Result=SplitHit();
					rest(100);
					EraseLowerOptionPrompt();
					EraseDisplayOfBasicStrategy();
					if(NumHandsInPlay > SplitHandNum) {
						++SplitHandNum;
						BjNoticeButton(SplitHandNum);
						SplitHit();
					} else SplitStand();
					goto loopback;
				}
				if(BettingFinished==TRUE) goto loopback;
				if(Bet==0) BjEnterPrompt(MANGO, ORANGE,"PLAY");
				if(Bet>=100) goto loopback;
				PlaceBet(2);
				goto loopback;
		case DOWNARROW: if(SplitMessageOn==TRUE) {
					SplitMessageOn=FALSE;
					EraseLowerOptionPrompt();
					Insurance=UNAVAILABLE;
					EraseUpperOptionPrompt();
					SplitMode=TRUE;
					SplitPair();
					SplitHit();
					BjNoticeButton(SplitHandNum);
				}
				if(BettingFinished==TRUE) goto loopback;
				if(Bet <=2) goto loopback;
				ReduceBet(2);
				goto loopback;
		case LEFTARROW: if(Insurance==AVAILABLE) {
					PlaceInsurance();
				}
				goto loopback;
		case RIGHTARROW: if(DoubleDown==AVAILABLE) {
					DoubleDown=UNAVAILABLE;
					EraseLowerOptionPrompt();
				}
				if(Insurance != UNAVAILABLE) {
					EraseUpperOptionPrompt();
				}
				if(SplitMessageOn==TRUE) {
					SplitMessageOn=FALSE;
					EraseLowerOptionPrompt();
				}
				if(BettingFinished==TRUE && SplitMode==FALSE) Result=PlayerHit();
				if(SplitMode==TRUE) Result=SplitHit();
				if(Result==0) return(0);
				goto loopback;
		case CTRL_F1: Screenshot792("Bljack8.bmp");
				PanelBeep();
				goto loopback;
		case CTRL_F2: Screenshot1024("Bljack10.bmp");
				PanelBeep();
				goto loopback;
		default: ScoldUser();
				goto loopback;
	}
}
void BjInit()
{
	Bet=0;
	cw=71; /* card width */
	ch=100; /* card height */
	min_old=70;
	SoftFlag=FALSE;
	PlayerSoftFlag=FALSE;
	DealerSoftFlag=FALSE;
	PlayerBlackjack=FALSE;
	DealerBlackjack=FALSE;
	Payoff=0;
	DoubleDown=UNAVAILABLE;
	Insurance=UNAVAILABLE;
	InsurancePayoff=0;
	ExtraShufffle=UNAVAILABLE;
	SplitMessageOn=FALSE;
	SplitMode=FALSE;
	NumHandsInPlay=1;
	SplitHandNum=0;
}
int BlackjackMode()
{
	install_timer(); 
	BeepSet=TRUE;
	rectfill(screen,0,0,800,600,BLACK);
	Brackets1(ORANGE,MANGO);
	BjBoxes();
	MarsF(780-(StrLenScorpio("FERENGI BLACKJACK")*2),10,2, MANGO,BLACK,"FERENGI");
	MarsF(780-(StrLenScorpio("BLACKJACK")*2),10,2, PURPLE,BLACK,"BLACKJACK");
	PutsLuna(780-(StrLenScorpio("FERENGI BLACKJACK")*2),78,ORANGE,BLACK,"ALL BETS IN GOLD-PRESSED LATINIUM");
	DrawBettingArea();
	DrawBettingMessage();
	SetCurrentFile("\\LC24APPS\\BLACKJAK\\BLACKJAQ.BMP");
	faces=load_bitmap(CurrentFile, faces_palette);
	if (!faces) {
		rest(1000);
		NormalLoadError(CurrentFile);
		return(86);
	}
	BjInit();
	bmp=create_bitmap(570,350);
	StakeBuf=create_bitmap(300,163);
	Stake=200;
	Bet=0;
	NewShuffle();
/*	rectfill(screen,240,70,272+cw,90+ch,BLACK); */
	BjClearBox2a();
	BjDisplayNew();
	BlackjackWindowActive(); /* play the game */
	remove_timer(); 
	DelayedShutdown();		/* spread the cards */
	destroy_bitmap(bmp);
	destroy_bitmap(StakeBuf);
	destroy_bitmap(faces);	/* exit to LCARS standby */
	return(0);
}


