/* Tic-tac-toe engine (5x5), adapted from a console program by
Alastair Francis, using minimax, alpha-beta pruning, and
depth-limited recursion with hueristic function
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef WB5_H
#define WB5_H


#include "lcars24.h"


#define Wb5BOARD_WIDTH 5
#define Wb5BOARD_SIZE 25

enum bool5 {Wb5True = -1, Wb5False};
typedef enum bool5 Wb5Boolean;

enum symbol5 {Wb5empty = 0, R, S};
typedef enum symbol5 Wb5GamePiece;

struct Wb5Grid  {
	Wb5GamePiece Wb5Element[Wb5BOARD_SIZE];
	int Wb5Elements_occupied;
};
typedef struct Wb5Grid Wb5BoardType;

struct Wb5Player {
	Wb5Boolean Wb5Computer;
	int Wb5SkillLevel;
};
typedef struct Wb5Player Wb5PlayerType;

Wb5GamePiece Wb5Players_piece;
int Wb5MaxDepth;


void Wb5InitBoard (Wb5BoardType* board);
void Wb5PlacePiece (Wb5BoardType* board, int position, Wb5GamePiece piece);
void Wb5RemovePiece (Wb5BoardType* board, int position);
Wb5Boolean Wb5IsWinner (Wb5BoardType board);
Wb5Boolean Wb5IsFull (Wb5BoardType board);
int Wb5Heuristic (Wb5BoardType board);
int Wb5FindBestMove (Wb5BoardType board, Wb5GamePiece piece);
void Wb5FindOpponentMove (Wb5BoardType board, Wb5GamePiece piece, int* status,
			 int alpha, int beta, int depth);
int Wb5FindPlayerMove (Wb5BoardType board, Wb5GamePiece piece, int* status,
				int alpha, int beta, int depth);

#endif

