/* Scrnshot.c, screenshot and other common functions */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "scrnshot.h"

/* Screenshot functions, to make screenshots anywhere in LCARS 24
	Control-F1 makes an 800 x 600 .bmp file, which is then converted
	to .png to makes a copy small enough for transfer
	by floppy, if the utility bmp2png.exe is in the folder.
	Control-F2 makes a 1024 x 768 file the same way.
*/


void Screenshot792(char *filespec)
{ /* Old function name, but output is 800 x 600 */
  /* saves screen as a .png file if bmp2png.exe present, otherwise .bmp */
	BITMAP *bmp;
	PALETTE pal;
	char cmd[60]="bmp2png -Q -E ";
	char dest[128];

	get_palette(pal);
	bmp=create_sub_bitmap(screen, 0, 0, 800, 600);
	save_bitmap(filespec,bmp,pal);
	destroy_bitmap(bmp);

	strcat(cmd, filespec);
	replace_extension(dest,filespec,"BAK",12);

	if( __file_exists("bmp2png.exe")) {
		system(cmd);
		if( __file_exists(dest) ) remove(dest);
	}
}

void Screenshot1024(char *filespec)
{
  /* saves screen as a .png file if bmp2png.exe present, otherwise .bmp */
	BITMAP *bmp;
	PALETTE pal;
	char cmd[60]="bmp2png -Q -E ";
	char dest[128];

	if(ScreenSize != 1024) return;
	get_palette(pal);
	bmp=create_sub_bitmap(screen, 0, 0, 1024, 800);
	save_bitmap(filespec,bmp,pal);
	destroy_bitmap(bmp);

	strcat(cmd, filespec);
	replace_extension(dest,filespec,"BAK",12);

	if( __file_exists("bmp2png.exe")) {
		system(cmd);
		if( __file_exists(dest) ) remove(dest);
	}
}

/* The following subroutine is not used. */
/*
void SmoothBlit2y(BITMAP *src, BITMAP *dest, int srcX, int srcY,
int destX, int destY, int srcW, int srcH)
{
	int x,y;
	int r,g,b,ar,ag,ab;
	int r2,g2,b2;
	int ImageCol, NewCol, PrevLineCol, NextxCol;

	for(x=0; x<srcW; x+=2) {
		for(y=0; y<srcH; y+=1) {
			ImageCol = getpixel(src,x+srcX,y+srcY);
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);

			NextxCol = getpixel(src,x+srcX,y+srcY+2);
			r2=getr(NextxCol);
			g2=getg(NextxCol);
			b2=getb(NextxCol);
			ar=((r+r2)/2)+(r+r2)%2;
			ag=((g+g2)/2)+(g+g2)%2;
			ab=((b+b2)/2)+(b+b)%2;
			putpixel(dest,x+destX,y+destY+1,makecol(ar,ag,ab));
		}
	}
}
*/
void SmoothBlit2x(BITMAP *src, BITMAP *dest, int srcX, int srcY,
int destX, int destY, int srcW, int srcH)
{		/* double height and width, faking full resolution */
	int x,y;
	int r,g,b,ar,ag,ab;
	int r2,g2,b2;
	int ImageCol, NextxCol;

	srcW-=2;
	for(y=0; y<srcH; y++) {
		for(x=0; x<srcW; x++) {
			ImageCol = getpixel(src,x+srcX,y+srcY);
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);
			putpixel(dest,(x*2)+destX,(y*2)+destY,ImageCol);
			putpixel(dest,(x*2)+destX,(y*2)+destY+1,ImageCol);

			NextxCol = getpixel(src,x+srcX+1,y+srcY);
			r2=getr(NextxCol);
			g2=getg(NextxCol);
			b2=getb(NextxCol);
			ar=((r+r2)/2)+(r+r2)%2;
			ag=((g+g2)/2)+(g+g2)%2;
			ab=((b+b2)/2)+(b+b)%2;
/*
			ar=(r+r2)/2;
			ag=(g+g2)/2;
			ab=(b+b2)/2;
*/
			putpixel(dest,(x*2)+destX+1,(y*2)+destY,makecol(ar,ag,ab));
			putpixel(dest,(x*2)+destX+1,(y*2)+destY+1,makecol(ar,ag,ab));

		}
	}
/* SmoothBlit2y(dest, dest, srcX, srcY, destX, destY, srcW, srcH); */
}

void SmoothBlitY(BITMAP *bmp, int srcX, int srcY, int w, int h)
{
	int x,y;
	int r,g,b,ar,ag,ab;
	int r2,g2,b2;
	int ImageCol, NextxCol;

	h-=2;
	for(x=0; x<w; x++) {
		for(y=0; y<h; y++) {
			ImageCol = getpixel(bmp,x+srcX,y+srcY);
			NextxCol = getpixel(bmp,x+srcX,y+srcY+2);
			if(NextxCol==ImageCol) goto skip;
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);

			r2=getr(NextxCol);
			g2=getg(NextxCol);
			b2=getb(NextxCol);
			ar=((r+r2)/2)+(r+r2)%2;
			ag=((g+g2)/2)+(g+g2)%2;
			ab=((b+b2)/2)+(b+b)%2;
/*
			ar=(r+r2)/2;
			ag=(g+g2)/2;
			ab=(b+b2)/2;
*/
			putpixel(bmp,x+srcX,y+srcY+1,makecol(ar,ag,ab));
skip:   		r=0;
		}
	}
/* Smooth3(srcX, srcY, w, h); */
/* FixBlack(srcX, srcY, w, h); */
}


int SmoothBlitX(int srcX, int srcY, int w, int h)
{
	int x,y;
	int r,g,b,ar,ag,ab;
	int r2,g2,b2;
	int ImageCol, NextxCol;

	w-=1;
	for(y=0; y<h; y++) {
		for(x=1; x<w; x++) {
			ImageCol = getpixel(screen,x+srcX,y+srcY);
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);

			NextxCol = getpixel(screen,x+srcX+2,y+srcY);
			r2=getr(NextxCol);
			g2=getg(NextxCol);
			b2=getb(NextxCol);
			ar=((r+r2)/2)+(r+r2)%2;
			ag=((g+g2)/2)+(g+g2)%2;
			ab=((b+b2)/2)+(b+b)%2;
/*
			ar=(r+r2)/2;
			ag=(g+g2)/2;
			ab=(b+b2)/2;
*/
			putpixel(screen,x+srcX+1,y+srcY,makecol(ar,ag,ab));

		}
	}
	return(0);
}

int FixBlack(int srcX, int srcY, int w, int h)
{
	int x,y;
	int r,g,b;
	int ImageCol;
	int bottom,right;
	int Dark;

	Dark=48;
	bottom=srcY+h;
	right=srcX+w;

	for(y=srcY; y <bottom; ++y) {
		for(x=srcX; x <right; ++x) {
			ImageCol = getpixel(screen,x,y);
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);
/* was 14 */			if( r<=Dark && g<=Dark && b<=Dark) putpixel(screen,x,y,BLACK);
		}
	}
	return(0);
}
void GrayArea(int x, int y, int w, int h)
{
	int r,g,b,av,x2,x3,y2,y3;
	int ImageCol;

	x3=x+w;
	y3=y+h;
	for(y2=y; y2 <y3; ++y2) {
		for(x2=x; x2 < x3; ++x2) {
			ImageCol = getpixel(screen,x2,y2);
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);
			av=(r+g+b)/3;
			putpixel(screen,x2,y2,makecol(av,av,av));
		}
	}
}

