/* 	Luna.c, 5x14 font, no lowercase, antialiased, not scalable
	Usage: PutsLuna(int x,int y,int ForeColor,int BackColor,char *cStr)
	Use colors predefined in lccolor.c. ForeColor or BackColor must be BLACK.
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "luna.h"


int LoadFont14()
{
	long z;
	PACKFILE *Fp;

	memset(Font14, (null), 12544);
	SetCurrentFile("\\SYSTEM\\FONTS\\font14.sff");
	Fp = pack_fopen(CurrentFile, "rb");
	if (Fp == NULL) {
		FontLoadError(CurrentFile);
		exit(0);
	}
	for(z = 0; z < 12544; ++z ) Font14[z] = pack_getc(Fp);
	pack_fclose( Fp );
	return(0);
}
int StrLenFont14(char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;

	pos = 1;
	j = strlen(Str);
	strcpy(Capture, Str);
	if( Capture[j-1] <= 32 ) Capture[j-1] = 32;
	if( Capture[j] <= 32 ) Capture[j] = 32;
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		i = Capture[k];
		if( Capture[k] == 9 ) pos = (40 + ((pos/40)*40) );
			else pos += Font14[i]-65;
	}
	return(pos);
}

int BlitHeadline14(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{
	int a,b;
	int z;
	unsigned char i;
	static unsigned char BitVal[] = { 128,64,32,16,8,4,2,1 };

	if( TargetChar <= 32 ) return(1);
	z=(TargetChar-30)*64;
	for(b=0; b<18; ++b) {
		for(a=0; a<8; ++a) {
			i = Font14[b+z] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x, b+y, Hue);
		}
	}
	for(b=0; b<18; ++b) {
		for(a=0; a<8; ++a) {
			i = Font14[b+z+32] & BitVal[a];
			if( i == BitVal[a]) putpixel(bmp, a+x+8, b+y, Hue);
		}
	}
	return(0);
}

int SmoothHeadline14(BITMAP *bmp, int TargetChar, int x, int y, int Hue)
{  /* fine antialiasing for a few characters */
	int a,b;

		switch( TargetChar )
		{

			case 37: /* percent sign */
				putpixel(bmp, x,y+11, ac4);
				putpixel(bmp, x,y+12, ac3);
				putpixel(bmp, x+1,y+9, ac4);
				putpixel(bmp, x+1,y+10, ac3);
				putpixel(bmp, x+1,y+13, ac3);
				putpixel(bmp, x+2,y+7, ac4);
				putpixel(bmp, x+2,y+8, ac3);
				putpixel(bmp, x+2,y+11, ac3);
				putpixel(bmp, x+2,y+12, ac4);
				putpixel(bmp, x+3,y+6, ac3);
				putpixel(bmp, x+4,y+7, ac3);
				putpixel(bmp, x+5,y+1, ac4);
				putpixel(bmp, x+5,y+2, ac3);
				putpixel(bmp, x+5,y+5, ac3);
				putpixel(bmp, x+5,y+6, ac4);
				putpixel(bmp, x+6,y, ac3);
				putpixel(bmp, x+6,y+3, ac3);
				putpixel(bmp, x+6,y+4, ac4);
				putpixel(bmp, x+7,y+1, ac3);
				putpixel(bmp, x+7,y+2, ac4);
				break;
			case 38: /* ampersand */
				putpixel(bmp, x,y+7, ac4);
				putpixel(bmp, x,y+8, ac3);
				putpixel(bmp, x,y+12, ac3);
				putpixel(bmp, x+1,y+6, ac3);
				putpixel(bmp, x+2,y+8, ac3);
				vline(bmp, x+2,y+9,y+10,ac4);
				putpixel(bmp, x+2,y+11, ac3);
				putpixel(bmp, x+3,y+2, ac3);
				putpixel(bmp, x+3,y+8, ac3);
				putpixel(bmp, x+3,y+11, ac3);
				putpixel(bmp, x+5,y+6, ac3);
				putpixel(bmp, x+5,y+7, ac4);
				putpixel(bmp, x+6,y+10, ac3);
				putpixel(bmp, x+7,y+8, ac3);
				putpixel(bmp, x+7,y+9, ac4);
				break;
			case 40: /* opening parenthesis */
				vline(bmp, x,y+1,y+2,ac4);
				putpixel(bmp, x,y+3, ac3);
				putpixel(bmp, x,y+10, ac3);
				vline(bmp, x,y+11,y+12,ac4);
				putpixel(bmp, x+1,y, ac4);
				putpixel(bmp, x+1,y+1, ac3);
				putpixel(bmp, x+1,y+12, ac3);
				putpixel(bmp, x+1,y+13, ac4);
				putpixel(bmp, x+2,y+3, ac3);
				putpixel(bmp, x+2,y+4, ac4);
				putpixel(bmp, x+2,y+9, ac4);
				putpixel(bmp, x+2,y+10, ac3);
				putpixel(bmp, x+3,y+2, ac4);
				putpixel(bmp, x+3,y+11, ac4);
				break;
			case 41: /* closing parenthesis */
				vline(bmp, x+3,y+1,y+2,ac4);
				putpixel(bmp, x+3,y+3, ac3);
				putpixel(bmp, x+3,y+10, ac3);
				vline(bmp, x+3,y+11,y+12,ac4);
				putpixel(bmp, x+2,y, ac4);
				putpixel(bmp, x+2,y+1, ac3);
				putpixel(bmp, x+2,y+12, ac3);
				putpixel(bmp, x+2,y+13, ac4);
				putpixel(bmp, x+1,y+3, ac3);
				putpixel(bmp, x+1,y+4, ac4);
				putpixel(bmp, x+1,y+9, ac4);
				putpixel(bmp, x+1,y+10, ac3);
				putpixel(bmp, x,y+2, ac4);
				putpixel(bmp, x,y+11, ac4);
				break;
			case 47: /* slash */
				b=12;
				for(a=0; a<=6; ++a) {
					putpixel(bmp, x-1+a,y+1+b, ac3);
					putpixel(bmp, x-1+a,y+b, ac4);
					putpixel(bmp, x+1+a,y+b, ac3);
					putpixel(bmp, x+1+a,y+1+b, ac4);
					b-=2;
				}
				break;
			case 45: /* hyphen */
				hline(bmp,x,y+8,x+3,ac3);
				break;
			case 44: /* comma */
			case 46: /* period */
				hline(bmp, x,y+11,x+1, ac3);
				break;
			case 58: /* colon */
			case 59: /* semicolon */
				hline(bmp, x,y+5,x+1, ac3);
				hline(bmp, x,y+11,x+1, ac3);
				break;
			case 49: /* 1 */
				putpixel(bmp, x+1,y+1, ac4);
/*				putpixel(bmp, x+1,y+4, ac3);    */
				putpixel(bmp, x+2,y, ac3);
				putpixel(bmp, x+2,y+1, ac3); /* was ac1 */
				break;
			case 50: /* 2 */
				putpixel(bmp, x,y+9, ac4);
				putpixel(bmp, x,y+10, ac3);
				putpixel(bmp, x+1,y+7, ac4);
/*				putpixel(bmp, x+2,y+2, ac3);	*/
				putpixel(bmp, x+2,y+5, ac4);
				putpixel(bmp, x+2,y+9, ac3);
				putpixel(bmp, x+2,y+10, ac4);
				putpixel(bmp, x+3,y+7, ac3);
				putpixel(bmp, x+3,y+8, ac4);
				putpixel(bmp, x+4,y+5, ac4);
/*				hline(bmp, x+2,y+11,x+4,ac3);	*/
				break;
			case 52: /* 4 */
/*				hline(bmp, x,y+10,x+5,ac3);	*/
				putpixel(bmp, x,y+6, ac4);
				putpixel(bmp, x,y+7, ac3);
				putpixel(bmp, x+1,y+3, ac4);
				putpixel(bmp, x+1,y+4, ac3);
				vline(bmp, x+2,y,y+1,ac4);
				vline(bmp, x+2,y+2,y+6,ac3);
				break;
			case 53: /* 5 */
				putpixel(bmp, x+2,y+5, ac4);
				putpixel(bmp, x+2,y+7, ac4);
				putpixel(bmp, x+3,y+5, ac3);
				putpixel(bmp, x+4,y+6, ac4);
/*				hline(bmp, x+2,y+2,x+4, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 54: /* 6 */
				putpixel(bmp, x+2,y+5, ac4);
				putpixel(bmp, x+2,y+7, ac4);
				putpixel(bmp, x+3,y+5, ac3);
				putpixel(bmp, x+4,y+6, ac4);

/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 55: /* 7 */
				if(fc==BLACK) {
					/* left side */
					FontFadeDown(bmp,x,y+10,bc,4);
					FontFadeDown(bmp,x+1,y+6,bc,4);
					FontFadeDown(bmp,x+2,y+2,bc,4);
					/* right side */
					FontFadeUp(bmp,x+2,y+13,bc,4);
					FontFadeUp(bmp,x+3,y+9,bc,4);
					FontFadeUp(bmp,x+4,y+5,bc,4);
				} else {
					/* left side */
					FontFadeUp(bmp,x,y+13,fc,4);
					FontFadeUp(bmp,x+1,y+9,fc,4);
					FontFadeUp(bmp,x+2,y+5,fc,4);
					/* right side */
					FontFadeDown(bmp,x+2,y+10,fc,4);
					FontFadeDown(bmp,x+3,y+6,fc,4);
					FontFadeDown(bmp,x+4,y+2,fc,4);
				}
				break;
			case 57: /* 9 */
				putpixel(bmp, x,y+7, ac4);
				putpixel(bmp, x+1,y+8, ac3);
				putpixel(bmp, x+2,y+6, ac3);
				putpixel(bmp, x+2,y+8, ac4);

/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);   */
				break;
			case 65: /* A */
				if(fc==BLACK) {
					FontFadeDown(bmp,x,y,bc,14);
					FontFadeDown(bmp,x+4,y,bc,14);
					FontFadeUp(bmp,x+2,y+13,bc,14);
				} else {
					FontFadeUp(bmp,x,y+13,fc,14);
					FontFadeUp(bmp,x+4,y+13,fc,14);
					FontFadeDown(bmp,x+2,y,fc,14);
				}
/*
				vline(bmp,x+2,y+8,y+9,fc);
				putpixel(bmp, x+1,y, ac3);
				putpixel(bmp, x+2,y, fc);
				putpixel(bmp, x+3,y, ac3);
*/
				break;
			case 66: /* B */
/*				putpixel(bmp, x+2,y+2, ac3); 	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				putpixel(bmp, x+4,y+5, ac4);
				putpixel(bmp, x+4,y+6, ac4);
				break;
			case 48: /* zero */
			case 51: /* 3 */
			case 56: /* 8 */
			case 67: /* C */
			case 68: /* D */
			case 79: /* O */
			case 81: /* Q */
/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 71: /* G */
				vline(bmp, x+2,y+7,y+8,ac3);
/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 80: /* P */
/*				putpixel(bmp, x+2,y+2, ac3);	*/
				break;
			case 82: /* R */
/*				putpixel(bmp, x+2,y+2, ac3);	*/
				putpixel(bmp, x+4,y+5, ac4);
				putpixel(bmp, x+4,y+6, ac4);
				break;
			case 83: /* S */
				putpixel(bmp, x,y+5, ac2);
				putpixel(bmp, x,y+6, ac3);
				putpixel(bmp, x+2,y+5, ac3);
				putpixel(bmp, x+1,y+7, ac3);
				putpixel(bmp, x+2,y+8, ac3);
				putpixel(bmp, x+3,y+6, ac3);
				putpixel(bmp, x+4,y+7, ac3);
				putpixel(bmp, x+4,y+8, ac2);
/*				putpixel(bmp, x+2,y+2, ac3);	*/
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 84: /* T */
/*				hline(bmp, x,y+2,x+3,ac3);	*/
				vline(bmp, x-1,y,y+1,ac4);
				vline(bmp, x+4,y,y+1,ac4);
				break;
			case 74: /* J */
			case 85: /* U */
/*				putpixel(bmp, x+2,y+11, ac3);	*/
				break;
			case 69: /* E */
/*				hline(bmp, x+2,y+2,x+3,ac3);	*/
/*				hline(bmp, x+2,y+7,x+3,ac3);	*/
/*				hline(bmp, x+2,y+11,x+3,ac3);	*/
				break;
			case 70: /* F */
/*				hline(bmp, x+2,y+2,x+3,ac3);	*/
/*				hline(bmp, x+2,y+7,x+3,ac3);    */
				break;
			case 72: /* H */
/*				hline(bmp, x+2,y+7,x+3,ac3);	*/
				break;
			case 75: /* K */
				if(fc==BLACK) {
					FontFadeDown(bmp,x+4,y+6,bc,8);
					FontFadeUp(bmp,x+4,y+7,bc,8);
					FontFadeDown(bmp,x+2,y,bc,7);
					FontFadeUp(bmp,x+2,y+13,bc,7);
				} else {
					FontFadeUp(bmp,x+4,y+13,fc,9);
					FontFadeDown(bmp,x+4,y,fc,9);
					FontFadeUp(bmp,x+2,y+7,fc,7);
					FontFadeDown(bmp,x+2,y+7,fc,7);
				}
				break;
			case 76: /* L */
/*				hline(bmp, x+2,y+11,x+3,ac3);	*/
				break;
			case 77: /* M */
				if(fc==BLACK) {
					FontFadeDown(bmp,x+3,y,bc,7);
					FontFadeDown(bmp,x+4,y,bc,7);
					FontFadeUp(bmp,x+2,y+12,bc,8);
					FontFadeUp(bmp,x+5,y+12,bc,8);
				} else {
					FontFadeUp(bmp,x+3,y+6,fc,7);
					FontFadeUp(bmp,x+4,y+6,fc,7);
					FontFadeDown(bmp,x+2,y+5,fc,8);
					FontFadeDown(bmp,x+5,y+5,fc,8);
				}
				vline(bmp, x,y,y+13,ac2);
				vline(bmp, x+7,y,y+13,ac2);
				break;
			case 78: /* N */
				if(fc==BLACK) {
					FontFadeDown(bmp,x+3,y+2,bc,5);
					FontFadeUp(bmp,x+2,y+10,bc,5);
				} else {
					FontFadeUp(bmp,x+3,y+6,fc,5);
					FontFadeDown(bmp,x+2,y+7,fc,5);
				}
				vline(bmp, x,y,y+13,ac2);
				vline(bmp, x+5,y,y+13,ac2);
				break;
			case 86: /* V */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+13,bc,14);
					FontFadeUp(bmp,x+4,y+13,bc,14);
					FontFadeDown(bmp,x+2,y,bc,14);
				} else {
					FontFadeDown(bmp,x,y,fc,14);
					FontFadeDown(bmp,x+4,y,fc,14);
					FontFadeUp(bmp,x+2,y+13,fc,14);
				}
				break;
			case 87: /* W */
				vline(bmp, x,y,y+3,ac2);
				vline(bmp, x,y+4,y+7,ac3);
				vline(bmp, x,y+8,y+11,ac4);
				vline(bmp, x+2,y+2,y+3,ac4);
				vline(bmp, x+2,y+4,y+6,ac3);
				rectfill(bmp, x+3,y+8,x+4,y+10,ac3);
				rectfill(bmp, x+3,y+11,x+4,y+12,ac4);
				vline(bmp, x+5,y+2,y+3,ac4);
				vline(bmp, x+5,y+4,y+6,ac3);
				vline(bmp, x+7,y,y+3,ac2);
				vline(bmp, x+7,y+4,y+7,ac3);
				vline(bmp, x+7,y+8,y+11,ac4);
				break;
			case 88: /* X */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+5,bc,6);
					FontFadeDown(bmp,x,y+8,bc,6);
					FontFadeUp(bmp,x+5,y+5,bc,6);
					FontFadeDown(bmp,x+5,y+8,bc,6);
					FontFadeDown(bmp,x+2,y,bc,6);
					FontFadeUp(bmp,x+2,y+13,bc,8);
					FontFadeDown(bmp,x+3,y,bc,6);
					FontFadeUp(bmp,x+3,y+13,bc,8);
				} else {
					FontFadeDown(bmp,x,y,fc,8);
					FontFadeUp(bmp,x,y+13,fc,8);
					FontFadeDown(bmp,x+5,y,fc,8);
					FontFadeUp(bmp,x+5,y+13,fc,8);
					FontFadeUp(bmp,x+2,y+5,fc,6);
					FontFadeDown(bmp,x+2,y+6,fc,8);
					FontFadeUp(bmp,x+3,y+5,fc,6);
					FontFadeDown(bmp,x+3,y+6,fc,8);
				}
				break;
			case 89: /* Y */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+4,bc,5);
					FontFadeUp(bmp,x+1,y+7,bc,5);
					FontFadeDown(bmp,x+2,y+1,bc,4);
					FontFadeDown(bmp,x+3,y+1,bc,4);
					FontFadeUp(bmp,x+4,y+7,bc,5);
					FontFadeUp(bmp,x+5,y+4,bc,5);
				} else {
					FontFadeDown(bmp,x,y,fc,5);
					FontFadeDown(bmp,x+1,y+4,fc,5);
					FontFadeUp(bmp,x+2,y+4,fc,4);
					FontFadeUp(bmp,x+3,y+4,fc,4);
					FontFadeDown(bmp,x+4,y+4,fc,5);
					FontFadeDown(bmp,x+5,y,fc,5);
				}
				break;
			case 90: /* Z */
/*				hline(bmp, x,y+2,x+1,ac3);	*/
/*				hline(bmp, x+2,y+11,x+3,ac3);	*/
				vline(bmp, x,y+6,y+7,ac4);
				vline(bmp, x,y+8,y+9,ac3);
				putpixel(bmp, x+1,y+3,ac4);
				vline(bmp, x+1,y+4,y+5,ac3);
				vline(bmp, x+2,y+8,y+9,ac3);
				putpixel(bmp, x+2,y+10,ac4);
				vline(bmp, x+3,y+4,y+5,ac3);
				vline(bmp, x+3,y+6,y+7,ac4);
				break;
			case 92: /* backslash */
				b=12;
				for(a=6; a>=0; --a) {
					vline(bmp, x+a,y+b,y+1+b,fc);
					putpixel(bmp, x+1+a,y+1+b, ac3);
					putpixel(bmp, x+1+a,y+b, ac4);
					putpixel(bmp, x-1+a,y+b, ac3);
					putpixel(bmp, x-1+a,y+1+b, ac4);
					b-=2;
				}
				break;
/* ## */
			case 118: /* v */
			case 121: /* y (same as v for this process) */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+8,bc,6);
					FontFadeUp(bmp,x+1,y+13,bc,5);

					FontFadeDown(bmp,x+2,y+4,bc,7);
					FontFadeDown(bmp,x+3,y+4,bc,7);

					FontFadeUp(bmp,x+4,y+13,bc,5);
					FontFadeUp(bmp,x+5,y+8,bc,6);

				} else {
					FontFadeDown(bmp,x,y+3,fc,6);
					FontFadeDown(bmp,x+1,y+9,fc,5);
					FontFadeUp(bmp,x+2,y+10,fc,7);
					FontFadeUp(bmp,x+3,y+10,fc,7);
					FontFadeDown(bmp,x+4,y+9,fc,5);
					FontFadeDown(bmp,x+5,y+3,fc,6);
				}
				break;
			case 119: /* w */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+8,bc,6);
					FontFadeUp(bmp,x+1,y+13,bc,5);
					FontFadeDown(bmp,x+2,y+3,bc,6);
					FontFadeDown(bmp,x+3,y+3,bc,6);

					FontFadeUp(bmp,x+4,y+13,bc,5);
					FontFadeUp(bmp,x+5,y+13,bc,5);

					FontFadeDown(bmp,x+6,y+3,bc,6);
					FontFadeDown(bmp,x+7,y+3,bc,6);
					FontFadeUp(bmp,x+8,y+13,bc,5);
					FontFadeUp(bmp,x+9,y+8,bc,6);
				} else {
					FontFadeDown(bmp,x,y+3,fc,6);
					FontFadeDown(bmp,x+1,y+9,fc,5);
					FontFadeUp(bmp,x+2,y+8,fc,6);
					FontFadeUp(bmp,x+3,y+8,fc,6);

					FontFadeDown(bmp,x+4,y+9,fc,5);
					FontFadeDown(bmp,x+5,y+9,fc,5);

					FontFadeUp(bmp,x+6,y+8,fc,6);
					FontFadeUp(bmp,x+7,y+8,fc,6);
					FontFadeDown(bmp,x+8,y+9,fc,5);
					FontFadeDown(bmp,x+9,y+3,fc,6);
				}
				break;
			case 120: /* x */
				if(fc==BLACK) {
					FontFadeUp(bmp,x,y+7,bc,5);
					FontFadeDown(bmp,x,y+9,bc,5);

					FontFadeDown(bmp,x+2,y+3,bc,4);
					FontFadeDown(bmp,x+3,y+3,bc,4);
					FontFadeUp(bmp,x+2,y+13,bc,4);
					FontFadeUp(bmp,x+3,y+13,bc,4);

					FontFadeDown(bmp,x+5,y+9,bc,5);
					FontFadeUp(bmp,x+5,y+7,bc,5);
				} else {
					FontFadeDown(bmp,x,y+3,fc,5);
					FontFadeUp(bmp,x,y+13,fc,5);

					FontFadeUp(bmp,x+2,y+6,fc,4);
					FontFadeUp(bmp,x+3,y+6,fc,4);
					FontFadeDown(bmp,x+2,y+10,fc,4);
					FontFadeDown(bmp,x+3,y+10,fc,4);

					FontFadeUp(bmp,x+5,y+13,fc,5);
					FontFadeDown(bmp,x+5,y+3,fc,5);
				}
				putpixel(bmp,x+1,y+8, ac3);
				putpixel(bmp,x+4,y+8, ac3);
				break;
			default: break;
		}
	return(0);
}
int Headline14(BITMAP *bmp, int x,int y, int Hue, char *Str)
{
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	Shadow=FindShadow(Hue, BackgroundColor);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			SmoothHeadline14(bmp,i,pos,y,Hue);
			BlitHeadline14(bmp,i,pos,y,Hue);

/* hyphen lengthened to en dash if before numeric/space/slash, fills to em if double */
if(Capture[k] == 45) {
		if( (Capture[k+1]>46 && Capture[k+1]< 58) || Capture[k+1]==32 || Capture[k+1]==45) {
			pos+=3;
			SmoothHeadline14(bmp,45,pos,y,Hue);
			BlitHeadline14(bmp,45,pos,y,Hue);
		}
		if( Capture[k+1]==45 )  pos-=3;
}

		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Font14[i]-65;
	}

	return(0);
}
int PutsFont14(int x,int y,int ForeColor,int BackColor,char *Str)
{
	fc=ForeColor;
	bc=BackColor;
	if(bc==BLACK) FadeOut(fc);
	if(fc==BLACK) FadeIn(bc);
	if(fc==RED && bc==CARDWHITE) { 	/* special for card games */
		ac3 = makecol(253, 154,   131);
		ac4 = makecol(251,  182,   167);
	}
	BackgroundColor=BackColor;
	Headline14(screen,x,y,ForeColor,Str);
	return(0);
}

void PutsLuna(int x,int y,int ForeColor,int BackColor,char *Str)
{
	PutsFont14(x,y,ForeColor,BackColor,strupr(Str));
}
int StrLenLuna(char *Str)
{
	return(StrLenFont14(strupr(Str)));
}

