/* Lcars24.h, defines and globals for LCARS 24 */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef LCARS24_H
#define LCARS24_H


#define ESC	0x1b
#define F1 	 315
#define F2 	 316
#define F3 	 317
#define F4 	 318
#define F5 	 319
#define F6 	 320
#define F7 	 321
#define F8 	 322
#define F9 	 323
#define F10	 324
#define F11	 389
#define F12	 390
#define UPARROW	 	328
#define DOWNARROW 	336
#define LEFTARROW 	331
#define RIGHTARROW	333
#define HOMEKEY 327
#define ENDKEY 335
#define PGUPKEY 329
#define PGDNKEY 337
#define CTRLHOMEKEY 375
#define CTRLENDKEY 373
#define CTRLPGUPKEY 388
#define CTRLPGDNKEY 374
#define INSKEY 338
#define DELKEY 339
#define CTRLLEFTKEY 371
#define CTRLRIGHTKEY 372
#define CTRLLEFTARROW 	371
#define CTRLRIGHTARROW 	372
#define CTRLUPARROW 	397
#define CTRLDOWNARROW 	401
#define ALTLEFTARROW 	411
#define ALTRIGHTARROW 	413
#define ALTUPARROW 	408
#define ALTDOWNARROW 	416
#define BS 8
#define ENTER 13

#define LINELENGTH 96
#define LINECOUNT 15000
#define MAXPROGRAMS 300

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <dos.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/exceptn.h>
#include <dir.h>
#include <malloc.h> /* The math engine wanted this. */
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <pc.h>
#include <process.h>
#include <dpmi.h>
#include <float.h>
#include "allegro.h"
#include "gif.h"
#include "jpeg.h"

char Ln[LINECOUNT][LINELENGTH];
char ProgramPath[MAXPROGRAMS][LINELENGTH];
char Highlight[LINELENGTH];
char MathInput[2][80];
char MathOutput[80];
char ErrMessage[80];
char DosVerStr[80];
char CurrentFile[80];
char AppTitle[MAXPROGRAMS][LINELENGTH];
char LcarsExeName[12];
char NewName[80];
int NumOfFiles;
char file_too_long;
char load_abort;
int EndAppList;
int NumOfApps;
char NoAppList;
int c;
int t;
int EndText;
char AppPage;
int OldPWy;
int PWx;
int PWy;
int PickWindowOffset;
int MaxX;
int MaxY;
char DosDetected;
char GifList[100][80];
int EndGifList;
char VoiceList[100][80];
int EndVoiceList;
char BeepList[100][80];
int EndBeepList;

float m;	/* magnification factor from VGA for brackets */
int uy;	/* brackets: upper edge of divider */
int ly;	/* brackets: lower edge of divider */
extern int _doserrno;
char CurrentTrack[30];
char TimeDisplay[6];
char DateDisplay[6];
char SecDisplay[3];
char SecWhenAlarmSet[3]; /* to seed random music selection for alarm */
char TimeSetting[6];
char DateSetting[6];
char YearDisplay[5];
char old_sec;
char min_old;
char day_old;

int Hours, Minutes, Seconds;
int DateMonth, DateDay, DateYear;
int DayOfMonth;
char SettingType;
int AlarmHour;
int AlarmMin;
int SingleAlarmOnOff;
int MidiPlaying;
char AlarmString[11];
char KeyInStr[80];
char MathClip[80];
char DosClip[80];
char LcarsPath[80];
char CurrentPath[80];
char PathOfDriveC[80];
char PathOfDriveA[80];

size_t w,cx,cy,dx; /* for keyboard input */
int x, y;
size_t k;  /* for strlen */
int TimeColor;
int BracketColor1, BracketColor2;
char DriveChange;
char DirectoryChange;
int ProgramType;
char DosFolderArray[1000][80];
char DosFileArray[1000][80];
int NumOfFolders;
int TotalBytes;
char CopyPath[80];
int CurrentDrive;
int DepthFound, ScreenSize;
int W1Current;
char PathName[100];
char StarDate[10];
int null;
int BlasterOK;
char MuteBeeps;
char BeepSet;
char AlarmType;
char ColorScheme;
char AudioOff;
int SnoozeVal;
int SnoozeAlarmMin;
int Timers[15];
/* for Viewscreen */
int VsOffsetX;
int VsOffsetY;
int VsImageW, VsImageH;
int VsZoom, VsPrevZoom;
char VsScroll;
BITMAP *VsImage;
BITMAP *VsBuf;
PALETTE VsPalette;
char Endgame; /* special pallete flag */
char MonoType;
char MilitaryTime;
char Relaunch;
char SlideshowActive;
int Autorun;
int SecondsCounter;
int TimerOldSec;

#endif


