/* Kakuro game for LCARS 24
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "kakuro.h"

BITMAP *globalcorner;
BITMAP *topbevel;
BITMAP *sidebevel;

void KkrLoadPuzzleNum()
{
	PACKFILE *Fp;

	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\KAKURO\\PUZZNUM.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==NULL ) {
		return;
	} else{
		KkrPuzzleNum=pack_getc(Fp);
	}
	pack_fclose( Fp );
}
void KkrSavePuzzleNum()
{
	PACKFILE *Fp;

	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\KAKURO\\PUZZNUM.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		if(KkrCellsRemaining < 1) KkrPuzzleNum++;
		if(KkrPuzzleNum > NumOfFiles) KkrPuzzleNum=0;
		pack_putc( KkrPuzzleNum, Fp);
	}
	pack_fclose( Fp );
}
void KkrDisplayFilename()
{
	rectfill(screen,160,13,548,39,PALEBLUE);
	PutsLuna(160,20,BLACK,PALEBLUE,MakeDisplayName(CurrentFile));
}
void KkrCountCellsRemaining()
{
	int zx,zy;

	KkrCellsRemaining=0;
	for( zy = 0; zy < 9; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			t=Ln[zy][zx];
			if(isdigit(t)) KkrCellsRemaining++;
		}
	}
}
void KkrDisplayCellsRemaining()
{
	char OutStr[3];

	itoa(KkrCellsRemaining,OutStr,10);
	rectfill(screen,660,KkrUpLftY-10, 676,KkrUpLftY+11, BLACK);
	PutsFont21(660,KkrUpLftY-10, ORANGE, OutStr);
}
void KkrSignage()
{
	PutsFont21(561,KkrUpLftY-10, ORANGE, "EMPTY CELLS:");
	PutsFont14(561,120, PURPLE,BLACK,   "NUMERICAL CROSSWORD");
	PutsFont14(561,140, PALEBLUE,BLACK, "Use digits 1-9 (no repeats) to");
	PutsFont14(561,160, PALEBLUE,BLACK, "form each word across and down.");
	PutsFont14(561,180, PALEBLUE,BLACK, "Its sum is shown at upper left.");
	KkrCountCellsRemaining();
	KkrDisplayCellsRemaining();
}
void KkrPuzzleCompleteMessage(char mode)
{
	rectfill(screen,561,KkrUpLftY-10,760,KkrUpLftY+136,BLACK);
	if(mode==1) {
		MarsF(561,KkrUpLftY-10,2, ORANGE,BLACK,"PUZZLE");
		MarsF(561,KkrUpLftY+54,2, ORANGE,BLACK,"COMPLETE");
	} else {
		KkrSignage();
	}
}
int KkrMakeFileList()
{
	struct ffblk fblock;
	int Found;
	char *mask = "C:\\LCARS24\\LC24APPS\\KAKURO\\*.KK8";

	NumOfFiles = 0;
	Found = findfirst(mask, &fblock, FA_ARCH);
	if( Found ) {
		return(1);
	}
	while ( !Found ) {
		strcpy(CommonFileArray[NumOfFiles], fblock.ff_name);
		Found = findnext( &fblock );
		++NumOfFiles;
	}
	--NumOfFiles;
	return(0);
}
int PutsMulti14(int x,int y, int Hue, int Bak, char *Str)
{  /* Luna with plus and equal signs in BIGBLUE (Bak not used) */
	char Capture[1800];
	int i;
	int k;
	int pos;
	size_t j;
	int tabpos;
	unsigned int t;

	fc=Hue;
	bc=BLACK;
	FadeOut(fc);
	BackgroundColor=BLACK;

	Shadow=FindShadow(Hue, BLACK);
	t=32;
	pos = x;
	j = strlen(Str);
	strcpy(Capture, Str);
	k=(null);
	Capture[j+1] = (k);
	for(k = 0; k < j; ++k) {
		if( Capture[k] < 32 && Capture[k] != 9 ) i = (t);
		else i = Capture[k];
		if(y>0 && Capture[k] != 9 ) {
			SmoothHeadline14(screen,i,pos,y,Hue);
			if(i=='+' || i=='=') BlitHeadline14(screen,i,pos,y,BIGBLUE);
			else BlitHeadline14(screen,i,pos,y,Hue);

/* hyphen lengthened to en dash if before numeric/space/slash, fills to em if double */
if(Capture[k] == 45) {
		if( (Capture[k+1]>46 && Capture[k+1]< 58) || Capture[k+1]==32 || Capture[k+1]==45) {
			pos+=3;
			SmoothHeadline14(screen,45,pos,y,Hue);
			BlitHeadline14(screen,45,pos,y,Hue);
		}
		if( Capture[k+1]==45 )  pos-=3;
}

		}
		if( Capture[k] == 9 ) {
			tabpos=0;
			while( pos-x >= tabpos) tabpos += 40;
			pos = tabpos + x;
		} else pos += Font14[i]-65;
	}

	return(0);
}
void KkrDrawPuzzleGrid(int Width, int Height)
{
	int z;

	for( z = 0; z <= Height; ++z) {
		line(screen,KkrUpLftX,KkrUpLftY+(z*42),KkrUpLftX+(Width*42),KkrUpLftY+(z*42),BIGBLUE);
	}
	for( z = 0; z <= Width; ++z) {
		line(screen,KkrUpLftX+(z*42),KkrUpLftY,KkrUpLftX+(z*42),KkrUpLftY+(Height*42),BIGBLUE);
	}
}
void KkrFillPuzzGrid()
{
	BITMAP *corner;
	int tx,ty,r,g,b,DARK,z ;

	corner=create_bitmap(36,36);
	clear_to_color(corner,BLACK);

/* outer frame */
	rectfill(screen,KkrUpLftX,KkrUpLftY-10,KkrUpLftX+(9*42)+10,KkrUpLftY,KkrGridColor);
	LeftBumper26(KkrUpLftX+16,KkrUpLftY-10, KkrGridColor);
	rectfill(screen,KkrUpLftX-10,KkrUpLftY+(9*42),KkrUpLftX+(9*42)+10,KkrUpLftY+(9*42)+10,KkrGridColor);
	rectfill(screen,KkrUpLftX-10,KkrUpLftY+3,KkrUpLftX,KkrUpLftY+(9*42)+10,KkrGridColor);
	rectfill(screen,KkrUpLftX+(9*42),KkrUpLftY-10,KkrUpLftX+(9*42)+10,KkrUpLftY+(9*42)+10,KkrGridColor);

	rectfill(screen,KkrUpLftX+1,KkrUpLftY+1,KkrUpLftX+18,KkrUpLftY+18, BLACK);
	bc=BLACK;
	FadeOut(KkrGridColor);
	putpixel(screen,KkrUpLftX+1,KkrUpLftY+1,fc);
	putpixel(screen,KkrUpLftX+2,KkrUpLftY+1,ac1);
	putpixel(screen,KkrUpLftX+1,KkrUpLftY+2,ac1);
	putpixel(screen,KkrUpLftX+2,KkrUpLftY+2,ac3);

	putpixel(screen,KkrUpLftX+3,KkrUpLftY+1,ac3);
	putpixel(screen,KkrUpLftX+1,KkrUpLftY+3,ac3);

	putpixel(screen,KkrUpLftX+4,KkrUpLftY+1,ac4);
	putpixel(screen,KkrUpLftX+1,KkrUpLftY+4,ac4);

	r=getr(ac4);
	g=getg(ac4);
	b=getb(ac4);
	DARK=makecol(r/2,g/2,b/2);

	putpixel(screen,KkrUpLftX+5,KkrUpLftY+1,DARK);
	putpixel(screen,KkrUpLftX+1,KkrUpLftY+5,DARK);

	blit(screen, corner,KkrUpLftX-10,KkrUpLftY-10,0,0,36,36);

	draw_sprite_v_flip(screen, corner, KkrUpLftX-10, KkrUpLftY+(9*42)-25);
	draw_sprite_h_flip(screen, corner, KkrUpLftX+(9*42)-25, KkrUpLftY-10);
	draw_sprite_vh_flip(screen, corner, KkrUpLftX+(9*42)-25, KkrUpLftY+(9*42)-25);

	blit(screen, globalcorner,KkrUpLftX+(9*42)-5, KkrUpLftY+(9*42)-5,0,0,5,5);

	for(z=0; z<11; z++) hline(topbevel,12-z,z,13,KkrGridColor);
	putpixel(topbevel,12,0,ac4);
	putpixel(topbevel,13,0,ac3);
	putpixel(topbevel,0,10,ac4);
	putpixel(topbevel,1,10,ac3);

	for(z=0; z<11; z++) vline(sidebevel,z,12-z,13,KkrGridColor);
	putpixel(sidebevel,0,12,ac4);
	putpixel(sidebevel,0,13,ac3);
	putpixel(sidebevel,10,0,ac4);
	putpixel(sidebevel,10,1,ac3);

	destroy_bitmap(corner);

	PutsLuna(451,260, BRICK, BLACK, "ONLY CORRECT");
	PutsLuna(451,280, BRICK, BLACK, "INPUT ACCEPTED");

/* some on-screen help */

	tx=56;
	ty=KkrUpLftY+(9*42)+22;
	PutsMulti14(tx,ty,    SKYBLUE, BLACK, "1+2=3");
	PutsMulti14(tx,ty+20, SKYBLUE, BLACK, "1+3=4");
	PutsMulti14(tx,ty+40, SKYBLUE, BLACK, "9+7=16");
	PutsMulti14(tx,ty+60, SKYBLUE, BLACK, "9+8=17");

	tx+=StrLenLuna("9+8=17")+25;
	PutsMulti14(tx,ty,    ORANGE, BLACK, "1+2+3=6");
	PutsMulti14(tx,ty+20, ORANGE, BLACK, "1+2+4=7");
	PutsMulti14(tx,ty+40, ORANGE, BLACK, "9+8+6=23");
	PutsMulti14(tx,ty+60, ORANGE, BLACK, "9+8+7=24");

	tx+=StrLenLuna("9+8+7=24")+25;
	PutsMulti14(tx,ty,    SKYBLUE, BLACK, "1+2+3+4=10");
	PutsMulti14(tx,ty+20, SKYBLUE, BLACK, "1+2+3+5=11");
	PutsMulti14(tx,ty+40, SKYBLUE, BLACK, "9+8+7+5=29");
	PutsMulti14(tx,ty+60, SKYBLUE, BLACK, "9+8+7+6=30");

	tx+=StrLenLuna("9+8+7+6=30")+25;
	PutsMulti14(tx,ty,    ORANGE, BLACK, "1+2+3+4+5=15");
	PutsMulti14(tx,ty+20, ORANGE, BLACK, "1+2+3+4+6=16");
	PutsMulti14(tx,ty+40, ORANGE, BLACK, "9+8+7+6+4=34");
	PutsMulti14(tx,ty+60, ORANGE, BLACK, "9+8+7+6+5=35");

	tx+=StrLenLuna("9+8+7+6+5=35")+25;
	PutsMulti14(tx,ty,    SKYBLUE, BLACK, "1+2+3+4+5+6=21");
	PutsMulti14(tx,ty+20, SKYBLUE, BLACK, "1+2+3+4+5+7=22");
	PutsMulti14(tx,ty+40, SKYBLUE, BLACK, "9+8+7+6+5+3=38");
	PutsMulti14(tx,ty+60, SKYBLUE, BLACK, "9+8+7+6+5+4=39");

	tx+=StrLenLuna("9+8+7+6+5+4=39")+25;
	PutsMulti14(tx,ty,    ORANGE, BLACK, "1+2+3+4+5+6+7=28");
	PutsMulti14(tx,ty+20, ORANGE, BLACK, "1+2+3+4+5+6+8=29");
	PutsMulti14(tx,ty+40, ORANGE, BLACK, "9+8+7+6+5+4+2=41");
	PutsMulti14(tx,ty+60, ORANGE, BLACK, "9+8+7+6+5+4+3=42");

	tx+=StrLenLuna("9+8+7+6+5+4+3=42")+25;
	PutsMulti14(tx,ty,    SKYBLUE, BLACK, "1+2+3+4+5+6+7+8=36");
	PutsMulti14(tx,ty+20, SKYBLUE, BLACK, "1+2+3+4+5+7+8+9=39");
	PutsMulti14(tx,ty+40, SKYBLUE, BLACK, "9+8+7+6+5+3+2+1=41");
	PutsMulti14(tx,ty+60, SKYBLUE, BLACK, "9+8+7+6+5+4+2+1=42");
}
void KkrPutAcrossSum(int zx, int zy)
{
	int sx,sum;
	char sumstr[3]="00";

	sum=0;
	sx=zx+1;

	while( isdigit(Ln[zy][sx]) || islower(Ln[zy][sx]) ) {
		c=Ln[zy][sx];
		if(islower(c)) c-=48;
		sum+=(c-48);
		sx++;
	}
	itoa(sum,sumstr,10);
	PutsLuna(KkrUpLftX+(zx*42)+40-StrLenLuna(sumstr),KkrUpLftY+(zy*42)+6, BLACK, LAVENDER, sumstr);
}
void KkrPutDownSum(int zx, int zy)
{
	int sy,sum;
	char sumstr[3]="00";

	sum=0;
	sy=zy+1;

	while( isdigit(Ln[sy][zx]) || islower(Ln[sy][zx]) ) {
		c=Ln[sy][zx];
		if(islower(c)) c-=48;
		sum+=(c-48);
		sy++;
	}
	itoa(sum,sumstr,10);
	PutsLuna(KkrUpLftX+(zx*42)+5,KkrUpLftY+(zy*42)+24, BLACK, LAVENDER, sumstr);
}
void KkrPutClues()
{
	int zx,zy;
	char OneLetter[2] ="A";

	t=32;
	for( zy = 0; zy < 9; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			c= Ln[zy][zx];
			if(c=='B') {
				rectfill(screen,KkrUpLftX+(zx*42),KkrUpLftY+(zy*42),KkrUpLftX+(zx*42)+42,KkrUpLftY+(zy*42)+42,LAVENDER);
/* flange holes, extra rounded corner */
				if(zx==8) {
					rectfill(screen,KkrUpLftX+(zx*42)+22,KkrUpLftY+(zy*42)+22,KkrUpLftX+(zx*42)+36,KkrUpLftY+(zy*42)+36,BLACK);
					if( zy>2 && !isupper(Ln[zy-1][zx])) blit(globalcorner,screen,0,0, KkrUpLftX+(zx*42)+42-5, KkrUpLftY+(zy*42)-5,5,5);
				}
			}
			if (islower(c))  {
				t=c-48;
				OneLetter[0]=(t);
				PutsFont21(KkrUpLftX+18+(zx*42),KkrUpLftY+11+(zy*42),MANGO, OneLetter);
			}
		}
	}

	for( zy = 0; zy < 9; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			c=Ln[zy][zx];
			if(c=='S') {
				rectfill(screen,KkrUpLftX+(zx*42),KkrUpLftY+(zy*42),KkrUpLftX+(zx*42)+42,KkrUpLftY+(zy*42)+42,LAVENDER);
				if(zx<8 && !isupper(Ln[zy][zx+1])) KkrPutAcrossSum(zx,zy);
				if(zy<8 && !isupper(Ln[zy+1][zx])) KkrPutDownSum(zx,zy);
			}
		}
	}
/* top PADD bevels */
	for( zx = 1; zx < 8; ++zx) {
		c=Ln[0][zx];
		if(c=='B') rectfill(screen,KkrUpLftX+(zx*42),KkrUpLftY-10,KkrUpLftX+(zx*42)+42,KkrUpLftY,BLACK);
		/* a top left bevel */
		if( c=='B' && (Ln[0][zx-1]=='S' || zx==1) ) draw_sprite_h_flip(screen,topbevel,KkrUpLftX+(zx*42),KkrUpLftY-10);
		/* a top right bevel */
		if( c=='B' && (Ln[0][zx+1]=='S' || zx==7) ) blit(topbevel,screen,0,0,KkrUpLftX+(zx*42)+29,KkrUpLftY-10,14,11);
	}

/* (left) side PADD bevels */
	for( zy = 1; zy < 8; ++zy) {
		c=Ln[zy][0];
		if(c=='B') rectfill(screen,KkrUpLftX-10, KkrUpLftY+(zy*42), KkrUpLftX, KkrUpLftY+(zy*42)+42,BLACK);
		/* a side upper bevel */
		if( c=='B' && (Ln[zy-1][0]=='S' || zy==1) ) draw_sprite_v_flip(screen,sidebevel,KkrUpLftX-10,KkrUpLftY+(zy*42));
		/* a side lower bevel */
		if( c=='B' && (Ln[zy+1][0]=='S' || zy==7) ) blit(sidebevel,screen,0,0,KkrUpLftX-10,KkrUpLftY+(zy*42)+29,11,14);
	}
}
void KkrShowSolution(int Width, int Height)
{
	char OneLetter[2] ="A";
	int zx,zy;

	for( zy = 0; zy < Height; ++zy) {
		for( zx = 0; zx < Width; ++zx) {
			t= Ln[zy][zx];
			OneLetter[0] = (t);
			if( isdigit(t)) {
				rectfill(screen, KkrUpLftX+(zx*42)+1, KkrUpLftY+(zy*42)+2,KkrUpLftX+(zx*42)+40,KkrUpLftY+(zy*42)+39,BLACK);
				PutsFont21(KkrUpLftX+18+(zx*42),KkrUpLftY+11+(zy*42),NAPLES, OneLetter);
			}
		}
	}
	KkrSolutionShowing=TRUE;
	ButtonType4(543, 96+(3*47), PURPLE, "BACK", "ESC", ORANGE);

	/* erase upper-right signage */
	rectfill(screen,561,KkrUpLftY-10,760,KkrUpLftY+136,BLACK);
}
void KkrDrawCursor()
{
	int cx,cy;

	cx=KkrUpLftX+14+(KkrX*42);
	cy=KkrUpLftY+28+(KkrY*42);

	xor_mode(TRUE);
	rectfill(screen,cx+1, cy+6, cx+13, cy+9, WHITE);
	xor_mode(FALSE);
}
int KkrCursorLeft()
{
	--KkrX;
	while( isupper(Ln[KkrY][KkrX]) && KkrX>1 ) KkrX--; /* skip blanks */
	if(KkrX < 1) KkrX=1;
	if( isupper(Ln[KkrY][KkrX]) ) KkrCursorRight();
}
int KkrCursorRight()
{
	++KkrX;
	while( isupper(Ln[KkrY][KkrX]) && KkrX<8) KkrX++; /* skip blanks */
	if(KkrX > 8) KkrX=8;
	if( isupper(Ln[KkrY][KkrX]) ) KkrCursorLeft();
}
int KkrCursorUp()
{
	--KkrY;
	while( isupper(Ln[KkrY][KkrX]) && KkrY>1) KkrY--; /* skip blanks */
	if(KkrY < 1) KkrY=1;
	if( isupper(Ln[KkrY][KkrX]) ) KkrCursorDown();
}
int KkrCursorDown()
{
	++KkrY;
	while( isupper(Ln[KkrY][KkrX]) && KkrY<8) KkrY++; /* skip blanks */
	if(KkrY > 8) KkrY=8;
	if( isupper(Ln[KkrY][KkrX]) ) KkrCursorUp();
}
void KkrUpdateWrongGuesses()
{
	char OutStr[4];

	KkrWrongGuesses++;
	PutsLuna(451,320, BRICK, BLACK, "INCORRECT: ");
	itoa(KkrWrongGuesses,OutStr,10);
	rectfill(screen, 519,320, 540,335, BLACK);
	PutsLuna(520,320, BIGBLUE, BLACK, OutStr);
}
void KkrClearUserNotes()
{
	int zx,zy;

	for( zy = 0; zy < 9; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			KkrUserNotes[zy][zx] = 0;
		}
	}
}
int KkrCheckOneUserNote(int ny, int nx, int val)
{
	int bin, check;

	bin=1;
	bin=bin<<val;
	check=KkrUserNotes[ny][nx] & bin;
	if(check==0) KkrUserNotes[ny][nx] +=bin;
		else KkrUserNotes[ny][nx] -=bin;

	return(check);
}
void KkrPutUserNote(int x, int y, int Val)
{
	int nx,ny;
	char Str[2];

	if(Val < 1 || Val > 9) return;

	t= Ln[KkrY][KkrX];
	if( ! isdigit(t)) return;

	nx=KkrUpLftX+(x*42);
	ny=KkrUpLftY+(y*42);

	nx +=6;
	ny +=4;
	if(Val > 3) ny +=13;
	if(Val > 6) ny +=13;
	if(Val==2 || Val==5 || Val==8) nx +=13;
	if(Val==3 || Val==6 || Val==9) nx +=26;

	itoa(Val,Str,10);
	if(KkrCheckOneUserNote(ny,nx,Val)==0) PutsArial10(screen,nx,ny, BRICK, Str);
		else PutsArial10(screen,nx,ny, BLACK, Str);
}
void KkrPutOneChar()
{
	char OneLetter[2] ="A";

	if(! isdigit(c)) return;
	t= Ln[KkrY][KkrX];

	if( c != Ln[KkrY][KkrX] ) {
		if(isdigit(t)) KkrUpdateWrongGuesses();
		return;
	}
	OneLetter[0] = (t);

	rectfill(screen, KkrUpLftX+(KkrX*42)+3, KkrUpLftY+(KkrY*42)+2,KkrUpLftX+(KkrX*42)+40,KkrUpLftY+(KkrY*42)+39,BLACK);
	PutsFont21(KkrUpLftX+18+(KkrX*42),KkrUpLftY+11+(KkrY*42),MANGO, OneLetter);
	t+=48;
	KkrPuzzle[KkrY][KkrX] = (t);
	Ln[KkrY][KkrX] = (t);
	KkrCellsRemaining--;
	KkrActivity++;
	KkrDisplayCellsRemaining();
	if(KkrCellsRemaining < 1) KkrPuzzleCompleteMessage(1);
}
int KkrNewPuzzle()
{
	int Result;

	KkrPuzzleNum++;
	if(KkrPuzzleNum > NumOfFiles) KkrPuzzleNum = 0;
	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\KAKURO\\");
	strcat(CurrentFile, CommonFileArray[KkrPuzzleNum]);

	KkrDisplayFilename();
	Result = LoadTextFile();
	rectfill(screen,KkrUpLftX,KkrUpLftY,KkrUpLftX+(9*42),KkrUpLftY+378,BLACK);
	rectfill(screen,450,KkrUpLftY-10,753,200,BLACK);

	/* Erase "WRONG GUESSES" */
	rectfill(screen, KkrUpLftX,KkrUpLftY+(9*42)+62, KkrUpLftX+116,KkrUpLftY+(9*42)+80,BLACK);
	KkrWrongGuesses=0;
	KkrSolutionShowing=FALSE;
	KkrActivity=0;
	/* show BACK button disabled */
	rectfill(screen,543,96+(3*47),716,96+(4*47)-4,BLACK);

	if( exists("C:\\LCARS24\\LC24APPS\\KAKURO\\PUZZ.WIP"))
		remove("C:\\LCARS24\\LC24APPS\\KAKURO\\PUZZ.WIP");

	return(Result);
}
void KkrSaveGameInProgress()
{
	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\KAKURO\\PUZZ.WIP");
	SaveTextFile();
}
void KkrUndoSolution()
{
	char OneLetter[2] ="A";
	int zx,zy;

	for( zy = 0; zy < 9; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			t= Ln[zy][zx];
			OneLetter[0] = (t);
			if( isdigit(t)) {
				rectfill(screen, KkrUpLftX+(zx*42)+3, KkrUpLftY+(zy*42)+2,KkrUpLftX+(zx*42)+40,KkrUpLftY+(zy*42)+39,BLACK);
			}
		}
	}

	KkrSignage();
	KkrSolutionShowing=FALSE;

	/* show BACK button disabled */
	rectfill(screen,543,96+(3*47),716,96+(4*47)-4,BLACK);
}
int KkrWindowActive()
{

NextPuzz:
	KkrGridColor = LAVENDER;
	KkrDrawPuzzleGrid(9,9);
	KkrFillPuzzGrid();
	KkrPutClues();
	KkrSignage();
	KkrX=0;  /* cursor coordinates */
	KkrY=1;
	while( isupper(Ln[KkrY][KkrX]) ) KkrX++; /* park cursor */
	KkrClearUserNotes();
loopback:
	KkrDrawCursor();
	do {
		PePutTime(ORANGE);
	} while(!kbhit());
	c = GetKey();
	KkrDrawCursor();
	switch( c )
		{
			case 27: 	KkrUndoSolution();
					goto loopback;
/*
			case 33:	KkrPutUserNote(KkrX,KkrY,1);
					goto loopback;
			case 34:	KkrPutUserNote(KkrX,KkrY,2);
					goto loopback;
			case 35:	KkrPutUserNote(KkrX,KkrY,3);
					goto loopback;
			case 36:	KkrPutUserNote(KkrX,KkrY,4);
					goto loopback;
			case 37:	KkrPutUserNote(KkrX,KkrY,5);
					goto loopback;
			case 38:	KkrPutUserNote(KkrX,KkrY,6);
					goto loopback;
			case 39:	KkrPutUserNote(KkrX,KkrY,7);
					goto loopback;
			case 40:	KkrPutUserNote(KkrX,KkrY,8);
					goto loopback;
			case 41:	KkrPutUserNote(KkrX,KkrY,9);
					goto loopback;
*/

			case 13: 	goto loopback;
			case F9: 	if( KkrNewPuzzle() !=0) return(86);
					goto NextPuzz;
			case F10:  	KkrShowSolution(9,9);
					goto loopback;
			case F11:	OpenHelp("C:\\LCARS24\\LC24APPS\\KAKURO\\KAKURO.TXT");
					min_old=70;
					goto loopback;
			case F12:	if(KkrCellsRemaining >0 && KkrActivity > 0) KkrSaveGameInProgress();
					KkrSavePuzzleNum();
					return(0);
			case LEFTARROW: KkrCursorLeft();
					goto loopback;
			case RIGHTARROW: KkrCursorRight();
					goto loopback;
			case PGUPKEY:
			case UPARROW: 	KkrCursorUp();
					goto loopback;
			case PGDNKEY:
			case DOWNARROW: KkrCursorDown();
					goto loopback;
			case 350: 	Screenshot792("Kakuro8.bmp");
					goto loopback;
			case 351: 	Screenshot1024("Kakuro10.bmp");
					goto loopback;
			default:  	if(isdigit(c)) KkrPutOneChar();
					if(c > 32 && c < 42) KkrPutUserNote(KkrX,KkrY,c-32);
					goto loopback;
		}
}
void KkrScreen()
{
	int top=96;

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(PALEBLUE);
	Title("KAKURO");

	PutsLuna(705-StrLenLuna("NOTES: SHIFT + NUMERIC KEYS"),566, BLACK,PALEBLUE, "NOTES: SHIFT + NUMERIC KEYS");
	PutsLuna(172,566, BLACK,PALEBLUE, "MOVE CURSOR: ARROW KEYS");
	PutsLuna(378,566, BLACK,PALEBLUE, "INPUT: NUMERIC KEYS");

	RightBumper36(718,top+(3*47), PURPLE);
	ButtonType4(543, top+(4*47), LILAC, "NEXT PUZZLE", "F9", SEABLUE);
	ButtonType4(543, top+(5*47), PURPLE, "SOLUTION", "F10", BIGBLUE);
	ButtonType4(543, top+(6*47), LILAC, "HELP", "F11", TAN);
	ButtonType4(543, top+(7*47), PURPLE, "CLOSE", "F12", ORANGE);


/* to verify button alignment with puzzle grid */
/* hline(screen, 47, KkrUpLftY+(9*42)+12, 753, SKYBLUE); */

	KkrGridColor = LAVENDER;
	KkrDrawPuzzleGrid(9,9);
	KkrFillPuzzGrid();
}
void KkrInit()
{
	MaxX=799;
	MaxY=599;
	min_old=70;
	KkrUpLftX=41+9;
	KkrUpLftY=64+9;
	KkrPuzzleNum=0;
	KkrWrongGuesses=0;
	KkrSolutionShowing=FALSE;
	KkrActivity=0;
}
int KakuroMode()
{
	int Result;
	char IsWIP;

	/* an extra rounded inside corner */
	globalcorner=create_bitmap(5,5);
	clear_to_color(globalcorner,BLACK);
	topbevel=create_bitmap(14,11);
	clear_to_color(topbevel,BLACK);
	sidebevel=create_bitmap(11,14);
	clear_to_color(sidebevel,BLACK);
	IsWIP=FALSE;
	KkrInit();
	KkrScreen();
	if(KkrMakeFileList()) {
		rest(100);
		NormalLoadError("C:\\LCARS24\\LC24APPS\\KAKURO\\*.KK8");
		return(86);
	}
	CommonSortFiles();
	KkrLoadPuzzleNum();

	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\KAKURO\\PUZZ.WIP");
	if( exists(CurrentFile)) {
        	IsWIP=TRUE;
		LoadTextFile();
	}
	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\KAKURO\\");
	strcat(CurrentFile, CommonFileArray[KkrPuzzleNum]);
	if(IsWIP==FALSE) LoadTextFile();
	KkrDisplayFilename();
	Result = KkrWindowActive();
	destroy_bitmap(globalcorner);
	destroy_bitmap(topbevel);
	destroy_bitmap(sidebevel);
	return(Result);
}

