/* 	Guide.c, two setting guides for the clock module  */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "lcars24.h"
#include "guide.h"

void PutSettingAM(int x, int y)
{
	MarsF(x, y, 2, NAPLES, BLACK, " A.M. ");
}
void PutSettingPM(int x, int y)
{
	MarsF(x, y, 2, NAPLES, BLACK, " P.M. ");
}
int BlackPlusSign(int x,int y, int s)
{
	rectfill(screen, x,y+(s*15),x+(s*13),y+(s*18),BLACK);
	rectfill(screen, x+(s*5),y+(s*10),x+(s*8),y+(s*24),BLACK);
}
int BlackMinusSign(int x,int y, int s)
{
	rectfill(screen, x,y+(s*15),x+(s*13),y+(s*18),BLACK);
}
void SettingSelect()
{
	PutsScorpio(190,569-(6*47)+14,ORANGE,"SETTINGS");
	ButtonType2(120, 569-(5*47)+14, PURPLE, PALEBLUE, "TIME");
	ButtonType2(120, 569-(4*47)+14, LILAC, ORANGE, "DATE");
	ButtonType2(120, 569-(3*47)+14, BLACK, MANGO, "ALARM");
	ButtonType2(120, 569-(2*47)+14, BRICK, TAN, "OPTIONS");
	ButtonType3(120, 569-(1*47)+14, ORANGE, LILAC, "BACK");

	F36_1(260, 569-(5*47)+15, NAPLES, BLACK);
	F36_2(260, 569-(4*47)+15, SKYBLUE, BLACK);
	F36_3(260, 569-(3*47)+15, ORANGE, BLACK);
	F36_4(260, 569-(2*47)+15, NAPLES, BLACK);
	EscSymbol(237, 569-(1*47)+14,2, ORANGE);
}
void PopUp1(int x, int y, int Hue, char *Str)
{
	NortheastElbow(x+189,y,Hue);
	rectfill(screen,x,y,x+249,y+26,Hue);
	rectfill(screen,134,y,134+StrLenScorpio(Str)+6,y+27,BLACK);
	PutsScorpio(138,y,ORANGE,Str);
}
void SettingGuide(char type, int x, int y, int Hue)
{
/* upper panel frame section */
	RightBumper36(x+278,y+279,Hue); /* at bottom, but . . . */
	rectfill(screen,x+258,y+249,x+295,y+304,BLACK);

	rectfill(screen,x,y+190,x+209,y+200,Hue);
	rectfill(screen,x+214,y+190,x+314,y+200,Hue);
	rectfill(screen,x+294,y+201,x+314,y+297,Hue);

/* lower panel frame section */

	rectfill(screen,x,y+305,x+209,y+315,Hue);
	rectfill(screen,x+214,y+305,x+296,y+315,Hue);
	rectfill(screen,x+294,y+255,x+310,y+305,Hue);
	SoutheastCorner(x+293,y+304);

	rectfill(screen,x,y+205,x+79,y+250,NAPLES);
	UpArrowSymbol( x+84, y+208, NAPLES );
	DownArrowSymbol( x+84, y+232, NAPLES );
	BlackPlusSign(x+62,y+199,1);
	BlackMinusSign(x+62,y+223,1);
	if( type == 1 ) PutsLuna(x+4,y+231,BLACK,NAPLES,"HOUR");
	if( type == 2 ) PutsLuna(x+4,y+231,BLACK,NAPLES,"MONTH");

	rectfill(screen,x,y+255,x+79,y+300,NAPLES);
	RightArrowSymbol( x+84, y+258, NAPLES );
	LeftArrowSymbol( x+84, y+282, NAPLES );
	BlackPlusSign(x+62,y+249,1);
	BlackMinusSign(x+62,y+273,1);
	if( type == 1 ) PutsLuna(x+4,y+281,BLACK,NAPLES,"MINUTE");
	if( type == 2 ) PutsLuna(x+4,y+281,BLACK,NAPLES,"DAY");

	rectfill(screen,x+130,y+205,x+209,y+250,ORANGE);
	PutsLuna(x+134,y+231,BLACK,ORANGE,"SET");
	EnterSymbol(x+214, y+211, 2, ORANGE);

	rectfill(screen,x+130,y+255,x+209,y+300,ORANGE);
	PutsLuna(x+134,y+281,BLACK,ORANGE,"CANCEL");
	EscSymbol(x+217, y+260, 2, ORANGE);
}

