/*	 Cropcirc.c, three functions for drawing antialiased, filled circles
	void CropCircle(int x,int y, int radius)
	void BlackHole(int x,int y, int radius)
	void Circle36(int x, int y, int Hue)
	Set fc, ac1, ac2, ac3, and ac4 before using
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "cropcirc.h"

void FadeWest(BITMAP *bmp,int x, int y)
{
	putpixel(bmp,x+2,y,fc); /* fc */
	putpixel(bmp,x+1,y,ac2);
	putpixel(bmp,x,y,ac3);
}
void FadeEast(BITMAP *bmp,int x, int y)
{
	putpixel(bmp,x-2,y,fc); /* fc */
	putpixel(bmp,x-1,y,ac2);
	putpixel(bmp,x,y,ac3);
}
void FadeNorth(BITMAP *bmp,int x, int y)
{
	putpixel(bmp,x,y+2,fc);  /* fc */
	putpixel(bmp,x,y+1,ac2);
	putpixel(bmp,x,y,ac3);
}
void FadeSouth(BITMAP *bmp,int x, int y)
{
	putpixel(bmp,x,y-2,fc);  /* fc */
	putpixel(bmp,x,y-1,ac2);
	putpixel(bmp,x,y,ac3);
}
int CropCircle(BITMAP *bmp,int reverse, int x,int y, float radius)
{  /* Set fc, ac1, ac2, ac3, and ac4 before using */
	float n=0,invradius=1/(float)radius;
	int dx=0,dy=radius-1;
	int edge=0;
	int trap=dy;

	if(reverse==0) FadeOut(fc);

	circlefill(bmp,x,y,radius-1,fc);

	if(radius < 10 && s < 4 ) return(1);

	while (dx<=dy)
	{
		FadeEast(bmp,x+dx,y+dy);
		FadeEast(bmp,x+dx,y-dy);
		FadeWest(bmp,x-dx,y+dy);
		FadeWest(bmp,x-dx,y-dy);
		FadeSouth(bmp,x+dy,y+dx);
		FadeNorth(bmp,x+dy,y-dx);
		FadeSouth(bmp,x-dy,y+dx);
		FadeNorth(bmp,x-dy,y-dx);
		dx++;
		n+=invradius;
		dy=radius * sin(acos(n));
		if(dy==trap) ++edge;
	}
	--edge;

	hline(bmp,x-edge+2,y-radius+1,x+edge-2,ac1);

	putpixel(bmp,x-edge+1,y-radius+1,ac2);
	putpixel(bmp,x+edge-1,y-radius+1,ac2);
	putpixel(bmp,x-edge,y-radius+1,ac3);
	putpixel(bmp,x+edge,y-radius+1,ac3);
	putpixel(bmp,x-edge-1,y-radius+1,ac4);
	putpixel(bmp,x+edge+1,y-radius+1,ac4);
	putpixel(bmp,x-edge-2,y-radius+1,ac4);
	putpixel(bmp,x+edge+2,y-radius+1,ac4);



	hline(bmp,x-edge+2,y+radius-1,x+edge-2,ac1);

	putpixel(bmp,x-edge+1,y+radius-1,ac2);
	putpixel(bmp,x+edge-1,y+radius-1,ac2);
	putpixel(bmp,x-edge,y+radius-1,ac3);
	putpixel(bmp,x+edge,y+radius-1,ac3);
	putpixel(bmp,x-edge-1,y+radius-1,ac4);
	putpixel(bmp,x+edge+1,y+radius-1,ac4);
	putpixel(bmp,x-edge-2,y+radius-1,ac4);
	putpixel(bmp,x+edge+2,y+radius-1,ac4);

	++edge;  /* cheating for Mars usage */

	putpixel(bmp,x-radius+1,y-edge+1,ac3);
	putpixel(bmp,x-radius+1,y+edge-1,ac3);
	putpixel(bmp,x-radius+1,y-edge,ac4);
	putpixel(bmp,x-radius+1,y-edge,ac4);
	putpixel(bmp,x-radius+1,y-edge-1,ac4);
	putpixel(bmp,x-radius+1,y+edge+1,ac4);
	putpixel(bmp,x+radius-1,y-edge+1,ac3);
	putpixel(bmp,x+radius-1,y+edge-1,ac3);
	putpixel(bmp,x+radius-1,y-edge,ac4);
	putpixel(bmp,x+radius-1,y+edge,ac4);
	putpixel(bmp,x+radius-1,y-edge-1,ac4);
	putpixel(bmp,x+radius-1,y+edge+1,ac4);
	return(0);
}
void BlackHole(BITMAP *bmp,int x,int y, float radius)
{ /* Set fc, ac1, ac2, ac3, and ac4 before using */
	int temp, temp1, temp2, temp3, temp4;

	temp=fc;
	temp1=ac1;
	temp2=ac2;
	temp3=ac3;
	temp4=ac4;
	fc=BLACK;
	ac1=BLACK;
	ac2=temp3;
	ac3=temp2;
	ac4=temp1;
	CropCircle(bmp,1,x,y,radius);
	fc=temp;
	ac1=temp1;
	ac2=temp2;
	ac3=temp3;
	ac4=temp4;
}


