/*	 Fast buffered copy routine, using existing Ln array declared in
	textio.h
	(Don't call this if that array is in use.)
	Return values: 0: Okay
				1: Couldn't open source
				2: Couldn't create destination
				3: Write error
				4: File too large for this buffer
*/
/*
 * This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "copyfile.h"


int CopyFile(char *src, char *dest)
{
	PACKFILE *sf;
	PACKFILE *df;
	int c, x, y, endx, endy;

/* input from source to buffer */
	for(y = 0; y < LINECOUNT-1; ++y) memset(Ln[y],(null),LINELENGTH);

	if ( ( sf = pack_fopen(src, "rb" )) == NULL ) return(1);
	x=y=0;
	do {
		c=pack_getc(sf);
		if(c==EOF) break;
		Ln[y][x]=c;
		x++;
		if(x==LINELENGTH-1) {
			y++;
			x=0;
		}
		if(y >= LINECOUNT-1) {
			pack_fclose(sf);
			return(4);
		}
	}  while(1);

	endy=y;
	endx=x;
	pack_fclose(sf);

/* output from buffer to destination */

	if ( ( df = pack_fopen(dest, "wb" )) == NULL ) return(2);

	x=y=0;
	do {
		if(x==endx && y==endy) break;
		c=Ln[y][x];
		pack_putc(c, df);
		x++;
		if(x==LINELENGTH-1) {
			y++;
			x=0;
		}
	}  while(1);

	pack_fclose(df);
	return(0);
}
/* eof */

