/*
 *	Some routines for common use
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "common.h"


void CommonSortFiles()
{
	char bag[16];
	int f;
	int r = 0;
	int done,ch;
	int z,i;

	for( z=0; z<NumOfFiles; ++z) {
		for( i=0; i<16; ++i) {
			ch=CommonFileArray[z][i];
			if( ch !=(null) ) ch=toupper(ch);
			CommonFileArray[z][i]=ch;
		}
	}
	do {
		done = TRUE;
		for (f=0; f<NumOfFiles; ++f) {
			r = strcmp(CommonFileArray[f],CommonFileArray[f+1]);
			if( r > 0 )  {
				strcpy(bag,CommonFileArray[f]);
				strcpy(CommonFileArray[f],CommonFileArray[f+1]);
				strcpy(CommonFileArray[f+1],bag);
				done = FALSE;
			}
		}
	} while ( done == FALSE );
}

int CommonMakeFileList(char *mask)
{
	struct ffblk fblock;
	int Found;
	int z;

	for(z = 0; z < 1000; z++) memset(CommonFileArray[z],0,13);

	NumOfFiles=0;
	Found=findfirst(mask, &fblock, FA_ARCH);
	while (!Found) {
		NumOfFiles++;
		strcpy(CommonFileArray[NumOfFiles], fblock.ff_name);
		Found = findnext( &fblock );
	}
	return(NumOfFiles);
}

void SaveBookmark(char *filespec, int place)
{
	PACKFILE *Fp;
	char output[10];
	char bmkfile[80];
	int len,z;

	replace_extension(bmkfile,filespec,"BMK",sizeof(bmkfile));

	itoa(place,output,10);
	len=strlen(output);

	if ( ( Fp=pack_fopen(bmkfile, "wb" ))==NULL ) return;
		else for(z=0;z<=len;z++) pack_putc( output[z], Fp );

	pack_fclose( Fp );
}

int LoadBookmark(char *filespec)
{
	PACKFILE *Fp;
	char input[10];
	int result, z;
	unsigned short t;
	char bmkfile[80];

	replace_extension(bmkfile,filespec,"BMK",sizeof(bmkfile));
	if( ! (__file_exists(bmkfile)) ) return(0);
	if(( Fp=pack_fopen(bmkfile, "rb" ))==NULL) return(0);

	memset(input,0,10);

	z=0;
	t=32;
	do {
		if(pack_feof(Fp)) break;
		t = pack_getc(Fp);
		input[z] = (t);
		z++;
	}  while(1);

	pack_fclose( Fp );

	return(atoi(input));
}
