/*	 cards.c, reusable routines for card games */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "cards.h"


/* First, different versions of A and K for cards */
void CardA(int x,int y, int color)
{
	fc=color;
	bc=CARDWHITE;
	if(color==BLACK) FadeIn(bc);
	if(color==RED) {
		ac3 = makecol(253, 154,   131);
		ac4 = makecol(251,  182,   167);
	}

	rectfill(screen, x+2,y,x+4,y+9,fc);
	vline(screen, x+1,y+6,y+13,fc);
	vline(screen, x+5,y+6,y+13,fc);

	vline(screen, x+3,y+4,y+5,ac3);
	vline(screen, x+3,y+6,y+7,bc);

	vline(screen, x,y+7,y+9,ac4);
	vline(screen, x+6,y+7,y+9,ac4);
	vline(screen, x,y+10,y+13,ac3);
	vline(screen, x+6,y+10,y+13,ac3);

	vline(screen, x+1,y+1,y+2,ac4);
	vline(screen, x+5,y+1,y+2,ac4);
	vline(screen, x+1,y+3,y+5,ac3);
	vline(screen, x+5,y+3,y+5,ac3);

	vline(screen, x+2,y+10,y+11,ac3);
	vline(screen, x+4,y+10,y+11,ac3);
	vline(screen, x+2,y+12,y+13,ac4);
	vline(screen, x+4,y+12,y+13,ac4);
}
void CardK(int x,int y, int color)
{
	fc=color;
	bc=CARDWHITE;
	if(color==BLACK) FadeIn(bc);
	if(color==RED) {
		ac3 = makecol(253, 154,   131);
		ac4 = makecol(251,  182,   167);
	}

	rectfill(screen, x,y,x+1,y+13,fc);
	vline(screen, x+2,y+2,y+3,ac4);
	vline(screen, x+2,y+4,y+9,ac3);
	vline(screen, x+2,y+10,y+11,ac4);
	vline(screen, x+2,y+6,y+7,fc);
	vline(screen, x+3,y,y+13,fc);
	putpixel(screen, x+3,y+6,ac4);
	vline(screen, x+4,y,y+1,fc);
	vline(screen, x+4,y+2,y+3,ac3);
	vline(screen, x+4,y+4,y+5,ac4);
	vline(screen, x+4,y+8,y+9,ac4);
	vline(screen, x+4,y+10,y+11,ac3);
	vline(screen, x+4,y+12,y+13,fc);
}

/*	 Then, upside-down 1-0, A, J, Q, and K for playing cards,
	otherwide identical to those of the Luna font
	Usage: DownA(int x,int y)
	So, unlike the Luna font, these are individual functions
	to be called directly.
	Think upside-down when determining x and y.
	The foreground, background, and antialiasing colors must be set,
	normally through previous use of PutsLuna for the upper-left
	corner of a card.  Use stardard Starfleet (LCARS) colors.
*/

void Down0(int x,int y)
{
	DownO(x,y);
}
void Down1(int x,int y)
{
	putpixel(screen, x-1,y-1, ac4);
	vline(screen, x-1,y-2,y-3,fc);
	putpixel(screen, x-1,y-4, ac3);

	putpixel(screen, x-2,y, ac4);
	putpixel(screen, x-2,y-1, ac3);
	vline(screen, x-2,y-2,y-13,fc);

	vline(screen, x-3,y,y-13,fc);
}
void Down2(int x,int y)
{
	vline(screen, x,y-1,y-5,fc);
	putpixel(screen, x,y-9, ac4);
	putpixel(screen, x,y-10, ac3);
	vline(screen, x,y-11,y-13,fc);

	vline(screen, x-1,y,y-5,fc);
	putpixel(screen, x-1,y-7, ac4);
	vline(screen, x-1,y-8,y-13,fc);

	vline(screen, x-2,y,y-1,fc);
	putpixel(screen, x-2,y-2, ac3);
	putpixel(screen, x-2,y-5, ac4);
	vline(screen, x-2,y-6,y-8,fc);
	putpixel(screen, x-2,y-9, ac3);
	putpixel(screen, x-2,y-10, ac4);
	vline(screen, x-2,y-12,y-13,fc);

	vline(screen, x-3,y,y-6,fc);
	putpixel(screen, x-3,y-7, ac3);
	putpixel(screen, x-3,y-8, ac4);
	vline(screen, x-3,y-12,y-13,fc);

	vline(screen, x-4,y-1,y-4,fc);
	putpixel(screen, x-4,y-5, ac4);
	vline(screen, x-4,y-12,y-13,fc);
	hline(screen, x-2,y-11,x-4,ac3);
}
void Down3(int x,int y)
{
	DownO(x,y);
	rectfill(screen, x,y-6,x-1,y-7,bc);
	vline(screen, x-2,y-6,y-7,fc);
	putpixel(screen, x-4,y-6, ac4);
}
void Down4(int x,int y)
{
	rectfill(screen, x,y-8,x-5,y-9,fc);
	hline(screen, x,y-10,x-5,ac3);
	rectfill(screen, x-3,y,x-4,y-13,fc);

	putpixel(screen, x,y-6, ac4);
	putpixel(screen, x,y-7, ac3);

	putpixel(screen, x-1,y-3, ac4);
	putpixel(screen, x-1,y-4, ac3);
	vline(screen, x-1,y-5,y-7,fc);

	vline(screen, x-2,y,y-1,ac4);
	vline(screen, x-2,y-2,y-6,ac3);
	vline(screen, x-2,y-3,y-5,fc);
}
void Down5(int x,int y)
{
	Down6(x,y);
	hline(screen, x,y,x-4,fc);
	hline(screen, x,y-8,x-2,bc);
	rectfill(screen, x-2,y-2,x-4,y-4,bc);
}
void Down6(int x,int y)
{
	DownO(x,y);
	putpixel(screen, x-2,y-5, ac4);
	putpixel(screen, x-2,y-7, ac4);	 /* was ac3 */
	hline(screen, x-2,y-6,x-3,fc);
	putpixel(screen, x-3,y-5, ac3);
	putpixel(screen, x-4,y-5, bc);	/* was ac4 */
	putpixel(screen, x-4,y-6, ac4);	 /* was ac3 */
}
void Down7(int x,int y)
{
	rectfill(screen, x,y,x-4,y-1,fc);
	hline(screen, x,y-2,x-1,ac3);
	vline(screen, x-2,y-2,y-3,ac4);
	rectfill(screen, x-3,y-2,x-4,y-3,fc);
	rectfill(screen, x-2,y-4,x-4,y-5,ac3);
	rectfill(screen, x-1,y-6,x-4,y-7,ac4);
	rectfill(screen, x-1,y-8,x-3,y-9,ac3);
	rectfill(screen, x,y-10,x-3,y-11,ac4);
	rectfill(screen, x,y-12,x-2,y-13,ac3);
	vline(screen, x-3,y-4,y-7,fc);
	vline(screen, x-2,y-6,y-11,fc);
	vline(screen, x-1,y-10,y-13,fc);
}
void Down8(int x,int y)
{
	DownO(x,y);
	putpixel(screen, x,y-6, ac4);
	putpixel(screen, x-4,y-6, ac4);
	putpixel(screen, x-2,y-5, ac3);
	putpixel(screen, x-2,y-6, fc);
	putpixel(screen, x-2,y-7, ac3);
}
void Down9(int x,int y)
{
	DownO(x,y);
	putpixel(screen, x,y-7, ac3);
	putpixel(screen, x,y-8, ac4);
	hline(screen, x-1,y-7,x-2,fc);
	putpixel(screen, x-1,y-8, ac3);
	putpixel(screen, x-2,y-6, ac3);
	putpixel(screen, x-2,y-8, ac4);
}
void DownO(int x,int y)
{
	rectfill(screen, x-1,y,x-3,y-1,fc);  /* top */
	rectfill(screen, x-1,y-12,x-3,y-13,fc); /* bottom */
	rectfill(screen, x,y-1,x-1,y-12,fc);	/* left */
	rectfill(screen, x-3,y-1,x-4,y-12,fc);	 /* right */
	putpixel(screen, x-2,y-2, ac3);
	putpixel(screen, x-2,y-11, ac3);
}
void DownA(int x,int y)
{
	rectfill(screen, x-2,y,x-4,y-9,fc);
	vline(screen, x-1,y-6,y-13,fc);
	vline(screen, x-5,y-6,y-13,fc);

	vline(screen, x-3,y-4,y-5,ac3);
	vline(screen, x-3,y-6,y-7,bc);

	vline(screen, x,y-7,y-9,ac4);
	vline(screen, x-6,y-7,y-9,ac4);
	vline(screen, x,y-10,y-13,ac3);
	vline(screen, x-6,y-10,y-13,ac3);

	vline(screen, x-1,y-1,y-2,ac4);
	vline(screen, x-5,y-1,y-2,ac4);
	vline(screen, x-1,y-3,y-5,ac3);
	vline(screen, x-5,y-3,y-5,ac3);

	vline(screen, x-2,y-10,y-11,ac3);
	vline(screen, x-4,y-10,y-11,ac3);
	vline(screen, x-2,y-12,y-13,ac4);
	vline(screen, x-4,y-12,y-13,ac4);
}
void DownJ(int x,int y)
{
	rectfill(screen, x-1,y-12,x-3,y-13,fc); /* bottom */
	rectfill(screen, x,y-8,x-1,y-12,fc);	/* left */
	rectfill(screen, x-3,y,x-4,y-12,fc);	 /* right */
	putpixel(screen, x-2,y-11, ac3);
}
void DownK(int x,int y)
{
	rectfill(screen, x,y,x-1,y-13,fc);
	vline(screen, x-2,y-2,y-3,ac4);
	vline(screen, x-2,y-4,y-9,ac3);
	vline(screen, x-2,y-10,y-11,ac4);
	vline(screen, x-2,y-6,y-7,fc);
	vline(screen, x-3,y,y-13,fc);
	putpixel(screen, x-3,y-6,ac4);
	vline(screen, x-4,y,y-1,fc);
	vline(screen, x-4,y-2,y-3,ac3);
	vline(screen, x-4,y-4,y-5,ac4);
	vline(screen, x-4,y-8,y-9,ac4);
	vline(screen, x-4,y-10,y-11,ac3);
	vline(screen, x-4,y-12,y-13,fc);
}
void DownQ(int x,int y)
{
	DownO(x,y);
	rectfill(screen, x-3,y-14,x-4,y-15,fc);
}


/* main card routines */

int shuffle( int *deck, int n_cards )
{
		  int i;
		  static int first_time = TRUE;

	/* seed the random-number generator with the current time */
	if( first_time ){
					 first_time = FALSE;
					 srand( (unsigned int)time( NULL ) );
		  }
		 /* shuffle by exhanging random pairs of cards. */
		  for( i = n_cards - 1; i > 0; i -= 1 ){
					 int where;
					 int temp;
					 where = rand() % i;
					 temp = deck[ where ];
					 deck[ where ] = deck[ i ];
					 deck[ i ] = temp;
		  }
}
int DrawDownCard(int x, int y, int Full)
{
	int NAPLES2, NAPLES3;

	NAPLES2=makecol(225,180,135);
	NAPLES3=makecol(199,159,120);

	++x;
	cw-=2;
	hline(screen,x+2,y,x+cw-2,NAPLES3);
	hline(screen,x+2,y+ch,x+cw-2,NAPLES3);
	vline(screen,x,y+2,y+ch-2,NAPLES3);
	vline(screen,x+cw,y+2,y+ch-2,NAPLES3);
	rectfill(screen,x+1,y+1,x+cw-1,y+ch-1,makecol(32,32,64));
	putpixel(screen,x+1,y+1,NAPLES3);
	putpixel(screen,x+cw-1,y+1,NAPLES3);
	putpixel(screen,x+1,y+ch-1,NAPLES3);
	putpixel(screen,x+cw-1,y+ch-1,NAPLES3);

	if( Full == 1) {
		putpixel(screen,x+10,y+19,BRICK);
		putpixel(screen,x+22,y+46,PURPLE);
		putpixel(screen,x+17,y+22,NAPLES2);
		putpixel(screen,x+46,y+9,makecol(186,93,93));
		putpixel(screen,x+36,y+79,BIGBLUE);
		set_palette(faces_palette);
		if(Animate == 1) {
			blit(faces, screen, 715,23, x+2, y+29, 67,53);
			delay(170);
			Animate = 0;
		}
		blit(faces, screen, 613,23, x+2, y+29, 67,53);
	}
	cw+=2;
}
void DrawSmallSpots(int x, int y, char *suit)
{
	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 593,1, x+2, y+22, 9,13);
		blit(faces, screen, 603,1, x+cw-10, y+ch-34, 9,13);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 579,34, x+3, y+22, 9,13);
		blit(faces, screen, 579,34, x+cw-10, y+ch-34, 8,13);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 594,18, x+2, y+22, 9,13);
		blit(faces, screen, 588,34, x+cw-10, y+ch-34, 9,13);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 595,52, x+2, y+22, 9,13);
		blit(faces, screen, 598,34, x+cw-10, y+ch-34, 9,13);
	}
}
void CenterSpot(int x, int y, char *suit)
{
	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 566,1, x+29, y+43, 13,16);
	if( strcmp(suit,"D") == 0 ) blit(faces, screen, 566,34, x+29, y+43, 13,17);
	if( strcmp(suit,"C") == 0 ) blit(faces, screen, 566,18, x+29, y+43, 13,16);
	if( strcmp(suit,"H") == 0 ) blit(faces, screen, 566,52, x+29, y+43, 13,17);
}
void TwoSpots(int x, int y, char *suit)
{
	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 566,1, x+29, y+12, 13,17);
		blit(faces, screen, 580,1, x+29, y+ch-27, 13,17);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 566,34, x+29, y+12, 13,17);
		blit(faces, screen, 566,34, x+29, y+ch-27, 13,17);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 566,18, x+29, y+12, 13,16);
		blit(faces, screen, 580,18, x+29, y+ch-27, 13,16);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 566,52, x+29, y+12, 13,17);
		blit(faces, screen, 580,52, x+29, y+ch-27, 13,17);
	}
}
void FourSpots(int x, int y, char *suit)
{
	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 566,1, x+15, y+12, 13,17);
		blit(faces, screen, 580,1, x+15, y+ch-26, 13,17);
		blit(faces, screen, 566,1, x+cw-13-15, y+12, 13,17);
		blit(faces, screen, 580,1, x+cw-13-15, y+ch-27, 13,17);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 566,34, x+16, y+12, 13,17);
		blit(faces, screen, 566,34, x+16, y+ch-26, 13,17);
		blit(faces, screen, 566,34, x+cw-13-16, y+12, 13,17);
		blit(faces, screen, 566,34, x+cw-13-16, y+ch-27, 13,17);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 566,18, x+15, y+12, 13,16);
		blit(faces, screen, 580,18, x+15, y+ch-26, 13,16);
		blit(faces, screen, 566,18, x+cw-13-15, y+12, 13,16);
		blit(faces, screen, 580,18, x+cw-13-15, y+ch-27, 13,16);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 566,52, x+15, y+12, 13,17);
		blit(faces, screen, 580,52, x+15, y+ch-26, 13,17);
		blit(faces, screen, 566,52, x+cw-13-15, y+12, 13,17);
		blit(faces, screen, 580,52, x+cw-13-15, y+ch-27, 13,17);
	}
}
void SixSpots(int x, int y, char *suit)
{
	FourSpots(x,y,suit);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 566,1, x+15, y+43, 13,17);
		blit(faces, screen, 566,1, x+cw-13-15, y+43, 13,17);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 566,34, x+16, y+43, 13,17);
		blit(faces, screen, 566,34, x+cw-13-16, y+43, 13,17);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 566,18, x+15, y+43, 13,16);
		blit(faces, screen, 566,18, x+cw-13-15, y+43, 13,16);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 566,52, x+15, y+43, 13,17);
		blit(faces, screen, 566,52, x+cw-13-15, y+43, 13,17);
	}
}
void EightSpots(int x, int y, char *suit)
{					  /* added spots for the nines and tens */
	int i=20;

	FourSpots(x,y,suit);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 566,1, x+15, y+12+i, 13,17);
		blit(faces, screen, 580,1, x+15, y+ch-27-i, 13,17);
		blit(faces, screen, 566,1, x+cw-13-15, y+12+i, 13,17);
		blit(faces, screen, 580,1, x+cw-13-15, y+ch-27-i, 13,17);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 566,34, x+16, y+12+i, 13,17);
		blit(faces, screen, 566,34, x+16, y+ch-27-i, 13,17);
		blit(faces, screen, 566,34, x+cw-13-16, y+12+i, 13,17);
		blit(faces, screen, 566,34, x+cw-13-16, y+ch-27-i, 13,17);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 566,18, x+15, y+12+i, 13,16);
		blit(faces, screen, 580,18, x+15, y+ch-27-i, 13,16);
		blit(faces, screen, 566,18, x+cw-13-15, y+12+i, 13,16);
		blit(faces, screen, 580,18, x+cw-13-15, y+ch-27-i, 13,16);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 566,52, x+15, y+12+i, 13,17);
		blit(faces, screen, 580,52, x+15, y+ch-27-i, 13,17);
		blit(faces, screen, 566,52, x+cw-13-15, y+12+i, 13,17);
		blit(faces, screen, 580,52, x+cw-13-15, y+ch-27-i, 13,17);
	}
}

void DrawAce(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	CardA(x+3,y+4,Hue);
	DownA(x+cw-3,y+ch-4);

	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 682,2, x+20, y+29, 31,42);
		else CenterSpot(x,y,suit);
}
void Draw2(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"2");
	Down2(x+cw-4,y+ch-4);
	TwoSpots(x,y,suit);
}
void Draw3(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"3");
	Down3(x+cw-4,y+ch-4);
	TwoSpots(x,y,suit);
	CenterSpot(x,y,suit);
}
void Draw4(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+3,y+4,Hue,CARDWHITE,"4");
	Down4(x+cw-3,y+ch-4);
	FourSpots(x,y,suit);
}
void Draw5(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"5");
	Down5(x+cw-4,y+ch-4);
	FourSpots(x,y,suit);
	CenterSpot(x,y,suit);
}
void Draw6(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"6");
	Down6(x+cw-4,y+ch-4);
	SixSpots(x,y,suit);
}
void Draw7(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"7");
	Down7(x+cw-4,y+ch-4);

	SixSpots(x,y,suit);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 566, 1, x+29, y+25, 13,16);
	if( strcmp(suit,"D") == 0 ) blit(faces, screen, 566,34, x+29, y+25, 13,17);
	if( strcmp(suit,"C") == 0 ) blit(faces, screen, 566,18, x+29, y+25, 13,16);
	if( strcmp(suit,"H") == 0 ) blit(faces, screen, 566,52, x+29, y+25, 13,17);
}
void Draw8(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"8");
	Down8(x+cw-4,y+ch-4);

	SixSpots(x,y,suit);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 566,1, x+29, y+25, 13,16);
		blit(faces, screen, 580,1, x+29, y+ch-13-25, 13,16);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 566,34, x+29, y+25, 13,17);
		blit(faces, screen, 566,34, x+29, y+ch-13-25, 13,17);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 566,18, x+29, y+25, 13,16);
		blit(faces, screen, 580,18, x+29, y+ch-13-25, 13,16);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 566,52, x+29, y+25, 13,17);
		blit(faces, screen, 580,52, x+29, y+ch-13-25, 13,17);
	}
}
void Draw9(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+4,y+4,Hue,CARDWHITE,"9");
	Down9(x+cw-4,y+ch-4);

	EightSpots(x,y,suit);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 566,1, x+29, y+25, 13,16);
	if( strcmp(suit,"D") == 0 ) blit(faces, screen, 566,34, x+29, y+25, 13,17);
	if( strcmp(suit,"C") == 0 ) blit(faces, screen, 566,18, x+29, y+25, 13,16);
	if( strcmp(suit,"H") == 0 ) blit(faces, screen, 566,52, x+29, y+25, 13,17);
}
void Draw10(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;
	PutsLuna(x+2,y+4,Hue,CARDWHITE,"10");
	Down1(x+cw-2,y+ch-4);
	Down0(x+cw-8,y+ch-4);

	EightSpots(x,y,suit);
	if( strcmp(suit,"S") == 0 ) {
		blit(faces, screen, 566,1, x+29, y+25, 13,16);
		blit(faces, screen, 580,1, x+29, y+ch-13-25, 13,16);
	}
	if( strcmp(suit,"D") == 0 ) {
		blit(faces, screen, 566,34, x+29, y+25, 13,17);
		blit(faces, screen, 566,34, x+29, y+ch-13-25, 13,17);
	}
	if( strcmp(suit,"C") == 0 ) {
		blit(faces, screen, 566,18, x+29, y+25, 13,16);
		blit(faces, screen, 580,18, x+29, y+ch-13-25, 13,16);
	}
	if( strcmp(suit,"H") == 0 ) {
		blit(faces, screen, 566,52, x+29, y+25, 13,17);
		blit(faces, screen, 580,52, x+29, y+ch-13-25, 13,17);
	}
}
void DrawJack(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;

	PutsLuna(x+4,y+4,Hue,CARDWHITE,"J");
	DownJ(x+cw-4,y+ch-4);

	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 0,0, x+12, y+12, 48,77);
	if( strcmp(suit,"D") == 0 ) blit(faces, screen, 47,0, x+12, y+12, 48,77);
	if( strcmp(suit,"C") == 0 ) blit(faces, screen, 94,0, x+12, y+12, 48,77);
	if( strcmp(suit,"H") == 0 ) blit(faces, screen, 141,0, x+12, y+12, 48,77);
}
void DrawQueen(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;

	PutsLuna(x+4,y+4,Hue,CARDWHITE,"Q");
	DownQ(x+cw-4,y+ch-4);

	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 188,0, x+12, y+12, 48,77);
	if( strcmp(suit,"D") == 0 ) blit(faces, screen, 235,0, x+12, y+12, 48,77);
	if( strcmp(suit,"C") == 0 ) blit(faces, screen, 282,0, x+12, y+12, 48,77);
	if( strcmp(suit,"H") == 0 ) blit(faces, screen, 329,0, x+12, y+12, 48,77);
}
void DrawKing(int x, int y, char *suit)
{
	int Hue;

	if( strcmp(suit,"S") == 0 || strcmp(suit,"C") == 0  ) Hue = BLACK;
		else Hue = RED;

	CardK(x+4,y+4,Hue);
	DownK(x+cw-4,y+ch-4);

	set_palette(faces_palette);
	if( strcmp(suit,"S") == 0 ) blit(faces, screen, 376,0, x+12, y+12, 48,77);
	if( strcmp(suit,"D") == 0 ) blit(faces, screen, 423,0, x+12, y+12, 48,77);
	if( strcmp(suit,"C") == 0 ) blit(faces, screen, 470,0, x+12, y+12, 48,77);
	if( strcmp(suit,"H") == 0 ) blit(faces, screen, 517,0, x+12, y+12, 48,77);
}
void DrawPhantom(int px, int py, int NumCards)
{	  /* for animation of a string of moving cards, seen very briefly */
	rectfill(screen,px+1,py+1,px+cw-1,py+ch-1+((NumCards-1)*15),CARDWHITE);
}
int DrawCard(int x, int y, int value)
{
	char *suit;
	int a=1;
	int Hue, Hue2;

	Hue=makecol(104,83,62);
	Hue2=makecol(145,116,87);

	hline(screen,x+2,y,x+cw-2,Hue);
	hline(screen,x+2,y+ch,x+cw-2,Hue);
	vline(screen,x,y+2,y+ch-2,Hue);
	vline(screen,x+cw,y+2,y+ch-2,Hue);
	rectfill(screen,x+1,y+1,x+cw-1,y+ch-1,CARDWHITE);
	putpixel(screen,x+1,y+1,Hue2);
	putpixel(screen,x+cw-1,y+1,Hue2);
	putpixel(screen,x+1,y+ch-1,Hue2);
	putpixel(screen,x+cw-1,y+ch-1,Hue2);

	while( value > 13 ) {
		value -= 13;
		++a;
	}
	if( a == 1 ) suit="S";
	if( a == 2 ) suit="D";
	if( a == 3 ) suit="C";
	if( a == 4 ) suit="H";

	DrawSmallSpots(x,y,suit);
	switch( value )
	{
		case 1:  DrawAce(x,y,suit);
				break;
		case 2:  Draw2(x,y,suit);
				break;
		case 3:  Draw3(x,y,suit);
				break;
		case 4:  Draw4(x,y,suit);
				break;
		case 5:  Draw5(x,y,suit);
				break;
		case 6:  Draw6(x,y,suit);
				break;
		case 7:  Draw7(x,y,suit);
				break;
		case 8:  Draw8(x,y,suit);
				break;
		case 9:  Draw9(x,y,suit);
				break;
		case 10:	 Draw10(x,y,suit);
				break;
		case 11:	 DrawJack(x,y,suit);
				break;
		case 12:	 DrawQueen(x,y,suit);
				break;
		case 13:	 DrawKing(x,y,suit);
				break;
	}
}
void DelayedShutdown()
{
	int x;

	rectfill(screen, 120, 250, 790, 590, BLACK); /* erase lower window */

/* spread the deck face-up in curvy patterns */
	for( x=14; x<=26; ++x) {
		rest(22-x);
		DrawCard((14*x),264+((x-13)*(x-13)),x);
	}
	for( x=1; x<=13; ++x) {
		rest(32-x);
		DrawCard(130+(14*x),484-(x*(x*1.3)),x);
	}
	for( x=27; x<=39; ++x) {
		rest(40-x);
		DrawCard(110+(14*x),284+((x-26)*(x-26)),x);
	}
	for( x=40; x<=52; ++x) {
		rest(50-x);
		DrawCard((14*x)-100,464-((x-39)*((x-39)*1.2)),x);
	}
	rest(700);
}

/* eof */

