/***
 *** File: proc.c
 ***	(C)opyright 1996 Luigi Rizzo (luigi@iet.unipi.it)
 ***	Miscellaneous procedures for pcbridge (ROMable version and others)
 ***/

#include "bridge.h"

/***
 *** strings here are in the form
 *** COL ROW Text '|' (terminator). terminator ascii code must be >80
 *** col, row start from 0.
 ***/
char *banner =
    "\000\000" "PCBRIDGE v.3.02|"
    "\000\001" "02 nov 96 08:30|"
    "\036\000" "by Luigi Rizzo (luigi@iet.unipi.it)|"
    "\031\001" "Dipartimento di Ingegneria dell'Informazione|"
    "\023\002" "Universita` di Pisa - via Diotisalvi 2, 56126 Pisa, Italy|"
    "\055\006" "=== Bridge  Statistics ===|"
    "\000\004" "Freelist|"
    "\000\005" "Loops|"
    "\000\006" "Tab colls|"
    "\000\010" "St I/O MEM|"
    "\000\011" "Eth. addr.|"
    "\000\013" "Rx packets|"
    "\000\014" "Rx bytes|"
    "\000\015" "Local drop|"
    "\000\016" "Filtered|"
    "\000\017" "Rx bridge|"
    "\000\020" "Broadcast|"
    "\000\021" "Multicast|"
    "\000\022" "Unknown|"
    "\000\023" "Fwd all|"
    "\000\024" "Tx packets|"
    "\000\025" "Dropped|"
    "\000\026" "Loops|"
    "\000\027" "Que Reset|"
    "\000\000||"	;
/***
 *** print_string prints a set of strings. Use '|' as
 *** string terminator, empty string as end of strings
 ***/

void print_string(char *s)
{
    char row, col, c;
    short off;
    do {
	col =  *s++;
	row =  *s++;
	if (col>79 || row>24) return;

	off= (row*80+col);
	while ( (c= *s++) !='|') {
	    video[off++]=c | 0x0a00; /* green... */
	}
    } while (*s != '|');
}

u_long tab[256]; /* 2 chars, 2 bytes each. */
/*** ascii-h; color-h; ascii-low; color-low ***/

/***
 ***	print_stat prints quickly a counter writing to video RAM
 ***	each counter is 8 bytes: 2 bytes pos, 6 bytes counter
 ***/
void print_stat(int i)
{
    short the_off;
    int j;

    u_char *p;
    u_long a=shadow_counters[i], *q;

    if (!a) return;
    counters[i].low += a;
    shadow_counters[i]=0;
    if (video) {
	the_off=counters[i].offset >> 1;
	p= (u_char *)(&counters[i].low)+3; /* data */
	q=(u_long *)video + 2 + the_off;	/* video */

	*q++ = tab[*p--];
	*q++ = tab[*p--];
	*q++ = tab[*p--];
	*q++ = tab[*p];
	if (counters[i].low < a) {
	    counters[i].high++;
	    p= (u_char *)(&counters[i].high) + 1; /* data */
	    q=(u_long *)video + the_off;	/* video */
	    *q++ = tab[*p--];
	    *q++ = tab[*p];
	}
    } else {
	if (counters[i].low < a)
	    counters[i].high++;
    }
}

void print_addr(int row, int col, u_char *p, int len)
{
    short the_off= (row*80+col)>>1;
    int j;
    u_long *q=(u_long *)video;
 
    if (!video) return;
    if (len >=0)
	for (j=0; j<len; j++) q[the_off++]=tab[p[j]];
    else
	for (j= -len; j--;) q[the_off++]=tab[p[j]];
}

/*** init_tab builds a table of hex strings ***/
char hexdigits[]="0123456789abcdef";
void init_tab()
{
    int i;
    for (i=0; i<256;i++) {
	tab[i] = ( hexdigits[ (i>>4) & 0xf] ) |
	     ( (u_long)hexdigits[i & 0xf] << 16 ) | 0x0e000e00L ;
    }
}

/*** print_mask  print the startup screen after cleaning page 0 ***/
void print_mask()
{
    int i,j;
    /*** init offsets ***/
    counters[BIGLOOP_CTR].offset= (5*80+12); /* bigloop */
    counters[COLLSN_CTR].offset= (6*80+12); /* collisions */
    for (i=0;i<NUM_COUNTERS;i++)
	for (j=0;j<MAX_CARDS; j++)
	    counters[RXPKT_CTR+i*MAX_CARDS+j].offset=
		    ((11+i)*80 + 12 + 14*j);
    video= VIDEO_BASE_COLOR;
    video[0]= 0xaaaa;
    video[0]= 0x5555;
    if (video[0] != 0x5555) {
	video= VIDEO_BASE_MONO;
	video[0]= 0xaaaa;
	video[0]= 0x5555;
	if (video[0] != 0x5555) video= 0;
    }
    if (!video) return;
	/* ;; bleu background, write ' ' */
    for (i=0;i<2048;i++) video[i]=0x0e20;
    init_tab();
    print_string(banner);
    print_cards();
}

print_cards()
{
    int i;
    char *fmt, buf[128];
    struct if_vars *sc;
    for (i=0; i< curr_if; i++) {
	sc= &c_if[i];
 	if (sc->eth_vendor==VENDOR_WD)
	    sprintf(buf+2,"wd %x %x||",sc->eth_asic_base,
		(u_long)(sc->eth_bmem)/16);
	else if (sc->eth_vendor==VENDOR_NOVELL)
	    sprintf(buf+2,"ne %x ----||",sc->eth_nic_base);
	else if (sc->eth_vendor==VENDOR_SINK)
	    sprintf(buf+2,"si %x %x||",sc->eth_asic_base,
		(u_long)(sc->eth_bmem)/16);
	else sprintf(buf+2,"............||");
	buf[1]=8;
	buf[0]=12+i*14;
	print_string(buf);
	print_addr(9, 12+14*i, &(sc->eth_node_addr), 6);
    }
}

#define PCBRIDGE_SPORT	2299
#define PCBRIDGE_CPORT	2298

/***
 *** make_pkt prepares a packet for output
 *** ifp= interface where to send data (used to get ethernet addr)
 *** pkt packet buffer;
 *** len = data len including headers
 ***/
void make_pkt(struct if_vars *ifp, struct eth_packet *pkt, int len)
{
    static unsigned short pkt_id=0;
    struct iphdr *ip=(struct iphdr *)&(pkt->body);
    struct udphdr *udp=(struct udphdr *)&(pkt->body[sizeof(struct iphdr)]);

    /*** build ethernet header ***/
    pkt->eth_dst[0]= 0xffff;
    pkt->eth_dst[1]= 0xffff;
    pkt->eth_dst[2]= 0xffff;
    bcopy(ifp->eth_node_addr, pkt->eth_src, 6);
    pkt->eth_type=htons(IP); /* htons(DOD_IP_TYPE) */

    ip->verhdrlen= 0x45;	/* 2 chars, might be done faster */
    ip->service = 0;
    ip->len =htons(len);
    ip->ident = htons(pkt_id++);
    ip->frags = 0;
    ip->ttl = 0x0f; /* might be shorter! */
    ip->protocol = IP_UDP;
    *(u_long *)(ip->src) = 0;
    *(u_long *)(ip->dest) = htonl(IP_BROADCAST);
    ip->chksum= 0;
    ip->chksum= ipchksum(ip, sizeof(struct iphdr));

    udp->src = htons(PCBRIDGE_CPORT);
    udp->dest = htons(PCBRIDGE_SPORT);
    udp->len = htons(len - sizeof(struct iphdr));
    udp->chksum[0] = 0; /* no checksum */
}

/***
 *** process_pkt processes incoming packets.
 ***/
process_pkt(struct eth_packet *buf, long len, u_short port)
{
    int i;
    struct iphdr *iph= (struct iphdr *)&(buf->body);
    struct udphdr *udph= (struct udphdr *)&(iph->dest[4]);
    struct bdgcmd *cmd= (struct bdgcmd *)&(udph->chksum[1]);

    if (
	  cmd->magic[0]== 'L' && cmd->magic[1]=='R'	 &&
	  udph->dest == ntohs(PCBRIDGE_CPORT)		 &&
	  iph->protocol == IP_UDP			 &&
	  buf->eth_type ==  ntohs(IP)
       ) {
	/*** have an IP pkt for me
	 ***	bx+46= command. Command codes are:
	 ***	0: dump data segment (256 bytes, offset at bx+48)
	 ***	1: dump filter table (256 bytes, offset at bx+48)
	 ***	2: flush filter table
	 ***	3: cold reset of the bridge
	 ***	4: enable filters
	 ***	5: disable filters
	 ***	6: restart
	 ***
	 ***	bx+48 has memory address to dump
	 ***/
	printf("\r[%X] %I -> %I cmd %d      ",
		timeofday(),
		ntohl(*(long *)iph->src), ntohl(*(long *)iph->dest),
		ntohs(cmd->cmd[0]) );
	switch (ntohs(cmd->cmd[0])) {
	case 0: /* dump_data */
	    printf("dump data, offset %x! \r", ntohs(cmd->cmd[1]));
	    /* for (i=0; i<256;i++) dst[i]=data[i]; XXX */
	    break;
	case 1: /* dump_table_seg */
	    printf("dump table, offset %x! \r", ntohs(cmd->cmd[1]));
	    /* for (i=0; i<256;i++) dst[i]=bdg_table[i]; XXX */
	    break;
	case 2: /* flush_table */
	    printf("Flush table! \r");
	    flush_table();
	    break;
	case 3: /* reset_bdg */
	    printf("Reset! \r");
	    { void (*f)()= (void (*)())0xffff0L; (*f)(); };
	    break;
	case 4: /* enable filters */
	    printf("enable filters! \r");
	    use_filters=1;
	    break;
	case 5: /* disable filters */
	    printf("disable filters! \r");
	    use_filters=0;
	    break;
	case 6: /* restart */
	    printf("restart! \r");
	    longjmp(jmp_restart);
	    break;
	}
    }
}
/*** end of file ***/
