;;---------- File: ct.inc ---------------------------
;;
;; 05may93 Alessandro Fanelli, Luigi Rizzo (luigi@iet.unipi.it)
;;
;; Statistics for pcbridge. They are both printed on the screen
;; and sent to the network on every active interface.
;;
;; Counter names. Cards # start from 1, so idx are base+1..base+MAX_CARDS
;; Counters are sequential for each field.

MAX_CARDS               EQU 5	;; can't fit more on the screen...

BIGLOOP_CTR             EQU 0	;; main counter
COLLSN_CTR              EQU 1	;; table collision 
TIME_CTR		EQU 2	;; time-of-day
RX_BASE_CTR		EQU 2
RXALL_BASE_CTR          EQU MAX_CARDS*1+2 ;; to max_cards*2+2-1
TXPKT_BASE_CTR          EQU MAX_CARDS*2+2 ;;...
DROP_BASE_CTR           EQU MAX_CARDS*3+2
LOCAL_DROP_BASE_CTR     EQU MAX_CARDS*4+2
RXPKT_BRIDGE            EQU MAX_CARDS*5+2
RX_BYTE_BASE            EQU MAX_CARDS*6+2
BAD_RX_BASE             EQU MAX_CARDS*7+2
NUM_COUNTERS            EQU 8

;;----------------------------------------------------------------
    .DATA
ethaddr_base	label word	;; used once to print card addresses
    FOR name, <1,2,3,4,5> 
	pos_&name&_ha dw (9*80-2+14*name)*2 ;; positions for ethernet address
	ct_&name&_ha      DW 3 DUP (0)      ;; if_addr in print order
    ENDM
last_stat_sent	db 8 dup (0);	last time sent statistics for i-th card
table_offset	dw 8 dup (0);	last segment sent statistics for i-th card

;; The following data are also sent out to the net, thus they must
;; be contiguous.

;;===== Ethernet Header - 14 bytes - total 14

out_pkt	dw	3 dup (0ffffh)	;; 00: dest, broadcast
eth_src	dw	3 dup (?)	;; 06: card address
	dw	8		;; 12: IP type
;;===== IP header - 20 bytes - total 34
 	dw	45h 		;; 14: VERS 4, IHL 5, TOS 0)
	dw 	(?)		;; 16: Total length (byte 14 to end)
	dw	(?)		;; 18: Identification (random number)
	dw	0		;; 20: Flags=0, frag.offset=0
	dw	(?)		;; 22: TTL(0x0f=15), Protocol (0x11=UDP)
	dw	(?)		;; 24: IP header checksum (14 to 33incl.)
 	dw	2 dup (0)	;; 26: Src address (0 ?)
	dw	2 dup (0ffffh)	;; 30: Dest address, broadcast
;;===== UDP Header - 8 bytes - total 42
	dw	(?)		;; 34: Source port
	dw	(?)		;; 36: Destination port
	dw	(?)		;; 38: UDP Length (byte 34 to end of data)
	dw	0		;; 40: Chechsum (0 if not computed)
;;===== UDP DATA

magic_string db 16 dup (?)	;; 42: filled up at run time
port_id	   LABEL BYTE		;; 58: used for port id when sending out data
if_found   DB 8 dup (0)         ;; 58: 1 if found, 0 if not
if_address DW 8 dup (0eeeeh,0eeeeh,0eeeeh,0);;66: if_address
	;; 6 bytes IF address, 1 TX status, 1 flags. 64bytes, total 130
IF_FLAG_DISABLE		EQU 1	;; RX/TX disabled on this if
    ;; IF_FLAG_TEMP_DISABLE	EQU 2	;; temporarily disabled
    ;; IF_FLAG_PERM_DISABLE	EQU 4	;; permanently disabled
;;	Each counter is 6 bytes, preceded by 2 bytes indicating
;;	the memory offset on a PC screen.
counter_base dw (5*80+12)*2,0,0,0 ;; 130: bigloop counter. 8bytes, total 138
	dw (6*80 + 12)*2,0,0,0	;; 138: collisions.
time_ctr_w label byte
	 dw (5*80 + 26)*2,0,0,0	;; 146: time
				;; 154:
    FOR ctr, <1,2,3,4,5,6,7,8>	;; 8 counters per card
        FOR card, <1,2,3,4,5>	;; 5 cards
	    dw ( 10*80 +80*ctr -2 + 14*card)*2,	0, 0, 0 
	ENDM
    ENDM ;; 320 bytes total 474
 
pos_vdrm     dw     0b000h	;; 474: 2 bytes total 476
	;; the following 4 words are actually unused
bdg_flush_ptr	dw (0)
unused_3	dw 0, 0, 0
	;; This is the filtering table, made of 16 3-word entries.
	;; Filtering is made on the Ethernet TYPE fields.
	;; Word 1 and 2 define a right-open interval (e.g. 800h,801h)
	;; contains only 800h). Word 0 is divided into 2 bytes:
	;; LSB tells what to do if type is outside the interval
	;; MSB tells what to do if type is inside the interval
	;; Values are: 1=bridge, 2=discard, 3=try next filter.
	;; 00 means no more filters are needed.
	;; The following will pass only IP and ARP.
	;; If you put 0 in the first word, then all packets will be
	;; bridged.
filters	     label byte
	dw 	103h, 800h, 801h ;; take IP. Zero 1st word for no filters
	dw	103h, 806h, 807h ;; take ARP
 	dw	202h, 0, 0    ;; discard all the others
	dw	13 dup (0, 0, 0 ) ;; address filters. 96 bytes, total 572;
	dw 	0; end of filter
table_data_off	dw (?)
table_data	dw	256 dup (?); 512 bytes of table data
    ;; End of sent data.
eth_pkt_size	equ	$ - out_pkt ;; used later to compute checksums etc.
;;********************************************************************

	.DATA?
current_rx_segment	dw (?)
tab          dw 256 dup(?)	;; a table of hex strings

;;----------------------------------------------------
COUNT_CYCLE   MACRO name,size
    LOCAL done
    .CODE
    IFNB <size>
	add word ptr counter_base[8*name+2],size ;; LSW
	jnc done                  ;; if no-overflow verify for printing
    ELSE
	inc word ptr counter_base[8*name+2] ;; LSW
	jnz done                  ;; if no-overflow verify for printing
    ENDIF
    inc word ptr counter_base[8*name+4] ;; 2SW
    jnz done
    inc word ptr counter_base[8*name+6];; MSW, no overflow in one year
done:
ENDM	;; COUNT_CYCLE
;;----------------------------------------------------

;;----------------------------------------------------
PRINT_COUNTERS	MACRO
    LOCAL go_out, no_time
    .CODE
    ;; mov es, pos_vdrm ;; not needed
    mov al, byte ptr counter_base[2]
    and al, 7
    jz no_time
    FOR card, <1,2,3,4,5> ;; still needed for IF_W_ACCESS, IF_W_WRITE
	LOCAL next,cicla,no_stat
      IF card le num_dls
	cmp al,card
	jne next
	cmp if_found[card], 0  ;; if card 1 not found, dont print counter
	jz go_out
	xor ah,ah
	mov bx, ax ;; lr 16 apr 93 ;; card index
	mov al,time_ctr_w[2]
	and al, 0f0h ;; once every 10 second send packet
	cmp al, last_stat_sent[bx]
	je no_stat ;; already sent...
;;----- management code, send info on the network ---------------
	mov last_stat_sent[bx],al
	mov di, offset out_pkt ;; di points to output buffer
	call make_pkt ;; now copy table data
        ;; mov si, table_offset[2*card] ;; from... local to each card
        ;; mov table_data_off,si
	;; lea di, table_data ;; to
	;; mov cx, 256
	;; mov AX, bdg_table_ptr
	;; push ds
	;; pop es	;; es=data segment (packet)
	;; mov ds,ax ;; ds=table segment
	;; rep movsw
	;; mov ax,es ;; restore ds
	;; mov ds,ax
        ;; mov table_offset[2*card],si ;; from... local to each card!!
	    ;; remember, I am on this side
        lea si, out_pkt[6]                         
        mov di, [si+4]      ;; hash source address
        xor di, [si+2]
	shl DI, 3                ;; now ES:DI is the hash address
	mov ES, bdg_table_ptr
	movsw                    ;; now save source address/if in table
	movsw
	movsw
	mov AL, card             ;; save source IF
	stosb

	IF_W_ACCESS card, no_stat ;; out ES:DI buffer
	COUNT_CYCLE %(card + TXPKT_BASE_CTR) ;; update tx. ctr
	mov SI, offset out_pkt
	mov CX, eth_pkt_size ;; size of packet
	MEM_COPY ;; DS:SI -> ES:DI for CX bytes
	    ;; CX is lost, as well as SI and DI
	mov CX, eth_pkt_size ;; size of packet
	IF_W_WRITE card ;; forward data (buffer is at fixed position)
        mov byte ptr if_address[8*card+7],0 ; restore status
;;----------------- end management code ----------------------------
    no_stat:
        mov bp,2+card ;; print all counters related to a card
    cicla:
	push bp
	call print_stat ;; also sets ES
	pop bp
	add bp,MAX_CARDS ;; that is is 5
	cmp bp, 2+ MAX_CARDS*NUM_COUNTERS + card
	jnz cicla

        mov al,byte ptr if_address[8*card+6] ; status
        and al,1
        add al,'X' ;; this is a hack. 'X' is bad, 'Y' is good
        mov es:[2*(8*80-2+14*card)],al ;; print status on screen
        mov al,byte ptr if_address[8*card+7] ; status
        and al,1
        add al,'0' ;; display port status
        mov es:[2*(8*80-1+14*card)],al ;; print status on screen
	jmp go_out
    next:
      ENDIF  ;; card le num_dls   
    ENDM

    mov ah,2
    int 1ah
    mov time_ctr_w[2],dh
    mov time_ctr_w[3],cl
    mov time_ctr_w[4],ch
    mov bp,2
    CALL PRINT_STAT
no_time:
    mov bp, 0 ;; print counter 0
    CALL PRINT_STAT
    mov bp, 1 ;; print counter 1
    CALL PRINT_STAT
go_out:
ENDM      ;; PRINT_COUNTERS
;;-----------------------------end of file-------------------------------------
