/*
 * The elfdump function and the return value
 */

struct elf_entry {
	const char *name;
	u_int64_t	value;
	u_int64_t	size;
};

/*
 * The return value is a struct with appeneded the storage for strings
 * and the matched entries. It is allocated by the function and must be
 * freebd by the caller.
 */
struct elfdump_info {
	int count;
	struct elf_entry m[0];	/* 'count' entries */
};

/* flags values */
#define	ED_DYN		(1<<0)
#define	ED_EHDR		(1<<1)
#define	ED_GOT		(1<<2)
#define	ED_HASH		(1<<3)
#define	ED_INTERP	(1<<4)
#define	ED_NOTE		(1<<5)
#define	ED_PHDR		(1<<6)
#define	ED_REL		(1<<7)
#define	ED_SHDR		(1<<8)
#define	ED_SYMTAB	(1<<9)
#define	ED_ALL		((1<<10)-1)

struct elfdump_info *elfdump(u_int flags, const char* fn, const char *syms);
