/* 
 * event.h -- header file for event handling routines
 *
 * rmdp -- Reliable Multicast data Distribution Protocol
 * 
 * (C) 1996-1998 Luigi Rizzo and Lorenzo Vicisano
 *     (luigi@iet.unipi.it, vicisano@cs.ucl.ac.uk)
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Luigi Rizzo,
 *      Lorenzo Vicisano and other contributors.
 * 4. Neither the name of the Authors nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef RMDP__EVENT_H
#define RMDP__EVENT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <assert.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "rmdp.h"

#define MAX_CHAN 32

#define TIMIT	struct timit
TIMIT {
    TIMIT *next;
    int id;				/* event id. */
    int flags;				/* flags */
    int (*t_f)(void *);			/* function to call */
    void *t_p;				/* function parameter list */
    ui32 delta;				/* delta t (usec) */
};

#define EVLIST	struct evlist
EVLIST {
    int io_chan[MAX_CHAN];		/* fd, -1 if empty */
    int io_id[MAX_CHAN];		/* channel id. */
    ui16 io_ch_num;			/* number of active channels */
    int (*io_f[MAX_CHAN])(void *);	/* function to call */
    void *io_p[MAX_CHAN];		/* function parameter list */
    fd_set in_s;
    fd_set out_s;
    fd_set err_s;
    TIMIT *timevent;			/* timevent list */
    struct timeval lasttime;
    struct timeval default_timeout;
    ui32 late;				/* we are scheduling the current
					   event late usec late! */
    int selected;			/* the last selected fd */
};

/**
 ** event tags
 **/

#define EV_DEFTIMEOUT	-4	/* got default timeout */
#define EV_GOTSIGNAL	-3	/* got a signal in select() */
#define EV_TERMINATE	-2	/* exit event loop with no timer pending
				   and no channel to listen to */
#define	EV_NO_PENDING	-1	/* exit event loop with no timer pending
				   but 1 or more channels to listen to
				   (only if blocking == 0) */
#define EV_NULL		0	/* exit event loop with no event occurred
				   but some timer pending */

EVLIST *createevlist();
int getevent(EVLIST *e, int blocking);
void insertchan(EVLIST *e, int chan, int id, CALLBACK f, void *p);
void deletechan(EVLIST *e, int chan);
void settimer(EVLIST *e, int id, ui32 delta, CALLBACK f, void *p, int real);
void set_default_timeout(EVLIST *e, struct timeval *tv);
int showselected (EVLIST *e);

#endif  /* RMDP__EVENT_H */
