;
; File: sender1.asm, sender module for cable tester
;
; (C) 1996 Maurizio Fabbri, Fabio Raso, Luigi Rizzo
; Dipartimento di Ingegneria dell'Informazione
; via Diotisalvi 2 -- 56126 PISA (ITALY)
; email: luigi@iet.unipi.it
;
; keep all pins but one to '1', on the remaining one sent a code.
;
; note: the weak pullups are too weak to make the line change state
; in time. Perhaps it is necessary to add a stronger pullup (e.g. 1K)
; to force a '1'. This is better than having the PIC drive the line,
; because it allows short circuits to be detected.

	device pic16c84
	config  CP=off,WDT=off,PWRT=off,OSC=hs

include "defs.inc"

; variables

dataout	equ	0x10	; the byte which goes out
bitctr	equ	0x11	; how many bits in current byte ?
maskB	equ	0x12	; bit enabled in port B
ctr1	equ	0x13	; delay
    org 0
start 
    clrf INTCON        ; disable interrupts
    bsf STATUS,RP0bit  ; page 1
    bcf OPTION_REG,7	; pullup enabled.
    ldc 0xff, TRISB	; all bits input
    bcf STATUS,RP0bit  ; page 0
    ldc 0xff, PORTB	; all outputs = 1 (default)

main_loop
    ldc 1, maskB	; start from pin 1
    ldc 0x70, dataout	; flag

pin_loop
    ldc 8, bitctr
    movf maskB, W
    bsf STATUS,RP0bit  ; page 1
    xorwf TRISB, F	; make this bit an output
    bcf STATUS,RP0bit  ; page 0
    
bit_loop		; ----------------------
    movlw 0		; default out value
    btfsc dataout,7	; test msb
    movlw 0xff		; this if bit is 1
    movwf PORTB		; output data

    bcf STATUS, Cbit	; clear carry, a 0 comes in
    rlf dataout, F
    btfsc STATUS, Cbit	; store carry into bit 0
    incf dataout, F
    nop 
    movlw 0x5
    movwf ctr1
	; 11 clocks until now
l0  loop  ctr1, l0	; N*3 - 1 clocks
    loop bitctr, bit_loop	; 3 clocks

    ; 28 clocks/bit, 27 on last bit

    nop
    nop
    nop
    movlw 0xff
    movwf PORTB		; restore idle level

    movf maskB, W
    bsf STATUS,RP0bit  ; page 1
    xorwf TRISB, F      ; make this bit an input again
    bcf STATUS,RP0bit  ; page 0

    incf dataout,F
    bcf STATUS, Cbit    ; clear carry
    rlf maskB, F
    btfss STATUS, Cbit
    goto pin_loop
    goto main_loop
end
