#include <dev/usb/usb_subr.h>
#if !defined USBDI_H
#define USBDI_H
#ifdef OLD_USB_COMPAT
/* XXX from usbdi.h */
typedef struct usbd_xfer        *usbd_xfer_handle;
typedef struct usbd_device      *usbd_device_handle;
typedef struct usbd_interface   *usbd_interface_handle;
typedef struct usbd_pipe        usbd_pipe_handle;	/* XXX */
typedef void                    *usbd_private_handle;
typedef void (*usbd_callback)(usbd_xfer_handle, usbd_private_handle,
                              usbd_status);
/* Request flags */
//usbd_status usbd_endpoint_count(usbd_interface_handle, u_int8_t *);
//	iface->idesc->bNumEndpoints

#define usbd_get_string(udev, si,  buf)	\
	usbreq_get_string_any(udev, si, buf, sizeof(buf))

/*--- todo --- */

#define USBD_NO_COPY            0x01    /* do not copy data to DMA buffer */

usbd_status usbd_open_pipe(usbd_interface_handle, u_int8_t,
                           u_int8_t, usbd_pipe_handle *);


usbd_xfer_handle usbd_alloc_xfer(usbd_device_handle);

usbd_status usbd_close_pipe(usbd_pipe_handle);
usb_endpoint_descriptor_t *
usbd_interface2endpoint_descriptor(usbd_interface_handle iface, u_int8_t index);
usbd_status usbd_device2interface_handle(usbd_device_handle,
                              u_int8_t, usbd_interface_handle *);
void usbd_get_xfer_status(usbd_xfer_handle, usbd_private_handle *,
                          void **, u_int32_t *, usbd_status *);
usbd_status usbd_abort_pipe(usbd_pipe_handle);
void usbd_setup_isoc_xfer(usbd_xfer_handle, usbd_pipe_handle,
                          usbd_private_handle, u_int16_t *,
                          u_int32_t, u_int16_t, usbd_callback);
void *usbd_alloc_buffer(usbd_xfer_handle, u_int32_t);
usbd_status usbd_free_xfer(usbd_xfer_handle);
usbd_status usbd_transfer(usbd_xfer_handle);


#endif /* USBDI_H */
#endif
