
#ifndef SPCAUSB_H
#define SPCAUSB_INIT_H

#if defined(__FreeBSD__)
#define TimeOut 1000	/* XXX 1 second ? */
#else
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 6)
#define wait_ms(a) msleep((a))
#endif
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 11)
#define TimeOut 1000
#else
#define TimeOut HZ
#endif
#endif /* !__FreeBSD__ */

#if 0
static int spca_clear_feature(struct usb_device *dev, int endpoint)
{
	int inpipe;
	inpipe = usb_rcvintpipe(dev,endpoint);
	usb_clear_halt(dev, inpipe);
	return 0;
}
#endif

static int spca50x_setup_qtable(struct usb_spca50x *spca50x,
	unsigned int request, unsigned int ybase, unsigned int cbase,
	unsigned char qtable[2][64]);

/* Alias setting */
/***************************** Implementation ****************************/

/* Read request from the device, using a vendor-specific request req */
/* XXX was spca5xxRegRead() */
static int usb_rd_vend_dev(struct usb_device *dev,
       __u16 req, __u16 value, __u16 index, __u8 * buffer, __u16 length)
{
    return usb_control_msg(dev, usb_rcvctrlpipe(dev, 0),
	req, UT_READ_VENDOR_DEVICE, value, index, buffer, length, TimeOut);
}

int em28xx_read_reg_req(struct usb_device *dev, uint16_t req, uint16_t reg)
{
	uint8_t buf;
	usb_rd_vend_dev(dev, req, 0x0000 /* val */, reg, &buf, 1);
	return buf;
}

int em28xx_read_reg(struct usb_device *dev, uint16_t reg)
{
	return em28xx_read_reg_req(dev, UR_GET_STATUS, reg);
}


/* Write request to the device, using a vendor-specific request req */
/* was spca5xxRegWrite */
static int usb_wr_vend_dev(struct usb_device *dev,
	__u16 req, __u16 value, __u16 index, __u8 * buffer, __u16 length)
{
    return usb_control_msg(dev, usb_sndctrlpipe(dev, 0),
	 req, UT_WRITE_VENDOR_DEVICE, value, index, buffer, length, TimeOut);
}

int em28xx_write_regs_req(struct usb_device *dev,
	uint16_t req, uint16_t reg, uint8_t *buf, uint16_t len)
{
	usb_wr_vend_dev(dev, req, 0x0000 /* val */, reg, buf, len);
	return 0;
}

int em28xx_write_regs(struct usb_device *dev, uint16_t reg, uint8_t *buf, uint16_t len)
{
	return em28xx_write_regs_req(dev, UR_GET_STATUS, reg, buf, len);
}

/* Read from the _interface_, vendor specific */
/* XXX was sonixRegRead */
static int usb_rd_vend_int(struct usb_device *dev,
	 __u16 req, __u16 value, __u16 index, __u8 * buffer, __u16 length)
{
    return usb_control_msg(dev, usb_rcvctrlpipe(dev, 0),
	req, UT_READ_VENDOR_INTERFACE, value, index, buffer, length, TimeOut);
}

#define Et_RegRead(dev,req,value,index,buffer,length)		\
	usb_rd_vend_int(dev,req,value,index,buffer,length)

/* Write to the _interface_, vendor specific */
/* XXX was sonixRegWrite */
static int usb_wr_vend_int(struct usb_device *dev,
	  __u16 req, __u16 value, __u16 index, __u8 * buffer, __u16 length)
{
    return usb_control_msg(dev, usb_sndctrlpipe(dev, 0),
	req, UT_WRITE_VENDOR_INTERFACE, value, index, buffer, length, TimeOut);
}


#define Et_RegWrite(dev,req,value,index,buffer,length)		\
	usb_wr_vend_int(dev,req,value,index,buffer,length)

/* This is a standard request to set an alternate endpoint.
 * On freebsd should probably use usbd_set_interface(sc->sc_iface,sc->valternate);
 * XXX used only in one function.
 */
static int spca_set_interface(struct usb_device *dev, int interface,
			      int alternate)
{
    int ret;
#if !defined(__FreeBSD__)
    struct usb_interface *iface;

    iface = usb_ifnum_to_if(dev, interface);
    if (!iface) {
	warn("selecting invalid interface %d", interface);
	return -EINVAL;
    }

    /* 9.4.10 says devices don't need this, if the interface
       only has one alternate setting */
    if (iface->num_altsetting == 1) {
	dbg("ignoring set_interface for dev %d, iface %d, alt %d",
	    dev->devnum, interface, alternate);
	return 0;
    }
#endif	/* !__FreeBSD__ */

    if ((ret = usb_control_msg(dev, usb_sndctrlpipe(dev, 0),
			       USB_REQ_SET_INTERFACE, USB_RECIP_INTERFACE /* UT_WRITE_INTERFACE */,
			       alternate, interface, NULL, 0,
			       TimeOut * 5)) < 0)
	return ret;


    return 0;

}

static int spca50x_reg_write(struct usb_device *dev,
			     __u16 req, __u16 index, __u16 value)
{
    int rc;

    rc = usb_control_msg(dev, usb_sndctrlpipe(dev, 0),
	req, UT_WRITE_VENDOR_DEVICE, value, index, NULL, 0, TimeOut);

    PDEBUG(5, "reg write: 0x%02X,0x%02X:0x%02X, 0x%x", req, index, value, rc);

    if (rc < 0)
	err("reg write: error %d", rc);

    return rc;
}

/* Read a number of size 1-2-4 from given index, cmd req.
 */
static int spca50x_reg_read_with_value(struct usb_device *dev,
    __u16 req, __u16 value, __u16 index, __u16 length)
{
    int i, rc;
    unsigned char buffer[4] = { 0, 0, 0, 0 };

    /* Hope plp didn't ask for more */
    if (length > sizeof(buffer)) {
	printf("Ouch, spca50x_reg_read_with_value: size %d too large\n", length);
	length = 4;
    }
    rc = usb_control_msg(dev, usb_rcvctrlpipe(dev, 0),
			 req, USB_DIR_IN | USB_TYPE_VENDOR | USB_RECIP_DEVICE,
			 value, index, buffer, length, TimeOut);

    i = UGETDW(buffer);
    PDEBUG(5, "reg read: 0x%02X,0x%02X:0x%04X error %d", req, index, i, rc);
    if (rc < 0) {
	err("reg read: error %d", rc);
	return rc;
    }
    return i;
}

/*
 * Read a number of size 1-2-4 from given index, cmd req.
 * returns: negative is error, pos or zero is data
 */
static int spca50x_reg_read(struct usb_device *dev,
    __u16 req, __u16 index, __u16 length)
{
    return spca50x_reg_read_with_value(dev, req, 0, index, length);
}

/*
 * Simple function to wait for a given 8-bit value to be returned from
 * a spca50x_reg_read call.
 * Returns: negative is error or timeout, zero is success.
 */
static int spca50x_reg_readwait(struct usb_device *dev,
				__u16 reg, __u16 index, __u16 value)
{
    int count = 0;
    int result = 0;

    while (count < 20) {
	result = spca50x_reg_read(dev, reg, index, 1);
	if (result == value)
	    return 0;

	wait_ms(50);

	count++;
    }

    PDEBUG(2, "spca50x_reg_readwait failed");

    return -EIO;
}

/*
 * Write a vector of 3 byte-entries (reg-value-index).
 * 0-0-0 is the terminator
 */
static int spca50x_write_vector(struct usb_spca50x *spca50x,
				__u16 data[][3])
{
    struct usb_device *dev = spca50x->dev;
    int err_code;

    int I = 0;
    while (data[I][0] != 0 || data[I][1] != 0 || data[I][2] != 0) {
	err_code = spca50x_reg_write(dev, data[I][0], data[I][2], data[I][1]);
	if (err_code < 0) {
	    PDEBUG(1, "Register write failed for 0x%x,0x%x,0x%x",
		   data[I][0], data[I][1], data[I][2]);
	    return -1;
	}
	I++;
    }
    return 0;
}

static int spca50x_setup_qtable(struct usb_spca50x *spca50x,
	unsigned int request, unsigned int ybase, unsigned int cbase,
	unsigned char qtable[2][64])
{
    int i;
    int err;

    /* loop over y components */
    for (i = 0; i < 64; i++) {
	err = spca50x_reg_write(spca50x->dev, request, ybase + i, qtable[0][i]);
	if (err < 0) {
	    PDEBUG(2, "spca50x_reg_write failed");
	    return err;
	}
    }

    /* loop over c components */
    for (i = 0; i < 64; i++) {
	err = spca50x_reg_write(spca50x->dev, request, cbase + i, qtable[1][i]);
	if (err < 0) {
	    PDEBUG(2, "spca50x_reg_write failed");
	    return err;
	}
    }

    /* all ok */
    return 0;
}
#endif				/* SPCAUSB_H */
