/*
 * spca_globals.h
 *
 * $FreeBSD$
 */

#ifndef _SPCA_GLOBALS_H
#define _SPCA_GLOBALS_H

struct usb_spca50x;

extern int pwcdebug;

int spca50x_init_source(struct usb_spca50x *spca50x);
int spca50x_configure(struct usb_spca50x *spca50x);
int spca50x_set_packet_size(struct usb_spca50x *spca50x, int size);
void spcaCameraStart(struct usb_spca50x *spca50x);
void spca50x_stop_isoc(struct usb_spca50x *spca50x);

int spca5xx_setMode(struct usb_spca50x *spca50x, int width, int height, int format);

int _unused_spca50x_move_data_helper(struct usb_spca50x *spca50x,
        unsigned char *cdata, int datalength);

int spca5xx_ioctl_helper(struct usb_spca50x *spca50x, unsigned int cmd, void *arg);

int spcaDetectCamera(int vendor, int product, struct pwc_softc *sc);
__u16 spca50x_get_brightness(struct usb_spca50x *spca50x);
void spca50x_set_brightness(struct usb_spca50x *spca50x, __u8 brightness);

void init_jpeg_decoder(struct usb_spca50x *spca50x);


struct usb_quickcam;
int usb_quickcam_stop(struct usb_quickcam *quickcam);
void quickcam_parse_data(struct usb_quickcam *quickcam, int curframe);
int usb_quickcam_upload_frame(struct usb_quickcam *quickcam);
int config_quickcam(struct usb_spca50x *spca50x);

int spca50x_outpicture(struct spca50x_frame *myframe);

/* from qce-ga/ */

/*
 * Structure filled in for each of the types of sensor (HDCS, PB0100)
 */
struct sensorctrl {
	int (*init) (struct usb_device * dev, int mode, int *rgain, int *bgain, int *ggain,
		struct sensorctrl *sensor_ctrl);
	int (*set_shutter) (struct usb_device * dev, int sval, int xval, struct sensorctrl *sensor_ctrl);
	int (*set_gains) (struct usb_device * dev, int rgain, int bgain, int ggain);
	int (*set_window) (struct usb_device * dev, int x, int y, int w, int h,
		struct sensorctrl *sensor_ctrl);
	int (*set_size) (struct usb_device * dev, int mode);
	int (*start) (struct usb_device * dev, struct sensorctrl *sensor_ctrl);
	int (*stop) (struct usb_device * dev, struct sensorctrl *sensor_ctrl);
	int width, height;	// size delivered by the sensor.  
	int mode;		// mode: 0 full; 1 half; 2 quater.  
	/* addresses used for the hdcs sensor */
	unsigned char control;
	unsigned char config;
};

int usb_quickcam_set1(struct usb_device *dev, short reg, char val);
int usb_quickcam_get_i2c(struct usb_device *dev, unsigned char sensor_addr, int reg, void *buf, int len);
int qc_sensor_init(struct usb_spca50x *spca50x);

/* em28xx setup */
int em28xx_read_reg_req(struct usb_device *dev, uint16_t req, uint16_t reg);
int em28xx_read_reg(struct usb_device *dev, uint16_t reg);
int em28xx_write_regs_req(struct usb_device *dev, uint16_t req, uint16_t reg, uint8_t *buf, uint16_t len);
int em28xx_write_regs(struct usb_device *dev, uint16_t reg, uint8_t *buf, uint16_t len);


struct sensorctrl;

struct sensor_data {
        int	name;
        int     reg23;
        unsigned char   i2c_addr;
        int     id_reg;
        unsigned char   id;
        int     length_id;
        void    (*load)(struct sensorctrl *);
};

#endif /* _SPCA_GLOBALS_H */
