/*
 * linux_usbif.h - Linux API; usb_control_msg() usb_set_interface()
 *                            usb_set_configuration()
 * Inspired by code from
 * Copyright (C) 2003,2004,2005,2006 Takafumi Mizuno <taka-qce at ls-a.jp>
 *
 * $Id: linux_usbif.h,v 1.12 2007/01/13 16:38:30 luigi Exp $
 */

#ifndef _LINUX_USBIF_H
#define _LINUX_USBIF_H

/* standard FreeBSD headers */
#include <sys/param.h>
#include <sys/systm.h>	/* memcpy */
#include <sys/limits.h>
#include <sys/proc.h>	/* XXX ? */
#include <sys/kernel.h>
#include <sys/fcntl.h>

#include <sys/stddef.h>	/* XXX ? */
#include <sys/types.h>	/* XXX ? */
#include <sys/ioccom.h>
#include <sys/malloc.h>
#include <sys/module.h>
#include <sys/bus.h>
#include <machine/bus.h>

#include <sys/uio.h>

/* usb headers */

#include <dev/usb/usb.h>
#include <dev/usb/usbdi.h>	/* usbd_device_handle */
#include <dev/usb/usbdi_util.h>	/* usbd_device */
#include <dev/usb/usb_port.h>
#include <dev/usb/usbdivar.h>

/* video4linux header, and some typedefs */
#include "videodev.h"
typedef unsigned int	uint;
typedef	uint8_t		u8;
typedef	uint64_t	u64;

/* from $kernel_source_top/include/linux/???.h */
#define	KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))

/* fake a high version so MODULE_USE_COUNT is not used */
#define LINUX_VERSION_CODE KERNEL_VERSION(2, 6, 8)

#define __KERNEL__	/* simulate kernel */

#define	ERESTARTSYS	ERESTART
#define	ENOIOCTLCMD	EINVAL

/*
 * XXX fixes for things not defined in FreeBSD
 */

#if !defined(PWC_H)	/* XXX only for the spca.. */
#define printk(fmt , args...) printf(fmt , ##args)
#define	warn(X...)			printf(X)
#define dbg(X...)			printf(X)
#define err(X...)			printf(X)
#define info(fmt, X...)			printf(fmt "\n" , ##X)

#define wait_ms(x)	tsleep("spca", PCATCH, "xx", x*HZ/1000)
#define udelay(x)	tsleep("spca", PCATCH, "xx", x*HZ/1000000)

/* if you really need malloc/free, uncomment this but with care. */
// #define kmalloc(siz,opt)        malloc(siz, M_USBDEV, M_WAITOK)
// #define kfree(pt)               free(pt, M_USBDEV)
#endif

/* from $kernel_source_top/include/linux/module.h */
#define MODULE_AUTHOR(name)
#define MODULE_LICENSE(license)
#define MODULE_DESCRIPTION(desc)
//#define MODULE_SUPPORTED_DEVICE(name)
#define MODULE_PARM(var,type)
#define MODULE_PARM_DESC(var,desc)

#define MODULE_DEVICE_TABLE(type,name)

/* from $kernel_source_top/include/linux/wait.h */
/* no action for queue */
// #define init_waitqueue_head(q)          do { } while (0)
#define waitqueue_active(q)             0
#define wake_up_interruptible(q)        do { } while (0)

/* from $kernel_source_top/include/asm-$arch/semaphore.h */
/* no action for semaphore */
// #define         down(lock)              do { } while (0)
// #define         up(lock)                do { } while (0)
// #define         init_MUTEX(lock)        do { } while (0)

/* from $kernel_source_top/include/asm-$arch/spinlock.h */
typedef void *	spinlock_t;
#define spin_lock_irqsave(lock, flags)	{ int __unused i = flags; }
#define spin_unlock_irqrestore(lock, flags)
#define spin_lock(sem)	do { } while (0)
#define spin_unlock(sem)	do { } while (0)

// #define         SPIN_LOCK_UNLOCKED      0

/* from $kernel_source_top/include/asm-$arch/hardirq.h */
/* no idea */
#define         in_interrupt()          0

#define __devinitdata	const	/* attribute used in linux headers */

struct usb_device_id {
        __u16           idVendor;
        __u16           idProduct;
};

#define USB_DEVICE(vend,prod) (vend), (prod)

// #define USB_ENDPOINT_DIR_MASK           0x80
#define USB_DIR_OUT                     UT_WRITE
#define USB_DIR_IN                      UT_READ
#define USB_TYPE_VENDOR                 UT_VENDOR
#define USB_RECIP_DEVICE                UT_DEVICE
#define USB_RECIP_INTERFACE             UT_INTERFACE
// #define USB_RECIP_ENDPOINT              UT_ENDPOINT
// #define USB_RECIP_OTHER                 UT_OTHER

// #define USB_ENDPOINT_XFERTYPE_MASK      UE_XFERTYPE
// #define USB_ENDPOINT_XFER_CONTROL       UE_CONTROL
// #define USB_ENDPOINT_XFER_ISOC          UE_ISOCHRONOUS
// #define USB_ENDPOINT_XFER_BULK          UE_BULK
// #define USB_ENDPOINT_XFER_INT           UE_INTERRUPT

#define USB_REQ_SET_INTERFACE           UR_SET_INTERFACE

#define HZ      hz	/* on FreeBSD... */


#define usb_sndctrlpipe(a,b)            (b)
#define usb_rcvctrlpipe(a,b)            (b)
#define usb_sndintpipe(a,b)            (b)
#define usb_rcvintpipe(a,b)            (b)
#define usb_sndisocpipe(a,b)            (b)
#define usb_rcvisocpipe(a,b)            (b)
// #define usb_rcvbulkpipe(a,b)            (b)
#define usb_sndbulkpipe(a,b)            (b)

/*
 * This is a trick to make spca routines to reference
 * the usbd_device_handle without having to change all
 * interfaces. We are lucky that both are structs.
 */
#define usb_device	usbd_device	/* XXX */

#endif /* _LINUX_USBIF_H */
