#include <math.h>
#include "aljuli.h"

#if 0
#include <stdio.h>

main () {
    double JD;
    struct tm t;

    get_tm (&t);
    puts ("Current date/time from DOS");
    print_tm (&t);

    JD = tm_to_jd (&t);
    printf ("Julian date %.7f\ndate/time back from Julian date ", JD);
    print_jd (JD);

    JD = tm_to_jd2k (&t);
    printf ("J2000  date %.7f\ndate/time back from J2000  date ", JD);
    print_jd2k (JD);




    t.tm_year = 2000 - 1900;
    t.tm_mon = 0;
    t.tm_mday = 1;
    t.tm_hour = 0;
    t.tm_min = 0;
    t.tm_sec = 0;

    puts ("\n2000/1/1 00:00:00 converted by Julian date\n");
    print_tm (&t);

    JD = tm_to_jd (&t);
    printf ("Julian date %.7f\ndate/time back from Julian date ", JD);
    print_jd (JD);

    t.tm_year = 2000 - 1900;
    t.tm_mon = 0;
    t.tm_mday = 1;
    t.tm_hour = 0;
    t.tm_min = 0;
    t.tm_sec = 0;

    puts ("\n2000/1/1 00:00:00 converted by J2000\n");
    print_tm (&t);

    JD = tm_to_jd2k (&t);
    printf ("J2000  date %.7f\ndate/time back from J2000  date ", JD);
    print_jd2k (JD);

    t.tm_year = 97;
    t.tm_mon = 9;
    t.tm_mday = 12;
    t.tm_hour = 5;
    t.tm_min = 0;
    t.tm_sec = 0;

    puts ("\n1997/10/10 05:00:00\n");
    print_tm (&t);

    JD = tm_to_jd (&t);
    printf ("Julian date %.7f\ndate/time back from Julian date ", JD);
    print_jd (JD);

    JD = tm_to_jd2k (&t);
    printf ("J2000  date %.7f\ndate/time back from J2000  date ", JD);
    print_jd2k (JD);


}
#endif



/* Flag last or first day of year */
static const double PI = 3.141592653589793;


static char *days[7] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
static char *months[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                           "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};


#define RTOH (12.0 / PI)


static int hms (double x) {
    int h, m;
    long sint, sfrac;
    double s;

    s = x * RTOH;
    if (s < 0.0) {
        s += 24.0;
    }
    h = s;
    s -= h;
    s *= 60;
    m = s;
    s -= m;
    s *= 60;

    /* Handle shillings and pence roundoff. */
    sfrac = 1000.0 * s + 0.5;
    if (sfrac >= 60000) {
        sfrac -= 60000;
        m += 1;
        if (m >= 60) {
            m -= 60;
            h += 1;
        }
    }
    sint = sfrac / 1000;
    sfrac -= sint * 1000;

    printf( "%3dh %02dm %02ld.%03lds  ", h, m, sint, sfrac );
    return (0);
}

int alhms (double s) {
    int h, m, sign;
    long sint, sfrac;

    if (s < 0.) {
        sign = -1;
        s = -s;
    } else {
        sign =  1;
    }

    h = s;
    s -= h;
    s *= 60;
    m = s;
    s -= m;
    s *= 60;

    /* Handle shillings and pence roundoff. */
    sfrac = 1000.0 * s + 0.5;
    if (sfrac >= 60000) {
        sfrac -= 60000;
        m += 1;
        if (m >= 60) {
            m -= 60;
            h += 1;
        }
    }
    sint = sfrac / 1000;
    sfrac -= sint * 1000;

    if (sign < 0) {
        h = -h;
    }

    printf( "%4dh %02dm %02ld.%03lds  ", h, m, sint, sfrac );
    return (0);
}


int print_jd2k (double J) {
    J += cal_to_jd (2000, 1, 0, 0, 0, 0);

    return (print_jd (J));
}

/* Calculate month, day, and year from Julian date */

int print_jd (double J) {
    int month, day;
    long year, a, c, d, x, y, jd;
    int BC;
    double dd;

    if (J < 1721425.5) /* January 1.0, 1 A.D. */
        BC = 1;
    else
        BC = 0;

    jd = J + 0.5; /* round Julian date up to integer */

    /* Find the number of Gregorian centuries
     * since March 1, 4801 B.C.
     */
    a = (100 * jd + 3204500L) / 3652425L;

    /* Transform to Julian calendar by adding in Gregorian century years
     * that are not leap years.
     * Subtract 97 days to shift origin of JD to March 1.
     * Add 122 days for magic arithmetic algorithm.
     * Add four years to ensure the first leap year is detected.
     */
    c = jd + 1486;
    if (jd >= 2299160.5)
        c += a - a/4;
    else
        c += 38;

    /* Offset 122 days, which is where the magic arithmetic
     * month formula sequence starts (March 1 = 4 * 30.6 = 122.4).
     */
    d = (100 * c - 12210L) / 36525L;
    /* Days in that many whole Julian years */
    x = (36525L * d) / 100L;

    /* Find month and day. */
    y = ((c - x) * 100L) / 3061L;
    day = c - x - ((306L * y) / 10L);
    month = y - 1;
    if (y > 13)
        month -= 12;

    /* Get the year right. */
    year = d - 4715;
    if (month > 2)
        year -= 1;

    /* Day of the week. */
    a = (jd + 1) % 7;

    /* Fractional part of day. */
    dd = day + J - jd + 0.5;

    if (BC) {
        year = -year + 1;
        printf( "%ld B.C. ", year );
    } else {
        printf( "%ld ", year );
    }

    day = dd;
    printf( "%s %d %s", months[month-1], day, days[a] );

    /* Display fraction of calendar day
     * as clock time.
     */
    a = dd;
    dd = dd - a;
    alhms (dd * 24);

    printf( "\n" );

    return(0);
}


/*     Calculate Julian day from Gregorian calendar date
 */
double cal_to_jd (
    long year,
    int month,
    double day,
    double hour,
    double min,
    double sec
) {
    long y, a, b, c, e, m;
    double J;


    /* The origin should be chosen to be a century year
     * that is also a leap year.  We pick 4801 B.C.
     */
    y = year + 4800;
    if (year < 0) {
        y += 1;
    }

    /* The following magic arithmetic calculates a sequence
     * whose successive terms differ by the correct number of
     * days per calendar month.  It starts at 122 = March; January
     * and February come after December.
     */
    m = month;
    if (m <= 2) {
        m += 12;
        y -= 1;
    }
    e = (306 * (m+1)) / 10;

    a = y / 100;      /* number of centuries */
    if (year <= 1582L) {
        if (year == 1582L) {
            if( month < 10 )
                    goto julius;
            if( month > 10)
                    goto gregor;
            if( day >= 15 )
                    goto gregor;
        }
        julius:
        printf( " Julian Calendar assumed.\n" );
        b = -38;
    } else { /* -number of century years that are not leap years */
        gregor:
        b = (a / 4) - a;
    }

    c = (36525 * y) / 100; /* Julian calendar years and leap years */

    /* Add up these terms, plus offset from J 0 to 1 Jan 4801 B.C.
     * Also fudge for the 122 days from the month algorithm.
     */
    J = b + c + e + day - 32167.5;
    J += (3600.0 * hour + 60.0 * min + sec) / 86400.0;

    return (J);
}

/*     Calculate J2000 day from Gregorian calendar date
 */
double cal_to_jd2k (
    long year,
    int month,
    double day,
    double hour,
    double min,
    double sec
) {
    double J;

    if ((year < 1801) || (year > 2099)) {
        /*  out of range for the fomula */
        return (-1);
    }

    J = 367L * year -
        ((7 * (year + ((month + 9) / 12
                      )
              )
         ) / 4
        ) +
        ((275 * month) / 9
        ) +
        day - 730530L;

    J += (((sec / 60.) + min) / 60. + hour) / 24.;

    return (J);
}

void print_tm (struct tm *t) {
    printf ("%2d/%02d/%02d (%s) %2d:%02d:%02d (%s)\n",
            t->tm_year, t->tm_mon + 1, t->tm_mday, days [t->tm_wday],
            t->tm_hour, t->tm_min, t->tm_sec, t->tm_isdst ? "DST" : "ST");
} /* print_tm */


void sprint_tm (char *buf, struct tm *t) {
    sprintf (buf, "%2d/%02d/%02d (%s) %2d:%02d:%02d (%s)",
            t->tm_year, t->tm_mon + 1, t->tm_mday, days [t->tm_wday],
            t->tm_hour, t->tm_min, t->tm_sec, t->tm_isdst ? "DST" : "ST");
} /* print_tm */


double tm_to_jd (struct tm *t) {
    double J;

    J = cal_to_jd (t->tm_year + 1900, t->tm_mon + 1, t->tm_mday,
                   t->tm_hour, t->tm_min, t->tm_sec);

    return (J);

} /* date2jd */

double tm_to_jd2k (struct tm *t) {
    double J;

    J = cal_to_jd2k (t->tm_year + 1900, t->tm_mon + 1, t->tm_mday,
                     t->tm_hour, t->tm_min, t->tm_sec);

    return (J);

} /* date2jd */

void get_tm (struct tm *t) {
    time_t tp;
    struct tm *T;

    time (&tp);
    T = localtime (&tp);

    *t = *T;
} /* get_tm */



