#include "ui.h"
#include <assert.h>
#include <ctype.h>
#include <conio.h>
#include <time.h>

static void execCancelCheck(void)
{
  /*
  check for ``esc''
  prompt for: [c]ontinue, [s]top, [a]bort
  */
  int key;
  if (kbhit() && (getch() == '\x1b'))
  {
    while (kbhit())
      getch();
    printf("[C]ontinue, [S]top, or [A]bort? ");
    do
    {
      key = tolower(getch());
    } while (strchr("csa", key) == 0);
    switch (key)
    {
      case 'c': execModeSet(EXECMODE_NORMAL); break;
      case 's': execModeSet(EXECMODE_CANCEL); break;
      case 'a': execModeSet(EXECMODE_ABORT);  break;
      default:
        assert(0);
    }
    printf("%c\n", key);
  }
}

void showHelp(const char *str)
{
  printf("Format: Syncdir src [dst] flags\n"
         "/a            add files\n"
         "/c            copy files\n"
         "/d[d]         delete files\n"
         "/u            update files\n"
         "/f[acdu]      force add, copy, delete, update\n"
         "/r            recurse into subdirectories\n"
         "/v            verbose mode\n"
         "/q            quiet mode\n"
         "/n            no action\n"
         "/[+][!][name] log actions & errors to [name]\n"
         "              [+] for append, [!] for errors only\n"
         "              default name: syncdir.log\n"
         "/i...         begin include file list\n"
         "/x...         begin exclude file list\n"
         "/b            execute in both directons\n");
  if (str)
    printf("%s\n", str);
  printf("\n");
}

void showExecuteError(const char *file, const char *fn, const char *str, const char *log)
{
  UNUSED(str);
  UNUSED(fn);
  UNUSED(file);

  if (optionTest(OPT_VERBOSE))
    printf("%s", log);
  else
    printf("%s", log);
  execCancelCheck();
}

static const char *prepareText(const char *src, const char *dst, ACTION act)
{
  static char txt[2048];
  if (act == ACTION_DELETE)
  {
    sprintf(txt, "DELETE %s\r\n", src);
  } else
  {
    sprintf(txt, "%-6.6s %s\r\n"
                 "   --> %s\r\n",
                 actionString(act),
                 src,
                 dst);
  }
  return txt;
}

void showExecuteAction(const char *src, const char *dst, ACTION act, BOOL exec, const char *log)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);

  if (optionTest(OPT_VERBOSE))
    printf("%s", log);
  else
    printf("%s", log);
  execCancelCheck();
}

void showCompleteAction(const char *src, const char *dst, ACTION act)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);

  if (optionTest(OPT_VERBOSE))
    ;
  execCancelCheck();
}

BOOL queryAction(const char *src, const char *dst, ACTION act)
{
  int key;
  printf("\r%s(y/Y/n/N)? ", prepareText(src, dst, act));
  do
  {
    key = getch();
  } while (strchr("yYnN", key) == 0);
  printf("%c\n", key);
  switch (key)
  {
    case 'Y': 
      key = 'y';
      switch (act)
      {
        case ACTION_ADD:      optionSet(0, OPT_FORCE_ADD); break;
        case ACTION_DELETE:   optionSet(0, OPT_FORCE_DELETE); break;
        case ACTION_COPY:
        case ACTION_UPDATE:   optionSet(0, OPT_FORCE_COPY); break;
        default:
          assert(0);
      }
    case 'y': 
      break;
    case 'N': 
      key = 'n';
      switch (act)
      {
        case ACTION_ADD:      optionSet(0, OPT_NEVER_ADD); break;
        case ACTION_DELETE:   optionSet(0, OPT_NEVER_DELETE); break;
        case ACTION_COPY:
        case ACTION_UPDATE:   optionSet(0, OPT_NEVER_COPY); break;
        default:
          assert(0);
      }
    case 'n': 
      break;
    default:
    assert(0);
  }
  return (key == 'y');
}

void showBegin(void)
{
  if (optionTest(OPT_VERBOSE))
  {
  }
}

void showComplete(void)
{
  if (optionTest(OPT_VERBOSE))
  {
  }
}

void showExecuteBegin(void)
{
  if (optionTest(OPT_VERBOSE))
  {
  }
  execCancelCheck();
}

void showExecuteUpdate(void)
{
  if (optionTest(OPT_VERBOSE))
    ;
  execCancelCheck();
}

void showExecuteComplete(void)
{
  if (optionTest(OPT_VERBOSE))
    ;
}

void showExecuteActionBegin(const char *src, const char *dst, ACTION act)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);
}

void showExecuteActionComplete(const char *src, const char *dst, ACTION act)
{
  UNUSED(act);
  UNUSED(dst);
  UNUSED(src);
}

static time_t start;

void showScanBegin(const FILETABLE *tbl)
{
  start = time(0);
  printf("%s", tbl->name);
}

BOOL showScanUpdate(const FILETABLE *tbl, UINT32 scanCt)
{
  time_t now = time(0);
  if (difftime(now, start) >= 1)
  {
    start = now;
    printf("\r%s Scanned (%lu) Accepted (%lu)", tbl->name, scanCt, tbl->entryCt);
  }
  return TRUE;
}

void showScanComplete(const FILETABLE *tbl, UINT32 scanCt)
{
  UNUSED(tbl);
  UNUSED(scanCt);

  printf("\r%s Scanned (%lu) Accepted (%lu)", tbl->name, scanCt, tbl->entryCt);
  printf("\n");
}

void showCopyBegin(const char *src, const char *dst, UINT32 amt)
{
  UNUSED(src);
  UNUSED(dst);
  UNUSED(amt);

  if (optionTest(OPT_VERBOSE))
    ;
  execCancelCheck();
}

void showCopyUpdate(const char *src, const char *dst, UINT32 amt, UINT32 complete)
{
  UNUSED(src);
  UNUSED(dst);

  if (optionTest(OPT_VERBOSE))
  {
  }
  execCancelCheck();
}

void showCopyComplete(const char *src, const char *dst, UINT32 amt)
{
  UNUSED(src);
  UNUSED(dst);
  UNUSED(amt);
}

void showProcessBegin(UINT32 amt)
{
  UNUSED(amt);
  
  printf("processing (0 of %lu)", amt);
  start = time(0);
}

void showProcessUpdate(UINT32 amt, UINT32 complete)
{
  time_t now = time(0);
  if (difftime(now, start) >= 1)
  {
    start = now;
    printf("\rprocessing (%lu of %lu)", complete, amt);
  }
}

void showProcessComplete(UINT32 amt)
{
  UNUSED(amt);
  printf("\rprocessing (%lu of %lu)\n", amt, amt);
}

void showPostProcessBegin(const char *dir, UINT32 amt)
{
  UNUSED(dir);
  UNUSED(amt);
  if (optionTest(OPT_VERBOSE))
    ;
}

void showPostProcessUpdate(const char *dir, UINT32 amt, UINT32 complete)
{
  UNUSED(dir);
  if (optionTest(OPT_VERBOSE))
    ;
}

void showPostProcessComplete(const char *dir, UINT32 amt)
{
  UNUSED(dir);
  UNUSED(amt);
}

